<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ItineraryXML.inc,v 1.4 2006/11/16 08:15:46 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/connector/route/output/XML.inc"));

class ItineraryXML_RouteOutput extends XML_RouteOutput {

  function ItineraryXML_RouteOutput($properties,$cache) {
    $this->XML_RouteOutput($properties,$cache);
  }

  function GetHeader() {
    return 'Content-type: text/xml';
  }

  function GetOutput() {
    return $this->_FormatXML($this->ProcessItinerary());
  }
  
  function ProcessItinerary() {
    if ($this->data['result']['err']) return $this->data['result'];
    $this->cache->SetIdByParams(array($this->data));
    $result = $this->cache->Get();
    if (Is_Null($result)) {
      include(FileUp2('.admin/route/lg/route_'.$this->properties['default_lang'].'.inc'));
      $result = array('command'=>$this->data['command'], 'request_time'=>$this->data['request_time'], 'result'=>array('extent'=>$this->data['result']['extent'], 'itinerary'=>array()));
      foreach ($this->data['result']['itinerary'] as $val) {
        $item = array(
          'node_id'=>$val['node']['id'],
          'x'=>$val['node']['x'],
          'y'=>$val['node']['y'],
        );
        if ($val['link']) {
          if ($val['link']['turn']) $item['turn']=$val['link']['turn'];
          $item['fee']=$val['link']['attr']['fee']?'true':'false';
          $item['time']=$val['link']['time'];
          $item['totaltime']=$val['link']['totaltime'];
          $item['dist']=$val['link']['dist'];
          $item['totaldist']=$val['link']['totaldist'];
        }
        $item['node_type']=$val['node']['attr']['type'];
        if ($val['node']['attr']['name']) {
          $description = $val['node']['attr']['name'];
        } else {
          $description = $val['node']['attr']['municip_name'];
          if (!preg_match('/'.$val['node']['attr']['municip_part'].'/', $description)) {
            $description .= ' - '.$val['node']['attr']['municip_part'];
          }
        }
        $item['desc'] = iconv($this->properties['code_page_core'],$this->properties['code_page'],$description);
        $item['cntry_abbr'] = $val['node']['attr']['cntry_abbr'];
        if (preg_match('/-/',$item['cntry_abbr'])) {
          $item['desc'] = $RESOURCE_STRING['itinerary_border_checkpoint'].' '.$item['cntry_abbr'].' '.$item['desc']; 
        }
        $route = '';
        if ($val['link']) {
          $turn = $val['link']['turn'];
          if (!isset($item['turn'])) $route .= '';
          elseif ($turn < 0) $route .= '';
          elseif ($turn < 15) $route .= $RESOURCE_STRING['itinerary_turn_straight'];
          elseif ($turn < 60) $route .= $RESOURCE_STRING['itinerary_turn_left_slight'];
          elseif ($turn < 120) $route .= $RESOURCE_STRING['itinerary_turn_left'];
          elseif ($turn < 170) $route .= $RESOURCE_STRING['itinerary_turn_left_sharp'];
          elseif ($turn < 180) $route .= $RESOURCE_STRING['itinerary_turn_uturn_left'];
          elseif ($turn == 180) $route .= $RESOURCE_STRING['itinerary_turn_uturn_straight'];
          elseif ($turn < 190) $route .= $RESOURCE_STRING['itinerary_turn_uturn_right'];
          elseif ($turn < 240) $route .= $RESOURCE_STRING['itinerary_turn_right_slight'];
          elseif ($turn < 300) $route .= $RESOURCE_STRING['itinerary_turn_right'];
          elseif ($turn < 345) $route .= $RESOURCE_STRING['itinerary_turn_right_sharp'];
          elseif ($turn < 360) $route .= $RESOURCE_STRING['itinerary_turn_straight'];

          switch ($val['link']['attr']['type']) {
            case 1:
              $route .= ($route?' ':'').$RESOURCE_STRING['itinerary_drive_I'].' '.Str_Replace(',',', ', $val['link']['attr']['number_to_drive']);
            break;
            case 2:
              $route .= ($route?' ':'').$RESOURCE_STRING['itinerary_drive_II'].' '.Str_Replace(',',', ', $val['link']['attr']['number_to_drive']);
            break;
            case 5:
              $route .= ($route?' ':'').$RESOURCE_STRING['itinerary_drive_highway'].' '.Str_Replace(',',', ', $val['link']['attr']['number_to_drive']);
            break;
            default:
              if (!$route) $route .= ($route?' ':'').$RESOURCE_STRING['itinerary_drive_other'];
            break;
          }
          if ($val['link']['attr']['dir_to_drive'])
            $route .= ($route?' ':'').$RESOURCE_STRING['itinerary_drive_to'].' '.$val['link']['attr']['dir_to_drive'];
            
        }
        if ($route) $item['drive'] = trim($route);
        if ($val['link']['attr']['number_to_drive']) {
          $item['road_number'] = $val['link']['attr']['number_to_drive'];
        }
        if ($val['link']['attr']['type']) {
          $item['road_type'] = $val['link']['attr']['type'];
        }
        $result['result']['itinerary'][] = $item;
      }
      $this->cache->Set($result);
    }
    return $result;
  }
}
?>
