<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: RWNetServer.inc,v 1.15 2006/11/29 10:20:45 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/route/main_route_engine.inc"));

class RWNetServer_RouteEngine extends RouteEngine {

  function RWNetServer_Engine($properties, $cache) {
    $this->RouteEngine($properties, $cache);
  }

  function Coord2Node($x, $y, $epsg) {
    $rwbase = $this->_CreateRWNet();
    $pt = $this->_ConvertCoord($x,$y,(integer)$epsg,'to_network');
    $ret = $rwbase->Coordinate2Node($pt['x'],$pt['y']);
    $rwbase->free();
    return $this->_PrepareResult($ret);  
  }

  function Coord2NodeM($coords, $epsg) {
    $rwbase = $this->_CreateRWNet();
    $coords = Explode('|', $coords);
    $ret = array();
    if (Is_array($coords)) {
      foreach ($coords as $key=>$coord) {
        if ($key > 24) {
          $ret[] = array('err'=>'RE104');
          break;
        }
        list($x,$y,$id) = Explode(':', $coord);
        $this->cache->SetIdByParams(array(md5($this->properties),$x,$y,$epsg));
        $result = $this->cache->Get();
        if (Is_Null($result)) {
          $pt = $this->_ConvertCoord((double)$x,(double)$y,(integer)$epsg,'to_network');
          $item = $rwbase->Coordinate2Node($pt['x'],$pt['y']);
          $this->cache->Set($item); 
        } else {
          $item = $result; 
        }
        if ($item['err']) {
          $item = array('err'=>$item['err']);
        } else {
          unset ($item['err']);
        }
        if ($id) $item['id'] = $id;
        $ret[] = $item;
      }
    }
    $rwbase->free();
    return $this->_PrepareResult($ret);  
  }

  function RouteInfo($nodes, $routetype, $epsg) {
    $rwbase = $this->_CreateRWNet();
    $r = $this->_FindRoute($nodes, $routetype, $epsg, 5, &$rwbase);
    if ($r['err']) {
      $rwbase->free();
      return $this->_PrepareResult(array('err'=>$r['err']));
    }
    $nodes = array(); 
/*    $i=1;
    while (true) {
      $node = $rwbase->_NetCalcs[0]->RouteGetNode($i++);
      if ($node < 0) break;
      $nodes[] = $node;
    }
    print_r($nodes);
    $links = array(); 
    $i=1;
    while (true) {
      $link = $rwbase->_NetCalcs[0]->RouteGetLink($i++);
      if ($link == 0) break;
      $links[] = $link;
    }
    print_r($links);*/
    
    //die();
    //print_r($r);die();
//    $node_row = Count($nodes)-1;
    $data = array();
    $cnt = Count($r['data'][2]);
    if (!$cnt) {
      return $this->_PrepareResult(array('err'=>103));
    }
    $node_via=0;
    foreach($r['data'][2] as $linkkey=>$link) {
      //Via list
      if ($link[0][0]) {
        if ($link[0][0] == 2) {
          $data[Count($data)-1]['turn'] = $link[0][7];
        }
        if ($cnt == $linkkey+1) {
          $data[Count($data)-1]['nodeto']['via'] = 1;
        }
        //turn
        $node_via = $link[0][0];
        continue;
      }
      
      $item = array();
      foreach ($link[0] as $keyatt=>$att) {
        $name = strtolower($r['data'][1][$keyatt][0]);
        if ($name == 'name') {
          if (preg_match('/linkid/', $att)) {
            $list = Explode('|',$att);
            foreach ($list as $vallist) {
              $vallist = Explode('=',$vallist);
              $item[$vallist[0]] = $vallist[1];
            }
          } else {
            $item['linkid'] = $att;
          }
        } else {
          $item[$name] = $att;
        }
      }
      $lastel = Count($link[1][0])-1;
      $node = $rwbase->Coordinate2Node($link[1][0][0][0],$link[1][0][0][1]);
      $item['nodefrom']=array('id'=>$node['node'],'x'=>$link[1][0][0][0],'y'=>$link[1][0][0][1],'via'=>$node_via);
      $node = $rwbase->Coordinate2Node($link[1][0][$lastel][0],$link[1][0][$lastel][1]);
      $item['nodeto']=array('id'=>$node['node'],'x'=>$link[1][0][$lastel][0],'y'=>$link[1][0][$lastel][1]);
      $item['dir'] = (!StrCmp($item['nodefrom']['id'],$item['fnode']))?1:-1;
      if (Count($data) > 0) $data[Count($data)-1]['nodeto']['via'] = $node_via;
//      $item['nodefrom']=array('id'=>$nodes[$node_row],'x'=>$link[1][0][0][0],'y'=>$link[1][0][0][1]);
//      $item['nodeto']=array('id'=>$nodes[--$node_row],'x'=>$link[1][0][$lastel][0],'y'=>$link[1][0][$lastel][1]);
      $data[] = $item;
      $node_via=0;
    }
    $rwbase->free();
    //print_r($data);
    return $this->_PrepareResult(array('err'=>$r['err'],'dist'=>$r['dist'],'time'=>$r['time'], 'data'=>$data));
  }

  function RouteBasicInfo($nodes, $routetype, $epsg) {
    $r = $this->_FindRoute($nodes, $routetype, $epsg, 5);
    return $this->_PrepareResult(array('err'=>$r['err'],'dist'=>$r['dist'],'time'=>$r['time']));
  }

  function RouteGML($nodes, $routetype, $epsg) {
    $r = $this->_FindRoute($nodes, $routetype, $epsg, 3);
    return $this->_PrepareResult(array('err'=>$r['err'],'dist'=>$r['dist'],'time'=>$r['time'], 'xml'=>$r['data'].'.xml', 'xsd'=>$r['data'].'.xsd'));
  }

  function RouteSHP($nodes, $routetype, $epsg) {
    $r = $this->_FindRoute($nodes, $routetype, $epsg, 1);
    return $this->_PrepareResult(array('err'=>$r['err'],'dist'=>$r['dist'],'time'=>$r['time'], 'shp'=>$r['data'].'.shp', 'shx'=>$r['data'].'.shx', 'dbf'=>$r['data'].'.dbf'));
  }

  function RouteMap($nodes, $routetype, $epsg, $bbox, $width, $height, $imageformat) {
    $r = $this->RouteSHP($nodes, $routetype, $epsg);
    if (!$r['err']) {
      switch ($this->properties['image']['type']) {
        case 'MapScript':
          $map = ms_newMapObj($this->properties['image']['map']);
          if ($width > $this->properties['image']['maxsize'] || $height > $this->properties['image']['maxsize']) {
            $r['err'] = 102;
            break;
          } else {
            $map->setSize($width, $height);
          }
          $map->setProjection('+init=epsg:'.($epsg?$epsg:4326),MS_TRUE);
          $bboxe = Explode(',', $bbox);
          $bboxe[0] = (double)$bboxe[0];
          $bboxe[1] = (double)$bboxe[1];
          $bboxe[2] = (double)$bboxe[2];
          $bboxe[3] = (double)$bboxe[3];
          if ($bboxe[0] < $bboxe[2] && $bboxe[1] < $bboxe[3])
            $map->setExtent($bboxe[0],$bboxe[1],$bboxe[2],$bboxe[3]);
          else {
            $r['err'] = 101;
            break;
          }
          $map->selectOutputFormat($imageformat?$imageformat:'GIF');
          $layer = $map->getLayerByName($this->properties['image']['layer']);
          $layer->set('data', str_replace('.shp', '', $r['shp']));
          $layer->set('status', true);
          $web = $map->web;
          $web->set('imagepath', $this->properties['image']['imagepath']);
          $web->set('imageurl', $this->properties['image']['imageurl']);
          $image = $map->draw();
          $url = $image->saveWebImage();
          $image->free;
          //clear cache
          if (rand(1,100) == 1) exec($this->properties['image']['clearcommand']);
        break;
      }
    }
    if ($r['err']) {
      return $this->_PrepareResult(array('err'=>$r['err']));
    } else {
      return $this->_PrepareResult(array('err'=>$r['err'],'dist'=>$r['dist'],'time'=>$r['time'], 'url'=>$url));
    }
  }
  
  function RouteProfileData($nodes, $routetype, $epsg, $partsize=100) {
    function GetPointUsingMeasure(&$line, $measures, $measure) {
      $len = 0;
      $end = false;
      $last_i = 0;
      for($i=0; $i<$line->numpoints; $i++) {
        $last_i = $i;
        $len += $measures[$i];
        if ($len > $measure) {
          $len -= $measures[$i];
          break;
        }
      }
      $part = $measure - $len;
      $ptf = $line->point($last_i-1);
      $ptt = $line->point($last_i);
      $dx = $ptt->x-$ptf->x; 
      $dy = $ptt->y-$ptf->y;
      $s = sqrt(($dx*$dx)+($dy*$dy));
      $sc = $s?(($measure - $len)/$s):0;
      $res = array();
      $res['x'] = $ptf->x+($sc*$dx);
      $res['y'] = $ptf->y+($sc*$dy);
      return $res;
    }
    
    $r = $this->_FindRoute($nodes, $routetype, $epsg, 1);
    if ($r['err']) {
      return $this->_PrepareResult(array('err'=>$r['err']));
    }
    $shpfile = ms_newShapefileObj($this->properties['output_dir'].'/'.$r['data'], -1);
    //Merge lines to one object for using measures
    $shp_merged = ms_newShapeObj(MS_SHP_ARCM);
    $line_merged = ms_newLineObj();
    $last_pt = null;
    $length = 0;
    $measures = array();
    for ($i=0; $i<$shpfile->numshapes; $i++) {
      $shp = $shpfile->getShape($i);
      for ($j=0; $j<$shp->numlines; $j++) {
        $line = $shp->line($j);
        for ($k=0; $k<$line->numpoints; $k++) {
          $pt = $line->point($k);
          if ($last_pt) {
            $dx = $pt->x-$last_pt->x;
            $dy = $pt->y-$last_pt->y;
            $ds = sqrt(($dx*$dx)+($dy*$dy));
            $length += $ds;
          }
          if ($last_pt->x == $pt->x && $last_pt->y == $pt->y) continue;
          $line_merged->addXY($pt->x,$pt->y,$length);
          $measures[] = $ds;
          $last_pt = $pt;
        }
      }
    }
    $shp_merged->add($line_merged);
    //Get Height in points on line 
    $rwbase = $this->_CreateRWNet();
    $map = ms_newMapObj($this->properties['profile']['map']);
    $layer = $map->getLayerByName($this->properties['profile']['layer']);
    $point = ms_newPointObj();

    $step = $length/$partsize;
    $j=0;
    $res = array();
    for($i=0; $i<=$length+1; $i+=$step) {
      $pt = GetPointUsingMeasure(&$line_merged, $measures, $i);
      //echo $i."<BR>";
      //$pt = $shp_merged->getpointusingmeasure($i);
      //unset($pt); 
      //if (!$pt) $pt = $line_merged->point($j++);
      if ($pt) {
        $point->setXY($pt['x'],$pt['y']);
        $height = '?';
        if (@$layer->queryByPoint($point,MS_SINGLE,0) == MS_SUCCESS) {
          $layer->open();
          $result = $layer->getResult(0);
          $shp = $layer->getShape($result->shapeindex, $result->tileindex);
          $height = Round($shp->getValue($layer,'value_0'),1);
          $layer->close();
          $map->freequery($layer->index);
          $node = $rwbase->Coordinate2Node($pt['x'],$pt['y']);
          $node['data'] = $this->GetNodeInfo($node['node']); 
        }
        $res[] = array('pt'=>$pt, 'len'=>Round($i), 'elv'=>$height, 'node'=>$node);
      }
    }
    //echo($length); 
    $point->free();
    $line_merged->free;
    $shp_merged->free();
    $shpfile->free();
    $rwbase->free();
    //print_r($res);die();
    return $this->_PrepareResult(array('err'=>$r['err'], 'data'=>$res));
  }

  function RouteProfile($nodes, $routetype, $epsg, $width, $height, $imageformat, $labels) {
    $r = $this->RouteProfileData($nodes, $routetype, $epsg, (($width)/2));    
    if (!$r['err']) {
      $r = $this->_ProcessProfile($r,$width, $height, $imageformat, $labels);
      if (rand(1,100) == 1) exec($this->properties['profile']['clearcommand']);
    }
    return $r;
  }

  function RouteNode2Node($node1, $node2, $routetype) {
    $r = $this->_FindRoute($node1.','.$node2, $routetype, $epsg, 5);
    return $this->_PrepareResult(array('err'=>$r['err'],'dist'=>$r['dist'],'time'=>$r['time']));
  }
  
  function GetFile($filename, $format) {
    switch ($format) {
      case 'MIF': $gf=0; break; 
      case 'SHP': $gf=1; break; 
      case 'TAB': $gf=2; break; 
      case 'GML':
      default: 
        $gf=3; 
      break; 
    }
    $fn = $this->properties['output_dir'].'/'.$filename;
    if (file_exists($fn)) {
      $result['data'] = file_get_contents($fn);
    } else {
      $result = array('err'=>100);
    }
    return $result;
  }
  
  function GetNodeInfo($id) {
    $prop = $this->properties['ext_info']['node'];
    switch ($prop['type']) {
      case 'DBF':
        $result = $this->_GetDBFRecord($prop['src'],$id,$prop['code_page'],$this->properties['code_page']);
      break;
      case 'RDBMS':
      break;
    }
    return $result;
  }
  
  function GetLinkInfo($id) {
    $prop = $this->properties['ext_info']['link'];
    switch ($prop['type']) {
      case 'DBF':
        $result = $this->_GetDBFRecord($prop['src'],$id,$prop['code_page'],$this->properties['code_page']);
      break;
      case 'RDBMS':
        $conn_f = FileUp2('.admin/db/'.$prop['src']['connector'].'.inc');
        if(file_exists($conn_f)) include_once($conn_f);
        else die('RWNetServer.inc: Bad DB connector '.$prop['src']['connector'].' or connector is missing.');
        $conn_c = strtoupper($prop['src']['connector']);
        $conn = new $conn_c;
        if($prop['src']['sql'])
          $sql = str_replace('...LINKID...',$id,$prop['src']['sql']);
        else
          $sql = 'select * from '.$prop['src']['table'].' where '.$prop['src']['ident'].'='.$id;
        $conn->query($sql);
        $conn->next_record();
        $result = $conn->Record;
      break;
    }
    $type = $result['TYPE'];
    if ($type > 2048) {$type-=2048;$result['TYPE_ROUNDABOUT']=1;}  
    if ($type > 1024) {
      $type-=1024;
      $result['TYPE_ONEWAY']=1;
      $result['TYPE_ONEWAY_DIRECTION']=1;
    }
    if ($type > 512) {
      $type-=512;
      $result['TYPE_ONEWAY']=1;
      $result['TYPE_ONEWAY_DIRECTION']=-1;
    }
    if ($type > 256) $type-=256;
    if ($type > 128) $type-=128;
    if ($type > 64) $type-=64;
    if ($type > 32) $type-=32;
    if ($type > 10 && $type < 16) $type-=10;
    $result['TYPE_ROAD'] = $type;
    return $result;
  }
  
  function RouteErrorMsg($code) {
    $rwbase = $this->_CreateRWNet();
    switch ($code) {
      case 'RE100':
        $ret = 'File does not exist.';
      break;
      case 'RE101':
        $ret = "Bad value in 'bbox' parameter.";
      break;
      case 'RE102':
        $ret = "Image size is limited.";
      break;
      case 'RE103':
        $ret = "Route is not found.";
      break;
      case 'RE104':
        $ret = "Too many coords.";
      break;
      default:
        $ret = $rwbase->TranslateErrorMessage(Substr($code,2));
      break;
    }
    $rwbase->free();
    return $ret;
  }
  
  /**************** PRIVATE ********************/

  function _CreateRWNet() {
    return new RWNetServer_NETBASE(
      $this->properties['server'],
      $this->properties['port'],
      $this->properties['network']
    );
  }
  
  function _FindRoute($nodes, $routetype, $epsg, $format, $rwbasein=false) {
    $this->cache->SetIdByParams(array(md5($this->properties),$nodes,$routetype,$epsg,$format));
    $result = $this->cache->Get();
    if (Is_Null($result)) {
      
      if ($rwbasein) $rwbase = &$rwbasein; else $rwbase = $this->_CreateRWNet();
      $rwcalc = $rwbase->CreateNETCALC();
      
      switch ($routetype) {
        case 2: $rwcalc->SetShortest(); break;
        default: $rwcalc->SetFastest(); break;
      }
      $rwcalc->ExtraVarCreate();
      $rwcalc->GISformat($format);
  
      $nds = $this->_PrepareNodes($nodes);
      switch ($nds['type']) {
        case 'node':
          $listmode = 1;
          foreach ($nds['data'] as $key=>$val) {
            $rwcalc->NodeListSet($key+1,$val['id']);
            $rwcalc->ViaListSet($key+1,$val['id'].'.',0);
          }
        break;
        case 'coord':
          $listmode = 3;
          if (!$epsg) $epsg=4326;
          foreach ($nds['data'] as $key=>$val) {
            $pt = $this->_ConvertCoord($val['x'],$val['y'],(integer)$epsg,'to_network');
            $rwcalc->PositionListSet($key+1,$pt['x'],$pt['y']);
            $rwcalc->ViaListSet($key+1,($key+1).'.',0);
          }
        break;
      }

      $result = $rwcalc->RouteList(3,$listmode,Count($nds['data']),3,20,0,0,TRUE,1);

      if (!$rwbasein) $rwbase->free();
      
      $this->cache->Set($result);
     }
     return $result; 
  }

  function _GetDBFRecord($fn, $id, $cpfrom, $cpto) {
    //static $db;
    if (!$db) $db = dbase_open($fn,0);
    if ($db) {
      $result = dbase_get_record_with_names($db,$id);
      foreach($result as $key=>$val) {
        $result[$key] = iconv($cpfrom,$cpto,Trim($val));
      }
      dbase_close($db);
    }
    return $result;
  }
  
}

class RWNetServer_NETCALC {
  var $_NetBase;
  var $_Client;
  var $_Network;
  var $_ServiceName='RW_NETCALC';
  var $_Version='';
  
  function RWNetServer_NETCALC($netbase) {
    $this->_NetBase = $netbase;
    $this->_Client = $netbase->_Client;
    $this->_Version = $netbase->_Version;
    kbmMW_Client_SetStateID($this->_Client,-1);
    kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'ROUTEREADY');
    $this->SID = kbmMW_Client_GetStateID($this->_Client); 
    $this->SetNet($netbase->_Network);
  }

  function Free() {
    return kbmMW_Client_ReleaseStateEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID);
  }

  function GetStateId() {
    return $this->SID;
  }

  function SetStateId($id) {
    $this->SID = $id;
  }

  function AddNodes($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ADDNODES',(double)$value);
  }
  
  function Alpha($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ALPHA',(double)$value);
  }

  function BestNode($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'BESTNODE',(integer)$value);
  }

  function ExtraVarCreate() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'EXTRAVARCREATE');
  }

  function GetLinkCost($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'GETLINKCOST',(integer)$value);
  }

  function GetLinkCostDyn($link,$percent) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'GETLINKCOSTDYN',(integer)$link,(double)$percent);
  }

  function GetLinkExtra($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'GETLINKEXTRA',(integer)$value);
  }

  function GetLinkExtraDyn($link,$percent) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'GETLINKEXTRADYN',(integer)$link,(double)$percent);
  }

  function GetNodeCost($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'GETNODECOST',(integer)$value);
  }

  function GetNodeExtra($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'GETNODEEXTRA',(integer)$value);
  }

  function GISformat($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'GISFORMAT',(integer)$value);
  }

  function IsoCost($node,$maxcost) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOCOST',(integer)$node,(double)$maxcost);
  }

  function IsoCostDyn($link,$percent,$maxcost) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOCOSTDYN',(integer)$link,(double)$percent,(double)$maxcost);
  }

  function IsoCostDynLocationList($link,$percent,$locationnum) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOCOSTDYNLOCATIONLIST',(integer)$link,(double)$percent,(integer)$locationnum);
  }

  function IsoCostDynLocationListN($link,$percent,$locationnum,$nearest,$maxcost) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOCOSTDYNLOCATIONLISTN',(integer)$link,(double)$percent,(integer)$locationnum,(integer)$nearest,(double)$maxcost);
  }

  function IsoCostMulti($nodenum,$maxcost) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOCOSTMULTI',(integer)$nodenum,(double)$maxcost);
  }

  function IsoCostNodeList($node,$nodenum) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOCOSTNODELIST',(integer)$node,(integer)$nodenum);
  }

  function IsoCostNodeListN($node,$nodenum,$nearest,$maxcost) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOCOSTNODELISTN',(integer)$node,(integer)$nodenum,(integer)$nearest,(double)$maxcost);
  }

  function IsoLink2($nodenum) {
    $r=array();
    list($r['err'],$r['data']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOLINK2',(integer)$nodenum);
    return array_reverse($r);
  }

  function IsoLink2Dyn($link,$percent) {
    $r=array();
    list($r['err'],$r['data']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOLINK2DYN',(integer)$link,(double)$percent);
    return array_reverse($r);
  }

  function IsoLink4($nodenum) {
    $r=array();
    list($r['err'],$r['data']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOLINK4',(integer)$nodenum);
    return array_reverse($r);
  }

  function IsoPoly2($nodenum,$doughnut,$xlong1,$ylat1,$xlong2,$ylat2) {
    $r=array();
    list($r['err'],$r['data']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOPOLY2',$nodenum,$doughnut,$xlong1,$ylat1,$xlong2,$ylat2);
    return array_reverse($r);
  }

  function IsoPoly3($maxcost,$nodenum,$minvalency,$xlong1,$ylat1,$xlong2,$ylat2) {
    $r=array();
    list($r['err'],$r['data']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOPOLY3',$maxcost,$nodenum,$minvalency,$xlong1,$ylat1,$xlong2,$ylat2);
    return array_reverse($r);
  }

  function IsoPoly4($maxcost,$nodenum,$xlong1,$ylat1,$xlong2,$ylat2) {
    $r=array();
    list($r['err'],$r['data']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ISOPOLY4',$maxcost,$nodenum,$xlong1,$ylat1,$xlong2,$ylat2);
    return array_reverse($r);
  }

  function LocationListGet($index) {
    $r=array();
    list($r['err'],$r['link'],$r['percent']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'LOCATIONLISTGET',(integer)$index);
    return array_reverse($r);
  }

  function LocationListGetNewPos($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'LOCATIONLISTGETNEWPOS',(integer)$value);
  }

  function LocationListGetOldPos($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'LOCATIONLISTGETOLDPOS',(integer)$value);
  }

  function LocationListLimit() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'LOCATIONLISTLIMIT');
  }

  function LocationListSet($index,$link,$percent) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'LOCATIONLISTSET',(integer)$index,(integer)$link,(double)$percent);
  }

  function NearestLocation($link,$percent,$locationnum) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NEARESTLOCATION',(integer)$link,(double)$percent,(integer)$locationnum);
  }

  function NearestNode($node,$locationnum) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NEARESTNODE',(integer)$node,(integer)$locationnum);
  }

  function NearestOpen($node) {
    $r=array();
    list($r['err'],$r['nearestnode'],$r['nearestlink'],$r['cost']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NEARESTOPEN',(integer)$node);
    return array_reverse($r);
  }

  function NearestOpenDyn($link,$percent) {
    $r=array();
    list($r['err'],$r['nearestnode'],$r['nearestlink'],$r['cost']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NEARESTOPENDYN',(integer)$link,(double)$percent);
    return array_reverse($r);
  }

  function NodeListGet($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NODELISTGET',(integer)$value);
  }

  function NodeListGetNewPos($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NODELISTGETNEWPOS',(integer)$value);
  }

  function NodeListGetOldPos($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NODELISTGETOLDPOS',(integer)$value);
  }

  function NodeListLimit() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NODELISTLIMIT');
  }

  function NodeListSet($index,$node) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'NODELISTSET',(integer)$index,(integer)$node);
  }

  function OptimumAlpha() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'OPTIMUMALPHA');
  }

  function PositionListGet($index) {
    $r=array();
    list($r['err'],$r['x'],$r['y']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'POSITIONLISTGET',(integer)$index);
    return array_reverse($r);
  }

  function PositionListSet($index,$x,$y) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'POSITIONLISTSET',(integer)$index,(double)$x,(double)$y);
  }

  function Route($node1,$node2) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTE',(integer)$node1,(integer)$node2);
  }

  function RouteDyn($link1,$link2,$percent1,$percent2) {
    $r=array();
    list($r['err'],$r['fromto1'],$r['fromto2'],$r['routelength'],$r['extra']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTEDYN',(integer)$link1,(integer)$link2,(double)$percent1,(double)$percent2);
    return array_reverse($r);
  }
 
  function RouteFind($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTEFIND',(integer)$value);
  }

  function RouteFindDyn($link,$percent) {
    $r=array();
    list($r['err'],$r['fromto1'],$r['fromto2'],$r['routelength'],$r['extra']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTEFINDDYN',(integer)$link,(double)$percent);
    return array_reverse($r);
  }

  function RouteGetLink($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTEGETLINK',(integer)$value);
  }

  function RouteGetNode($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTEGETNODE',(integer)$value);
  }

  function RouteList($tspmode,$listmode,$listnum,$concatmode,$offroadspeed,$starttime,$timeformat,$vialist,$roadnameid) {
    $r=array();
    list($r['err'],$r['dist'],$r['time'],$r['data']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTELIST',(integer)$tspmode,(integer)$listmode,(integer)$listnum,(integer)$concatmode,(double)$offroadspeed,(double)$starttime,(integer)$timeformat,(integer)$vialist,(integer)$roadnameid);
    return array_reverse($r);
  }

  function RouteMaxCost($iterations,$node1,$node2) {
    $r=array();
    list($r['err'],$r['node1'],$r['node2']) = kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTEMAXCOST',(integer)$iterations);
    return array_reverse($r);
  }

  function RouteReady() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'ROUTEREADY');
  }

  function SetFastest() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'SETFASTEST');
  }

  function SetLimit($limitid,$value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'SETLIMIT',(integer)$limitid,(integer)$value);
  }

  function SetNet($value) {
    $this->_Network = $value;
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'SETNET',(integer)$value);
  }

  function SetShortest() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'SETSHORTEST');
  }

  function SharpTurnDrivingDirections($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'SHARPTURNDRIVINGDIRECTIONS',(integer)$value);
  }

  function StepsAdd($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'STEPSADD',(double)$value);
  }

  function StepsClear() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'STEPSCLEAR');
  }

  function TSP2($nodenum,$tsptype,$maxseconds) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'TSP2',(integer)$nodenum,(integer)$tsptype,(integer)$maxseconds);
  }

  function TSP2dyn($locationnum,$tsptype,$maxseconds) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'TSP2DYN',(integer)$locationnum,(integer)$tsptype,(integer)$maxseconds);
  }

  function TSP2extra() {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'TSP2EXTRA');
  }

  function UTurnAllowed($value) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'UTURNALLOWED',$value);
  }

  function ViaListSet($index,$name,$time) {
    return kbmMW_Client_SendRequestEx($this->_Client,$this->_ServiceName,$this->_Version,$this->SID,'VIALISTSET',(integer)$index,(string)$name,(double)$time);
  }

}

class RWNetServer_NETBASE {

//   var $Host = '127.0.0.1';
//   var $Port = 3000;
//   var $Net  = 1;

  var $_Transport;
  var $_Client;
  var $_Network;
  var $_ServiceName='RW_NETBASE';
  var $_Version='';
  var $_NetCalcs=array();
  var $Connected=false;

  function RWNetServer_NETBASE($host='127.0.0.1', $port=3000, $network=1) {
  //function RWNetServer_NETBASE() {
    $ext = (PHP_OS == "WINNT" || PHP_OS == "WIN32")?'php_kbmmw.dll':'php_kbmmw.so';
    if (!function_exists('kbmMW_New_ClientTransport')) dl($ext);

    $this->_Transport = kbmMW_New_ClientTransport();
    $this->_Client = kbmMW_New_Client($this->_Transport);

    kbmMW_Client_Connect($this->_Client,$host,$port);

    $this->Connected = kbmMW_ClientTransport_IsConnected($this->_Transport);
    if (!$this->Connected) die('RWNetServer_NETBASE not connected');

    $this->SetNet($network);
  }

  function Free() {
    foreach ($this->_NetCalcs as $value) $value->free();
    kbmMW_Client_Disconnect($this->_Client);
    kbmMW_Dispose_Client($this->_Client);
    kbmMW_Dispose_ClientTransport($this->_Transport);
  }

  function CreateNETCALC() {
    $rwcalc = new RWNetServer_NETCALC($this);
    $this->_NetCalcs[] = $rwcalc;
    return $rwcalc;
  }
  
  function TranslateErrorMessage($value) {
    $msg = array(
      0=>"No error",
      10=>"Network not loaded",
      11=>"RW Net trial license has expired",
      12=>"Network too big for license or input file empty",
      13=>"Invalid shapefile",
      14=>"Too many links at one node (no more than 1900)",
      15=>"Wrong version code in network file",
      16=>"Function not available in turnmode",
      17=>"CGF file is password protected",
      18=>"Function only available in turnmode",
      20=>"Field name not found in file",
      21=>"Field isn't of type number/decimal 11.3",
      22=>"Field is not numerical",
      30=>"Number out of bounds",
      31=>"Couldn't load network: wrong path, file not found etc",
      32=>"File couldn't be found, opened, created etc.",
      33=>"Node2 / link2 not found",
      34=>"No node index created",
      35=>"Route not ready",
      36=>"Route index out of bounds",
      37=>"No results calculated",
      38=>"Nodes in subnet or node=0",
      39=>"Function ExtraVarCreate hasn't been called",
      40=>"General error",
      41=>"Out of memory",
      42=>"Internal error",
      43=>"Function not available in Free/Standard version (OCX only)",
      44=>"No spatial index found (spatialindex.bin)",
      45=>"No link found",
      46=>"No coordinate file found (coord3.bin)",
      47=>"Not possible with encrypted files",
      48=>"Road file is already open",
      49=>"Road file is not open",
      50=>"Cancelled by user",
      51=>"Number of records in road file doesn't match network",
      52=>"The network contains subnets",
      53=>"(Not implemented yet)",
      54=>"No solution found, increase factor in function CPP",
      55=>"One or more nodes or locations are not defined in list",
      56=>"Only shortest or fastest route can be processed with this function",
      57=>"Function VRPcreate has not been called",
      58=>"VRP solution not possible - limits too tight"
    );
    return $msg[abs($value)];
  }
  
  function AirDistNode($node1,$node2) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'AIRDISTNODE',$this->_Network,(integer)$node1,(integer)$node2);
  }

  function AirDistPos($x1,$y1,$x2,$y2) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'AIRDISTPOS',$this->_Network,(double)$x1,(double)$y1,(double)$x2,(double)$y2);
  }
  
  function CheckLink($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'CHECKLINK',$this->_Network,(integer)$value);
  }

  function CheckNode($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'CHECKNODE',$this->_Network,(integer)$value);
  }

  function CloseLink($link,$code) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'CLOSELINK',$this->_Network,(integer)$link,(integer)$code);
  }
  
  function Coordinate2Location($xlongv,$ylatv) {
    $r = array();
    list($r['err'],$r['link'],$r['percent'],$r['side'],$r['dist'],$r['xlongnew'],$r['ylatnew']) = kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'COORDINATE2LOCATION',(integer)$this->_Network,(double)$xlongv,(double)$ylatv);
    return array_reverse($r);
  }
  
  function Coordinate2LocationSimple($xlongv,$ylatv,$link,$percent) {
    $r = array();
    list($r['err'],$r['link'],$r['percent']) = kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'COORDINATE2LOCATIONSIMPLE',$this->_Network,(double)$xlongv,(double)$ylatv);
    return array_reverse($r);
  }
  
  function Coordinate2Node($xlongv,$ylatv) {
    $r = array();
    list($r['err'],$r['node'],$r['dist']) = kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'COORDINATE2NODE',$this->_Network,(double)$xlongv,(double)$ylatv);
    return array_reverse($r);
  }
  
  function ErrorMsg($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'ERRORMSG',(integer)$value);
  }

  function ExternIDfindID($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'EXTERNIDFINDID',$this->_Network,(integer)$value);
  }

  function ExternIDfindIndex($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'EXTERNIDFINDINDEX',$this->_Network,(string)$value);
  }

  function GetLinkDist($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'GETLINKDIST',$this->_Network,(integer)$value);
  }

  function GetLinkSpeed($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'GETLINKSPEED',$this->_Network,(integer)$value);
  }

  function GetLinkTime($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'GETLINKTIME',$this->_Network,(integer)$value);
  }

  function GetOpenStatus($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'GETOPENSTATUS',$this->_Network,(integer)$value);
  }

  function GISformat($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'GISFORMAT',$this->_Network,(integer)$value);
  }

  function LinkMax() {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'LINKMAX',$this->_Network);
  }

  function Location2Coordinate($link,$percent) {
    $r=array();
    list($r['err'],$r['xlong'],$r['ylat']) = kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'LOCATION2COORDINATE',$this->_Network,(integer)$link,(double)$percent);
    return array_reverse($r);
  }

  function NetworkLength() {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'NETWORKLENGTH',$this->_Network);
  }

  function NodeCoordX($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'NODECOORDX',$this->_Network,(integer)$value);
  }

  function NodeCoordY($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'NODECOORDY',$this->_Network,(integer)$value);
  }

  function NodeMax() {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'NODEMAX',$this->_Network);
  }

  function NWloaded() {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'NWLOADED',$this->_Network);
  }

  function RoadName1_Get($id,$linkid) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'ROADNAME1_GET',$this->_Network,(integer)$id,(integer)$linkid);
  }

  function RoundAbout($value) {
    $r=array(); 
    list($r['err'],$r['text']) = kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'ROUNDABOUT',$this->_Network,(integer)$value);
    return array_reverse($r);
  }

  function RoundAboutExitNode($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'ROUNDABOUTEXITNODE',$this->_Network,(integer)$value);
  }

  function SetLinkSpeed($link,$speed) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'SETLINKSPEED',$this->_Network,(integer)$link,(integer)$speed);
  }

  function SetLinkTime($link,$time) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'SETLINKTIME',$this->_Network,(integer)$link,(double)$time);
  }

  function SetNet($value) {
    $this->_Network = (integer)$value;
    if (is_array($this->_NetCalcs))
      //foreach ($this->_NetCalcs as $value) $value->SetNet($value);
      foreach ($this->_NetCalcs as $netcalc) $netcalc->SetNet($value);
  }

  function Units($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'UNITS',$this->_Network,(integer)$value);
  }

  function UTurnAllowed($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'UTURNALLOWED',$this->_Network,(integer)$value);
  }

  function Valency($value) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'VALENCY',$this->_Network,(integer)$value);
  }

  function GetFile($format,$fn) {
    return kbmMW_Client_SendRequest($this->_Client,$this->_ServiceName,$this->_Version,'GETFILE',(integer)$format,(string)$fn);
  }
  
}


?>
