<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: WMS.inc,v 1.2 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_maplayer.inc"));

class WMS_MapLayer extends MapLayer {
  
  function WMS_MapLayer($tree, $name, $request, $manager) {
    $this->MapLayer(&$tree, $name, &$request, &$manager);
    if(!isSet($this->properties["connection_type"])) $this->properties["connection_type"] = 'direct';
  }

  function WriteHTML() {
    $this->CreateHTMLContent();
  }


  function GetParameters () {
    $res = "";
    if (Is_Array($this->properties["parameters"])) {
      reset($this->properties["parameters"]);
      while (list($key,$value) = each($this->properties["parameters"])) {
        $res .= "&$key=$value";
      }
    }
    return $res;
  }

  function GetURLParameters() {
    require(FileUp2('.admin/map_schema.inc'));
//    $layers = array_keys($this->tree["layers"]);
    $version = $this->manager->project[$props['connection']]['servers'][0]['version'] ?
                         $this->manager->project[$props['connection']]['servers'][0]['version'] : '1.1.1';
    $content = 'REQUEST=GetMap&SERVICE=WMS&VERSION='.$version;
    $content .= "&LAYERS=".Implode(',',$this->GetLayers());
    $content .= "&STYLES=";
    $content .= "&WIDTH=" .$this->request["width"] .'&HEIGHT=' .$this->request["height"];
    $content .= "&BBOX=".$this->request['bbox']['minx'].','.$this->request['bbox']['miny'].','.$this->request['bbox']['maxx'].','.$this->request['bbox']['maxy'];
    switch($MAP_PROJECT['coord_sys']) {
      case 'S42': $srs = '28403'; break;
      case 'WGS84': $srs = '28403'; break;
      case 'SJTSK':
      default: $srs = '2065'; break;
    }
    $content .= '&SRS=EPSG:'.$srs;
    $content .= '&FORMAT='.($this->properties['content_type'] ? $this->properties['content_type'] : 'image/gif');
    
    if($this->properties['backgroundcolor']) {
      $bg_arr = Explode(',',$this->properties['backgroundcolor']);
      $content .= '&BGCOLOR=0x'.dechex($bg_arr[0]).dechex($bg_arr[1]).dechex($bg_arr[2]);
    }
    $content .= '&TRANSPARENT='.($this->properties['transcolor'] ? 'TRUE' : 'FALSE');

    if ($this->request["cacheId"]) $content .= '&cacheId=' .$this->request["cacheId"];
    $content .= $this->GetParameters();

    return $content;
  }

  function CreateHTMLContent() {
    $this->content = '<img name="Img_'.$this->name.'" src="';
    if ($this->properties["connection_type"] == "direct") {
      $url = $this->manager->GetURL($this->name);
      $this->content .= $url;
      $this->content .= strstr($url,'?') ? '&' : '?';
      $this->content .= $this->GetURLParameters();
    }
    else
/*
    elseif (($this->properties["connection_type"] == "session" && $this->request["mode"] == 0) ||
            ($this->tree["objects"]) || ($this->tree["style"]["map_path"])) {
      $this->content .= $this->tree["style"]["map_path"]."map.php?REQUEST=SImage&MAP=".$this->request["map"]."&INDEX=".$this->tree["index"];
*/
//     elseif (($this->properties["connection_type"] == "session" && $this->request["mode"] == 0) ||
//             ($this->tree["objects"])) {
//       $this->content .= "map.php?REQUEST=SImage&MAP=".$this->request["map"]."&INDEX=".$this->tree["index"].'&cache='.md5(time());
//       if (!$this->tree["select"])
//         $this->tree["select"] = array();
// 
//       if (Is_Array(&$this->tree["layers"]))
//         $layers = $this->tree["layers"];
//       else
//         $layers = array();
//       $layers[] = $this->tree;
// 
//       while (list(, $val) = each($layers)) {
//         $sel = $val["select"];
//         if ($sel) {
//           if ($sel[0] == "!s") continue;
//           reset($sel);
//           while (list(, $val2) = each($sel)) {
//             $this->tree["select"][] = $val2;
//           }
//         }
//       }
// 
//       $setting["name"] = $this->name;
//       $setting["tree"] = $this->tree;
//       $setting["request"] = $this->request;
//       $GLOBALS["TMapServer_Session"]["Interface"][$this->request["map"]][$this->tree["index"]] = $setting;
//     }
//     else {
//       $this->content .= $this->tree["style"]["map_path"]."map_image.php?name=".$this->name;
//       $this->content .= $this->GetURLParameters();
//     }
    
    $this->content .= '" hspace=0 vspace=0 border=0 ';
    if ($this->request["print"])
      'width="'.$this->request["print"]["width"].'" height="'.$this->request["print"]["height"];
    else
      'width="'.$this->request["width"].'" height="'.$this->request["height"];
    $this->content .= '>';

    $this->WriteHTMLLayer(array("visible"=>true));
  }

}


?>
