<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: TileMapService.inc,v 1.1 2008/02/05 13:11:16 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/connector/maplayer/Composite.inc"));
require_once(FileUp2(".admin/map_functions.inc"));

class TileMapService_MapLayer extends Composite_MapLayer {

  function TileMapService_MapLayer($tree, $name, $request, $manager) {
    $this->Composite_MapLayer(&$tree, $name, &$request, &$manager);
  }

  function WriteHTML() {
    //Find nearest resolution
    $tiles = &$this->properties['tiles'];

    $resolutions = $tiles['resolutions'];
    $px = $this->request['pixel'];
    $dif = abs($pixel-$res); 
    $res_nearest = $resolutions[0];
    $dif_last = abs($pixel-$res_nearest);
    foreach ($resolutions as $res) {
      $dif = abs($px-$res);
      if ($dif_last < $dif) {
        break;
      } elseif ($dif < $dif_last) {
        $res_nearest = $res;
        $dif_last = $dif;
      }
    }
    //Tiles
    $tilewidth = $res_nearest * $tiles['width'];
    $tileheight = $res_nearest * $tiles['height'];
    $tilewidthpx = Round($tiles['width'] * $px / $res_nearest);
    $tileheightpx = Round($tiles['height'] * $px / $res_nearest);
    //Origin
    $originx = $tiles['origin']['x'] ? $tiles['origin']['x'] : 0;
    $originy = $tiles['origin']['y'] ? $tiles['origin']['y'] : 0;
    //Tile count to vieport left and top 
    $tilecountleft = ($this->request['bbox']['minx'] - $originx) / $tilewidth;
    $tilecounttop = ($this->request['bbox']['maxy'] - $originy) / $tileheight;
    //Pixels to a viewport left and top
    $viewleft = Round((Floor($tilecountleft) - $tilecountleft) * $tilewidthpx);
    $viewleft += -20;
    $viewtop = Round(($tilecounttop - Ceil($tilecounttop)) * $tileheightpx);
    //First tile from left and top
    $tilecountleft = Floor($tilecountleft);
    $tilecounttop = Ceil($tilecounttop);
    $layers = Explode(',', $this->tree['name'].','.$this->GetCollectionLayers($this->tree));
    sort($layers);
    $layers = Implode(',',$layers);
    //$dir = crc32($layers);
    
    switch ($this->tree['style']['content-type']) {
      case 'image/jpeg':
        $extension = '.jpeg'; 
      break;
      case 'image/gif':
        $extension = '.gif';  
      break;
      case 'image/png':
      default:
        $extension = '.png'; 
      break;
    }
    $this->content = '
    <script>
    function createCookie2(name,value,path,days) {
       if (days) {
        var date = new Date();
        date.setTime(date.getTime()+(days*24*60*60*1000));
        var expires = "; expires="+date.toGMTString();
       }
       else var expires = "";
       document.cookie = name+"="+value+expires+"; path="+path;
    }
    createCookie2(\'ulayers\',\''.$layers.'\',\''.DirName($_SERVER["SCRIPT_NAME"]).'\',1);
    </script>
    ';
    
    for ($c=$tilecountleft, $l=$viewleft; $l<$this->request['width']; $c++, $l+=$tilewidthpx) {
      for ($r=$tilecounttop-1, $t=$viewtop; $t<$this->request['height']; $r--, $t+=$tileheightpx) {
        $this->content .= "\n<img src=\"".$tiles['repository']['url']."default/$res_nearest/$c/$r$extension";
        //if (!Is_array($_COOKIE)) $this->content .= "?ulayers=$layers";
        $this->content .= "\""; 
        //$this->content .= ' width="'.$tilewidthpx.'" height="'.$tileheightpx.'"'; 
        $this->content .= ' style="width:'.$tilewidthpx.'px;height:'.$tileheightpx.'px;position:absolute;top:'.$t.';left:'.$l.'">'; 
      }
    }
    $this->content .= "\n";
    $this->WriteHTMLLayer(array());
  }
  
  function WriteGD() {
    //Find nearest resolution
    $tiles = &$this->properties['tiles'];
    
    $resolutions = $tiles['resolutions'];
    $px = $this->request['pixel'];
    $dif = abs($pixel-$res); 
    $res_nearest = $resolutions[0];
    $dif_last = abs($pixel-$res_nearest);
    foreach ($resolutions as $res) {
      $dif = abs($px-$res);
      if ($dif_last < $dif) {
        break;
      } elseif ($dif < $dif_last) {
        $res_nearest = $res;
        $dif_last = $dif;
      }
    }
    //Tiles
    $tilewidth = $res_nearest * $tiles['width'];
    $tileheight = $res_nearest * $tiles['height'];
    $tilewidthpx = Round($tiles['width'] * $px / $res_nearest);
    $tileheightpx = Round($tiles['height'] * $px / $res_nearest);
    //Origin
    $originx = $tiles['origin']['x'] ? $tiles['origin']['x'] : 0;
    $originy = $tiles['origin']['y'] ? $tiles['origin']['y'] : 0;
    //Tile count to vieport left and top 
    $tilecountleft = ($this->request['bbox']['minx'] - $originx) / $tilewidth;
    $tilecounttop = ($this->request['bbox']['maxy'] - $originy) / $tileheight;
    //Pixels to a viewport left and top
    $viewleft = Round((Floor($tilecountleft) - $tilecountleft) * $tilewidthpx);
    $viewleft += -20;
    $viewtop = Round(($tilecounttop - Ceil($tilecounttop)) * $tileheightpx);
    //First tile from left and top
    $tilecountleft = Floor($tilecountleft);
    $tilecounttop = Ceil($tilecounttop);
    $layers = Explode(',', $this->tree['name'].','.$this->GetCollectionLayers($this->tree));
    sort($layers);
    $layers = Implode(',',$layers);
    $dir = crc32($layers);
    
    switch ($this->tree['style']['content-type']) {
      case 'image/jpeg':
        $f_create = 'imagecreatefromjpeg';
        $extension = 'jpeg'; 
      break;
      case 'image/gif':
        $f_create = 'imagecreatefromgif';
        $extension = 'gif';  
      break;
      case 'image/png':
      default:
        $f_create = 'imagecreatefrompng';
        $extension = 'png'; 
      break;
    }

    $this->CreateImage();
    
    for ($c=$tilecountleft, $l=$viewleft; $l<$this->request['width']; $c++, $l+=$tilewidthpx) {
      for ($r=$tilecounttop-1, $t=$viewtop; $t<$this->request['height']; $r--, $t+=$tileheightpx) {
        $path = $tiles['repository']['path'];

        if(preg_match('/^http/',$path)) {
        
        }
        else {
          $f = "$path{$this->properties['connection']}/{$this->name}/{$this->name}/$dir/$res_nearest/$c/$r.$extension";
          if(!file_exists($f)) $f = "$path{$this->properties['connection']}/{$this->name}/{$this->name}/default/$res_nearest/$c/$r.$extension";
          if(file_exists($f)) $img = $f_create($f);
          else $img = imagecreatefrompng($path.'emptytile.png');
        }
 
        if ($img) {
          ImageCopy($this->ImageGD, $img, $l, $t, 0, 0, $tilewidthpx, $tileheightpx);
          ImageDestroy($img);
        }
      }
    }
    
    //ImagePNG($this->ImageGD);die();
    return $this->ImageGD;
    
  }

  function CreateImage() {
    if (!$this->ImageGD) {
      $this->ImageGD = (GetGDVersion()==2)?ImageCreateTrueColor($this->request['width'], $this->request['height']):ImageCreate($this->request['width'], $this->request['height']);
      $bgcolor = $this->properties['tiles']['background']['color'] ? $this->properties['tiles']['background']['color'] : array(255,255,255);
      $bgcolor = imagecolorallocate($this->ImageGD, $bgcolor[0], $bgcolor[1], $bgcolor[2]);
      imagefilledrectangle( $this->ImageGD, 0, 0, $this->request['width'], $this->request['height'], $bgcolor);
      if ($this->properties['tiles']['background']['transparent'] != false) imagecolortransparent($this->ImageGD, $bgcolor);
    }
  }

}

?>
