<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: MapServer.inc,v 1.17 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_maplayer.inc"));

class MapServer_MapLayer extends MapLayer {

  function MapServer_MapLayer($tree, $name, $request, $manager) {
    $this->MapLayer(&$tree, $name, &$request, &$manager);
  }

  function WriteHTML() {
    $this->CreateHTMLContent();
  }

  function WriteLegendHTML() {
    $this->ObjectHandlerWriteLegend("HTML");

    $this->output .= $this->legend_output;
    if ($this->properties['legend']['type'] == 'MapServer' || !$this->properties['legend']['type']) {
      $setting["name"] = $this->name;
      $setting["tree"] = $this->tree;
      $setting["request"] = $this->request;
      $GLOBALS["TMapServer_Session"]["Interface"][$this->request["map"]][$this->tree["index"]] = $setting;
      $this->output .= "<IMG src=\"map.php?REQUEST=SImage&MAP=".$this->request["map"]."&INDEX=".$this->tree["index"]."&MapServerLegend=1\" hspace=0 vspace=0 border=0><p>\n";
    }
    if (!$this->cache_output) {
      echo $this->output;
    }
  }

  function WriteGIF($fn_image="",$url_append="") {
    $this->ImageFormat = "GIF";
    return $this->WriteImage($fn_image, $url_append, "map_imagetype=gif");
  }

  function WritePNG($fn_image="",$url_append="") {
    $this->ImageFormat = "PNG";
    return $this->WriteImage($fn_image, $url_append, "map_imagetype=png");
  }

  function WriteJPEG($fn_image="", $url_append="", $quality=-1) {
    $quality = $quality?'&map_imagequality='.$quality:'';
    $this->ImageFormat = "JPEG";
    return $this->WriteImage($fn_image, $url_append, "map_imagetype=jpeg".$quality);
  }

  function WriteGD() {
    $this->ImageFormat = "GD";
    $this->ImageGD = true;
    $this->SaveToFile = true;
    $fa = '';
    switch($this->properties['content-type']) {
       case 'image/jpeg': $q = $this->properties['jpeg-level']?'&map_imagequality='.$this->properties['jpeg-level']:'';
                          $fa = "map_imagetype=jpeg".$q;
                    break;
       case 'image/gif': $fa = "map_imagetype=gif";
                    break;
       case 'image/png': $fa = "map_imagetype=png";
                    break;
    }
    $this->WriteImage('','',$fa);
    return $this->ImageGD;
  }

  function WriteImage($fn_image, $url_append, $format_append) {
    $tim_start = GetTimeOfDay();

    if ($GLOBALS['MapServerLegend']) $this->properties['parameters']['mode']='legend';

    if (!$url_append) {
      $url_append = "";
      if (Is_Array($this->request)) {
        if ($this->properties['parameters']['mode']=='legend') {
          $layers = Implode("&layer=",array_intersect($this->GetLayers('legend'), $this->GetLayers()));
        } else {
          $layers = Implode("&layer=",$this->GetLayers());
        }
        $url_append .= "layer=$layers";
        if ($this->request["print"]) {
          $url_append .= "&mapsize=" .$this->request["print"]["width"] .'+' .$this->request["print"]["height"];
          $url_append .= "&mapext=".$this->request["print"]['minx'].'+'.$this->request["print"]['miny'].'+'.$this->request["print"]['maxx'].'+'.$this->request["print"]['maxy'];
        } else {
          $url_append .= "&mapsize=" .$this->request["width"] .'+' .$this->request["height"];
          $url_append .= "&mapext=".$this->request['bbox']['minx'].'+'.$this->request['bbox']['miny'].'+'.$this->request['bbox']['maxx'].'+'.$this->request['bbox']['maxy'];
        }
        if ($this->request["cacheId"]) $url_append .= '&cacheId=' .$this->request["cacheId"];
        if ($this->properties["session"]) {
          $url_append .= $this->session[$this->request["map"]][$this->name]["theme_mapping"];
        }
      }
    } else {
      $this->request = $GLOBALS["HTTP_GET_VARS"];
      $ext = Explode(" ", $this->request["mapext"]);
      $this->request['bbox']['minx'] = $ext[0];
      $this->request['bbox']['miny'] = $ext[1];
      $this->request['bbox']['maxx'] = $ext[2];
      $this->request['bbox']['maxy'] = $ext[3];
      $ext = Explode(" ", $this->request["mapsize"]);
      $this->request['width'] = $ext[0];
      $this->request['height'] = $ext[1];
      session_start();
      $this->tree = $GLOBALS["tree"];
      $this->tree["select"] = array();
    }
    
    $this->ObjectHandlerWriteLayerBefore($this->ImageFormat);

    $size = 0;
    $url = $this->manager->GetURL($this->name);
    $url .= $this->GetParameters();
    $url .= "&".$url_append."&".$format_append;

//    $select_params = $this->GetSelectParameters();
//    if ($select_params) $url .= "&".$select_params;

    if ($usegd || $this->SaveToFile):
      if (!$fn_image) {
        $fn_image = $this->File?$this->File:(Tempnam(($GLOBALS["SERVER_SYSTEM"] == "UNIX")?"/tmp":GetEnv("TEMP"), "tms_"));
        $temporaryfile = true;
      }
    endif;
    //die($url);
//    die("<a href='".Str_replace("127.0.0.1",$GLOBALS["SERVER_NAME"],$url)."'>$url</a>");

    $fp = FOpen($url, "r");

    if ($fp):

      if ($this->request["no_output"]):
        $size = 0;
        while (!feof($fp)):
          $buf = FRead($fp, 1024);
          $size += StrLen($buf);
        endwhile;
      elseif ($fn_image):
        $fp_image = FOpen($fn_image,"w");
        if ($fp_image):
          while (!feof($fp)):
            $buf = FRead($fp, 1024);
            FWrite($fp_image, $buf, 1024);
          endwhile;
          FClose($fp_image);
          $size = FileSize($fn_image);
        endif;

        $imginfo = getimagesize($fn_image);
        switch ($imginfo[2]):
          case 1:
            $im = ImageCreateFromGIF($fn_image);
          break;
          case 2:
            $im = ImageCreateFromJPEG($fn_image);
          break;
          case 3:
            $im = ImageCreateFromPNG($fn_image);
          break;
          default:
            echo("MapServer: Cannot create image. <br>");
            $fp = fOpen($fn_image, "r");
            echo fRead($fp, 5000);
            fClose($fp);
            die();
        endswitch;
        if ($temporaryfile):
          UnLink($fn_image);
          $temporaryfile = false;
        endif;
      else:
        $tim_end = GetTimeOfDay();
        $size = FPassThru($fp);
      endif;
    endif;

    if ($this->ImageGD) {
      $this->ImageGD = $im;
    } elseif ($fn_image) {
      switch ($this->ImageFormat):
        case "GIF":
          $size = ImageGIF($im, $fn_image);
        break;
        case "PNG":
          $size = ImagePNG($im, $fn_image);
        break;
        case "JPEG":
          $size = ImageJPEG($im, $fn_image);
        break;
      endswitch;

      if (!$this->SaveToFile && $temporaryfile) UnLink($fn_image);

    }

    $this->ObjectHandlerWriteLayerAfter($this->ImageFormat);

    //Get time for request for log of Apache
    if (function_exists("DiffTime")) {
      if (!$tim_end) $tim_end = GetTimeOfDay();
      @$t_diffm = Round(1000*DiffTime($tim_end["sec"], $tim_end["usec"], $tim_start["sec"], $tim_start["usec"]));
      if (function_exists("apache_note")) {
        @apache_note("MAP_REQUEST_TIME",$t_diffm);
      }
    }

    return $size;
  }


  function GetParameters () {
    $res = "";
    if (Is_Array($this->properties["parameters"])) {
      reset($this->properties["parameters"]);
      while (list($key,$value) = each($this->properties["parameters"])) {
        $res .= "&$key=$value";
      }
    }
    return $res;
  }

  function GetURLParameters() {
//    $layers = array_keys($this->tree["layers"]);
    $layers = Implode("&layer=",$this->GetLayers());
    $content .= "&layer=$layers";
    $content .= "&mapsize=" .$this->request["width"] .'+' .$this->request["height"];
    $content .= "&mapext=".$this->request['bbox']['minx'].'+'.$this->request['bbox']['miny'].'+'.$this->request['bbox']['maxx'].'+'.$this->request['bbox']['maxy'];
    if ($this->request["cacheId"]) $content .= '&cacheId=' .$this->request["cacheId"];
    if ($this->properties["session"]) {
      $content .= $this->session[$this->request["map"]][$this->name]["theme_mapping"];
    }
    $content .= $this->GetParameters();
    return $content;
  }

  function CreateHTMLContent() {
//  print_r($this->tree);
    $this->content = '<img name="Img_'.$this->name.'" src="';
    if ($this->properties["connection_type"] == "direct") {
      $this->content .= $this->manager->GetURL($this->name);
      $this->content .= $this->GetURLParameters();
    }
/*
    elseif (($this->properties["connection_type"] == "session" && $this->request["mode"] == 0) ||
            ($this->tree["objects"]) || ($this->tree["style"]["map_path"])) {
      $this->content .= $this->tree["style"]["map_path"]."map.php?REQUEST=SImage&MAP=".$this->request["map"]."&INDEX=".$this->tree["index"];
*/
    elseif (($this->properties["connection_type"] == "session" && $this->request["mode"] == 0) ||
            ($this->tree["objects"])) {
      $this->content .= "map.php?REQUEST=SImage&MAP=".$this->request["map"]."&INDEX=".$this->tree["index"].'&cache='.md5(time());
      if (!$this->tree["select"])
        $this->tree["select"] = array();

      if (Is_Array(&$this->tree["layers"]))
        $layers = $this->tree["layers"];
      else
        $layers = array();
      $layers[] = $this->tree;

      reset($layers);
      while (list(, $val) = each($layers)) {
        $sel = $val["select"];
        if ($sel) {
          if ($sel[0] == "!s") continue;
          reset($sel);
          while (list(, $val2) = each($sel)) {
            $this->tree["select"][] = $val2;
          }
        }
      }

      $setting["name"] = $this->name;
      $setting["tree"] = $this->tree;
      $setting["request"] = $this->request;
      $GLOBALS["TMapServer_Session"]["Interface"][$this->request["map"]][$this->tree["index"]] = $setting;
    }
    else {
      $this->content .= $this->tree["style"]["map_path"]."map_image.php?name=".$this->name;
      $this->content .= $this->GetURLParameters();
    }
    $this->content .= '" hspace=0 vspace=0 border=0 ';
    if ($this->request["print"])
      'width="'.$this->request["print"]["width"].'" height="'.$this->request["print"]["height"];
    else
      'width="'.$this->request["width"].'" height="'.$this->request["height"];
    $this->content .= '>';

    $this->WriteHTMLLayer(array("visible"=>true));
  }

}


?>
