<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: MapScript.inc,v 1.3 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

include_once(FileUp2(".admin/main_maplayer.inc"));

class MapScript_MapLayer extends MapLayer {

  function MapScript_MapLayer($tree, $name, $request, $manager) {
    $this->MapLayer(&$tree, $name, &$request, &$manager);
  }

  function WriteHTML() {
    $this->CreateHTMLContent();
  }

  function WriteImage($fn_image="", $url_append, $type, $quality=-1) {

    if (!$fn_image) {
      $fn_image = $this->File;
    } else {
      $this->File = $fn_image;
    }
  
    if (!$url_append) {
      $url_append = "";

      if (Is_Array($this->request)) {
        $lrs = $this->GetLayers();
        $url_append .= "layer=".Implode("&layer=",$lrs);
        $layers = array();
        reset($lrs);
        while (list(,$val) = each($lrs)) {
          $layers[$val] = true;
        }
        $url_append .= "&mapsize=" .$this->request["width"] .'+' .$this->request["height"];
        $url_append .= "&mapext=".$this->request['bbox']['minx'].'+'.$this->request['bbox']['miny'].'+'.$this->request['bbox']['maxx'].'+'.$this->request['bbox']['maxy'];
        if ($this->request["cacheId"]) $url_append .= '&cacheId=' .$this->request["cacheId"];
        if ($this->properties["session"]) {
          $url_append .= $this->session[$this->request["map"]][$this->name]["theme_mapping"];
        }
      }
    } else {
      $this->request = $GLOBALS["HTTP_GET_VARS"];
      $layers = array();
      $lrs = Explode("&", $GLOBALS["QUERY_STRING"]);
      reset($lrs);
      while (list(,$val) = each($lrs)) {
        if (Eregi("layer=(.*)", $val, $parse)) {
          $layers[$parse[1]] = true;
        } 
      } 
      $ext = Explode(" ", $this->request["mapext"]);
      $this->request['bbox']['minx'] = $ext[0];
      $this->request['bbox']['miny'] = $ext[1];
      $this->request['bbox']['maxx'] = $ext[2];
      $this->request['bbox']['maxy'] = $ext[3];
      $ext = Explode(" ", $this->request["mapsize"]);
      $this->request['width'] = $ext[0];
      $this->request['height'] = $ext[1];
      session_start();
      $this->tree = $GLOBALS["tree"];
      $this->tree["select"] = array();
    }
/*  
    if (!$url_append) {
      $url_append = "";
      if (Is_Array($this->request)) {
        while (list($key,$value) = each($this->request)) {
          $url_append .= "&$key=$value";
        }
      }
    }*/
    if ($this->request) {
      $request = $this->request;
      $request["mode"] = $request["mode"]?$request["mode"]:"map"; 
    } else {
      $request = $GLOBALS["HTTP_GET_VARS"];
    } 

    $srv = $this->manager->GetServer($this->name);
    
    //Create a map object
    $cwd = realpath(".");
    $_map = ms_newMapObj($srv["project"]);
    chdir($cwd);
    
    switch ($request["mode"]):
      case "map":
      case "scalebar": 
        //ImageType
        switch ($type):
          case "gif":
            $imagetype = MS_GIF;
//            $_map->transparent = MS_ON;
//            $_map->interlace = MS_ON;
          break;
          case "jpeg":
            $imagetype = MS_JPEG;
            $imagequality = $request["map_imagequality"]?$request["map_imagequality"]:$quality;
          break;
          case "png":
            $imagetype = MS_PNG;
//            $_map->transparent = MS_OFF;
          break;
        endswitch;
      
        //mapsize  
        if ($request["width"]):
          $_map->set("width", $request["width"]); 
          $_map->set("height", $request["height"]); 
        endif;
  
        //Map Extent
        if ($request["bbox"]):
          $_map->setextent($request['bbox']['minx'], $request['bbox']['miny'], $request['bbox']['maxx'], $request['bbox']['maxy']);
        endif;
      break;
      default:
        die("MapScript: Unknown mode");  
    endswitch;
    
    $size = 0;
    
    switch ($request["mode"]):
      case "map": 
        //Set layers visibility
        for ($i=0; $i < $_map->numlayers; $i++) {
          $lr = $_map->getLayer($i);
          //Scale dependent
          $on = $_map->scale >= $lr->minscale && 
               ($_map->scale <= $lr->maxscale || $lr->maxscale == -1)?MS_ON:MS_OFF;
          if ($layers[$lr->name]) {
            //The layer itself 
            $lr->set("status", $layers[$lr->name]?$on:MS_OFF);
          } else {
            //The layer in a group
            $lr->set("status", ($lr->group && $layers[$lr->group])?$on:MS_OFF);
          }
//          $lr->set("status", MS_ON);
//          echo $lr->name." ".$on." ".$lr->minscale." ".$lr->maxscale."\n";
        }
        
        //Draw the map 
        $img = $_map->draw();
        
//        session_start();
        
/*        
        //Draw shortest path
        $highligt = array(5063,5148,5157,5177,5176,5147,5175,5173,5171,5169,5167,5165,5164,5162,5287,5188,5204,5146,6531,6533,6535,6537,6538,6540,6611,6469,6480,6482,6484,6485,6486,6488,6489,6472,6463,6657,6656,6654,6652,6621,6623,6650,6726,6677,6675,6781,6636,7711,7380,7412,7382,7414,7733,7384,7416,7420,7421,7422,7424,7729,7396,8828,8829,9168,9270,9170,9278,9280,9282,9180,9178,9181,9381,9265,9264,9380,9157,9159,12707,12478,12477,12485,12486,12490,12721,21203,21073,21002,21003,21914,22063,21917,22064,21909,22254,22110,22111,22113,25036,25056,25055,25223,25067,25250,25871,25604,25603,25646,25647,26431,26474,26477,26440,26439,26009,26214,26216,26217,26063,26067,26218,26029,26068,26070,26229,26071,26073,26075,26031,26077,26079,26081,26228,26042,26045,26190,26191,26028,26027,26056,27864,27685,27686,27007,27110,26921,26923,26925,26885,26926,26928,27099,27098,26906,26904,26905,27035,26931,26933,26934,26936,26938,26892,26939,26993,26893,27102,26941,26942,26608,26710,26712,26715,26702,26716,26705,26733,26735,26737,26870,26863,26866,26792,27499,27458,27365,27391,27393,27395,27374,27502,27398,27377,27376,27400,27383,27521,27590,27591,27520,27584,27586,27585,27588,27564,27589,27570);
//        $highligt = array(5203,5202,5158,5041,5561,5563,5564,5658,5517,5520,5467,5466,5395,5423,5425,5427,5430,5529,5431,5433,5435,5438,5684,5709,5706,5704,5702,5700,5699,5697,5695,5679,5694,5797,5806,5807,5853,5683,5803,5978,5867,5906,5902,5905,5981,5817,5976,5815,5936,5934,5930,5926,5924,5917,5916,5828,5827,5829,5799,5831,5802,8400,5894,5891,5892,8503,8506,8501,8499,8366,8367,8604,8573,8601,8565,8567,8461,8460,8463,8466,8548,8550,8748,8551,8488,8703,8704,8706,8708,8605,8788,8785,8779,8656,8193,8350,8325,8323,8202,8201,8204,8321,9423,9424,9093,9477,9476,8983,8982,8962,8960,9135,9011,9010,9015,9013,8929,8928,8930,8932,8933,8913,8943,8915,9375,9175,9176,9376,9186,9114,9113,9112,9107,9105,9101,8860,8858,8857,7632,7634,7635,7619,7637,7551,7506,7731,7508,7401,7391,7495,7665,7412,7380,7645,7372,7374,7376,7377,7516,7517,7518,7437,7435,7718,7713,7103,6841,6840,7100,6799,6233,6232,6231,6230,6341,6453,6340,6272,6271,6274,6334,6335,6328,6326,6293,6292,6219,6306,6445,6893,7068,7067,7066,7058,7045,6877,6941,6878,6795,6905,7021,6911,6913,6936,6793,6916,6917,6923,6924,6807,6806,6856,6854,6972,6973,7124,6851,7096,6849,6787,6788,6852,7092,7339,7976,7972,7794,7793,7982,7980,7977,7924,7925,7759,7828,7830,7917,7826,7994,7966,7961,7773,7775,7857,7899,7895,7896,10428,10429,10256,10195,10345,10349,10480,7923,7850,7865,7776,7777,7779,7780,7786,12083,11840,11843,11851,12067,12068,12069,12070,11889,11896,11897,11895,12101,12017,12018,12020,11970,12021,11823,11844,11960,11996,11997,11987,11988,12000,11945,11946,12004,12398,12399,12407,12405,12126,12127,12450,12451,12452,12404,12434,12422,12423,12424,12418,12217,12216,12377,12413,12414,12390,12471,12381,12380,12382,12383,12242,12118,12117,12131,12797,12794,12792,12791,12790,12834,12836,12889,12886,12844,12843,12845,12826,12824,12825,12922,12883,12819,12711,21102,20921,20973,20918,20915,20916,20940,21195,21111,21108,21109,21196,21183,21172,21087,21088,21090,20994,21206,21002,21003,22000,21922,21482,21479,21430,21428,21426,21427,21414,21415,21902,21919,21899,21881,21937,21939,22010,22017,22018,22020,22044,22043,21887,22922,22869,22924,22926,22881,22872,22874,22892,22970,23104,23105,23103,23107,23136,23137,23000,22999,22980,23003,23002,22981,23039,23037,23035,23033,23031,22979,22977,23028,23162,22146,22144,22090,22203,22252,22097,22112,22111,22113,25036,25056,25055,25223,25067,25250,25596,25868,25602,25744,25615,25614,25610,25336,25392,25337,25385,25346,25344,25349,25390,25388,25387,25241,25240,25412,25237,25248,25261,24005,24008,24053,24054,24045,24042,24043,24106,24092,23987,24142,23968,23985,23805,23792,23788,23803,23553,23518,23550,23517,23574,23572,23573);

        $layer_route = $_map->getLayerByName('useky_high');
        $rectmap = $_map->extent;

        //Draw as shape
        $shpfile = ms_newShapefileObj($_map->shapepath."/".$layer_route->data, -1);
        while (list($key, $val) = each($highligt)) {
          $shp = $shpfile->getShape($val-1);
          if ($this->Extent_Insersect($rectmap, $shp->bounds)) { 
            $shp->Draw($_map,$layer_route,$img,0,'');
          }
          $shp->free();
        }
        
/*        //Draw all as shape
        for ($i=0; $i<$shpfile->numshapes; $i++) {
          $shp = $shpfile->getShape($i);
          if ($this->Extent_Insersect($rectmap, $shp->bounds)) { 
            $shp->Draw($_map,$lr_useky,$img,0,'');
          }
          $shp->free();
        }
*/        
//        $shpfile->free();

      break;
      case "scalebar":
        //Draw the scalebar
        $img = $_map->drawScaleBar();
      break;
    endswitch;
    
    //Send image to stdout
    switch ($type):
      case "gif":
        $size = $img->saveImage($fn_image, $imagetype, $_map->transparent, $_map->interlace, $imagequality);
//        $size = $img->saveImage($fn_image, $_map->transparent, $_map->interlace);
      break;
      case "jpeg":
      case "png":
        $size = $img->saveImage($fn_image, $imagetype, $_map->transparent, $_map->interlace, $imagequality);
    endswitch;
     
    flush();
  
    return $size; 
  } 
  
  function WriteGIF($fn_image="",$url_append="") {
    $this->ObjectHandlerWriteLayerBefore("GIF");
    $res = $this->WriteImage($fn_image, $url_append, "gif");
    $this->ObjectHandlerWriteLayerAfter("GIF");
    return $res;
  }

  function WritePNG($fn_image="",$url_append="") {
    $this->ObjectHandlerWriteLayerBefore("PNG");
    return $this->WriteImage($fn_image, $url_append, "png");
    $this->ObjectHandlerWriteLayerBefore("PNG");
  }

  function WriteJPEG($fn_image="", $url_append="", $quality=-1) {
    $this->ObjectHandlerWriteLayerBefore("JPEG");
    return $this->WriteImage($fn_image, $url_append, "jpeg", $quality);
    $this->ObjectHandlerWriteLayerBefore("JPEG");
  }
  
  function GetParameters () {
    $res = "";
    if (Is_Array($this->properties["parameters"])) {
      reset($this->properties["parameters"]);
      while (list($key,$value) = each($this->properties["parameters"])) {
        $res .= "&$key=$value";
      }
    }
    return $res;
  }
  
  function GetURLParameters() {
    $layers = array_keys($this->tree["layers"]);
    $layers = Implode("&layer=",$layers);
    $content .= "&layer=$layers";
    $content .= "&mapsize=" .$this->request["width"] .'+' .$this->request["height"];
    $content .= "&mapext=".$this->request['bbox']['minx'].'+'.$this->request['bbox']['miny'].'+'.$this->request['bbox']['maxx'].'+'.$this->request['bbox']['maxy'];
    if ($this->request["cacheId"]) $content .= '&cacheId=' .$this->request["cacheId"];
    if ($this->properties["session"]) {
      $content .= $this->session[$this->request["map"]][$this->name]["theme_mapping"];
    }
    $content .= $this->GetParameters();
    return $content;
  }
  
  function CreateHTMLContent() {
    $this->content = '<img name="Img_'.$this->name.'" src="';

    if ($this->properties["ConnectionType"] == "direct") {
      $this->content .= $this->manager->GetURL($this->name);
      $this->content .= $this->GetURLParameters();
    }
    elseif ($this->properties["ConnectionType"] == "session" && $this->request["type"] == "map") {
      $this->content .= "map.php?REQUEST=SImage&MAP=".$this->request["map"]."&INDEX=".$this->tree["index"];
      if (!$this->tree["select"]) 
        $this->tree["select"] = array();

      if (Is_Array(&$this->tree["layers"]))
        $layers = $this->tree["layers"];
      else
        $layers = array();
      $layers[] = $this->tree;

      reset($layers);
      while (list(, $val) = each($layers)) {
        $sel = $val["select"]; 
        if ($sel) {
          if ($sel[0] == "!s") continue;
          reset($sel);
          while (list(, $val2) = each($sel)) {
            $this->tree["select"][] = $val2;
          }
        }
      } 

      $setting["name"] = $this->name;
      $setting["tree"] = $this->tree;
      $setting["request"] = $this->request;
      $GLOBALS["TMapServer_Session"]["Interface"][$this->request["map"]][$this->tree["index"]] = $setting;
    }
    else {
      $this->content .= "map_image.php?name=".$this->name;
      $this->content .= $this->GetURLParameters();
    }
    $this->content .= '" hspace=0 vspace=0 border=0 width="'.$this->request["width"].'" height="'.$this->request["height"];
    $this->content .= '">';

    $this->WriteHTMLLayer(array("visible"=>true));
  }
  
/*  function CreateHTMLContent() {
    $this->content = '<img name="Img_'.$this->name.'" src="';

    $this->content .= $this->manager->GetURL($this->name)."?name=".$this->name;

    $layers = array_keys($this->tree["layers"]);
    $layers = Implode("&layer=",$layers);
    $this->content .= "&layer=$layers";
    $this->content .= "&mapsize=" .$this->request["width"] .'+' .$this->request["height"];
    $this->content .= "&mapext=".$this->request['bbox']['minx'].'+'.$this->request['bbox']['miny'].'+'.$this->request['bbox']['maxx'].'+'.$this->request['bbox']['maxy'];
    if ($this->request["cacheId"]) $this->content .= '&cacheId=' .$this->request["cacheId"];
    if ($this->properties["session"]) {
      $this->content .= $this->session[$this->request["map"]][$this->name]["theme_mapping"];
    }

    $this->content .= $this->GetParameters();

    $this->content .= '" hspace=0 vspace=0 border=0 width="'.$this->request["width"].'" height="'.$this->request["height"].'">';
    $this->WriteHTMLLayer(array("visible"=>true));
  }*/

  function Extent_Insersect (&$which, &$what) {
    $tile_ok = ($which->minx <= $what->minx && $which->miny <= $what->miny && $which->maxx >= $what->minx && $which->maxy >= $what->miny) ||
               ($which->minx <= $what->minx && $which->miny <= $what->maxy && $which->maxx >= $what->minx && $which->maxy >= $what->maxy) ||
               ($which->minx <= $what->maxx && $which->miny <= $what->miny && $which->maxx >= $what->maxx && $which->maxy >= $what->miny) ||
               ($which->minx <= $what->maxx && $which->miny <= $what->maxy && $which->maxx >= $what->maxx && $which->maxy >= $what->maxy);
    return $tile_ok;
  }
  
}

?>
