<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ImageCatalog_X_Y.inc,v 1.10 2007/01/17 13:54:54 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/connector/maplayer/ImageCatalog.inc"));

class ImageCatalog_X_Y_MapLayer extends ImageCatalog_MapLayer {
   
  function ImageCatalog_X_Y_MapLayer($tree, $name, $request, $manager) {
    $this->ImageCatalog_MapLayer(&$tree, $name, &$request, &$manager);
  }
  
  function GetTiles() {
    $this->tiles = array();
    $this->catalogs = $this->connection["catalogs"]?$this->connection["catalogs"]:array($this->connection);
    $first_only = $this->connection["first_catalog_only"];
//    p1($this);
    foreach ($this->catalogs as $catalog) {
      $this->GetTilesCatalog($catalog);
      if (count($this->tiles) > 0 && $first_only) { 
        foreach ($this->tiles as $tile) {
          if ($tile['image']) break(2);
        }
        $this->tiles = array();
      }
    }
  }

  function GetTilesCatalog($catalog) {
    static $md5_cache_image;
    if (!isset($md5_cache_image)) $md5_cache_image=array();

    $catalog["catalog"]["step_x"] = $catalog["catalog"]["step_x"]?$catalog["catalog"]["step_x"]:$this->connection["tile"]["pixel_width"]*$this->connection["tile"]["width"]; 
    $catalog["catalog"]["step_y"] = $catalog["catalog"]["step_y"]?$catalog["catalog"]["step_y"]:$this->connection["tile"]["pixel_height"]*$this->connection["tile"]["height"];

//    print_r($catalog["catalog"]);
    switch($catalog["catalog"]["corner"]) {
      case "ul":
        $catalog["catalog"]["y"] -= $catalog["catalog"]["step_y"]; 
      break;
    }
    
    $fromx = $catalog["catalog"]["x"]+Round(Floor(($this->request["bbox"]["minx"] - $catalog["catalog"]["x"])/$catalog["catalog"]["step_x"])*$catalog["catalog"]["step_x"]);
    $fromy = $catalog["catalog"]["y"]+Round(Ceil(($this->request["bbox"]["maxy"] - $catalog["catalog"]["y"])/$catalog["catalog"]["step_y"])*$catalog["catalog"]["step_y"]);

    if ($catalog["ocad"]) {
      $maxx = $catalog["catalog"]["x"] + $catalog["catalog"]["step_x"]*($catalog["ocad"]["cols"]);
      $maxy = $catalog["catalog"]["y"] + $catalog["catalog"]["step_y"]*($catalog["ocad"]["rows"]);
    }
    
    if (
      (isset($maxx) && ($this->request["bbox"]["minx"] >= $maxx)) ||
      ($this->request["bbox"]["maxx"] <= $catalog["catalog"]["x"] && $catalog["ocad"]) ||
      (isset($maxy) && ($this->request["bbox"]["miny"] >= $maxy)) ||
      ($this->request["bbox"]["maxy"] <= $catalog["catalog"]["y"] && $catalog["ocad"])) {
//      echo "-".$catalog["filename_format"][0]." ".$maxx." ".$this->request["bbox"]["minx"]."<br>";
      return false;
    }
//      echo "+".$catalog["filename_format"][0]."<br>";
    for ($y=$fromy; $y>$this->request["bbox"]["miny"]; $y-=$catalog["catalog"]["step_y"]) {
      for ($x=$fromx; $x<$this->request["bbox"]["maxx"]; $x+=$catalog["catalog"]["step_x"]) {
        $fn = $this->GetFileName($catalog, $x, $y);
        if ($fn && $this->connection["image_perm_replace"]) {
          $fperm = @fileperms($this->connection["image_path"].$fn);
          $hasperm=false;
          foreach($this->connection["image_perm_replace"] as $perm) {
            if ($perm['value']==substr(sprintf('%o', $fperm),$perm['substr'][0],$perm['substr'][1])) {
              $fileupdir = $this->FileUpDir($this->connection["image_path"],$perm['file']);
              $this->tiles[] = array("image"=>$fileupdir.$perm['file'],"x"=>$x,"y"=>$y);
              $hasperm=true;
              break;
            }
          }
          if ($hasperm) $fn = false;
        }
        if ($fn && $this->connection["image_md5_replace"]) {
          $md5sum = @md5_file($this->connection["image_path"].$fn);
          $md5 = $this->connection["image_md5_replace"][$md5sum];
          if ($md5) {
            $fileupdir = $this->FileUpDir($this->connection["image_path"],$md5);
            $this->tiles[] = array("image"=>$fileupdir.$md5,"x"=>$x,"y"=>$y);
            $fn = false;
          }
        }
        if ($fn && File_Exists($this->connection["image_path"].$fn)) {
          $this->tiles[] = array("image"=>$fn,"x"=>$x,"y"=>$y);
        } else {
          if (!$this->skipmissing) $this->tiles[] = array("image"=>false,"x"=>$x,"y"=>$y);
        }
      }
    }
  }
  
  function GetFileName($catalog, $x, $y) {
    @reset($catalog["filename_format"]);
    $res = "";
    for ($i=0; $i<Count($catalog["filename_format"]); $i++) {
      $val = $catalog["filename_format"][$i];
      if (Is_Array($val)) { 
        switch ($val["type"]) {
          case "x":
          case "y":
            $res .= SubStr(Str_Repeat("0", $val["length"]).$$val["type"], -1*$val["length"]);
          break;
          case "xl":
          case "yl":
            $val["type"] = $val["type"][0]; 
            $res .= SubStr($$val["type"], 0, $val["length"]);
          break;
          case "ocad_coord":
            $dx = Floor(($x - $catalog["catalog"]["x"])/$catalog["catalog"]["step_x"]);
            $dy = Floor(($y - $catalog["catalog"]["y"])/$catalog["catalog"]["step_y"])-1;
            if (($dx < 0) || ($dx > $catalog["ocad"]["cols"]-1) ||
                ($dy < 0) || ($dy > $catalog["ocad"]["rows"]-1)) {
              return false;
            }
            $res .= $dx."_".$dy;
          break;
          default:
            $res .= SubStr(Str_Repeat($val["type"],$val["length"]), -1*$val["length"]);
          break;
        }
      } else {
        $res .= $val;
      }
    }
//    e1($res."<br>"); 
    $res = $this->EncodeFileName($res);
//    e1($res."<br>"); 
//    echo $res;
//    die($res);
    return $res;
  }

  function FileUpDir($dir,$file) {
    static $cache = array();
    if (!isset($cache[$dir.$file])) {
      $updir = '';
      $i=20;
      while ($i-- && !File_Exists($dir.$updir.$file)) {
        $updir .= '../';
      }
      $cache[$dir.$file] = $updir;
    } 
    return $cache[$dir.$file];
  }
  
}

?>
