<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ImageCatalog.inc,v 1.8 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_maplayer.inc"));

class ImageCatalog_MapLayer extends MapLayer {

  var $encode = array();
  var $skipmissing=true;
   
  function ImageCatalog_MapLayer($tree, $name, $request, $manager) {
    $this->MapLayer(&$tree, $name, &$request, &$manager);
    $this->connection = $this->manager->GetServer($this->properties["connection"]);
  }

  function WriteHTML() {
    $this->CreateHTMLContent();
  }

  function WriteService() {
    $this->GetTiles();
    $res = array(
      'type'=>$this->tree["style"]["type"],
      'name'=>$this->name,
      'connection'=>$this->connection,
      'data'=>array()
    );
    foreach($this->tiles as $tile) {
      $pos = $this->GetImagePosition($tile);
      if (!$pos) continue;
      $res['data'][] = array(
        'img'=>$tile['image'],
        'x'=>$tile['x'],
        'y'=>$tile['y'],
        'pos'=>$pos
      );
    }
    return $res;
  }

  function WriteIFRM() {
    
    if (!function_exists('SortByPosition')) {
      function SortByPosition($a, $b) {
        if ($a['pos']['top'] == $b['pos']['top']) {
          if ($a['pos']['left'] == $b['pos']['left']) {
            return 0;
          } else {
            return ($a['pos']['left'] < $b['pos']['left'])?-1:1;
          }
        } else {
          return ($a['pos']['top'] < $b['pos']['top'])?-1:1;
        }
      }
    }    

    $this->skipmissing=false;
  
    $this->GetTiles();
    $data=array();
    foreach($this->tiles as $tile) {
      $pos = $this->GetImagePosition($tile);
      if (!$pos) continue;
      $data[] = array(
        'img'=>$tile['image'],
        'x'=>$tile['x'],
        'y'=>$tile['y'],
        'pos'=>$pos
      );
    }
    if ($data) {
      //Remove Duplicit
      $data2=array();
      foreach($data as $tile) {
        $key=$tile['x'].':'.$tile['y'];
        if (isset($data2[$key])) {
          if (!$data2[$key]['img'] && $tile['img']) {
            $data2[$key]=$tile;
          }
        } else {
          $data2[$key]=$tile;
        }
      }
      $data=array_values($data2);

      usort($data, 'SortByPosition');
      
      $matrix = array();
      $d=array(); 
      foreach($data as $tile) {
        $d[] = $tile['img']?$tile['img']:'-';
        $matrix[(string)$tile['pos']['left']][(string)$tile['pos']['top']]+=1;
      }
      
      $res = array(
        'pro'=>array(
          'typ'=>'imgmx',
          'nam'=>$this->name,
          'pos'=>array(
            'x'=>$data[0]['x'],
            'y'=>$data[0]['y'],
  //          'l'=>$data[0]['pos']['left'],
  //          't'=>$data[0]['pos']['top'],
            'w'=>$data[0]['pos']['width'],
            'h'=>$data[0]['pos']['height'],
          ),
          'cat'=>array(
            'u'=>$this->connection['image_path_url'],
            'u2'=>($this->connection['image_path_url2']?$this->connection['image_path_url2']:false),
            'r'=>Count(Current($matrix)),
            'c'=>Count($matrix),
          ),
        ),
        'dat'=>$d
      );
    } else {
      $res = array(
        'pro'=>array(
          'typ'=>'imgmx',
          'nam'=>$this->name
        ),
        'dat'=>array()
      );
    }
    return $res;
  }

  function WriteGD() {
    $this->ImageGD = ImageCreate($this->request['width'], $this->request['height']);
    $bgcolor = array(254,254,254);
    $bgcolor = imagecolorallocate($this->ImageGD, $bgcolor[0], $bgcolor[1], $bgcolor[2]);
    imagecolortransparent($this->ImageGD, $bgcolor);
    $this->WriteImage('GD');
    return $this->ImageGD;
  }
  
  function WriteGIF() {
    $this->WriteImage('GIF');
    ImageGIF($this->ImageGD);
    $this->DestroyImage();
  }

  function WriteImage($format) {
    if (!$this->ImageGD) {
      $this->ImageGD = ImageCreate($this->request['width'], $this->request['height']);
    }
    $this->GetTiles();
    reset($this->tiles);
    while (list(, $tile) = each($this->tiles)) {
      $pos = $this->GetImagePosition($tile);
      if (!$pos) continue;
      $fn = $this->connection["image_path"].$tile['image'];
      $imgsize = getimagesize($fn);
      switch($imgsize[2]) {
        case 1:
          $img = ImageCreateFromGif($fn);
        break;
        case 2:
          $img = ImageCreateFromJpeg($fn);
        break;
        case 2:
          $img = ImageCreateFromPng($fn);
        break;
        default:
          continue;
        break;
      }
      
      $dstx = ($pos['left'] < 0)?0:$pos['left']; 
      $dsty = ($pos['top'] < 0)?0:$pos['top'];
      $ratio = $imgsize[0]/$pos['width'];
      $dstw = $pos['width']+1+(($pos['left'] < 0)?$pos['left']:0)-(($pos['right'] > $this->request['width'])?$pos['right']-$this->request['width']-1:0); 
      $dsth = $pos['height']+1+(($pos['top'] < 0)?$pos['top']:0)-(($pos['bottom'] > $this->request['height'])?$pos['bottom']-$this->request['height']-1:0); 
      $srcx = Floor(($pos['left'] < 0)?-1*$ratio*$pos['left']:0); 
      $srcy = Floor(($pos['top'] < 0)?-1*$ratio*$pos['top']:0); 
      $srcw = Ceil(($dstw-1)*$ratio);  
      $srch = Ceil(($dsth-1)*$ratio);  
       
      imagecopyresized($this->ImageGD, $img, $dstx, $dsty, $srcx, $srcy, $dstw, $dsth, $srcw, $srch);
      ImageDestroy($img);
    }
  }

  function PrepareImage() {
    $this->Image = ImageCreate($this->request['width'], $this->request['height']);
  }
  
  function DestroyImage() {
    ImageDestroy($this->ImageGD);
    unset($this->ImageGD);
  }
  
  function CreateHTMLContent() {
    $this->GetTiles();
    reset($this->tiles);
    $output = "";
    $border = $this->properties["border"]?"border=1":"";
    
    $url_switch = true;
    reset($this->tiles);
    while (list(, $tile) = each($this->tiles)) {
      $pos = $this->GetImagePosition($tile);
      if (!$pos) continue;
      $left = $pos["left"]; 
      $top = $pos["top"];
      $style = ' style="position:absolute;left:'.$pos["left"].'px;top:'.$pos["top"].'px;height:'.$pos["height"].'px;width:'.$pos["width"].'px';      
      if ($this->properties["border"]) $style.=';border:1px solid black;';
      $style .= '"';
      if ($this->connection["image_path_url2"]) {
        if ($url_switch) {
          $image = "<img $border src=\"".$this->connection["image_path_url"].$tile["image"]."\"";
        } else {
          $image = "<img $border src=\"".$this->connection["image_path_url2"].$tile["image"]."\"";
        }
        $url_switch = !$url_switch;
      } else {      
        $image = "<img $border src=\"".$this->connection["image_path_url"].$tile["image"]."\"";
      }
      if (IsN() && (BrowserVersion() == 4)) {
        $output .= "<div$style>".$image;
        $output .= " suppress=\"TRUE\"";
        $output .= "></div>\n";
      } else {
        $output .= $image.$style.">\n";
      }
    }
    if (IsN() && (BrowserVersion() == 4)) {  //For correct zooming on images
      $output .= "<layer left=0 top=0 height=".$this->request["height"]." width=".$this->request["width"]."></layer>\n";
    }
    $this->content .= $output;
    $this->WriteHTMLLayer(array());
  }
  
  function GetImagePosition($tile) {
    $width = $tile["width"]?$tile["width"]:$this->connection["tile"]["width"];
    $height = $tile["height"]?$tile["height"]:$this->connection["tile"]["height"];
    $pixel_width = (double)$tile["pixel_width"]?$tile["pixel_width"]:$this->connection["tile"]["pixel_width"];
    $pixel_height = (double)$tile["pixel_height"]?$tile["pixel_height"]:$this->connection["tile"]["pixel_height"];

    $pixel_size = ($this->request["bbox"]["maxx"]-$this->request["bbox"]["minx"])/(double)$this->request["width"];
    
    $imgx = $pixel_width * $width;
    $imgy = $pixel_height * $height;
    
    if ($tile["x"]+$imgx < $this->request["bbox"]["minx"] || 
        $tile["x"] > $this->request["bbox"]["maxx"] ||
        $tile["y"]-$imgy > $this->request["bbox"]["maxy"] ||
        $tile["y"] < $this->request["bbox"]["miny"]) {        
      return false;
    }
    $res["left"] = Round(($tile["x"] - $this->request["bbox"]["minx"])/$pixel_size);
    $res["top"] = Round(($this->request["bbox"]["maxy"]-$tile["y"])/$pixel_size);
    $res["width"] = Ceil(Round($width/$pixel_size*$pixel_width,1));
    $res["height"] = Ceil(Round($height/$pixel_size*$pixel_height,1));
    $res["right"] = $res["left"]+$res["width"]; 
    $res["bottom"] = $res["top"]+$res["height"]; 
//    print_r($res);
    return $res;
  }
  
  //Implemented on children
  function GetTiles() {
    $this->tiles = array();
  }
  
  function EncodeFileName($filename) {
    if (Is_array($this->connection["filename_encode"])) {
      $pinfo = pathinfo($filename);
      $pinfo["basename"] = Substr($pinfo["basename"], 0, -1*StrLen($pinfo["extension"])-1); 
      foreach ($pinfo as $key=>$val) {
        switch ($this->connection["filename_encode"][$key]) {
          case "crypt":
            $pinfo[$key] = crypt($val, $this->connection["filename_encode"]["crypt_passwd"]);
          break;
          case "crc32":
            $pinfo[$key] = crc32($val);
          break;
          case "md5":
            $pinfo[$key] = MD5($val);
          break;
          case "none":
          break;
          case "plain":
          default:
            $pinfo[$key] = $val;
          break;
        }
      }
      if (StrCmp($pinfo["dirname"],'.') != 0) 
        $filename = $pinfo["dirname"]."/".$pinfo["basename"].".".$pinfo["extension"];
      else
        $filename = $pinfo["basename"].".".$pinfo["extension"];
//      e1($filename);
//      echo $filename;
    }
    return $filename;
  }
  
}

?>
