<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: Composite.inc,v 1.7 2007/02/23 14:40:06 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_maplayer.inc"));
require_once(FileUp2(".admin/map_functions.inc"));

class Composite_MapLayer extends MapLayer {

  function Composite_MapLayer($tree, $name, $request, $manager) {
    $this->MapLayer(&$tree, $name, &$request, &$manager);
  }

  function WriteHTML() {
    $setting = array();
    foreach($this->tree['layers'] as $key => $val) {
      if ($key) {
        $ServerType = $val['style']['type'];
        $file = FileUp2(".admin/connector/maplayer/$ServerType.inc");
        if ($file) include_once($file);
        else ErrorMsg(array("image"=>false, "msg"=>"Error: Bad connector $ServerType or connector is missing"));
        $MapLayer = $ServerType."_MapLayer";
        $layer = new $MapLayer($val, $key, &$this->request, &$this->manager);
        if (method_exists($layer, 'WriteHTML')) {
          $layer->cache_output = true;
          $layer->WriteHTML();
          if (method_exists($layer, 'GetParamsForWriteGD')) {
            $setting['WriteGD_'.$key] = $layer->GetParamsForWriteGD();
          }
        }
      }
    }
    $h = $this->request["height"];
    $w = $this->request["width"];
    $this->content =  '<IMG src="map.php?';
    $this->content .= 'REQUEST=SImage&MAP='.$this->request['map'].'&INDEX='.$this->tree['index'].'&MODE='.$this->request['mode'].'&cache='.md5(strtotime("now"));
    $this->content .=  '" hspace="0" vspace="0" border="0" width="'.$w.'" height="'.$h.'">';
    $this->WriteHTMLLayer(array("visible"=>true, "height"=>$h, "width"=>$w));

    $setting["name"] = $this->name;
    $setting["tree"] = $this->tree;
    $setting["request"] = $this->request;
    $GLOBALS["TMapServer_Session"]["Interface"][$this->request["map"]][$this->tree["index"]][$this->request['mode']] = $setting;

  }

  function WriteLegendHTML() {
    foreach($this->tree['layers'] as $key => $val) {
      if ($key) {
        $ServerType = $val['style']['type'];
        $file = FileUp2(".admin/connector/maplayer/$ServerType.inc");
        if ($file) include_once($file);
        else ErrorMsg(array("image"=>false, "msg"=>"Error: Bad connector $ServerType or connector is missing"));
        $MapLayer = $ServerType."_MapLayer";
        $layer = new $MapLayer($val, $key, &$this->request, &$this->manager);
        if (method_exists($layer, 'WriteLegendHTML')) {
          $layer->cache_output = $this->cache_output;
          $layer->WriteLegendHTML();
          if ($this->cache_output) $this->output .= $layer->output;
        }
      }
    }
  }

  function WriteGD() {
    $this->PrepareImage();
    return $this->ImageGD;
  }

  function WriteGIF() {
    $this->PrepareImage();
    ImageGIF($this->ImageGD);
  }

  function WritePNG() {
    $this->PrepareImage();
    ImagePNG($this->ImageGD);
  }

  function WriteJPEG() {
    $this->PrepareImage();
    if ($this->properties['jpeg-level'])
      ImageJPEG($this->ImageGD,'',$this->properties['jpeg-level']);
    else
      ImageJPEG($this->ImageGD);
  }

  function CreateImage() {
    if (!$this->ImageGD) {
      $this->ImageGD = (GetGDVersion()==2)?ImageCreateTrueColor($this->request['width'], $this->request['height']):ImageCreate($this->request['width'], $this->request['height']);
      $bgcolor = $this->properties['parameters']['background']['color']?$this->properties['parameters']['background']['color']:array(255,255,255);
      $bgcolor = imagecolorallocate($this->ImageGD, $bgcolor[0], $bgcolor[1], $bgcolor[2]);
      imagefilledrectangle( $this->ImageGD, 0, 0, $this->request['width'], $this->request['height'], $bgcolor);
      if ($this->properties['parameters']['background']['transparent'] != false) imagecolortransparent($this->ImageGD, $bgcolor);

    }
  }

  function PrepareImage() {
    session_start();
    foreach($this->tree['layers'] as $key => $val) {
      if ($key) {
        $this->CreateImage();

        $ServerType = $val['style']['type'];
        $file = FileUp2(".admin/connector/maplayer/$ServerType.inc");
        if ($file) include_once($file);
        else ErrorMsg(array("image"=>false, "msg"=>"Error: Bad connector $ServerType or connector is missing"));
        $MapLayer = $ServerType."_MapLayer";
        $layer = new $MapLayer($val, $key, &$this->request, &$this->manager);
        $layer->compositeparent = $this->request['map'];
        if (method_exists($layer, 'WriteGD')) {
          if (method_exists($layer, 'SetParamsForWriteGD')) {
            $layer->SetParamsForWriteGD($GLOBALS["TMapServer_Session"]["Interface"][$this->request["map"]][$this->tree["index"]]['WriteGD_'.$key]);
          }

          $img = $layer->WriteGD();
          if ($img) {
            $layer_transparency = $layer->properties['composite']['transparency']?$layer->properties['composite']['transparency']:100;
            if($layer_transparency==100) ImageCopy($this->ImageGD, $img, 0, 0, 0, 0, $this->request['width'], $this->request['height']);
            else ImageCopyMerge($this->ImageGD, $img, 0, 0, 0, 0, $this->request['width'], $this->request['height'],$layer_transparency);
            
            ImageDestroy($img);
          }

        } else {
          ErrorMsg(array("image"=>false, "msg"=>"Error: Connector $ServerType does not support composite layers."));
        }
/*        $layer->cache_output = $this->cache_output;
        $layer->params = $this->layer_params;*/

      }
    }

    if (!$this->ImageGD) {
      if ($this->properties['parameters']['background']['transparent'] != false) {
        $this->ImageGD = ImageCreateFromGIF(FileUp2('images/pixel_transp.gif'));
      } else {
        $this->CreateImage();
      }
    }
  }
}

?>
