<?php

/*
ESRI output types
*/ 
//esriImageFormat 
define("esriImageNone",-1);
define("esriImageBMP",0);
define("esriImageJPG",1);
define("esriImageDIB",2);
define("esriImageTIFF",3);
define("esriImagePNG",4);
define("esriImagePNG24",5);
define("esriImageEMF",6);
define("esriImagePS",7);
define("esriImagePDF",8);
define("esriImageAI",9);
define("esriImageGIF",10);
define("esriImageSVG",11);
define("esriImageSVGZ",12);

//esriImageReturnType
define("esriImageReturnURL",0);
define("esriImageReturnMimeData",1);


require_once($GLOBALS["TMAPY_LIB"]."/lib/nusoap/lib/nusoap.php");
require_once(FileUp2(".admin/main_maplayer.inc"));

class ArcServerA_MapLayer extends MapLayer {
  var $image_url="";
  var $legend_url="";
  var $webServiceUrl="";
  
  function ArcServerA_MapLayer($map, $index, $request, $manager) {
    $this->MapLayer(&$map,$index, $request, $manager);
  }

  function GetImageURL() {
    $this->legend_url = "";
    $this->image_url = "";
    //get connector params  
    $c = $this->manager->GetActive($this->name);
 
    //get extend 
    $proj = $this->manager->GetProject($this->name);
    if ($this->request["print"]) {
      $imageDPI = $this->request["print"]["dpi"];
      $xMin = $this->request["print"]["minx"];
      $yMin = $this->request["print"]["miny"];
      $xMax = $this->request["print"]["maxx"];
      $yMax = $this->request["print"]["maxy"];
      $imageHeight = $this->request["print"]["height"];
      $imageWidth = $this->request["print"]["width"];
    } else {
      $imageDPI = 96; //1280*1024 17inch disp
      $xMin = $this->request["bbox"]["minx"];
      $yMin = $this->request["bbox"]["miny"];
      $xMax = $this->request["bbox"]["maxx"];
      $yMax = $this->request["bbox"]["maxy"];
      $imageHeight = $this->request["height"];
      $imageWidth = $this->request["width"];
    }
      
    //set layers visibility
    $layerDescriptions = "<LayerDescriptions>"; 
    $arr = $this->GetLayers(false, true);//all layers 
    $arrvis = $this->GetLayers($mode); //just some layers visible for map or overview
    for($i=0;$i<Count($arr);$i++):
      $layer = $arr[$i];
      $visible = (In_Array($layer, $arrvis)?"true":"false");
      $layerDescriptions .= "<LayerDescription layerId=\"$layer\" layerName=\"$layer\" visible=\"$visible\" />"; 
    endfor; 
    $layerDescriptions .= "</LayerDescriptions>";
    
    //out image params
    $transparentColor = isset($this->properties["map"]["transparent_color"])?$this->properties["map"]["transparent_color"]:0xFFFFFF;
    $imageFormat = isset($this->properties["map"]["image_format"])?$this->properties["map"]["image_format"]:esriImagePNG;//esriImagePNG //4
    $imageReturnType = esriImageReturnURL; //0   
    
    switch ($this->request["mode"]) {  
      case 0: $mode = "visible"; break; 
      case 1: $mode = "overview"; break; 
      case 2: $mode = "legend"; break; 
    }
    switch ($mode) {
    
      //*Get legend    
      case "legend":
        $this->ObjectHandlerWriteLegend("HTML");
        $legendId = isset($this->properties["legend"]["legend_id"])?$this->properties["legend"]["legend_id"]:0;
        //todo dodelat v propreties
        $legendTitle = isset($this->properties["legend"]["title"])?$this->properties["legend"]["title"]:"Legenda";
        $legendWidth = isset($this->properties["legend"]["width"])?$this->properties["legend"]["width"]:80;
        $legendImageWidth = $legendWidth;//TODO no zatim je to takto
        $legendHeight = isset($this->properties["legend"]["height"])?$this->properties["legend"]["height"]:1200;
        $legendImageHeight = $legendHeight; 
        $legendImageDPI = isset($this->properties["legend"]["image_dpi"])?$this->properties["legend"]["image_dpi"]:10;
        $legendBackgroundColor = isset($this->properties["legend"]["backgroundcolor"])?$this->properties["legend"]["backgroundcolor"]:0xFFFFFF;
        $legendImageFormat = isset($this->properties["legend"]["image_format"])?$this->properties["map"]["image_format"]:4;
        $legendImageReturnType = 0;

        //to remove selected layers from legend
        $removeLayers = "";
        if ($legendId<0) {        
          $removeLayers = "";
          $arrlg = $this->GetLayers("legend");
          $arrvis = $this->GetLayers("visible");
          $ridx = 0;
          for($i=0;$i<Count($arr);$i++) {
            $layer = $arr[$i];
            if (!In_array($layer, $arrlg) || !In_array($layer, $arrvis)) { //layer is alowed in legend and is visible
              if ($ridx!=0) $removeLayers .= ","; 
              $removeLayers .= $layer;
              $ridx++;
            }
          }
        }
        
        $soapclient = new soapclient($c->GetWebServiceUrl()); 
        $par = array(
                     "serverObjectName"=>(string)$c->ServerObject, //ServerObject and MapId are defined for connector 
                     "mapId"=>$c->MapId,
                     "legendId"=>(int)$legendId,
                     "legendTitle"=>(string)$legendTitle,
                     "legendHeight"=>(int) $legendHeight,
                     "legendWidth"=>(int) $legendWidth,
                     "backgroundColor"=>(int) $legendBackgroundColor, 
                     "imageFormat"=>$legendImageFormat,
                     "imageReturnType"=>0, 
                     "imageHeight"=>(int) $legendImageHeight,
                     "imageWidth"=>(int) $legendImageWidth,
                     new soapval("imageDPI", "double", $imageDPI),
                     "removeLayers"=>(string)$removeLayers); 
        $this->legend_url = $soapclient->call("exportLegend",$par);
        if (!$soapclient->getError()){ 
          return $this->legend_url;
        }else{ 
          echo 'Chyba ws: '. $soapclient->getError(); 
        }
        break;
        
      //*Get image            
      default:
        $this->ObjectHandlerWriteLayerBefore("HTML");
        $soapclient = new soapclient($c->GetWebServiceUrl()); 
        //$this->debug = $xMin.$yMin; 
        $par = array(
                "serverObjectName"=>(string)$c->ServerObject, 
                "mapId"=>$c->MapId, 
                new soapval("xMin", "double", $xMin), 
                new soapval("yMin", "double", $yMin),
                new soapval("xMax", "double", $xMax),
                new soapval("yMax", "double", $yMax),
                "layerDescriptions"=>(string)$layerDescriptions, 
                "spatialReference"=>(string)"",
                "transparentColor"=>$transparentColor,
                "imageFormat"=>$imageFormat,
                "imageReturnType"=>$imageReturnType,
                "imageHeight"=>(Int) $imageHeight,
                "imageWidth"=>(Int) $imageWidth,
                new soapval("imageDPI", "double", $imageDPI));
        $this->image_url = $soapclient->call("exportMapImage",$par); 
        $this->ObjectHandlerWriteLayerAfter("HTML");
        if (!$soapclient->getError()){ 
           return $this->image_url;
        }else{ 
          echo 'Chyba ws: '. $soapclient->getError(); 
        }
        break;
    }
  }


  function WriteHTML() {
  
    if ($this->request["print"]) { 
      $h = $this->request["print"]["height"];
      $w = $this->request["print"]["width"];
    } else {
      $h = $this->request["height"];
      $w = $this->request["width"];
    }
    $this->content =  "<IMG src=\"".$this->GetImageURL()."\" hspace=0 vspace=0 border=0 width=\"$w\" height=\"$h\">";
    $this->WriteHTMLLayer(array("visible"=>true, "height"=>$h, "width"=>$w));
    
  }

  function WriteLegendHTML() {
    if ($GLOBALS["TMapServer_".get_class($this)]["legend"]["url"]) { 
      $url = $GLOBALS["TMapServer_".get_class($this)]["legend"]["url"];
      $this->ObjectHandlerWriteLegend("HTML");
    } else {
      $url = $this->GetImageURL();
    }
    $this->output =  "<IMG src=\"".$url."\" hspace=0 vspace=0 border=0>";
    if (!$this->cache_output) {
      echo $this->output;
    }
  }
}

?>
