<?php
require_once($GLOBALS["TMAPY_LIB"]."/ms/ArcGISServer.inc");
require_once(FileUp2(".admin/main_maplayer.inc"));

class ArcGISServer_MapLayer extends MapLayer {
  var $Request;
  var $msobj;
  
  //for WriteCallback
  //function ArcGISServer_MapLayer($map, $index, $request, $manager) { 
  function ArcGISServer_MapLayer($map=false, $index=false, $request=false, $manager=false) {
    if ($map) $this->MapLayer(&$map,$index, $request, $manager);
  }

  function GetConnection () {
    $this->Connection = $this->manager->GetServer($this->tree['style']['connection']?$this->tree['style']['connection']:$this->name);
    return $this->Connection;
  }

  function CreateMSArcGISServer ($connection) {
    if (!$this->msobj) {
      if (!$connection) $connection=$this->GetConnection();
      $this->msobj = new MS_ArcGISServer($connection);
      if ($this->request['charset']) $this->msobj->InternalCharsetSet = $this->request['charset']; 
    }
  }
  
  function getSOAPRequest($connection=false) {

    $this->CreateMSArcGISServer($connection);

    switch ($this->request['mode']) {
      case 0: $mode = 'visible'; break;
      case 1: $mode = 'overview'; break;
      case 2: $mode = 'legend'; break;
    }

    if ($this->request['print']) {
      $this->AGSParams['ImageHeight'] = $this->request['print']['height'];
      $this->AGSParams['ImageWidth'] = $this->request['print']['width'];
      $this->AGSParams['ImageDPI'] = $this->request['print']['dpi'];
    } else {
      $this->AGSParams['ImageHeight'] = $this->request['height'];
      $this->AGSParams['ImageWidth'] = $this->request['width'];
      $this->AGSParams['ImageDPI'] = $this->properties['parameters']['ImageDescription']['ImageDisplay']['ImageDPI']?$this->properties['parameters']['ImageDescription']['ImageDisplay']['ImageDPI']:96;
    }
    if (!$this->AGSParams['ImageFormat']) { 
      if ($this->properties['parameters']['ImageDescription']['ImageType']['ImageFormat']) {
        $this->AGSParams['ImageFormat'] = $this->properties['parameters']['ImageDescription']['ImageType']['ImageFormat'];
      } else {
        switch ($this->properties['content-type']) {
          case 'image/jpeg': $this->AGSParams['ImageFormat'] = 'esriImageJPG'; break;
          case 'image/gif': $this->AGSParams['ImageFormat'] = 'esriImageGIF'; break;
          case 'image/png': default: $this->AGSParams['ImageFormat'] = 'esriImagePNG24'; break;
        }
      }
    }
    $arrvis = $this->GetLayers($mode!='overview'?'visible':$mode);
    $arrall = $this->GetLayers($mode,true);
    $this->AGSParams['LayerDescriptions'] = array();
    foreach ($arrall as $val) {
      if ($val != '') {
        $arrlr = array(
          'LayerID'=>$val, 
          'Visible'=>In_Array($val,$arrvis),
          'ShowLabels'=>true,
          'ScaleSymbols'=>true,
        );
        if ($arrlr['Visible']) $this->AGSParams['LayerIDs'][] = $val;
        if (Is_array($this->properties['parameters']['LayerDescription'])) 
          $arrlr = array_merge($arrlr, $this->properties['parameters']['LayerDescription']);
        $this->AGSParams['LayerDescriptions'][] = $this->msobj->getSoapVal('LayerDescription',$arrlr);
      }
    }
    
    if ($this->properties['parameters']['MapDescription']['TransparentColor']) {
      if (Is_array($this->properties['parameters']['MapDescription']['TransparentColor'])) {
        $this->AGSParams['TransparentColor'] = $this->properties['parameters']['MapDescription']['TransparentColor'];
      } else {
        list($this->AGSParams['TransparentColor']['Red'],
             $this->AGSParams['TransparentColor']['Green'],
             $this->AGSParams['TransparentColor']['Blue']) = 
          Explode(' ', $this->properties['parameters']['MapDescription']['TransparentColor']);
      }
    }
    if (Is_array($this->properties['parameters']['MapDescription']['BackgroundSymbol'])) {
      $this->AGSParams['BackgroundSymbol'] = $this->properties['parameters']['MapDescription']['BackgroundSymbol'];
      $this->AGSParams['BackgroundSymbol']['Style'] = $this->AGSParams['BackgroundSymbol']['Style']?$this->AGSParams['BackgroundSymbol']['Style']:'esriSFSSolid';
    }

    
    switch ($mode) {
      case 'legend':
        $this->Request = array(
          'method'=>'GetLegendInfo',
          'params'=>array(
            'MapName'=>$this->msobj->encodeString($this->properties['parameters']['MapDescription']['Name']?$this->properties['parameters']['MapDescription']['Name']:$this->msobj->getMapName()),
            'LayerIDs'=>$this->msobj->getSoapVal('ArrayOfInt',$this->AGSParams['LayerIDs']),
            'LegendPatch'=>$this->msobj->getSoapVal('MapServerLegendPatch',array(
              'Width'=>20,
              'Height'=>16,
              'ImageDPI'=>96
            )),
            'ImageType'=>$this->msobj->getSoapVal('ImageType',array(
              'ImageFormat'=>$this->AGSParams['ImageFormat'],
              'ImageReturnType'=>$this->AGSParams['ImageReturnType']
            )),
          )
        );

      break;
      default:
        $map_description = array(
          'Name'=>$this->properties['parameters']['MapDescription']['Name']?$this->properties['parameters']['MapDescription']['Name']:$this->msobj->getMapName(),
          'Rotation'=>$this->properties['parameters']['MapDescription']['Rotation']?$this->properties['parameters']['MapDescription']['Rotation']:0,
          'MapArea'=>$this->msobj->getSoapVal('MapExtent',array(
            'Extent'=>$this->msobj->getSoapVal('EnvelopeN',array(
              'XMin'=>(double)$this->request["bbox"]["minx"],
              'YMin'=>(double)$this->request["bbox"]["miny"],
              'XMax'=>(double)$this->request["bbox"]["maxx"],
              'YMax'=>(double)$this->request["bbox"]["maxy"]
            )),
            //'SpatialReference'=>$this->properties['parameters']['MapDescription']['SpatialReference']?$this->msobj->getSoapVal('ProjectedCoordinateSystem',$this->properties['parameters']['MapDescription']['SpatialReference']):array(),
          )),
         'SpatialReference'=>$this->properties['parameters']['SpatialReference']?$this->msobj->getSoapVal('ProjectedCoordinateSystem',$this->properties['parameters']['SpatialReference']):array(),                
         'LayerDescriptions'=>$this->msobj->getSoapVal('ArrayOfLayerDescription',
           $this->AGSParams['LayerDescriptions']
          ),
        );          
        if ($this->AGSParams['BackgroundSymbol']) {
          $map_description['BackgroundSymbol'] = $this->msobj->getSoapVal('SimpleFillSymbol',array(
            'Color'=>$this->msobj->getSoapVal('RgbColor',$this->AGSParams['BackgroundSymbol']['Color']),
            'Style'=>$this->AGSParams['BackgroundSymbol']['Style'],
            'Outline'=>array()
          ));
        }
        if ($this->AGSParams['TransparentColor']) {
         $map_description['TransparentColor']=$this->msobj->getSoapVal('RgbColor',$this->AGSParams['TransparentColor']);          
        }
        $this->Request = array(
          'method'=>'ExportMapImage',
          'params'=>array(
            'MapDescription'=>$this->msobj->getSoapVal('MapDescription',$map_description),
            'ImageDescription'=>$this->msobj->getSoapVal('ImageDescription',array(
              'ImageType'=>$this->msobj->getSoapVal('ImageType',array(
                'ImageFormat'=>$this->AGSParams['ImageFormat'],
                'ImageReturnType'=>$this->AGSParams['ImageReturnType']
              )),
              'ImageDisplay'=>$this->msobj->getSoapVal('ImageDisplay',array(
                'ImageHeight'=>(integer)$this->AGSParams['ImageHeight'],
                'ImageWidth'=>(integer)$this->AGSParams['ImageWidth'],
                'ImageDPI'=>(integer)$this->AGSParams['ImageDPI'],
              )),
            ))
          )
        );
      break;
    }
    return $this->Request;
  }

  function GetImage() {
    $this->getSOAPRequest();
    //die($this->msobj->soapGetMessage($this->Request));
    switch ($this->request['mode']) {
      case 0: $mode = 'visible'; 
      case 1: $mode = 'overview'; 
        $this->ObjectHandlerWriteLayerBefore($this->ImageFormat);
        $this->SoapResult =$this->msobj->soapCall($this->Request);
        //$this->msobj->showerror('');
        //$this->ImageUrl = $this->SoapResult['Result']['ImageURL'];
        $this->ObjectHandlerWriteLayerAfter($this->ImageFormat);
      break;
      case 2: $mode = 'legend'; 
        $this->ObjectHandlerWriteLegend($this->ImageFormat);
        $this->SoapResult =$this->msobj->soapCall($this->Request);
      break;
    }
    return $this->SoapResult;
  }
  
  function WriteGD() {
    $this->ImageFormat = 'GD';
    $this->AGSParams = array('ImageReturnType'=>'esriImageReturnMimeData');
    $this->GetImage();
    if ($this->SoapResult['Result']['ImageData']) {
      $tmp = tempnam(false, 'tms-ags-');
      $fp = fOpen($tmp, 'w');
      if ($fp) {
        fwrite($fp, base64_decode($this->SoapResult['Result']['ImageData']));
        fClose($fp);
        //for memory saving - test it TONO
        unset($this->SoapResult['Result']['ImageData']);

        switch ($this->AGSParams['ImageFormat']) {
          case 'esriImageGIF':
            $this->ImageGD = imagecreatefromgif($tmp);
          break;
          case 'esriImagePNG':
          case 'esriImagePNG24':
            $this->ImageGD = imagecreatefrompng($tmp);
          break;
          case 'esriImageJPG':
            $this->ImageGD = imagecreatefromjpeg($tmp);
          break;
        }
        unlink($tmp);
      }
    } else {
      die('ArcGISServer_MapLayer: WriteGD Image source is not correct.');
    } 
    return $this->ImageGD;
  }

  function WriteGIF($fn_image="",$url_append="") {
    $this->ImageFormat = 'GIF';
    $this->AGSParams = array(
      'ImageFormat'=>'esriImageGIF',
      'ImageReturnType'=>'esriImageReturnMimeData'
    );
    $this->GetImage();
    echo base64_decode($this->SoapResult['Result']['ImageData']);
  }

  function WritePNG($fn_image='',$url_append='') {
    $this->ImageFormat = 'PNG';
    $this->AGSParams = array(
      'ImageFormat'=>'esriImagePNG24',
      'ImageReturnType'=>'esriImageReturnMimeData'
    );
    $this->GetImage();
    echo base64_decode($this->SoapResult['Result']['ImageData']);
  }

  function WriteJPEG($fn_image='', $url_append='', $quality=-1) {
    $this->ImageFormat = 'JPEG';
    $this->AGSParams = array(
      'ImageFormat'=>'esriImageJPG',
      'ImageReturnType'=>'esriImageReturnMimeData'
    );
    $this->GetImage();
    echo base64_decode($this->SoapResult['Result']['ImageData']);
  }
  
  function WriteCallback($params) {
    session_write_close(); 
    switch ($params['imageformat']) {
      case 'esriImageGIF':
        Header('Content-Type: image/gif');
      break;
      case 'esriImagePNG':
      case 'esriImagePNG24':
        Header('Content-Type: image/png');
      break;
      case 'esriImageJPG':
        Header('Content-Type: image/jpeg');
      break;
    }
    if ($params['imagedata']) {
      echo base64_decode($params['imagedata']); 
    } else {
      $this->CreateMSArcGISServer($params['connection']);
      //die($params['soapmessage']);
      $response = $this->msobj->soapSend($params['soapmessage'], $params['soapaction']);
      $response['Result']['ImageData'] = base64_decode($response['Result']['ImageData']);
      Header('Content-Length: '.StrLen($response['Result']['ImageData']));
      echo $response['Result']['ImageData'];
    }
  }

  function WriteHTML() {
    $this->GetConnection();
    $this->ImageFormat = 'HTML';
    //PROXY mode
    if ($this->Connection['application_proxy_mode']) {
      $this->AGSParams = array('ImageReturnType'=>'esriImageReturnMimeData');
      $this->getSOAPRequest();
      switch ($this->request['mode']) {
        case 0: $mode = 'visible'; 
        case 1: $mode = 'overview'; 
          $this->ObjectHandlerWriteLayerBefore($this->ImageFormat);
        break;
      }
      $this->msobj->soapGetMessage($this->Request);
      //die(print_R($this->msobj->SoapClient->SoapMessage));

      if(!is_array($_SESSION)) session_register('TMapServer');

      $cbsid = md5(microtime(true).rand());
      $_SESSION['TMapServer']['callback_mint'][$cbsid] = array(
        'lastused'=>time(),
        'lifetime'=>120,
        'file'=>'.admin/connector/maplayer/ArcGISServer.inc',
        'class'=>'ArcGISServer_MapLayer',
        'method'=>'WriteCallback',
        'params'=>array(
          'connection'=>$this->Connection,
          'soapmessage'=>$this->msobj->SoapClient->SoapMessage,
          'soapaction'=>$this->msobj->SoapClient->SoapAction,
          'imageformat'=>$this->AGSParams['ImageFormat'],
        )
      );
      
      
      
      $this->content = '<IMG src="map.php?PHPSESSID='.session_id().'&TMS_INTERFACE=CALLBACK&CBSID='.$cbsid.'" hspace=0 vspace=0 border=0 width="'.$this->AGSParams['ImageWidth'].'" height="'.$this->AGSParams['ImageHeight'].'">';
    //NORMAL mode
    } else {
      $this->AGSParams = array('ImageReturnType'=>'esriImageReturnURL');
      $this->GetImage();
      $url = $this->SoapResult['Result']['ImageURL'];
      if ($url) $this->content = '<IMG src="'.$this->ReplaceImageUrlPath($url).'" hspace=0 vspace=0 border=0 width="'.$response['Result']['ImageWidth'].'" height="'.$response['Result']['ImageHeight'].'">';
    }
    $this->WriteHTMLLayer(array("visible"=>true, "height"=>$this->AGSParams['ImageHeight'], "width"=>$this->AGSParams['ImageWidth']));
  }

  function WriteLegendHTML() {
    if (!function_exists('setCallbackMint')) {
      function setCallbackMint($cbsid,$imagedata,$imageformat) {
        session_register('TMapServer');
        $GLOBALS['TMapServer']['callback_mint'][$cbsid] = array(
          'lastused'=>time(),
          'lifetime'=>120,
          'file'=>'.admin/connector/maplayer/ArcGISServer.inc',
          'class'=>'ArcGISServer_MapLayer',
          'method'=>'WriteCallback',
          'params'=>array(
            'imageformat'=>$imageformat,
            'imagedata'=>$imagedata
          )
        );
      }
    } 
    //die(print_R($GLOBALS['TMapServer']));
    $this->ImageFormat = 'HTML';
    $this->GetConnection();
    if ($this->Connection['application_proxy_mode']) {
      $this->AGSParams = array('ImageReturnType'=>'esriImageReturnMimeData');
    } else {
      $this->AGSParams = array('ImageReturnType'=>'esriImageReturnURL');
    }
    $legend = $this->GetImage();
    //print_r($legend);
    $res = "<table cellpading=\"0\" cellspacing=\"0\" class=\"brow\" width=\"98%\">\n";
    if  (isset($legend['Result']['MapServerLegendInfo']['LayerID']))
      $legend = array($legend['Result']['MapServerLegendInfo']);
    else
      $legend = array_reverse($legend['Result']['MapServerLegendInfo']);
      //print_R($legend);
    foreach ($legend as $lg) {
      if ($lg['LegendGroups']['MapServerLegendGroup']['Heading'] == 'RGB' || $lg['MapServerLegendGroup']['Heading'] == 'RGB') continue;
      if ($lg['LegendGroups']['MapServerLegendGroup']['LegendClasses']['MapServerLegendClass']) {
        $class = $lg['LegendGroups']['MapServerLegendGroup']['LegendClasses']['MapServerLegendClass'];
      } else {
        $class = $lg['MapServerLegendGroup']['LegendClasses']['MapServerLegendClass'];
      }
      if(!is_array($class)) continue;
      if (isset($class['Label'])) {
        //die(print_r($lg));
        if ($class['SymbolImage']['ImageData']) {
          $cbsid = md5(microtime(true).rand());
          setCallbackMint($cbsid,$class['SymbolImage']['ImageData'], $this->AGSParams['ImageFormat']);
          $url = 'map.php?PHPSESSID='.session_id().'&TMS_INTERFACE=CALLBACK&CBSID='.$cbsid;
        } else 
          $url = $this->ReplaceImageUrlPath($class['SymbolImage']['ImageURL']);
        $res .= '<tr><td style="text-align:center;width:40px"><img src="'.$url.'"></td><td style="font-weight:bold">'.($lg['Name'].($class['Label']?' - '.$class['Label']:''))."</td><tr>\n";
      } else {
        $res .= '<tr><td colspan="2" style="font-weight:bold">'.$lg['Name']."</td><tr>\n";
        foreach ($class as $cls) {
          if ($cls['SymbolImage']['ImageData']) { 
            $cbsid = md5(microtime(true).rand());
            setCallbackMint($cbsid,$cls['SymbolImage']['ImageData'], $this->AGSParams['ImageFormat']);
            $url = 'map.php?PHPSESSID='.session_id().'&TMS_INTERFACE=CALLBACK&CBSID='.$cbsid;
          } else 
            $url = $this->ReplaceImageUrlPath($cls['SymbolImage']['ImageURL']);
          $res .= '<tr><td style="text-align:center;width:40px"><img src="'.$url.'"></td><td style="font-size:90%">'.($cls['Label']?$cls['Label']:'&nbsp;')."</td><tr>\n";
        }
      }
    }
    $res .= "</table>\n";
    $this->output =  $res;
    if (!$this->cache_output) echo $this->output;
  }

  function ReplaceImageUrlPath($url) {
    if (Is_array($this->Connection['image_url'])) {
      return str_replace(
        $this->Connection['image_url']['replace_from'], 
        $this->Connection['image_url']['replace_to'], 
        $url
      );
    }
  }

}

?>
