<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: TableXY.inc,v 1.3 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_editlayer.inc"));

class TableXY_EditLayer extends EditLayer {

  function TableXY_EditLayer($vobj) {
    $this->EditLayer($vobj);
    $this->table_params['field_x'] = $this->table_params['field_x']?$this->table_params['field_x']:'X';
    $this->table_params['field_y'] = $this->table_params['field_y']?$this->table_params['field_y']:'Y';
    $this->table_params['field_id'] = $this->table_params['field_id']?$this->table_params['field_id']:'ID';
    include_once(FileUp2('.admin/db/'.$this->db_file));
    $this->db = new $this->db_name;
  }

  function Insert($shape, $attrib) {
    $GLOBALS[$this->table_params['field_x']] = $shape[$shape['type']]['x'];
    $GLOBALS[$this->table_params['field_y']] = $shape[$shape['type']]['y'];
    include_once(FileUp2('.admin/functions.inc'));
    $met = $this->Metadata();
    $sql = 'INSERT INTO '.$this->table_name.' ';
    $this->_PrepareSpecialFields('insert');
    $sql .= CreateValuesSQLFromVar($met);
    echo $sql;
    $this->ret = $this->db->query($sql);
    echo 'AFTER';
    return ($this->ret?true:false);
  }
  
  function Update($id, $shape, $attrib) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $met = $this->Metadata();
      $this->_PrepareSpecialFields('insert');
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('update', $id)) {
        $sql = 'UPDATE '.$this->table_name.' SET ';
        $GLOBALS[$this->table_params['field_x']] = $shape[$shape['type']]['x'];
        $GLOBALS[$this->table_params['field_y']] = $shape[$shape['type']]['y'];
        $this->_PrepareSpecialFields('update');
        $sql .= CreateSetWhereSQLFromVar($met);
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }
  
  function Delete($id) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('delete', $id)) {
        $met = $this->Metadata();
        $sql = 'DELETE FROM '.$this->table_name;
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }
  
  function Metadata() {
    return $this->db->metadata($this->table_name);
  }
  
  function PrepareTableParams($shape,$table_par=array()) {
    $tbl_alias = 'T';
    $met = $this->Metadata();
    $sql = "SELECT * FROM $this->table_name $tbl_alias";
    $sql .= " WHERE ";
    $sql .= $this->table_params['field_x'].' > '.$shape['envelope']['minx'];
    $sql .= ' AND '.$this->table_params['field_x'].' < '.$shape['envelope']['maxx'];
    $sql .= ' AND '.$this->table_params['field_y'].' > '.$shape['envelope']['miny'];
    $sql .= ' AND '.$this->table_params['field_y'].' < '.$shape['envelope']['maxy'];
    if (!$GLOBALS['PROPERTIES_ACCESS']['all_read']) {
      $user_info = $GLOBALS["TMAPY_SECURITY"]->getUserInfo();
      if ($GLOBALS['PROPERTIES_ACCESS']['owner_read']) {
        $sql .= ' AND OWNER_ID = '.$user_info['ID']; 
      } 
    }
    if ($this->vobj->layer_properties['table']['order_by']) {
      $sql .= " ORDER BY $tbl_alias.".$this->vobj->layer_properties['table']['order_by'];
    }
    $table_par['sql'] = $sql;
    $table_par["properties"] = $this->_GetTableProperties();
    $table_par['table_schema'] = array('schema'=>$this->vobj->layer_properties['table']['schema']);
    $table_par['noprint']=true;
    $table_par['nopaging']=true;
//    $table_par['showedit']=true;
    return $table_par;
  }
  
  function PrepareFormData($id) {
    if (isset($id)) {
      $tbl_alias = 'T';
      $met = $this->Metadata();
      $sql = "SELECT * FROM $this->table_name $tbl_alias";
      $sql .= " WHERE $tbl_alias.".$this->table_params['field_id']." = $id ";
      @$this->db->query($sql);
      if ($this->db->next_record()) {
        $this->db->Record['FWKT_'] = 'POINT('.$this->db->Record[$this->table_params['field_x']].' '.$this->db->Record[$this->table_params['field_y']].')';
        SetVarFromHash(&$this->db->Record);
      }
    }
    return $this->db->Record;
  }
  
  function _PrepareSpecialFields($mode) {
    $user_info = $GLOBALS["TMAPY_SECURITY"]->GetUserInfo();
    $met = $this->Metadata();
    foreach ($met as $key=>$value) {

      switch (strtolower($value["type"])):
        case "date":
        case "datetime":
        case "smalldatetime":
    			if (isset($GLOBALS[$value["name"]])):
      			$GLOBALS[$value["name"]] = $this->db->str2dbdate($GLOBALS[$value["name"]]);
    			endif;
      endswitch;

      switch ($value['name']) {
        case 'OWNER_ID':
          if ($mode == 'insert') { 
            $GLOBALS[$value['name']] = $user_info['ID'];
          }
        break;
        case 'GROUP_ID':
        case 'LAST_GROUP_ID':
          if (($mode == 'insert') || ($value['name'] == 'LAST_GROUP_ID')) { 
            if (preg_match('/\[role#(.*)]/i',$this->table_params['special_fields']['group_id'], $qmatch)) {
              if (method_exists($GLOBALS["TMAPY_SECURITY"], 'GetRolesForUser')) {
                $user_roles = $GLOBALS["TMAPY_SECURITY"]->GetRolesForUser($user_info['LOGIN'], $user_info['SYSTEM']);
              }
              if ($user_roles) {
                if (!function_exists('QueryArrayByFilter')) {
                  include_once(FileUp2('.admin/functions.inc'));
                }
                $GLOBALS[$value['name']] = QueryArrayByFilter($user_roles, $qmatch[1]);
              }
            } else {
              $GLOBALS[$value['name']] = $user_info['GROUP_ID'];
            }
          }
        break;
        case 'LAST_USER_ID':
          $GLOBALS[$value['name']] = $user_info['ID'];
        break;
        case 'LAST_DATE':
          $GLOBALS[$value['name']] = $this->db->date2dbdate();
        break;
        case 'LAST_TIME':
          $GLOBALS[$value['name']] = $this->db->time2dbtime();
        break;
      }
    }
  }

  function _GetTableProperties() {
    return array(
      'DB_NAME'=>$this->db_name,
      'AGENDA_ID'=>$this->table_params['field_id'],
      'AGENDA_TABLE'=>$this->table_name,
      'ACCESS_UPDATE_OWNER_ID'=>'OWNER_ID'
    );
  }
  
  function _GetFields($met, $tbl_alias) {
    $fields = '';
    foreach ($met as $key=>$value) {
      if ($value['name'] != $this->table_params['field_shape']) {
        $fields .= ($fields?',':'').$tbl_alias.'.'.$value['name'];
      }
    }
    return $fields;
  }

}
?>
