<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: PostGIS.inc,v 1.3 2006/10/31 13:38:28 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_editlayer.inc"));

class PostGIS_EditLayer extends EditLayer {

  function PostGIS_EditLayer($vobj) {
    $this->EditLayer($vobj);
    $this->table_params['field_shape'] = $this->table_params['field_shape']?strtoupper($this->table_params['field_shape']):'THE_GEOM';
    $this->table_params['field_id'] = $this->table_params['field_id']?$this->table_params['field_id']:'ID';
    include_once(FileUp2('.admin/db/'.$this->db_file));
    $this->db = new $this->db_name;
  }

  function Insert($shape, $attrib) {
    include_once(FileUp2('.admin/functions.inc'));
    $met = $this->Metadata();
    foreach ($met as $key=>$value) {
      if ($value['name'] == $this->table_params['field_id']) {
        unset($met[$key]);
      } 
    }
    reset($met);
    $sql = 'INSERT INTO '.$this->table_name.' ';
    $shp = $this->_GetShape($shape, $this->vobj->layer_properties['edit']['type']);
    $GLOBALS[$this->table_params['field_shape']] = $shp;
    $this->_PrepareSpecialFields('insert');
    $GLOBALS[strtoupper($this->table_params['field_shape'])] = "GeometryFromText('$shp','".$this->table_params['epsg']."')";
    $sql .= CreateValuesSQLFromVar($met);
    $this->ret = $this->db->query($sql);
    return ($this->ret?true:false);
  }
  
  function Update($id, $shape, $attrib) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $met = $this->Metadata();
      $this->_PrepareSpecialFields('insert');
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('update', $id)) {
        $sql = 'UPDATE '.$this->table_name.' SET ';
        $shp = $this->_GetShape($shape, $this->vobj->layer_properties['edit']['type']);
        if($shape['text']) $GLOBALS[strtoupper($this->table_params['field_shape'])] = "GeometryFromText('$shp','".$this->table_params['epsg']."')";
        $this->_PrepareSpecialFields('update');
        $sql .= CreateSetWhereSQLFromVar($met);
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }

  function Delete($id) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('delete', $id)) {
        $met = $this->Metadata();
        $sql = 'DELETE FROM '.$this->table_name;
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }
  
  function Metadata() {
    return $this->db->metadata($this->table_name);
  }
  
  function PrepareTableParams($shape,$table_par=array()) {
    $tbl_alias = 'T';
    $met = $this->Metadata();
    $fields = $this->_GetFields($met, $tbl_alias);
    $sql = "SELECT $fields FROM $this->table_name $tbl_alias";
    $shp = $this->_GetShape($shape, 'polygon');
    $sql .= " WHERE Intersects(AsText(".$this->table_params['field_shape']."),'$shp')";
    if (!$GLOBALS['PROPERTIES_ACCESS']['all_read']) {
      $user_info = $GLOBALS["TMAPY_SECURITY"]->getUserInfo();
      if ($GLOBALS['PROPERTIES_ACCESS']['owner_read']) {
        $sql .= ' AND OWNER_ID = '.$user_info['ID']; 
      } 
    }
    if ($this->vobj->layer_properties['table']['order_by']) {
      $sql .= " ORDER BY $tbl_alias.".$this->vobj->layer_properties['table']['order_by'];
    }
    $table_par['sql'] = $sql;
    $table_par["properties"] = $this->_GetTableProperties();
    $table_par['table_schema'] = array('schema'=>$this->vobj->layer_properties['table']['schema']);
    $table_par['noprint']=true;
    $table_par['nopaging']=true;
//    $table_par['showedit']=true;
    return $table_par;
  }
  
  function PrepareFormData($id) {
    if (isset($id)) {
      $tbl_alias = 'T';
      $met = $this->Metadata();
      $fields = $this->_GetFields($met, $tbl_alias);
      $sql = "SELECT $fields, asText(".$this->table_params['field_shape'].") as FWKT_ FROM $this->table_name $tbl_alias";
      $sql .= " WHERE $tbl_alias.".$this->table_params['field_id']." = $id ";
      @$this->db->query($sql);
      if ($this->db->next_record()) {
        SetVarFromHash(&$this->db->Record);
      }
    }
    return $this->db->Record;
  }
  
  function _PrepareSpecialFields($mode) {
    $user_info = $GLOBALS["TMAPY_SECURITY"]->GetUserInfo();
    $met = $this->Metadata();
    foreach ($met as $key=>$value) {

      switch (strtolower($value["type"])):
        case "date":
        case "datetime":
        case "smalldatetime":
    			if (isset($GLOBALS[$value["name"]])):
      			$GLOBALS[$value["name"]] = $this->db->str2dbdate($GLOBALS[$value["name"]]);
    			endif;
      endswitch;

      switch ($value['name']) {
        case 'OWNER_ID':
          if ($mode == 'insert') { 
            $GLOBALS[$value['name']] = $user_info['ID'];
          }
        break;
        case 'GROUP_ID':
        case 'LAST_GROUP_ID':
          if (($mode == 'insert') || ($value['name'] == 'LAST_GROUP_ID')) { 
            if (preg_match('/\[role#(.*)]/i',$this->table_params['special_fields']['group_id'], $qmatch)) {
              if (method_exists($GLOBALS["TMAPY_SECURITY"], 'GetRolesForUser')) {
                $user_roles = $GLOBALS["TMAPY_SECURITY"]->GetRolesForUser($user_info['LOGIN'], $user_info['SYSTEM']);
              }
              if ($user_roles) {
                if (!function_exists('QueryArrayByFilter')) {
                  include_once(FileUp2('.admin/functions.inc'));
                }
                $GLOBALS[$value['name']] = QueryArrayByFilter($user_roles, $qmatch[1]);
              }
            } else {
              $GLOBALS[$value['name']] = $user_info['GROUP_ID'];
            }
          }
        break;
        case 'LAST_USER_ID':
          $GLOBALS[$value['name']] = $user_info['ID'];
        break;
        case 'LAST_DATE':
          $GLOBALS[$value['name']] = $this->db->date2dbdate();
        break;
        case 'LAST_TIME':
          $GLOBALS[$value['name']] = $this->db->time2dbtime();
        break;
      }
    }
  }
  
  function _GetTableProperties() {
    return array(
      'DB_NAME'=>$this->db_name,
      'AGENDA_ID'=>$this->table_params['field_id'],
      'AGENDA_TABLE'=>$this->table_name,
      'ACCESS_UPDATE_OWNER_ID'=>'OWNER_ID'
    );
  }

  function _GetFields($met, $tbl_alias) {
    $fields = '';
    foreach ($met as $key=>$value) {
      if ($value['name'] != $this->table_params['field_shape']) {
        $fields .= ($fields?',':'').$tbl_alias.'.'.$value['name'];
      }
    }
    return $fields;
  }
  
  function _GetShape($shape, $type) {
    switch ($type) {
      case 'point':
        $shp = 'POINT('.$shape[$shape['type']]['x'].' '.$shape[$shape['type']]['y'].')';
      break;
      case "line":
      case "polyline":
        $shp = 'LINESTRING(';
        $shp_coord = '';
        foreach ($shape[$shape['type']] as $val) {
          $shp_coord .= ($shp_coord?',':'');
          $shp_coord .= $val['x'].' '.$val['y'];
        }
        $shp .= $shp_coord.')';
      break;
      case "polygon":
      case "rect":
      case 'circle':
        switch ($shape['type']) {
          case 'rect':
          case 'polygon':
            if (!$input_shp) $input_shp = $shape[$shape['type']];
            $shp = 'POLYGON((';
            $shp_coord = '';
            foreach ($input_shp as $val) {
              $shp_coord .= ($shp_coord?',':'');
              $shp_coord .= $val['x'].' '.$val['y'];
            }
            $shp .= $shp_coord.'))';
          break;
        }
      break;
    }
    return $shp; 
  }

}
?>
