<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: OracleSpatial.inc,v 1.5 2006/12/14 12:09:13 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_editlayer.inc"));

class OracleSpatial_EditLayer extends EditLayer {

  function OracleSpatial_EditLayer($vobj) {
    $this->EditLayer($vobj);
    $this->table_params['field_shape'] = $this->table_params['field_shape']?$this->table_params['field_shape']:'SHAPE';
    $this->table_params['field_id'] = $this->table_params['field_id']?$this->table_params['field_id']:'OBJECTID';
    include_once(FileUp2('.admin/db/'.$this->db_file));
    $this->db = new $this->db_name;
  }

  function Insert($shape, $attrib) {
    include_once(FileUp2('.admin/functions.inc'));
    $met = $this->Metadata();
    foreach ($met as $key=>$value) {
/*      if ($value['name'] == $this->table_params['field_shape']) {
        $met[$key]['type'] = 'NUMBER';
      }*/
      if ($value['name'] == $this->table_params['field_id']) {
        unset($met[$key]);
      } 
    }
    reset($met);
    $sql = 'INSERT INTO '.$this->table_name.' ';
    $shp = $this->_GetShape($shape, $this->vobj->layer_properties['edit']['type']);
/*    switch ($this->vobj->layer_properties['edit']['type']) {
      case 'point':
        $shp = 'MDSYS.SDO_GEOMETRY(2001,NULL,MDSYS.SDO_POINT_TYPE('.$shape[$shape['type']]['x'].','.$shape[$shape['type']]['y'].',NULL),NULL,NULL)';
      break;
      case "line":
      case "polyline":
        $shp = 'MDSYS.SDO_GEOMETRY(2002,NULL,NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1),MDSYS.SDO_ORDINATE_ARRAY(';
        $shp_coord = '';
        foreach ($shape[$shape['type']] as $val) {
          $shp_coord .= ($shp_coord?',':'');
          $shp_coord .= $val['x'].','.$val['y'];
        }
        $shp .= $shp_coord.'))';
      break;
      case "polygon":
      case "rect":
        $shp = 'MDSYS.SDO_GEOMETRY(2003,NULL,NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),MDSYS.SDO_ORDINATE_ARRAY(';
        $shp_coord = '';
        foreach ($shape[$shape['type']] as $val) {
          $shp_coord .= ($shp_coord?',':'');
          $shp_coord .= $val['x'].','.$val['y'];
        }
        $shp .= $shp_coord.'))';
      break;
    }*/
    $GLOBALS[$this->table_params['field_shape']] = $shp;
    $this->_PrepareSpecialFields('insert');
    $sql .= CreateValuesSQLFromVar($met);
    $this->ret = $this->db->query($sql);
    return ($this->ret?true:false);
  }
  
  function Update($id, $shape, $attrib) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $met = $this->Metadata();
      $this->_PrepareSpecialFields('insert');
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('update', $id)) {
        $sql = 'UPDATE '.$this->table_name.' SET ';
        $shp = $this->_GetShape($shape, $this->vobj->layer_properties['edit']['type']);
        if ($shp) { 
          $GLOBALS[strtoupper($this->table_params['field_shape'])] = $shp;
        } else {
          unset($GLOBALS[strtoupper($this->table_params['field_shape'])]);
        }
        $this->_PrepareSpecialFields('update');
        $sql .= CreateSetWhereSQLFromVar($met);
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }

  function Delete($id) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('delete', $id)) {
        $met = $this->Metadata();
        $sql = 'DELETE '.$this->table_name;
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }
  
  function Metadata() {
    return $this->db->metadata($this->table_name);
  }
  
  function PrepareTableParams($shape,$table_par=array()) {
    $met = $this->Metadata();
    if ($this->vobj->layer_properties['table']['select']) {
      $tbl_alias = $this->vobj->layer_properties['table']['field_prefix'];
      $sql = $this->vobj->layer_properties['table']['select'];
    } else {
      $tbl_alias = 'T';
      $fields = $this->_GetFields($met, $tbl_alias);
      $sql = "SELECT $fields FROM $this->table_name $tbl_alias";
    }
    $shp = $this->_GetShape($shape, 'polygon');
    $sql .= ' WHERE SDO_FILTER('.$tbl_alias.'.'.$this->table_params['field_shape'].', '.$shp.",'querytype=WINDOW') = 'TRUE'";
    if (!$GLOBALS['PROPERTIES_ACCESS']['all_read']) {
      $user_info = $GLOBALS["TMAPY_SECURITY"]->getUserInfo();
      if ($GLOBALS['PROPERTIES_ACCESS']['owner_read']) {
        $sql .= ' AND OWNER_ID = '.$user_info['ID']; 
      } 
    }
    if ($this->vobj->layer_properties['table']['order_by']) {
      $sql .= " ORDER BY $tbl_alias.".$this->vobj->layer_properties['table']['order_by'];
    }
    $table_par['sql'] = $sql;
    $table_par["properties"] = $this->_GetTableProperties();
    $table_par['table_schema'] = array('schema'=>$this->vobj->layer_properties['table']['schema']);
    $table_par['noprint']=true;
    $table_par['nopaging']=true;
//    $table_par['showedit']=true;
    return $table_par;
  }
  
  function PrepareFormData($id) {
    if (isset($id)) {
      $tbl_alias = 'T';
      $met = $this->Metadata();
      $fields = $this->_GetFields($met, $tbl_alias);
      $sql = "SELECT $fields, REPLACE(TO_CHAR($tbl_alias.".$this->table_params['field_shape'].".Get_WKT()),', ',',') as FWKT_ FROM $this->table_name $tbl_alias";
      $sql .= " WHERE $tbl_alias.".$this->table_params['field_id']." = $id ";
      @$this->db->query($sql);
      if ($this->db->next_record()) {
        SetVarFromHash(&$this->db->Record);
      }
    }
    return $this->db->Record;
  }
  
  function _PrepareSpecialFields($mode) {
    $user_info = $GLOBALS["TMAPY_SECURITY"]->GetUserInfo();
    $met = $this->Metadata();
    foreach ($met as $key=>$value) {

      switch (strtolower($value["type"])):
        case "date":
        case "datetime":
        case "smalldatetime":
    			if (isset($GLOBALS[$value["name"]])):
      			$GLOBALS[$value["name"]] = $this->db->str2dbdate($GLOBALS[$value["name"]]);
    			endif;
      endswitch;

      switch ($value['name']) {
        case 'OWNER_ID':
          if ($mode == 'insert') { 
            $GLOBALS[$value['name']] = $user_info['ID'];
          }
        break;
        case 'GROUP_ID':
        case 'LAST_GROUP_ID':
          if (($mode == 'insert') || ($value['name'] == 'LAST_GROUP_ID')) { 
            if (preg_match('/\[role#(.*)]/i',$this->table_params['special_fields']['group_id'], $qmatch)) {
              if (method_exists($GLOBALS["TMAPY_SECURITY"], 'GetRolesForUser')) {
                $user_roles = $GLOBALS["TMAPY_SECURITY"]->GetRolesForUser($user_info['LOGIN'], $user_info['SYSTEM']);
              }
              if ($user_roles) {
                if (!function_exists('QueryArrayByFilter')) {
                  include_once(FileUp2('.admin/functions.inc'));
                }
                $GLOBALS[$value['name']] = QueryArrayByFilter($user_roles, $qmatch[1]);
              }
            } else {
              $GLOBALS[$value['name']] = $user_info['GROUP_ID'];
            }
          }
        break;
        case 'LAST_USER_ID':
          $GLOBALS[$value['name']] = $user_info['ID'];
        break;
        case 'LAST_DATE':
          $GLOBALS[$value['name']] = $this->db->date2dbdate();
        break;
        case 'LAST_TIME':
          $GLOBALS[$value['name']] = $this->db->time2dbtime();
        break;
      }
    }
  }
  
  function _GetTableProperties() {
    return array(
      'DB_NAME'=>$this->db_name,
      'AGENDA_ID'=>$this->table_params['field_id'],
      'AGENDA_TABLE'=>$this->table_name,
      'ACCESS_UPDATE_OWNER_ID'=>'OWNER_ID'
    );
  }

  function _GetFields($met, $tbl_alias) {
    $fields = '';
    foreach ($met as $key=>$value) {
      if ($value['name'] != $this->table_params['field_shape']) {
        $fields .= ($fields?',':'').$tbl_alias.'.'.$value['name'];
      }
    }
    return $fields;
  }
  
  function _GetShape($shape, $type) {
    if (!$shape['type']) return false;
    switch ($type) {
      case 'point':
        $shp = 'MDSYS.SDO_GEOMETRY(2001,NULL,MDSYS.SDO_POINT_TYPE('.$shape[$shape['type']]['x'].','.$shape[$shape['type']]['y'].',NULL),NULL,NULL)';
      break;
      case "line":
      case "polyline":
        $shp = 'MDSYS.SDO_GEOMETRY(2002,NULL,NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1),MDSYS.SDO_ORDINATE_ARRAY(';
        $shp_coord = '';
        foreach ($shape[$shape['type']] as $val) {
          $shp_coord .= ($shp_coord?',':'');
          $shp_coord .= $val['x'].','.$val['y'];
        }
        $shp .= $shp_coord.'))';
      break;
      case "polygon":
      case "rect":
        switch ($shape['type']) {
          case 'rect':
          case 'polygon':
            if (!$input_shp) $input_shp = $shape[$shape['type']];
            $shp = 'MDSYS.SDO_GEOMETRY(2003,NULL,NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),MDSYS.SDO_ORDINATE_ARRAY(';
            $shp_coord = '';
            foreach ($input_shp as $val) {
              $shp_coord .= ($shp_coord?',':'');
              $shp_coord .= $val['x'].','.$val['y'];
            }
            $shp .= $shp_coord.'))';
          break;
          case 'circle':
            $val = $shape[$shape['type']];
            $shp = 'MDSYS.SDO_GEOMETRY(2003,NULL,NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,4),MDSYS.SDO_ORDINATE_ARRAY(';
            $shp_coord  =     ($val['x']+cos(0)*$val['perim']).','.($val['y']+sin(0)*$val['perim']);
            $shp_coord .= ','.($val['x']+cos(pi()/2)*$val['perim']).','.($val['y']+sin(pi()/2)*$val['perim']);
            $shp_coord .= ','.($val['x']+cos(pi())*$val['perim']).','.($val['y']+sin(pi())*$val['perim']);
            $shp .= $shp_coord.'))';
          break;
        }
      break;
    }
    return $shp; 
  }

}
?>