<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: GeoServer_WFS.inc,v 1.2 2005/10/25 11:29:46 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

/*
TODO: zjistovat dynamicky nazev emelentu s prostorovou informaci ('SHAPE','the_geom',...)
*/

require_once(FileUp2(".admin/main_editlayer.inc"));

class GeoServer_WFS_EditLayer extends EditLayer {

  function GeoServer_WFS_EditLayer($vobj) {
    $this->EditLayer($vobj);
  }
  
  // sestavuje a odesila WFS-request GeoServeru
  function Insert($shape, $attrib) {
    $met = $this->Metadata();
    if($this->arcsde) $geo_tag = 'SHAPE';
    else $geo_tag = 'the_geom';
    $wfs_geo = '<'.$geo_tag.'>'.$this->_GetShape($shape,$this->vobj->layer_properties['edit']['type']).'</'.$geo_tag.'>';
   
    foreach ($met as $k=>$item) {
      if (isset($GLOBALS[$item['name']])) {
        //echo $item['name'].': '.$GLOBALS[$item['name']].'<BR>';
        $wfs_item .= '<'.$item['name'].'>'.$GLOBALS[$item['name']].'</'.$item['name'].'>';
      }
    }
    
    $ft = $this->_CutNamespace($this->feature_type);
    
    //tady slozim WFS-Insert
    $wfs_insert =  '<?xml version="1.0"?>';
    $wfs_insert .= '<Transaction version="1.0.0" service="WFS" xmlns:gml="http://www.opengis.net/gml">';
    $wfs_insert .= '<Insert><'.$ft.'>';
    $wfs_insert .= $wfs_geo.$wfs_item; //
    $wfs_insert .= '</'.$ft.'>';
    $wfs_insert .= '</Insert></Transaction>';
    
    //die(print_r($wfs_insert));
    $response_dom = $this->_RunCommand($wfs_insert); // tady dostavam odkaz na DOM xml-odpovedi WFS serveru, testuju zda se vratil SUCCESS
    if($response_dom==false) return false;
    
    $xpath_src = $response_dom->xpath_new_context();
    $success_node = $xpath_src->xpath_eval('/*[local-name() = \'WFS_TransactionResponse\']/*[local-name() = \'TransactionResult\']/*[local-name() = \'Status\']/*[local-name() = \'SUCCESS\']',$xpath_src); //
    $success = $success_node->nodeset;
    
    if(sizeof($success)>0) return true;
    else return false;
    //die(print_r($success));
  }
  
  // sestavuje a odesila WFS-request GeoServeru
  function Update($id, $attrib) {
    if (isset($id)) {
      $met = $this->Metadata();

      foreach($met as $field) {
        if(array_key_exists($field['name'],$attrib)) {
            $update_fields[] = $field['name'];  // fieldy, ktere se budou updatovat
        }
      }
      $fid = $this->feature_type.'.'.$id;

      foreach($update_fields as $property) {
        $properties .= '<Property><Name>'.$property.'</Name><Value>'.$attrib[$property].'</Value></Property>';
      }
      $wfs_update =  '<?xml version="1.0"?>';
      $wfs_update .= '<Transaction version="1.0.0" service="WFS" xmlns:gml="http://www.opengis.net/gml">'; 
      $wfs_update .= '<Update typeName="'.$this->feature_type.'">';
      $wfs_update .= $properties;
      $wfs_update .= '<Filter><FeatureId fid="'.$fid.'"/></Filter>';
      $wfs_update .= '</Update></Transaction>';
      //die(print_r($wfs_update));

      $response_dom = $this->_RunCommand($wfs_update); // tady dostavam odkaz na DOM xml-odpovedi WFS serveru, testuju zda se vratil SUCCESS
      $xpath_src = $response_dom->xpath_new_context();
      $success_node = $xpath_src->xpath_eval('/*[local-name() = \'WFS_TransactionResponse\']/*[local-name() = \'TransactionResult\']/*[local-name() = \'Status\']/*[local-name() = \'SUCCESS\']',$xpath_src); //
      $success = $success_node->nodeset;
    
      if(sizeof($success)>0) return true;
      else return false;
    }
  }

  // sestavuje a odesila WFS-request GeoServeru
  function Delete($id) {
    if (isset($id)) {
      $fid = $this->feature_type.'.'.$id;
      $wfs_delete =  '<?xml version="1.0"?>';
      $wfs_delete .= '<Transaction version="1.0.0" service="WFS">';
      $wfs_delete .= '<Delete typeName="'.$this->feature_type.'">';
      $wfs_delete .= '<Filter><FeatureId fid="'.$fid.'"/></Filter>';
      $wfs_delete .= '</Delete></Transaction>';
      //die(print_r($wfs_delete));
      
      $response_dom = $this->_RunCommand($wfs_delete); // tady dostavam odkaz na DOM xml-odpovedi WFS serveru, testuju zda se vratil SUCCESS
      $xpath_src = $response_dom->xpath_new_context();
      $success_node = $xpath_src->xpath_eval('/*[local-name() = \'WFS_TransactionResponse\']/*[local-name() = \'TransactionResult\']/*[local-name() = \'Status\']/*[local-name() = \'SUCCESS\']',$xpath_src); //
      $success = $success_node->nodeset;
    
      if(sizeof($success)>0) return true;
      else return false;
    }
  }
  
  
  // vraci asociativni pole s atributy FeatureType ($this->feature_type)
  function Metadata() {
    
    if(stristr($this->feature_type, "sde:")) $this->arcsde = true;
    
    $request = '<?xml version="1.0"?>';
    $request .= '<DescribeFeatureType version="1.0.0" service="WFS" xmlns:cdf="http://www.opengis.net/cite/data">'; // xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs">';
    $request .= '<TypeName>'.$this->feature_type.'</TypeName>';
    $request .= '</DescribeFeatureType>';
    
    //die(print_r($request));
    $response_dom = $this->_RunCommand($request) ;
    
    $xpath_src = $response_dom->xpath_new_context();

    $nodes_type = $xpath_src->xpath_eval('//*[local-name() = \'sequence\']/*[local-name() = \'element\'][@name]',$xpath_src); //

    $elems_type = $nodes_type->nodeset;

    foreach($elems_type as $elem_type) {
      
      if(($this->arcsde && ($elem_type->get_attribute("name") == "SHAPE")) || ((!$this->arcsde) && ($elem_type->get_attribute("name") == "the_geom"))) {      
        $this->$src_shp_type = $this->_CutNamespace($elem_type->get_attribute("type")); // geotyp zdrojovych dat
        continue;
        //die(print_r($this->$src_shp_type));
      }
      else {
        $names[] = $elem_type->get_attribute("name");
      }

      if($elem_type->has_attribute("type")) {
         $type = $elem_type->get_attribute("type");
         $lens[] = '';
      }
      else {
         $children = $elem_type->child_nodes();
         //die(print_r($children[1]->child_nodes()));
         foreach($children as $child) {
           if($child->tagname == "simpleType") $children_2 = $child->child_nodes(); 
         }
         foreach($children_2 as $child) {
           if($child->tagname == "restriction") {
             $type = $child->get_attribute("base");
             $children_3 = $child->child_nodes();
             foreach($children_3 as $child) {
               if($child->tagname == "maxLength") $lens[] = $child->get_attribute("value");
               else $lens[] = '';
             }
           }
         }
         /*
         $child_3 = $child_2[0]->child_nodes();
         if($child_3[0]->node_name() == "maxLength")
            $lens[] = $child_3[0]->get_attribute("value");
         else $lens[] = '';
         */
      }
      
      /*      
      $pos = strpos($type,":");
      $pos_gml = strpos($type,"gml:");
      if(($pos !== false)&&($pos_gml === false))  $type = substr($type,$pos+1);
      if($pos !== false)  $type = substr($type,$pos+1);
      */
      $type = $this->_CutNamespace($type);
      
      $types[] = $type;
      
      

      $null[] = $elem_type->get_attribute("nillable");
     }
    foreach($names as $k=>$name) {
    $ret[$k]['table']=$this->feature_type;
    $ret[$k]['name']=strToUpper($name);
    $ret[$k]['type']=$types[$k];
    $ret[$k]['len']=$lens[$k];
    $ret[$k]['null']=$null[$k];
    }
    //die(print_r($ret));
    return $ret;
  }

  function PrepareTableParams($shape,$table_par=array()) {
    $met = $this->Metadata();
    //die(print_r($met));
    $bbox = $this->_GetShape($shape,'bbox_plus');
    $wfs_query = '<?xml version="1.0"?>';
    $wfs_query .= '<GetFeature version="1.0.0" service="WFS" xmlns:gml="http://www.opengis.net/gml">';
    if($this->arcsde) $geoprop = 'SHAPE';
    else $geoprop = 'the_geom';
    $wfs_query .= '<Query typeName="'.$this->feature_type.'"><Filter><Intersects><PropertyName>'.$geoprop.'</PropertyName>';
    $wfs_query .= $bbox;
    $wfs_query .= '</Intersects></Filter></Query></GetFeature>';
    die(print_r($wfs_query));
    $response_dom = $this->_RunCommand($wfs_query); // tady dostavam odkaz na DOM xml-odpovedi WFS serveru
    
    $data = $this->_GetDataFromWFS($response_dom);
    
    $GLOBALS['GeoServer_WFS_EditLayer_Data']=$data;
//    $table_par['sql'] = $sql;
    $table_par["properties"] = array(
      'AGENDA_ID'=>'FID_',
      'DATA_TYPE'=>'ARRAY',
      'DATA_ARRAY_NAME'=>'GeoServer_WFS_EditLayer_Data'
    );
    $table_par['table_schema'] = array('schema'=>$this->vobj->layer_properties['table']['schema']);
    $table_par['no_print']=true;
    $table_par['nopaging']=true;
    return $table_par;

  }

  function PrepareFormData($id) {
    if (isset($id)) {
    // TADY SLOZIT GETFEATURE NA FEATURETYPE KDE 'fid'==$id
      $wfs_query = '<?xml version="1.0"?>';
      $wfs_query .= '<GetFeature version="1.0.0" service="WFS" outputFormat="GML2">';
      $wfs_query .= '<Query typeName="'.$this->feature_type.'"><Filter><FeatureId fid="'.$this->feature_type.'.'.$id.'"/>';
      $wfs_query .= '</Filter></Query></GetFeature>';
      //die(print_r($wfs_query));
      $response_dom = $this->_RunCommand($wfs_query);
      $data = $this->_GetDataFromWFS($response_dom);
      if(Count($data)>0) {
        foreach($data[0] as $k=>$val) {
          $GLOBALS[$k] = $val;
        }
      }
      //die(print_r($));
      //$GLOBALS['COUNTRY']=4875;
    }
  }  
  
  
  // odesila $request metodou POST na GeoServer
  function _RunCommand($request) {

      $ch = curl_init();
      //die($request);
      curl_setopt($ch, CURLOPT_URL, $this->wfs_server);
      //curl_setopt($ch, CURLOPT_HEADER, 0);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
      curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.5 [en] (WinNT; I)');

      curl_setopt($ch, CURLOPT_POST, true);
//      curl_setopt($ch, CURLOPT_POSTFIELDS, 'ArcXMLRequest='.UrlEncode($xml).'&HeaderFile=&FooterFile=');
      curl_setopt($ch, CURLOPT_POSTFIELDS, $request);

//     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $con->CurlParameters['verifypeer']?true:false);

//      curl_setopt($ch, CURLOPT_USERPWD, $con->CurlParameters['username'].':'.$con->CurlParameters['password']);


      $response = curl_exec ($ch);
      print_R($response);

      $ch_code = curl_getinfo ($ch, CURLINFO_HTTP_CODE);
      if (!$response) {
         die("error CURL Exec: ".curl_error($ch));
      }
      if ($ch_code != 200) {
         die("error CURL Exec: return code ".$ch_code);
      }
      curl_close ($ch);

      //DOM < $response

      // Uprava chybneho zacatku XML dokumentu
      $response_ok = preg_replace('/encoding="UTF-8[^"]*"/','encoding="UTF-8"',$response);

      if($dom = @domxml_open_mem($response_ok,DOMXML_LOAD_PARSING,$error)) return $dom;
      else return false;
  }


  // vraci editacnim funkcim XML segment s geoinformacemi generovany na zaklade tvaru
  function _GetShape($shape, $type) {
    switch ($type) {
      case 'point':
        $shp = $shape[$shape['type']];
        $coord_x = ($shp['x']);
        $coord_y = ($shp['y']);
        $point = '<gml:Point><gml:coordinates decimal="." cs="," ts=" ">'.$coord_x.','.$coord_y.'</gml:coordinates></gml:Point>';
        //if($this->arcsde) $multipoint = false; // toto neni koser! viz nahore TODO
        if(preg_match("/^Multi.+$/",$this->$src_shp_type)) {
          $wfs_geo = '<gml:MultiPoint srsName="http://www.opengis.net/gml/srs/epsg.xml#'.$this->map_epsg.'"><gml:pointMember>';
          $wfs_geo .= $point;
          $wfs_geo .= '</gml:pointMember></gml:MultiPoint>';
        }
        else {
          $wfs_geo = $point;
        }
        break;
      case 'line':
      case 'polyline':
        $shp = $shape[$shape['type']];
        if($shape['type'] == 'circle') {
          $coords = $this->_GetCircleCoords($shp['x'],$shp['y'],$shp['perim']);
        } else {
          foreach($shp as $point) {
            $coords .= ' '.$point['x'].','.$point['y'];
          }
        }
        $linestring = '<gml:LineString><gml:coordinates decimal="." cs="," ts=" ">'.Trim($coords).'</gml:coordinates></gml:LineString>';
        if(preg_match("/^Multi.+$/",$this->$src_shp_type)) {
          $wfs_geo = '<gml:MultiLineString srsName="http://www.opengis.net/gml/srs/epsg.xml#'.$this->map_epsg.'"><gml:lineStringMember>';
          $wfs_geo .= '<gml:coordinates decimal="." cs="," ts=" ">'.Trim($coords).'</gml:coordinates>';
          $wfs_geo .= $linestring;
          $wfs_geo .= '</gml:lineStringMember></gml:MultiLineString>';
        }
        else {
          $wfs_geo = $linestring;
        }
        break;
      case 'rect':
      case 'polygon':
        $shp = $shape[$shape['type']];
        if($shape['type'] == 'circle') {
          $coords = $this->_GetCircleCoords($shp['x'],$shp['y'],$shp['perim']);
        } else {
          foreach($shp as $point) {
            $coords .= ' '.$point['x'].','.$point['y'];
          }
        }
        $polygon = '<gml:Polygon><gml:outerBoundaryIs><gml:LinearRing>';
        $polygon .= '<gml:coordinates decimal="." cs="," ts=" ">'.Trim($coords).'</gml:coordinates>';
        $polygon .= '</gml:LinearRing></gml:outerBoundaryIs></gml:Polygon>';
        if(preg_match("/^Multi.+$/",$this->$src_shp_type)) {
          $wfs_geo = '<gml:MultiPolygon srsName="http://www.opengis.net/gml/srs/epsg.xml#'.$this->map_epsg.'"><gml:polygonMember>';
          $wfs_geo .= $polygon;
          $wfs_geo .= '</gml:polygonMember></gml:MultiPolygon>';
        }
        else {
          $wfs_geo .= $polygon;
        }
      break;
      case 'bbox':
      case 'bbox_plus':
        $shp = $shape[$shape['type']];
        $wfs_geo = '<gml:Box srsName="http://www.opengis.net/gml/srs/epsg.xml#'.$this->map_epsg.'">';
        if ($type == 'bbox') {
          $wfs_geo .= '<gml:coordinates>'.$shp[3]['x'].','.$shp[3]['y'].' '.$shp[1]['x'].','.$shp[1]['y'].'</gml:coordinates>';
        } else {
          $wfs_geo .= '<gml:coordinates>'.($shp[3]['x']-0.000001).','.($shp[3]['y']-0.000001).' '.($shp[1]['x']+0.000001).','.($shp[1]['y']+0.000001).'</gml:coordinates>';
        }
        $wfs_geo .= '</gml:Box>';
      break;
    }
    return $wfs_geo;
  }
  
  // vraci asoc.pole s atributy featuretype  
  function _GetDataFromWFS($response_dom) {
    $xpath_src = $response_dom->xpath_new_context();
    
    $nodes_members = $xpath_src->xpath_eval('//*[local-name() = \'featureMember\']/*[local-name() = \''.$this->_CutNamespace($this->feature_type).'\']',$xpath_src); //
    $members = $nodes_members->nodeset;
    $data = array();
    if(Count($members)>0) {
      foreach($members as $k=>$member) {
        $children = $member->child_nodes();
        $row = array();
        foreach($children as $rec) {
          if ($rec->tagname != 'the_geom') {
            $row[strtoupper($rec->tagname)]=$rec->get_content();
          }
        }
        $row['FID_']= preg_replace('/^.*\.([0-9]+)$/','\\1',$member->get_attribute('fid'));
        //$row['FID_']= $k;
        $data[] = $row;
      }
    }
    return $data;
  }
  
  // konvertuje kruh na vertex (vraci pole lomovych bodu)
  function _GetCircleCoords($x_center, $y_center, $perim) {
        for($i=0; $i<=360; $i+=10) {
          //$i = ($i/180)*M_PI;
          $i_rad = deg2rad($i);
          $x1 = cos($i_rad)*$perim;
          $y1 = sin($i_rad)*$perim;
          $coord_x = $x_center + $x1;
          $coord_y = $y_center + $y1;
          $ret .= ' '.$coord_x.','.$coord_y.' ';
        }
        //die(print_r($point));
        return $ret;
  }
  
  function _CutNamespace($value) {
    $val_ok = preg_replace('/^.*:(.+)$/','\\1',$value);
    
    return $val_ok;
  }
}
?>
