<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ArcSDE.inc,v 1.1 2008/01/30 10:45:46 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_editlayer.inc"));

class ArcSDE_EditLayer extends EditLayer {

  function ArcSDE_EditLayer($vobj) {
    $this->EditLayer($vobj);
    $this->table_params['field_shape'] = $this->table_params['field_shape']?strtoupper($this->table_params['field_shape']):'SHAPE';
    $this->table_params['field_id'] = $this->table_params['field_id']?$this->table_params['field_id']:'ID';
    include_once(FileUp2('.admin/db/'.$this->db_file));
    $this->db = new $this->db_name;
    if(!isSet($this->table_params['cs_id'])) {
      $sel = 'SELECT ST_SRID('.$this->table_params['field_shape'].') FROM '.$this->table_name;
      $this->db->query($sel);
      if($this->db->next_record()) $this->table_params['cs_id'] = $this->db->Record[0];
      else $this->table_params['cs_id'] = 1; //default
    }
  }

  function Insert($shape, $attrib) {
    include_once(FileUp2('.admin/functions.inc'));
    $met = $this->Metadata();
    if(isSet($this->table_params['special_fields']['FIELD_AUTOINCREMENT'])) {
      $a_id = $this->table_params['special_fields']['FIELD_AUTOINCREMENT'];
      $sel = 'SELECT Max('.$a_id.') as max FROM '.$this->table_name;
      $this->db->query($sel);
      if($this->db->next_record()) {
        $max = $this->db->Record['max'];
        $new_id = $max+1;
      }
    }
    if(!(isSet($a_id) && $this->table_params['field_id']==$a_id)) {
      foreach ($met as $key=>$value) {
        if ($value['name'] == $this->table_params['field_id']) {
          unset($met[$key]);
        } 
      }
    }
    reset($met);


    $sql = 'INSERT INTO '.$this->table_name.' ';
    $shp = $this->_GetShape($shape, $this->vobj->layer_properties['edit']['type']);
    $GLOBALS[$this->table_params['field_shape']] = $shp;
    $this->_PrepareSpecialFields('insert');
    $GLOBALS[strtoupper($this->table_params['field_shape'])] = "ST_GeomFromText('$shp',".$this->table_params['cs_id'].")";
    if(isSet($new_id)) {
      $GLOBALS[strtoupper($a_id)] = $new_id;
    }
    $sql .= CreateValuesSQLFromVar($met);
    //die(print_r($sql));
    $this->ret = @$this->db->query($sql);
    return ($this->ret?true:false);
  }
  
  function Update($id, $shape, $attrib) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $met = $this->Metadata();
      $this->_PrepareSpecialFields('insert');
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('update', $id)) {
        $sql = 'UPDATE '.$this->table_name.' SET ';
        $shp = $this->_GetShape($shape, $this->vobj->layer_properties['edit']['type']);
        if($shape['text']) $GLOBALS[strtoupper($this->table_params['field_shape'])] = "ST_GeomFromText('$shp',".$this->table_params['cs_id'].")";
        else unset($GLOBALS[strtoupper($this->table_params['field_shape'])]);
        $this->_PrepareSpecialFields('update');
        $sql .= CreateSetWhereSQLFromVar($met);
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }

  function Delete($id) {
    if ($id) {
      include_once(FileUp2('.admin/functions.inc'));
      $GLOBALS['PROPERTIES'] = $this->_GetTableProperties();
      if (HasAccessToRecord('delete', $id)) {
        $met = $this->Metadata();
        $sql = 'DELETE FROM '.$this->table_name;
        $sql .= ' WHERE '.$this->table_params['field_id'].' = '.$id;
        $this->ret = $this->db->query($sql);
      }
      return ($this->ret?true:false);
    }
  }
  
  function Metadata() {
    return $this->db->metadata($this->table_name);
  }
  
  function PrepareTableParams($shape,$table_par=array()) {
    $tbl_alias = 'T';
    $met = $this->Metadata();
    $fields = $this->_GetFields($met, $tbl_alias);
    $sql = "SELECT $fields FROM $this->table_name $tbl_alias";
    $shp = $this->_GetShape($shape, 'polygon');
    $sql .= " WHERE ST_Intersects(".$this->table_params['field_shape'].",ST_GeomFromText('$shp',".$this->table_params['cs_id']."))=1";
    
    if (!$GLOBALS['PROPERTIES_ACCESS']['all_read']) {
      $user_info = $GLOBALS["TMAPY_SECURITY"]->getUserInfo();
      if ($GLOBALS['PROPERTIES_ACCESS']['owner_read']) {
        $sql .= ' AND OWNER_ID = '.$user_info['ID']; 
      } 
    }
    if ($this->vobj->layer_properties['table']['order_by']) {
      $sql .= " ORDER BY $tbl_alias.".$this->vobj->layer_properties['table']['order_by'];
    }
    $table_par['sql'] = $sql;
    $table_par["properties"] = $this->_GetTableProperties();
    $table_par['table_schema'] = array('schema'=>$this->vobj->layer_properties['table']['schema']);
    $table_par['noprint']=true;
    $table_par['nopaging']=true;
//    $table_par['showedit']=true;
    return $table_par;
  }
  
  function PrepareFormData($id) {
    if (isset($id)) {
      $tbl_alias = 'T';
      $met = $this->Metadata();
      $fields = $this->_GetFields($met, $tbl_alias);
      $sql = "SELECT $fields, ST_AsText(".$this->table_params['field_shape'].") as FWKT_ FROM $this->table_name $tbl_alias";
      $sql .= " WHERE $tbl_alias.".$this->table_params['field_id']." = $id ";
      @$this->db->query($sql);
      if ($this->db->next_record()) {
        SetVarFromHash(&$this->db->Record);
      }
    }
    return $this->db->Record;
  }
  
  function _PrepareSpecialFields($mode) {
    $user_info = $GLOBALS["TMAPY_SECURITY"]->GetUserInfo();
    $met = $this->Metadata();
    foreach ($met as $key=>$value) {

      switch (strtolower($value["type"])):
        case "date":
        case "datetime":
        case "smalldatetime":
    			if (isset($GLOBALS[$value["name"]])):
      			$GLOBALS[$value["name"]] = $this->db->str2dbdate($GLOBALS[$value["name"]]);
    			endif;
      endswitch;

      switch ($value['name']) {
        case 'OWNER_ID':
          if ($mode == 'insert') { 
            $GLOBALS[$value['name']] = $user_info['ID'];
          }
        break;
        case 'GROUP_ID':
        case 'LAST_GROUP_ID':
          if (($mode == 'insert') || ($value['name'] == 'LAST_GROUP_ID')) { 
            if (preg_match('/\[role#(.*)]/i',$this->table_params['special_fields']['group_id'], $qmatch)) {
              if (method_exists($GLOBALS["TMAPY_SECURITY"], 'GetRolesForUser')) {
                $user_roles = $GLOBALS["TMAPY_SECURITY"]->GetRolesForUser($user_info['LOGIN'], $user_info['SYSTEM']);
              }
              if ($user_roles) {
                if (!function_exists('QueryArrayByFilter')) {
                  include_once(FileUp2('.admin/functions.inc'));
                }
                $GLOBALS[$value['name']] = QueryArrayByFilter($user_roles, $qmatch[1]);
              }
            } else {
              $GLOBALS[$value['name']] = $user_info['GROUP_ID'];
            }
          }
        break;
        case 'LAST_USER_ID':
          $GLOBALS[$value['name']] = $user_info['ID'];
        break;
        case 'LAST_DATE':
          $GLOBALS[$value['name']] = $this->db->date2dbdate();
        break;
        case 'LAST_TIME':
          $GLOBALS[$value['name']] = $this->db->time2dbtime();
        break;
      }
    }
  }
  
  function _GetTableProperties() {
    return array(
      'DB_NAME'=>$this->db_name,
      'AGENDA_ID'=>$this->table_params['field_id'],
      'AGENDA_TABLE'=>$this->table_name,
      'ACCESS_UPDATE_OWNER_ID'=>'OWNER_ID'
    );
  }

  function _GetFields($met, $tbl_alias) {
    $fields = '';
    foreach ($met as $key=>$value) {
      if ($value['name'] != $this->table_params['field_shape']) {
        $fields .= ($fields?',':'').$tbl_alias.'.'.$value['name'];
      }
    }
    return $fields;
  }
  
  function _GetShape($shape, $type) {
    if(isSet($this->table_params['coord_decimal_positions'])) $dec_pos = $this->table_params['coord_decimal_positions'];
    switch ($type) {
      case 'point':
        if(isSet($dec_pos)) {
          $shape[$shape['type']]['x'] = round($shape[$shape['type']]['x'],$dec_pos);
          $shape[$shape['type']]['y'] = round($shape[$shape['type']]['y'],$dec_pos);
        }
        $shp = 'POINT('.$shape[$shape['type']]['x'].' '.$shape[$shape['type']]['y'].')';
      break;
      case "line":
      case "polyline":
        $shp = 'LINESTRING(';
        $shp_coord = '';
        foreach ($shape[$shape['type']] as $val) {
          $shp_coord .= ($shp_coord?',':'');
          if(isSet($dec_pos)) {
            $val['x'] = round($val['x'],$dec_pos);
            $val['y'] = round($val['y'],$dec_pos);
          }          
          $shp_coord .= $val['x'].' '.$val['y'];
        }
        $shp .= $shp_coord.')';
      break;
      case "polygon":
      case "rect":
      case 'circle':
        switch ($shape['type']) {
          case 'rect':
          case 'polygon':
            if (!$input_shp) $input_shp = $shape[$shape['type']];
            $shp = 'polygon ((';
            $shp_coord = '';
            foreach ($input_shp as $val) {
              $shp_coord .= ($shp_coord?',':'');
              if(isSet($dec_pos)) {
                $val['x'] = round($val['x'],$dec_pos);
                $val['y'] = round($val['y'],$dec_pos);
              }                        
              $shp_coord .= $val['x'].' '.$val['y'];
            }
            $shp .= $shp_coord.'))';
          break;
        }
      break;
    }

    return $shp; 
  }

}
?>
