<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: Table.inc,v 1.9 2006/01/26 08:00:00 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */
require_once(FileUp2(".admin/main_dblayer.inc"));

class Table_DBLayer extends DBLayer {
  var $fieldx = "X";
  var $fieldy = "Y";
  var $fieldid = "ID";
  
  function Table_DBLayer($link, $index, $type) {
    $this->DBLayer(&$link, $index, $type);
    if ($this->table["table_params"]["field_x"]) $this->fieldx = $this->table["table_params"]["field_x"];
    if ($this->table["table_params"]["field_y"]) $this->fieldy = $this->table["table_params"]["field_y"];
    if ($this->table["table_params"]["field_id"]) $this->fieldid = $this->table["table_params"]["field_id"];
  }

  function GetQuery() {
    if ($this->table["name"]) {
      if ($this->table["sql_select"]) {
        $sql = "select ".$this->table["sql_select"]." from ".$this->table["name"]." where ";
      }
      else {
        $sql = "select ".Implode($this->output["fields"],",")." from ".$this->table["name"]." where ";
      }
    }
    else $sql = $this->table["sql_select"]." where ";

    list($x1,$y1,$x2,$y2) = Explode(",", $this->bbox);
//		echo($this->bbox);
    $tol = isset($this->properties["tolerance"])?$this->properties["tolerance"]:3;
    switch ($this->properties["tolerance_units"]) {
      case 'map':
        $xext=abs($tol);
        $yext=abs($tol);
      break;
      case 'pixel':
      default:
        $xext=abs($tol*(($x2-$x1)/$this->width));
        $yext=abs($tol*(($y2-$y1)/$this->height));
      break;
    }

    if ($this->querytype=="point") {
      $size_2 = Round($this->size / 2);
      if ($size_2 < $xext) $size_2 = $xext;
      $sql .= $this->fieldx." > ".(((double)StrTr($this->x,',','.'))-$size_2)." and ".$this->fieldx." < ".(((double)StrTr($this->x,',','.'))+$size_2)." and ".$this->fieldy." > ".(((double)StrTr($this->y,',','.'))-$size_2)." and ".$this->fieldy." < ".(((double)StrTr($this->y,',','.'))+$size_2);
    }
    else {
      $sql .= $this->fieldx." >= ".((double)StrTr($this->x1,',','.'))." and ".$this->fieldx." <= ".((double)StrTr($this->x2,',','.'))." and ".$this->fieldy." >= ".((double)StrTr($this->y1,',','.'))." and ".$this->fieldy." <= ".((double)StrTr($this->y2,',','.'));
    }
//    die($sql);
    return $sql;
  }

  function GetInterfaceResult() {
    if ($this->properties["table_extent"]) {
      if ($this->properties["type_field"]) {
        $sql = "select ID, X, Y, ".StrToUpper($this->properties["type_field"]).", X1, Y1, X2, Y2";
      }
      else $sql = "select ID, X, Y, X1, Y1, X2, Y2";
    }
    else {
      if ($this->properties["type_field"]) {
        $sql = "select ".$this->fieldid.", ".$this->fieldx.", ".$this->fieldy.", ".StrToUpper($this->properties["type_field"]);
      }
      else $sql = "select ".$this->fieldid.", ".$this->fieldx.", ".$this->fieldy;
    }
    
    if ($this->properties["alt_field"]) {
      $sql .= ", ".StrToUpper($this->properties["alt_field"]);
    }
    
    $sql .= " from ".($this->properties["table"]?$this->properties["table"]:$this->properties["query_layer"])." where ";
    
    if ( $this->parameters["Command"] == "SelByFld" ) {
      if ($this->properties["field_type"] == "text") {
        $sql .= StrToUpper($this->parameters["Field"])." like '".$this->parameters["Values"]."'";
      }
      else {
        if ($this->parameters["ValuesSeparator"] != ",") {
          $arr_value = Explode($this->parameters["ValuesSeparator"], $this->parameters["Values"]);
          $sql .= StrToUpper($this->parameters["Field"])." in (".Implode($arr_value,",").")";
        }
        else $sql .= StrToUpper($this->parameters["Field"])." in (".$this->parameters["Values"].")";
      }
    }
    elseif ( $this->parameters["Command"] == "SelBySQL" ) { 
//komentar lube - proc ";" ??      $sql = $this->parameters["SQL"].";";
            $sql = $this->parameters["SQL"];
    }
    else $sql = "";

    $query = $sql." AND ".$this->fieldx." IS NOT NULL AND ".$this->fieldy." IS NOT NULL";
    //die($query);

    //nastaveni spojeni na databazi
    $connection = $this->manager->GetActive($this->table["connection"]);
    $connection->query($query);
    $this->output["num"] = 0;
    while ($connection->next_record()):
      $this->x = ((double) $connection->Record[StrToUpper($this->fieldx)]);
      $this->y = ((double) $connection->Record[StrToUpper($this->fieldy)]);
      $this->GetMapProject();
      $point = $this->CoordSysConvertPoint($this->table["coord_sys"], $this->map_project["coord_sys"], $this->x, $this->y);
      $this->x = $point["x"]; 
      $this->y = $point["y"];
      if ($this->properties["type_field"]) {
        $this->type = $connection->Record[StrToUpper($this->properties["type_field"])];
      }
      else $this->type = "";
      if ($this->properties["table_extent"]) {
        $this->x1 = ((double) $connection->Record["X1"]);
        $this->y1 = ((double) $connection->Record["Y1"]);
        $this->x2 = ((double) $connection->Record["X2"]);
        $this->y2 = ((double) $connection->Record["Y2"]);
      }
      else {
        $this->x1 = $this->x-1;
        $this->y1 = $this->y-1;
        $this->x2 = $this->x+1;
        $this->y2 = $this->y+1;
      }
      if ($this->properties["alt_field"]) {
        $this->alt = $connection->Record[StrToUpper($this->properties["alt_field"])];
      }
      else $this->alt = "";

      $this->SetMaxExtent();
      $this->output["num"]++;
    endwhile;  
  }

}
?>
