<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: Postgres.inc,v 1.2 2001/10/19 08:22:42 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_dblayer.inc"));

class Postgres_DBLayer extends DBLayer {
  
  function Postgres_DBLayer($link, $index, $type) {
    $this->DBLayer(&$link,$index, $type);
  }

  function GetQuery() {
    if ($this->table["name"]) {
      if ($this->table["sql_select"]) {
        $sql = "select ".$this->table["sql_select"]." from ".$this->table["name"]." where ";
      }
      else {
        $sql = "select ".Implode($this->output["fields"],",")." from ".$this->table["name"]." where ";
      }
    }
    else $sql = $this->table["sql_select"]." where ";
    switch ($this->properties["layer_type"]) {
      case "Polygon":
        $sql .= "'(".$this->x.",".$this->y.")'::point @ polygon";
      break;
      case "Table":
        $size_2 = Round($this->size / 2);
        $sql .= "x > ".(((double)StrTr($this->x,',','.'))-$size_2)." and x < ".(((double)StrTr($this->x,',','.'))+$size_2)." and y > ".(((double)StrTr($this->y,',','.'))-$size_2)." and y < ".(((double)StrTr($this->y,',','.'))+$size_2);
      break;
      case "Point":
        $sql .= "point <-> '(".$this->x.",".$this->$y.")'::point < ".$this->size;
      break;
    }
    //echo "SQL: ".$sql."<br>";
    return $sql;
  }

  function GetInterfaceResult() {
    if ($this->properties["layer_type"] == "Point") $sql = "select id, point from ".$this->parameters["Theme"]." where ";
    else $sql = "select id, box from ".$this->parameters["Theme"]." where ";
    switch ($this->parameters["Command"]) {
      case "SelByFld":
        if ($this->properties["field_type"] == "text") {
          $sql .= $this->parameters["Field"]." like '".$this->parameters["Values"]."';";
        }
        else {
          if ($this->parameters["ValuesSeparator"] != ",") {
            $arr_value = Explode($this->parameters["ValuesSeparator"], $this->parameters["Values"]);
            $sql .= $this->parameters["Field"]." in (".Implode($arr_value,",").");";
          }
          else $sql .= $this->parameters["Field"]." in (".$this->parameters["Values"].");";
        }
      break;
      case "SelBySQL": 
        $sql .= $this->parameters["SQL"].";";
      break;
      default:
        $this->output["error"] = true;
        $this->output["errorText"] = 'Postgres_DBLayer: Unsuported interface command '.$this->parameters["Command"];
    }
    
    if (!$this->output["error"]) {
      $query = $sql;
  
      //nastaveni spojeni na databazi
      $connection = $this->manager->GetActive($this->table["connection"]);

      $connection->query($query);
      $this->output["num"] = 0;
      while ($connection->next_record() && $this->output["num"] < 20):
        if (!($this->properties["layer_type"] == "Point")) {
          list($x1,$y1,$x2,$y2) = Explode(",", $connection->Record["BOX"]);
          $this->x1 = (double) SubStr($x1, 1);
          $this->y1 = (double) SubStr($y1, 0, StrLen($y1)-1);  
          $this->x2 = (double) SubStr($x2, 1);
          $this->y2 = (double) SubStr($y2, 0, StrLen($y2)-1);  
          if ($this->x1 > $this->x2) { $aux = $this->x1; $this->x1 = $this->x2; $this->x2 = $aux; }
          if ($this->y1 > $this->y2) { $aux = $this->y1; $this->y1 = $this->y2; $this->y2 = $aux; }
          $this->x = Round($this->x1 + ($this->x2 - $this->x1)/2);
          $this->y = Round($this->y1 + ($this->y2 - $this->y1)/2);
  
          $this->SetMaxExtent();
        }
        else {
          list($x1,$y1) = Explode(",", $connection->Record["POINT"]);
          $this->x = ((double) SubStr($x1, 1)) -1;
          $this->y = ((double) SubStr($y1, 0, StrLen($y1)-1)) -1;  
          $this->x2 = $this->x+2;
          $this->y2 = $this->y+2;
          $this->SetMaxExtent();
        }
        $this->output["num"]++;
      endwhile;
    }  
  }

}
?>
