<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: MapServer.inc,v 1.18 2008/04/17 12:08:24 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_dblayer.inc"));

class MapServer_DBLayer extends DBLayer {
  
  function MapServer_DBLayer($link, $index, $type) {
    $this->DBLayer(&$link,$index, $type);
  }

  function GetVersion() {
    $this->manager->GetActive($this->table["connection"]);
    $proj_name = Key($this->manager->connection);
    return $this->manager->project[$proj_name]["servers"][$this->manager->connection[$proj_name]->index]["version"];
  }

  function GetQuery() {
    list($x1,$y1,$x2,$y2) = Explode(",", $this->bbox);
//		echo($this->bbox);
    $tol = isset($this->properties["tolerance"])?$this->properties["tolerance"]:0;
    switch ($this->properties["tolerance_units"]) {
      case 'map':
        $xext=abs($tol);
        $yext=abs($tol);
      break;
      case 'pixel':
      default:
        $xext=abs($tol*(($x2-$x1)/$this->width));
        $yext=abs($tol*(($y2-$y1)/$this->height));
      break;
    }
    $qtype = $this->querytype;
    if ($xext && $qtype=="point") {
      $qtype="rect";
       $this->x1 = $this->x - $xext;
       $this->x2 = $this->x + $xext;
       $this->y1 = $this->y - $yext;
       $this->y2 = $this->y + $yext;
    }
    if ($qtype=="point") return "&mode=nquery&qlayer=".$this->properties["table"]["name"]."&mapxy=".$this->x."+".$this->y;
    else return "&mode=nquery&qlayer=".$this->properties["table"]["name"]."&minx=".$this->x1."&miny=".$this->y1."&maxx=".$this->x2."&maxy=".$this->y2;
  }

  /* changed by jiva 
  function GetQueryRect($rect) {
    $url = "&mode=nquery&qlayer=".$this->properties["table"]["name"];
    $url .= "&minx=".$rect[0];
    $url .= "&miny=".$rect[1];
    $url .= "&maxx=".$rect[2];
    $url .= "&maxy=".$rect[3];
    return $url;
  }
  */
  
  function GetInterfaceResult() {
    $query = "&mode=itemnquery&qlayer=".$this->properties["query_layer"];
    switch ($this->parameters["Command"]) {
      case "Activate":
      break;
      case "ShowCoord":
          $cntlimit = 50;
          $data = Explode(",",$this->parameters["Coords"]);
          reset($data);
          while (list($key, $val) = each($data)) {
            $ext = Explode(":", $val);
            $data[$key] = array("ext"=>$ext[0]." ".$ext[1]." ".$ext[0]." ".$ext[1]);
          }
          reset($data);
          include_once($GLOBALS["TMAPY_LIB"]."/db/db_array.inc");
          $dbcon = new DB_Sql_Array($data);
      break;
      case "SelByFld":
        $cntlimit = $this->parameters["CountLimit"]?$this->parameters["CountLimit"]:1000000;
        $separator = isset($this->parameters["ValuesSeparator"])?$this->parameters["ValuesSeparator"]:',';
        $arr_value = Explode($separator, $this->parameters["Values"]);
        if ($this->GetVersion() > "3.3") {
          if($this->properties['mapserv_usesqlsyntax']) {
            $conds = array();
            foreach($arr_value as $val) {
              if($this->properties["field_type"]=='text') $val = "'$val'"; 
              $conds[] = $this->parameters["Field"].'='.$val;
            }
            $qstring = Implode(' OR ',$conds);
          }
          else $qstring = '/^'.Implode($arr_value,'$|^').'$/';
          if (StrPos($this->properties["query_layer"], "_")) {
            $this->output["error"] = true;
            $this->output["errorText"] = 'MapServer_DBLayer: Layer name cannot have _ in the name ('.$this->properties["query_layer"].')';
          } else {
            if ($this->GetVersion() > "3.9") {
              $query .= "&qitem=".$this->parameters["Field"]."&qstring=".$qstring;
            } else {
              $query .= "&map_".$this->properties["query_layer"]."_filteritem=".$this->parameters["Field"]."&map_".$this->properties["query_layer"]."_filter=".$qstring;
            }
          }
        } else {
          $query .= "&item=".$this->parameters["Field"]."&value=^".Implode($arr_value,'$|^')."$";
        }
      break;
      default:
        $this->output["error"] = true;
        $this->output["errorText"] = 'MapServer_DBLayer: Unsuported interface command '.$this->parameters["Command"];
    }
    //die($query);
    			
    //Get coordinates
    if (!$this->output["error"]) {
      //nastaveni spojeni na databazi
      if ($this->parameters["Command"] != "ShowCoord") {
        $connection = $this->manager->GetActive($this->table["connection"]);
        $connection->query($query);
      } else {
        $connection = $dbcon;
        $connection->query('');
      }
      $this->output["num"] = 0;
      $this->Records = array();
      while (($next=$connection->next_record()) && $this->output["num"] < $cntlimit) {
        $this->Records[] = $connection->Record;
        if(isSet($connection->Record["ext"])) {
          list($x1,$y1,$x2,$y2) = Explode(" ", $connection->Record["ext"]);
          $this->x1 = (double) $x1;
          $this->y1 = (double) $y1;  
          $this->x2 = (double) $x2;
          $this->y2 = (double) $y2;
          if ($this->x1 > $this->x2) { $aux = $this->x1; $this->x1 = $this->x2; $this->x2 = $aux; }
          if ($this->y1 > $this->y2) { $aux = $this->y1; $this->y1 = $this->y2; $this->y2 = $aux; }
          $this->x = Round($this->x1 + ($this->x2 - $this->x1)/2);
          $this->y = Round($this->y1 + ($this->y2 - $this->y1)/2);
          $this->SetMaxExtent();
        }
        $this->output["num"]++;
      }
      if ($next) {
        $this->output["alert"] = true;
        $this->output["alertName"] = "alert_select_limit";
      }
    }  
  }
}

?>