<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: MapScript.inc,v 1.3 2008/02/07 13:43:35 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_dblayer.inc"));

class MapScript_DBLayer extends DBLayer {
  
  function MapScript_DBLayer($link, $index, $type) {
    $this->DBLayer(&$link,$index, $type);
  }

  function GetQuery() {

    list($x1,$y1,$x2,$y2) = Explode(",", $this->bbox);
    $xext=abs(3*(($x2-$x1)/$this->width));
//    $yext=abs(3*(($y2-$y1)/$this->height));

    $request = array(
      "type"=>"spatial",
      "layer"=>$this->properties["table"]["name"],
      "datapath"=>$this->properties["table"]["datapath"],
      "x"=>$this->x,
      "y"=>$this->y,
      "tolerance"=>$xext
    );
    return $request;
  }

  function GetInterfaceResult() {

//    die($this->parameters["Command"]);
    
    switch ($this->parameters["Command"]) {
      case "ShowCoord":
          $cntlimit = 50;
          $data = Explode(",",$this->parameters["Coords"]);
          reset($data);
          while (list($key, $val) = each($data)) {
            $ext = Explode(":", $val);
            $data[$key] = array("ext"=>array("minx"=>$ext[0], "miny"=>$ext[1],"maxx"=>$ext[0],"maxy"=>$ext[1]));
          }
          reset($data);
          include_once("db_array.inc");
          $dbcon = new DB_Sql_Array($data);
      break;
      case "SelByFld":
        $cntlimit = 20;

        if (($this->parameters["ValuesSeparator"] == ",") || (!isset($this->parameters["ValuesSeparator"]))):
          $values=$this->parameters["Values"];
        else:
          $arr_value = Explode($this->parameters["ValuesSeparator"], $this->parameters["Values"]);
          $values = Implode($arr_value,",");
        endif;          
        $unique = isset($this->properties["unique_fields"])?$this->properties["unique_fields"]:array();
        $request = array(
            "type"=>"item",
            "layer"=>$this->properties["layer"],
            "values"=>$values,
            "field"=>$this->parameters["Field"],
            "unique"=>$unique
        );
      
      break;
      default:
        $this->output["error"] = true;
        $this->output["errorinterface"] = true;
        $this->output["errorText"] = 'MapScript_DBLayer: Unsuported interface command: '.$this->parameters["Command"];
    }

    //Get coordinates
    if (!$this->output["error"]) {
      //nastaveni spojeni na databazi
      if ($this->parameters["Command"] != "ShowCoord") {
        if (!$this->manager->GetActive($this->table["connection"])) $this->manager->SetActive($this->table["connection"],$this->properties["type"]);
        $connection = $this->manager->GetActive($this->table["connection"]);
        $connection->query($request);
      } else {
        $connection = $dbcon;
        $connection->query('');
      }
      $this->output["num"] = 0;
//      $i = 0;
      while ($connection->next_record() &&  $this->output["num"] < $cntlimit):

        $this->x1 = (double) $connection->Record["ext"]["minx"];
        $this->y1 = (double) $connection->Record["ext"]["miny"];
        $this->x2 = (double) $connection->Record["ext"]["maxx"];
        $this->y2 = (double) $connection->Record["ext"]["maxy"]; 
        
        if ($this->x1 > $this->x2) { $aux = $this->x1; $this->x1 = $this->x2; $this->x2 = $aux; }
        if ($this->y1 > $this->y2) { $aux = $this->y1; $this->y1 = $this->y2; $this->y2 = $aux; }
        $this->x = Round($this->x1 + ($this->x2 - $this->x1)/2);
        $this->y = Round($this->y1 + ($this->y2 - $this->y1)/2);
//        $this->output["num"] = $i;
        $this->SetMaxExtent();
//        $i++;
//        $this->output["num"] = $i;
          $this->output["num"]++;
      endwhile;
    }  
  }
}
?>
