<?php

require_once(FileUp2(".admin/main_dblayer.inc"));

class ArcServerA_DBLayer extends DBLayer {
  
  function ArcServerA_DBLayer($link, $index, $type) {
    $this->DBLayer(&$link,$index, $type);
  }

  function GetQuery() {
    //query envelope
    list($x1,$y1,$x2,$y2) = Explode(",", $this->bbox);
    $tol = isset($this->properties["tolerance"])?$this->properties["tolerance"]:3;
    switch ($this->properties["tolerance_units"]) {
      case 'map':
        $xext=abs($tol);
        $yext=abs($tol);
      break;
      case 'pixel':
      default:
        $xext=abs($tol*(($x2-$x1)/$this->width));
        $yext=abs($tol*(($y2-$y1)/$this->height));
      break;
    }

    //subFields - other fields won't be querried
    $subFields = "";
    $MAX = count($this->table["schema"])-1;
    $i = 0;
    foreach( $this->table["schema"] as $k => $v){
       $subFields .= $k;
       if ($i<$MAX) $subFields .= ","; 
       $i++;
    };
    
    //spatial field
    $sp_field = $this->table["spatial_field"]?$this->table["spatial_field"]:"SHAPE";
    
    //set query parameter 
    $query = array ("lyname"=>$this->properties["table"]["name"],
                    "xmin"=>($this->x-$xext),
                    "ymin"=>($this->y-$yext),
                    "xmax"=>($this->x+$xext),
                    "ymax"=>($this->y+$yext),
                    "spatial_field"=>$sp_field,
                    "subfields"=>$subFields,
                    "where"=>"",
                    "query_type"=>"spatial"
                    //,
                    //"count_limit"=>$this->properties['count_limit']
                    );
                    
    return $query;
  }


  function GetInterfaceResult() {
    //check commands
    switch ($this->parameters["Command"]) {
      case "Activate":
        return;
        break;
      
      case "ShowCoor":
        $data = Explode(",",$this->parameters["Coords"]);
        reset($data);
        while (list($key, $val) = each($data)) {
          $ext = Explode(":", $val);
          $data[$key] = array("ext"=>array("minx"=>$ext[0], "miny"=>$ext[1],"maxx"=>$ext[0],"maxy"=>$ext[1]));
        }
        reset($data);
        include_once("db_array.inc");
        $dbcon = new DB_Sql_Array($data); //z ims konektoru a asi funkci
        break;
      
      case "SelByFld":
        $separator = isset($this->parameters["ValuesSeparator"])?$this->parameters["ValuesSeparator"]:',';
        $arr_value = Explode($separator, $this->parameters["Values"]);
        $where = "";
        if($this->properties["field_type"]=='string' || $this->properties["field_type"]=='text') {
          $fname = $this->parameters["Field"];
          $fldvals = Implode($arr_value,"','");
          $where = "$fname IN ('$fldvals')";
        }
        elseif($this->properties["field_type"]=='bool') {
          $where = $this->parameters["Field"]." = ".($arr_value?"1":"0");
        }
        elseif($this->properties["field_type"]=='date') {
          $where = $this->parameters["Field"].' = {ts '."'".$arr_value."'".'}';
        }
        else
          $where = $this->parameters["Field"].' IN ('.Implode($arr_value,",").')';
        break;
        
      case "SelBySQL":
        $where = $this->parameters["SQL"]; 
        break;        

      default:
        $this->output["error"] = true;
        $this->output["errorText"] = 'ArcServerA_DBLayer: Unsuported interface command '.$this->parameters["Command"];
    } 
 
     //create query parameter for connection 
     $query = array ("lyname"=>$this->parameters["Theme"],
                     "subfields"=>"",
                     "where"=>$where,
                     "query_type"=>"normal", 
                    );

    
    //send query and parse the result extent
    if (!$this->output["error"]) {
      if ($this->parameters["Command"] != "ShowCoord") {
        $connection = $this->manager->GetActive($this->table["connection"]);
        $connection->query($query);
      } else {
        $connection = $dbcon;
        $connection->query('');
      }
      
      $this->output["num"] = 0;
      $this->Records = array();
      while ($connection->next_record()):
        $this->Records[] = $connection->Record;
        $ext = $connection->Record["ext"];
        $this->x1 = (double) $ext["minx"];
        $this->y1 = (double) $ext["miny"];  
        $this->x2 = (double) $ext["maxx"];
        $this->y2 = (double) $ext["maxy"];
        if ($this->x1 > $this->x2) { $aux = $this->x1; $this->x1 = $this->x2; $this->x2 = $aux; }
        if ($this->y1 > $this->y2) { $aux = $this->y1; $this->y1 = $this->y2; $this->y2 = $aux; }
        $this->x = Round($this->x1 + ($this->x2 - $this->x1)/2);
        $this->y = Round($this->y1 + ($this->y2 - $this->y1)/2);
        $this->SetMaxExtent();
        $this->output["num"]++;
      endwhile;
      
    }   
  }
}

?>
