<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ArcIMS.inc,v 1.14 2008/04/15 14:28:34 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2(".admin/main_dblayer.inc"));

class ArcIMS_DBLayer extends DBLayer {
  
  function ArcIMS_DBLayer($link, $index, $type) {
    $this->DBLayer(&$link,$index, $type);
  }

  function GetQuery() {
//    include_once(FileUp2(".admin/functions.inc"));
//    print_r($this);
    $proj = $this->manager->GetProject($this->table['connection']);
    $decim_sep = $proj['servers'][0]['decimal_separator']?$proj['servers'][0]['decimal_separator']:'.'; 
 
//die(print_r($proj));
    list($x1,$y1,$x2,$y2) = Explode(",", $this->bbox);
//		echo($this->bbox);
    $tol = isset($this->properties["tolerance"])?$this->properties["tolerance"]:3;
    switch ($this->properties["tolerance_units"]) {
      case 'map':
        $xext=abs($tol);
        $yext=abs($tol);
      break;
      case 'pixel':
      default:
        $xext=abs($tol*(($x2-$x1)/$this->width));
        $yext=abs($tol*(($y2-$y1)/$this->height));
      break;
    }
//    die($this->bbox);
//    die($xext);
    $xml_request = '<ARCXML VERSION="1.1">'."\n";
    $xml_request .= '<REQUEST>'."\n";

    $xml_request .= '<GET_FEATURES outputmode="xml" envelope="true" geometry="false"';
    if ($this->properties['count_limit']) {
      $xml_request .= ' featurelimit ="'.$this->properties['count_limit'].'"';
    }
    $xml_request .= '>'."\n";
    $xml_request .= '<LAYER id="'.$this->properties["table"]["name"].'" />'."\n";
//    $xml_request .= '<LAYER id="3" />'."\n";
    $xml_request .= '<SPATIALQUERY subfields="#ALL#">'."\n";
    $xml_request .= '<SPATIALFILTER relation="area_intersection">'."\n";
    switch ($this->querytype) {
      case 'point':
        if (isset($this->properties["tolerance"]) && $this->properties["tolerance"]<=0){
          $xml_request .= "<MULTIPOINT>\n";
          $xml_request .= '<POINT x="'.Str_Replace('.',$decim_sep,($this->x)).'" y="'.Str_Replace('.',$decim_sep,($this->y)).'" />'."\n";
          $xml_request .= "</MULTIPOINT>\n";
        }else
          $xml_request .= '<ENVELOPE minx="'.Str_Replace('.',$decim_sep,($this->x-$xext)).'" miny="'.Str_Replace('.',$decim_sep,($this->y-$yext)).'" maxx="'.Str_Replace('.',$decim_sep,($this->x+$xext)).'" maxy="'.Str_Replace('.',$decim_sep,($this->y+$yext)).'" />'."\n";
      break;
      case 'extent':
          $xml_request .= '<ENVELOPE minx="'.Str_Replace('.',$decim_sep,($this->x1)).'" miny="'.Str_Replace('.',$decim_sep,($this->y1)).'" maxx="'.Str_Replace('.',$decim_sep,($this->x2)).'" maxy="'.Str_Replace('.',$decim_sep,($this->y2)).'" />'."\n";
      break;
    }    
    $xml_request .= "</SPATIALFILTER>\n";
    $xml_request .= "</SPATIALQUERY>\n";
    $xml_request .= "</GET_FEATURES>\n";
    $xml_request .= "</REQUEST>\n";
    $xml_request .= "</ARCXML>";
//die($xml_request);
    return $xml_request;

  }

  function GetInterfaceResult() {
//echo("sdvfasdvgasdfvgadfvgadfvgadf");
//    die($this->properties["layer"]);
    
    $xml_request = '<ARCXML VERSION="1.1">'."\n";
    $xml_request .= '<REQUEST>'."\n";
    $xml_request .= '<GET_FEATURES outputmode="xml" envelope="true" geometry="false">'."\n";
    $xml_request .= '<LAYER id="'.(isset($this->properties['query_layer'])?$this->properties['query_layer']:$this->parameters["Theme"]).'" />'."\n";

    switch ($this->parameters["Command"]) {
      case "Activate":
        return;
      break;
      case "ShowCoord":
          $data = Explode(",",$this->parameters["Coords"]);
          reset($data);
          while (list($key, $val) = each($data)) {
            $ext = Explode(":", $val);
            $data[$key] = array("ext"=>array("minx"=>$ext[0], "miny"=>$ext[1],"maxx"=>$ext[0],"maxy"=>$ext[1]));
          }
          reset($data);
          include_once($GLOBALS["TMAPY_LIB"]."/db/db_array.inc");
          $dbcon = new DB_Sql_Array($data);
      break;
      case "SelByFld":
        $separator = isset($this->parameters["ValuesSeparator"])?$this->parameters["ValuesSeparator"]:',';
        $arr_value = Explode($separator, $this->parameters["Values"]);
        $xml_request .= '<QUERY subfields="#ALL#" ';
        if($this->properties["field_type"]=='string' || $this->properties["field_type"]=='text')
          $xml_request .= 'where="'.$this->parameters["Field"].' IN ('."'".''.Implode($arr_value,"','").''."'".')"';
        elseif($this->properties["field_type"]=='bool')
          $xml_request .= 'where="'.$this->parameters["Field"].' = '.$arr_value?"1":"0".'"';
        elseif($this->properties["field_type"]=='date')
          $xml_request .= 'where="'.$this->parameters["Field"].' = {ts '."'".$arr_value."'".'}"';
        else
          $xml_request .= 'where="'.$this->parameters["Field"].' IN ('.Implode($arr_value,",").')"';
        $xml_request .= " />\n";
      break;
      case "SelBySQL":
        $xml_request .= '<QUERY subfields="#ALL#" ';
        $xml_request .= 'where="'.$this->parameters["SQL"].'"';
        $xml_request .= " />\n";
      break;
      default:
        $this->output["error"] = true;
        $this->output["errorText"] = 'ArcIMS_DBLayer: Unsuported interface command '.$this->parameters["Command"];
    }
    $xml_request .= "</GET_FEATURES>\n";
    $xml_request .= "</REQUEST>\n";
    $xml_request .= "</ARCXML>";
    //die($xml_request);
    //Get coordinates
    if (!$this->output["error"]) {
      //nastaveni spojeni na databazi
      if ($this->parameters["Command"] != "ShowCoord") {
        $connection = $this->manager->GetActive($this->table["connection"]);
        $connection->query($xml_request);
      } else {
        $connection = $dbcon;
        $connection->query('');
      }
      $this->output["num"] = 0;
      $this->Records = array();
      while ($connection->next_record()) {
        $this->Records[] = $connection->Record;
        $ext = $connection->Record["ext"];
        if(isSet($ext) && is_array($ext)) {
          $this->x1 = (double) $ext["minx"];
          $this->y1 = (double) $ext["miny"];  
          $this->x2 = (double) $ext["maxx"];
          $this->y2 = (double) $ext["maxy"];
          if ($this->x1 > $this->x2) { $aux = $this->x1; $this->x1 = $this->x2; $this->x2 = $aux; }
          if ($this->y1 > $this->y2) { $aux = $this->y1; $this->y1 = $this->y2; $this->y2 = $aux; }
          $this->x = ($this->x1 + ($this->x2 - $this->x1)/2);
          $this->y = ($this->y1 + ($this->y2 - $this->y1)/2);
          $this->SetMaxExtent();
        }
        $this->output["num"]++;
      }
    }  
  }
}

?>
