<?php
require_once($GLOBALS['TMAPY_LIB'].'/ms/ArcGISServer.inc');
require_once(FileUp2('.admin/main_dblayer.inc'));

class ArcGISServer_DBLayer extends DBLayer {
  
  function ArcGISServer_DBLayer($link, $index, $type) {
    $this->DBLayer(&$link,$index, $type);
  }

  function CreateMSArcGISServer () {
    $this->Connection = $this->manager->GetServer($this->table['connection']);;
    if ($this->table['parameters']['MapDescription']['Name'])
       $this->Connection['mapname'] = $this->table['parameters']['MapDescription']['Name']; 
    if (!$this->msobj) $this->msobj = new MS_ArcGISServer($this->Connection);
  }

  function GetQuery() {
  
    $this->CreateMSArcGISServer();
    
    $tol = isset($this->properties["tolerance"])?$this->properties["tolerance"]:3;
    switch ($this->properties["tolerance_units"]) {
      case 'map':
        $xext=abs($tol);
        $yext=abs($tol);
      break;
      case 'pixel':
      default:
        list($x1,$y1,$x2,$y2) = Explode(",", $this->bbox);
        $xext=abs($tol*(($x2-$x1)/$this->width));
        $yext=abs($tol*(($y2-$y1)/$this->height));
      break;
    }
    
    $this->AGSParams = array('SpatialFilter'=>array(
      'SearchOrder'=>'esriSearchOrderSpatial',
      'SpatialRel'=>'esriSpatialRelIntersects'
    ));
    
    switch ($this->querytype) {
      case 'point':
        if (isset($this->properties["tolerance"]) && $this->properties["tolerance"]<=0) {
          $this->AGSParams['SpatialFilter']['FilterGeometry'] = $this->msobj->getSoapVal('PointN',array(
            'X'=>(double)$this->x,
            'Y'=>(double)$this->y,
          ));
        } else {
          $this->AGSParams['SpatialFilter']['FilterGeometry'] = $this->msobj->getSoapVal('EnvelopeN',array(
            'XMin'=>(double)$this->x-$xext,
            'YMin'=>(double)$this->y-$yext,
            'XMax'=>(double)$this->x+$xext,
            'YMax'=>(double)$this->y+$yext,
          ));
        }
      break;
      case 'extent':
          $this->AGSParams['SpatialFilter']['FilterGeometry'] = $this->msobj->getSoapVal('EnvelopeN',array(
            'XMin'=>(double)$this->x1,
            'YMin'=>(double)$this->y1,
            'XMax'=>(double)$this->x2,
            'YMax'=>(double)$this->x2,
          ));
      break;
    }

    $this->Request = array(
      'method'=>'QueryFeatureIDs',
      'params'=>array(
        'MapName'=>$this->msobj->encodeString($this->msobj->getMapName()),
        'LayerID'=>$this->msobj->getLayerIndexByLayerName($this->properties["table"]["name"]),
        'QueryFilter'=>$this->msobj->getSoapVal('SpatialFilter',$this->AGSParams['SpatialFilter']),
      ),
    );

    return $this->Request;
    
  }

  function GetInterfaceResult() {
    //check commands
    
    switch ($this->parameters['Command']) {
      case 'Activate':
        return;
      break;
      case 'ShowCoord':
        $data = Explode(',',$this->parameters['Coords']);
        reset($data);
        while (list($key, $val) = each($data)) {
          $ext = Explode(':', $val);
          $data[$key] = array('_ENVELOPE_'=>array('minx'=>$ext[0], 'miny'=>$ext[1],'maxx'=>$ext[0],'maxy'=>$ext[1]));
        }
        reset($data);
        include_once('db_array.inc');
        $dbcon = new DB_Sql_Array($data);
      break;
      case 'SelByFld':
        $this->CreateMSArcGISServer();
        $separator = isset($this->parameters['ValuesSeparator'])?$this->parameters['ValuesSeparator']:',';
        if ($this->parameters['Values'] == '') {
          $field = 'FID'; 
          $arr_value=array(-1);
        } else {
          $field =$this->parameters['Field']; 
          $arr_value = Explode($separator, $this->parameters['Values']);
        }
        if ($field == '_ID_') {
          foreach ($arr_value as $k=>$v) $arr_value[$k] = $v-1;
          $this->AGSParams['QueryFilter']['FIDSet']=$this->msobj->getSoapVal('FIDSet',array(
            'FIDArray'=>$this->msobj->getSoapVal('FIDArray',$arr_value)
          ));
        } elseif ($field == 'FID') {
          $this->AGSParams['QueryFilter']['FIDSet']=$this->msobj->getSoapVal('FIDSet',array(
            'FIDArray'=>$this->msobj->getSoapVal('FIDArray',$arr_value)
          ));
        } else {
          if($this->properties['field_type']=='string' || $this->properties['field_type']=='text')
            $this->AGSParams['QueryFilter']['WhereClause'] = 'Upper('.$field.") IN (Upper('".Implode($arr_value,"'),Upper('")."'))";
          elseif($this->properties['field_type']=='bool')
            $this->AGSParams['QueryFilter']['WhereClause'] = $field.' = '.$arr_value?1:0;
          elseif($this->properties['field_type']=='date')
            $this->AGSParams['QueryFilter']['WhereClause'] = $field." = '".($arr_value?1:0)."'";
          else
            $this->AGSParams['QueryFilter']['WhereClause'] = $field.' IN ('.Implode($arr_value,',').')';
        }
        $this->AGSParams['LayerID']=$this->msobj->getLayerIndexByLayerName(isset($this->properties['query_layer'])?$this->properties['query_layer']:$this->parameters["Theme"]);
        
        $this->Request = array(
          'method'=>'QueryFeatureIDs',
          'params'=>array(
            'MapName'=>$this->msobj->encodeString($this->msobj->getMapName()),
            'LayerID'=>$this->AGSParams['LayerID'],
            'QueryFilter'=>$this->msobj->getSoapVal('QueryFilter',$this->AGSParams['QueryFilter']),
          )
        );
      break;
      case 'SelBySQL':
        $this->CreateMSArcGISServer();
        $this->AGSParams['LayerID']=$this->msobj->getLayerIndexByLayerName(isset($this->properties['query_layer'])?$this->properties['query_layer']:$this->parameters["Theme"]);
        $this->Request = array(
          'method'=>'QueryFeatureIDs',
          'params'=>array(
            'MapName'=>$this->msobj->encodeString($this->msobj->getMapName()),
            'LayerID'=>$this->AGSParams['LayerID'],
            'QueryFilter'=>$this->msobj->getSoapVal('QueryFilter',array(
              'WhereClause'=>$this->parameters['SQL']
            )),
          )
        );
      break;        
      default:
        $this->output['error'] = true;
        $this->output['errorText'] = 'ArcGISServer_DBLayer: Unsuported interface command '.$this->parameters['Command'];
      break;
    } 

    //Parse the result extent
    if (!$this->output['error']) {
      if ($this->parameters['Command'] != 'ShowCoord') {
        $connection = $this->msobj;
        $connection->query($this->Request);
      } else {
        $connection = $dbcon;
        $connection->query('');
      }

      $this->output['num'] = 0;
      $this->Records = array();
      while ($connection->next_record()) {
        $this->Records[] = $connection->Record;
        $ext = $connection->Record['_ENVELOPE_'];
        if(isSet($ext) && is_array($ext)) {
          $this->x1 = (double) $ext['minx'];
          $this->y1 = (double) $ext['miny'];  
          $this->x2 = (double) $ext['maxx'];
          $this->y2 = (double) $ext['maxy'];
          if ($this->x1 > $this->x2) { $aux = $this->x1; $this->x1 = $this->x2; $this->x2 = $aux; }
          if ($this->y1 > $this->y2) { $aux = $this->y1; $this->y1 = $this->y2; $this->y2 = $aux; }
          $this->x = ($this->x1 + ($this->x2 - $this->x1)/2);
          $this->y = ($this->y1 + ($this->y2 - $this->y1)/2);
          $this->SetMaxExtent();
        }
        $this->output['num']++;
      }
      //die(print_r($this->Records));
    }  
  }
}

?>
