<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: cl_objects_global.inc,v 1.51 2008/05/06 11:31:31 lube Exp $'.'$Name:  $';exit;}; /* HEADER */
include_once(FileUp2(".admin/access_map_.inc"));

$file_lang = FileUp2(".admin/lg/".$GLOBALS["client_lang"].".inc");
if($file_lang) require_once($file_lang);
$file_lg_app = FileUp2(".admin/lg/app_".$GLOBALS["client_lang"].".inc");
if (File_exists($file_lg_app)) include($file_lg_app);

$panel_schema = FileUp2(".admin/panel_schema.inc");
if ($panel_schema) {
  require($panel_schema);
  $MAP_PANEL = MapAccessArray($MAP_PANEL);
}

$info_schema = FileUp2(".admin/info_schema.inc");
if ($info_schema) {
  require_once($info_schema);
  $MAP_INFO = MapAccessArray($MAP_INFO);
  $MAP_INFO_PROPERTIES = MapAccessArray($MAP_INFO_PROPERTIES);
}

$map_schema = FileUp2(".admin/map_schema.inc");
if ($map_schema) {
  require($map_schema);
  $MAP_PROJECT = MapAccessArray($MAP_PROJECT);
}

$hotlink_schema = FileUp2(".admin/hotlink_schema.inc");
if ($hotlink_schema) {
  require_once($hotlink_schema);
  $MAP_LINK = MapAccessArray($MAP_LINK);
  $MAP_LINK_EX = MapAccessArray($MAP_LINK_EX);
}

$layer_schema = FileUp2(".admin/layer_schema.inc");
if ($layer_schema) {
  require_once($layer_schema);
  $MAP_LAYER = MapAccessArray($MAP_LAYER);
}

$tabs_schema = FileUp2(".admin/tabs_schema.inc");
if ($tabs_schema) {
  require_once($tabs_schema);
  $TABS_PANEL = MapAccessArray($TABS_PANEL);
}

$bookmark_schema = FileUp2(".admin/bookmark_schema.inc");
if ($bookmark_schema) {
  require_once($bookmark_schema);
  $MAP_BOOKMARK = MapAccessArray($MAP_BOOKMARK);
}

$edit_schema = FileUp2(".admin/edit_schema.inc");
if ($edit_schema) {
  require_once($edit_schema);
  $MAP_EDIT = MapAccessArray($MAP_EDIT);
  $MAP_EDIT_EX = MapAccessArray($MAP_EDIT_EX);
}

$properties_ = FileUp2(".admin/properties.inc");
if ($properties_) {
  require_once($properties_);
  $PROPERTIES = MapAccessArray($PROPERTIES);
}

class CL_Base {
  var $properties;
  var $parameters;
  var $main_client;

  function CL_Base($prop,$params,&$main_client) {
    $this->properties = $prop;
    $this->parameters = $params;
    $this->main_client = &$main_client;
  }

  function SetHTMLOutput() {
    return "";
  }
}

class CL_Text extends CL_Base {

  function CL_Text($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    return $this->properties["text"];
  }

}

class CL_TextPosition extends CL_Base {

  function CL_TextPosition($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    $this->properties["position"] = $this->properties["position"]?$this->properties["position"]:"absolute";
    if (!$this->properties["position"] || ($this->properties["position"] == "absolute")) {
      $netscape = IsN() && (BrowserVersion() == 4);
      $output = "<div";
      if ($this->properties["class"])  $output .= " class=\"".$this->properties["class"]."\"";
      $output .= " style=\"z-index:1;";
      if ($this->properties["position"]) $output .= "position:".$this->properties["position"].";";
      if ($this->properties["left"])   $output .= "left:".$this->properties["left"]."px;";
      if ($this->properties["top"])    $output .= "top:".$this->properties["top"]."px;";
      if ($this->properties["width"])  $output .= "width:".$this->properties["width"]."px;";
      if ($this->properties["height"]) $output .= "height:".$this->properties["height"]."px;";
      if ($this->properties["style"]) $output .= $this->properties["style"].";";
      $output .= '" ';
      $output .= '>';
      $output .= $this->properties["text"];
      $output .= "</div>\n";
    } else {
      $output = $this->properties["text"];
    }
    return $output;
  }

}

class CL_Function extends CL_TextPosition {

  function CL_Function($prop,$params,&$main_client) {
    $this->CL_TextPosition($prop,$params,&$main_client);

    $text = "";
    $width = (($this->properties["img_width"])?$this->properties["img_width"]:20);
    $height = (($this->properties["img_height"])?$this->properties["img_height"]:20);
    $width = "width=\"$width\"";
    $height = "height=\"$height\"";
    $align = ($this->properties["align"])?"align=\"".$this->properties["align"]."\"":'';

    if (($this->properties["image"] || $this->properties["text"]) && !$this->properties["hidden"]) {
      $text .= "<a ";
      if ($this->properties["class_href"]) {
        $text .="class=\"".$this->properties["class_href"]."\"";
      }
      $text .= "href=\"javascript:".$this->properties["function"]."\">";
      if ($this->properties["name"]) $name = "name='".$this->properties["name"]."'";
      if ($this->properties["image"]) $text .= "<img src=\"".$this->properties["image"]."\" alt=\"".$this->properties["alt"]."\" $width $height $align border='0' $name>";
      if ($this->properties["text"]) $text .= $this->properties["text"];
      $text .= "</a>";
    }
    $this->properties["text"] = $text;

  }

}
class CL_Tools extends CL_Base {

  function CL_Tools($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    $output = "<script type=\"text/javascript\">\n";
    $output .= "  panel=new Object();\n";
    $output .= "  panel.state='zoomIn';\n";
    $output .= $this->properties["init"];
    $output .= "</script>\n";
    return $output;
  }
}

class CL_ToolBar extends CL_Text {

  function CL_ToolBar($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);
    $toolobj_scr = "";$toolobj_scr_img = "";$toolobj = "";
    if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["tool_bar"]) {
      $toolobj .= "<table class=\"tool_bar\"><tr>\n";
      foreach($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["tool_bar"]["tool_array"] as $key=>$val) {
        $obj = $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["tool_bar"]["tool_array"][$key];
        if($obj && $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]][$key]) {

          $align = ($obj["align"])?"align=\"".$obj["align"]."\"":'';

          if($GLOBALS["MAP_PROJECT"]["status_bar"]["alt"]) $status = "onmouseover=\"window.status='".$obj["alt"]."';return true;\" onmouseout=\"window.status='';return true;\"";
          else $status = "";

          if(!$obj["hidden"]) {
            $toolobj .= "<td class=\"tool_bar\"><a ";
            $toolobj .= "href=\"javascript:".$obj["function"]."\" $status>";
            if ($obj["name"]) $name = "name='".$obj["name"]."'";

            if($GLOBALS["MapVars"]["panel_state"]) {
              $img_tool = (($obj["name"] == $GLOBALS["MapVars"]["panel_state"])?FileUpURL('images/'.$obj["image_on"]):FileUpURL('images/'.$obj["image_off"]));
            }
            elseif ($obj["active"]) $img_tool = FileUpURL('images/'.$obj["image_on"]);
            else $img_tool = FileUpURL('images/'.$obj["image_off"]) ;

            $imsize = getimagesize($img_tool);
            $toolobj .= "<img src=\"".$img_tool."\" alt=\"".$obj["alt"]."\" title=\"".$obj["alt"]."\" width=\"".$imsize[0]."\" height=\"".$imsize[1]."\"  $align border='0' $name>";
            $toolobj .= "</a>\n";

            //SPECIFIKA KONKRETNIHO NASTROJE
            $toolobj_spec = false;
            switch($obj["name"]) {
              case "edit":
                $toolobj .= "<select class=\"edit_box\" id=\"edit_box\" name=\"edit_box\">\n";
                $toolobj_spec["edit"] = "";

                foreach($GLOBALS["MAP_EDIT"] as $Ekey=>$Eval) {
                  if($GLOBALS["MapVars"]["edit_box"] == $Ekey) $selected = "selected";
                  else $selected="";
                  $toolobj .= "<option value=\"".$Ekey."\" ".$selected.">".$Eval["caption"]."\n";

                  $toolobj_spec["edit"] .= "edit['".$Ekey."']=new Object();\n";
                  $toolobj_spec["edit"] .= "e=edit['".$Ekey."'];\n";
                  $toolobj_spec["edit"] .= "e.link='".$Eval["link"]."';\n";
                  $toolobj_spec["edit"] .= "e.request='".$Eval["request"]."';\n";
                  $toolobj_spec["edit"] .= "e.output=new Object();\n";
                  $toolobj_spec["edit"] .= "e.output.target='".$Eval["output"]["target"]."';\n";
                  $toolobj_spec["edit"] .= "e.output.features='".$Eval["output"]["features"]."';\n";

                }
                $toolobj .= "</select>\n";

                if(is_array($GLOBALS["MAP_EDIT_EX"]["agenda_link"])) {
                  $toolobj .= "<a href=\"javascript:EditShowTable();\">";
                  $img_tool = FileUp2("images/database.gif");
                  if($img_tool) $imsize = getimagesize($img_tool);
                  $toolobj .= "<img src=\"".$img_tool."\" alt=\"".$GLOBALS["RESOURCE_STRING"]["edit_tool_showTable"]."\" title=\"".$GLOBALS["RESOURCE_STRING"]["edit_tool_showTable"]."\" width=\"".$imsize[0]."\" height=\"".$imsize[1]."\" border=\"0\">";
                  $toolobj .= "</a>\n";
                }

              break;
              case "xy2agend":
                $toolobj_scr .= "  map.geolocation=true;\n";
              break;
            }

            $toolobj .= "</td>\n";
					}
          if ($obj["active"] && !$GLOBALS["MapVars"]["panel_state"]) {
            $toolobj_scr .= "  panel=new Object();\n";
            $toolobj_scr .= "  panel.state='".$obj["name"]."';\n";
          }
          $toolobj_scr_img .= "  SetImg('".$obj["name"]."','".FileUpURL('images/'.$obj["image_on"])."','".FileUpURL('images/'.$obj["image_off"])."');\n";
        }
      }
      $toolobj .= "</tr></table>\n";
      if ($GLOBALS["MapVars"]["panel_state"]) {
        $toolobj_scr .= "  panel=new Object();\n";
        $toolobj_scr .= "  panel.state='".$GLOBALS["MapVars"]["panel_state"]."';\n";
      }
    }
    if($toolobj_scr || $toolobj_scr_img || is_array($toolobj_spec)) $toolobj .= "<script type=\"text/javascript\">\n";
    $toolobj .= $toolobj_scr;
    $toolobj .= $toolobj_scr_img;

    if(is_array($toolobj_spec)) foreach($toolobj_spec as $tk=>$tv) $toolobj .= $tv;

    if($toolobj_scr || $toolobj_scr_img || is_array($toolobj_spec)) $toolobj .= "</script>\n";
    $this->properties["text"] = $toolobj;
  }
}


class CL_MapImage extends CL_Base {

  function CL_MapImage($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    $params["MAP"] = $GLOBALS["MAP_PROJECT"]["name"]?$GLOBALS["MAP_PROJECT"]["name"]:($this->parameters["map_properties"]["connection"]?$this->parameters["map_properties"]["connection"]:$GLOBALS["MAP"]);
    $params["BBOX"] = $this->parameters["map_properties"]["bbox"];
    $params["WIDTH"] = $this->properties["width"];
    $params["HEIGHT"] = $this->properties["height"];
    $params["FORMAT"] = $this->properties["format"];
    $params["BGCOLOR"] = $this->properties["bgcolor"];
    $params["ULAYERS"] = $this->parameters["map_properties"]["ulayers"];
    $params["ULAYERS_ON"] = $this->parameters["map_properties"]["ulayers_on"];
    $params["ULAYERS_OFF"] = $this->parameters["map_properties"]["ulayers_off"];
    $params["SELECT"] = $this->parameters["map_properties"]["select"];
    $params["SCALE"] = $this->parameters["map_properties"]["scale"];
    $params["MODE"] = $this->properties["mode"]?$this->properties["mode"]:"map";
    $params["client_lang"] = $GLOBALS["client_lang"]?$GLOBALS["client_lang"]:"cz_win";

    require_once(FileUp2(".admin/main_mint_tms12.inc"));

    $interface = new Map_TMS12_Interface($params);

    require_once(FileUp2(".admin/map_".StrToLower($interface->parameters["format"]).".inc"));
    $cls = StrToUpper($interface->parameters["format"])."_Map";
    @$map = new $cls($interface);
    if (!Is_Object($map)) die("Bad format of map: ".$interface->parameters["format"]);
    $map->cache_output = true;
    $map->position = $this->properties["position"]?$this->properties["position"]:"absolute";
    switch ($map->position) {
      case "relative":
        $envelope_style = "position:relative";
      break;
      case "static":
        $envelope_style = "position:static";
      break;
      case "absolute":
      default:
        $envelope_style = "position:absolute;left:".$this->properties["left"]."px;top:".$this->properties["top"]."px";
      break;
    }
    $envelope_style .= ";overflow:hidden;width:".$this->properties["width"].";height:".$this->properties["height"];

    $map->layer_params = false;
    switch ($params["MODE"]) {
      case "map":
        $layername = "MapLayers";
        $map->output .= '<div id="'.$layername.'_Envelope" style="'.$envelope_style.'">'."\n";
        switch ($map->position) {
          case "relative":
          case "static":
            $map->output .= '<div id="'.$layername.'_Over" style="position:absolute;z-index:99">'."\n";
          break;
        }
        if ($map->wait) $map->WriteWaitLayer();
        if ($map->zoom) $map->WriteZoomLayer();
        if ($map->pan) $map->WritePanLayer();

        //MapImage OBJECT PLUGIN
        $PluginFile = FileUp2(".admin/client_objects/plugins/MapImage_plugin.inc");
        if(is_file($PluginFile)) include($PluginFile);

        switch ($map->position) {
          case "relative":
          case "static":
            $map->output .= '</div>'."\n";
          break;
        }
        $this->main_client->bbox = $map->request["bbox"]["minx"].",".$map->request["bbox"]["miny"].",".$map->request["bbox"]["maxx"].",".$map->request["bbox"]["maxy"];
      break;
      case "ov":
        $layername = "OVLayers";
        $map->output .= '<div id="'.$layername.'_Envelope" style="'.$envelope_style.'">'."\n";
        switch ($map->position) {
          case "relative":
          case "static":
            $map->output .= '<div id="'.$layername.'_Over" style="position:absolute;">'."\n";
          break;
        }
        if ($map->zoom) $map->WriteZoomLayer("OV");
        switch ($map->position) {
          case "relative":
          case "static":
            $map->output .= '</div>'."\n";
          break;
        }
        $this->map = $map;
      break;
    }

    $map->layer_params = array("position"=>$this->properties["position"]);//,"left"=>$this->properties["left"], "top"=>$this->properties["top"]);


    if ($params["MODE"] != "lg") {
      if (IsN() && (BrowserVersion() == 4)) {
        $map->output .= '<layer name="'.$layername.'" visibility="show" CLIP="0,0,'.$this->properties["width"].",".$this->properties["height"].'" left='.$this->properties["left"].' top='.$this->properties["top"].' width=' .$this->properties["width"].' height='.$this->properties["height"].' Z-INDEX=1>'."\n";
      } else {
        $map->output .= '<div id="'.$layername.'" style="position:relative;">'."\n";
      }
    }

    $map->layer_params["class"] = $this->properties["class"];

    switch ($map->position) {
      case "relative":
      case "static":
        if ($params["MODE"] != 'lg')
          $map->output .= '<div style="position:absolute;">'."\n";
    }
    $map->WriteMapContent();
    switch ($map->position) {
      case "relative":
      case "static":
        if ($params["MODE"] != 'lg')
          $this->output .= '</div>'."\n";
    }
    unset($map->layer_params["class"]);
    if ($params["MODE"] != "lg") {
      if (($map->point_layer != '') || ($map->select_content != '')) $map->WritePointLayer();
      if (IsN() && (BrowserVersion() == 4)) {
        $map->output .= '</layer>'."\n";
      } else {
        $map->output .=  '</div>'."\n";
        $map->output .=  '</div>'."\n";
        $map->output .=  '</div>'."\n";
      }
      if ($map->scale) $map->WriteScaleBar();
    } else {
    }

    $output .= $map->output;
    if ($GLOBALS["MapVars"]["cl_print_map_scale"] && $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["print_scale"]) {
      $output .= "<div style='width:300px'>".$GLOBALS["RESOURCE_STRING"]["panel_scale"]." 1:".$GLOBALS["MapVars"]["cl_print_map_scale"]."</div>";
    }

    return $output;
  }

}

class CL_MapOverview extends CL_Base {

  function CL_MapOverview($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["overview"]) {
      $file_ov_schema = FileUp2(".admin/overview_schema.inc");
      if ($file_ov_schema) include($file_ov_schema);
      else ErrorMsg(array("msg"=>"No file overview_schema.inc"));
      $map_overview = "";

      //object caption
      switch ($this->properties["caption"]["type"]) {
        case 'none':
        break;
        case 'function':
          if (function_exists($this->properties["caption"]["function"])) {
            $map_overview = $this->properties["caption"]["function"]();
          }
        break;
        case 'auto':
        case 'text':
        default:
          $caption = $this->properties["caption"]['text']?$this->properties["caption"]['text']:$GLOBALS["RESOURCE_STRING"]["caption_overview"];
          $class = $this->properties["caption"]['class']?$this->properties["caption"]['class']:'boxd_nadpis';
          $map_overview = '<table cellpadding="0" cellspacing="0" width="100%"><tr>'."\n";
          $map_overview .= "<td class='".$class."'>".$caption."</td>\n";
          $map_overview .= "</tr></table>\n";
        break;
      }


      //object

      $bbox = $this->parameters["map_properties"]["bbox"];
      list($ov_minx,$ov_miny,$ov_maxx,$ov_maxy) = explode(",",$bbox);
      reset($MAP_OVERVIEW);
      while (list($key, $val) = each($MAP_OVERVIEW)){
        list($minx_t,$miny_t,$maxx_t,$maxy_t) = explode(",",$val["extent"]);
        if (($minx_t<=$ov_minx) && ($miny_t<=$ov_miny) && ($maxx_t>=$ov_maxx) && ($maxy_t>=$ov_maxy)) {
          $change["status"] = true;
          $change["name"]=$val["name"];
          break;
        }
      }
      if ($change["status"]) $new_ov = $change["name"];
      else $new_ov = "default";

      if ($MAP_OVERVIEW[$new_ov]["extent"]) {
        if (Is_Array($MAP_OVERVIEW[$new_ov]["extent"])) {
          $ov_bbox = array($MAP_OVERVIEW[$new_ov]["extent"]["minx"], $MAP_OVERVIEW[$new_ov]["extent"]["miny"], $MAP_OVERVIEW[$new_ov]["extent"]["maxx"], $MAP_OVERVIEW[$new_ov]["extent"]["maxy"]);
        } else {
          $ov_bbox = Explode(",", $MAP_OVERVIEW[$new_ov]["extent"]);
        }
      } else {
        $ov_bbox = $this->main_client->map["first_extent"];
      }

      $map_overview .= '<script language="JavaScript" type="text/javascript">'."\n";
      $map_overview .= "<!--\n";
      $map_overview .= 'map.ov.minx='.$ov_bbox[0].";\n";
      $map_overview .= 'map.ov.miny='.$ov_bbox[1].";\n";
      $map_overview .= 'map.ov.maxx='.$ov_bbox[2].";\n";
      $map_overview .= 'map.ov.maxy='.$ov_bbox[3].";\n";
      $map_overview .= "ChangeRatio(map.ov);\n";
      $map_overview .= "//-->\n";
      $map_overview .= "</script>\n";
      switch ($MAP_OVERVIEW[$new_ov]["method"]) {
        case "image":
          $ov_img = $MAP_OVERVIEW[$new_ov]["image"];
        case "url":
          if ($MAP_OVERVIEW[$new_ov]["method"] == "url") $ov_img = $MAP_OVERVIEW[$new_ov]["url"];
          $connection = $this->parameters["map_properties"]["connection"];
          //include_once($GLOBALS["TMAPY_TMS"]."/.admin/connector/project/$connection.inc");
          if(!File_Exists($GLOBALS["TMAPY_TMS"]."/.admin/connector/project/$connection.inc"))
            include_once($GLOBALS["TMAPY_TMS"]."/.admin/connector/project/wizard/$connection.inc");
          else
            include_once($GLOBALS["TMAPY_TMS"]."/.admin/connector/project/$connection.inc");
          if(!isset($CONNECTOR["dir"])) $CONNECTOR["dir"]=$GLOBALS["manager"]->project[$GLOBALS["MAP_PROJECT"]["name"]]["dir"];

          $netscape = IsN() && (BrowserVersion() == 4);

          $position = $this->properties["position"]?$this->properties["position"]:"absolute";
          switch ($position) {
            case "relative":
              $envelope_style = "position:relative";
            break;
            case "static":
              $envelope_style = "position:static";
            break;
            case "absolute":
            default:
              $envelope_style = "position:absolute;left:".$this->properties["left"]."px;top:".$this->properties["top"]."px";
            break;
          }
          $envelope_style .= ";width:".$this->properties["width"].";height:".$this->properties["height"];
          $map_overview .= '<div id="OVLayers_Envelope" style="'.$envelope_style.'">'."\n";
          switch ($position) {
            case "relative":
            case "static":
              $map_overview .= '<div id="OVLayers_Over" style="position:absolute;z-index:99">'."\n";
            break;
          }

          $params["MAP"] = $this->parameters["map_properties"]["connection"];
          $params["BBOX"] = $this->parameters["map_properties"]["bbox"];
          $params["WIDTH"] = $this->properties["width"];
          $params["HEIGHT"] = $this->properties["height"];
          $params["MODE"] = $this->properties["mode"]?$this->properties["mode"]:"map";
          $params["client_lang"] = $GLOBALS["client_lang"]?$GLOBALS["client_lang"]:"cz_win";

          require_once(FileUp2(".admin/main_mint_tms12.inc"));
          $interface = new Map_TMS12_Interface($params);
          require_once(FileUp2(".admin/map_html.inc"));
          @$map = new HTML_MAP($interface);
          $map->position = $position;
          if (!Is_Object($map)) die("Bad format of map: ".$interface->parameters["format"]);
          $map->cache_output = true;
          $map->WriteZoomLayer("OV");
          $map_overview .= $map->output;

          switch ($position) {
            case "relative":
            case "static":
              $map_overview .= '</div>'."\n";
            break;
          }

          if ($netscape)
            $map_overview .= '<layer name=OVLayers width=' .$this->properties["width"] .' height=' .$this->properties["height"] .' visibility="show" Z-INDEX=1>'."\n";
          else {
            $map_overview .= "<div id=\"OVLayers\" ".($this->properties["class"]?"class=\"".$this->properties["class"]."\" ":"")."style=\";overflow:hidden;z-index:1;\">\n";
          }

          $map_overview .= "  <img name='src_ov' border=0 width=".$this->properties["width"]." height=".$this->properties["height"]." src='$ov_img'>\n";

          if ($netscape)
            $map_overview .= '</layer>'."\n";
          else
            $map_overview .= "</div>\n";

          if ($position != "absolute") {
            $map_overview .= '</div>'."\n";
          }


          break;
        case "dynamic":
          $params = $this->parameters;
          $this->properties["mode"] = "ov";
          $params["map_properties"]["bbox"] = Implode(",", $ov_bbox);
          $params["map_properties"]["ulayers"] = $this->properties["ulayers"]?$this->properties["ulayers"]:$this->parameters["map_properties"]["ulayers"];
          $mapimage = new CL_MapImage($this->properties, $params, &$this->main_client);
          $map_overview .= $mapimage->SetHTMLOutput();
          break;
      }
    }
    return $map_overview;
  }

}

class CL_MapZoom extends CL_Base {

  function CL_MapZoom($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    return $this->properties["text"];
  }

}

class CL_ZoomBar extends CL_Text {

  function CL_ZoomBar($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);
    $zoomobj = "";
    $zoombar = "\n<script type=\"text/javascript\">\n";

    if ($this->properties["zoombar"] || $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["zoom_bar"]) {
      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["zoom_bar"]) $panel_zoombar = $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["zoom_bar"];
      $zoombar .= "zoom=new Array();\n";
      $zoombar .= "zoom.length=".($this->properties["zoombar"]?Count($this->properties["zoombar"]):Count($panel_zoombar["zoom_array"])).";\n";

      $this->properties["units_type"] = ($this->properties["units_type"]?$this->properties["units_type"]:($panel_zoombar["units_type"]?$panel_zoombar["units_type"]:"scale"));
      $zoombar .= "zoom.type='".$this->properties["units_type"]."';\n";


      if($this->properties["zoombar"]) $obj_zoombar = $this->properties["zoombar"];
      elseif($panel_zoombar["zoom_array"]) $obj_zoombar = $panel_zoombar["zoom_array"];

      reset($obj_zoombar);
      while (list($i, $zoom) = each($obj_zoombar)) {
        $i += 1;
        if ($this->properties["units_type"] == 'pixel')
          $zoombar .= "zoom[$i]=".$zoom["pixel"].";\n";
        else
          $zoombar .= "zoom[$i]=".$zoom["scale"].";\n";
        $zoombar .= "SetImg('"."zoom_$i"."','".FileUpURL("images/".$zoom["img"])."','".FileUpURL("images/".$zoom["img2"])."');\n";
  	  }

      $position = ($this->properties["zoombar"]["position"]?$this->properties["zoombar"]["position"]:($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["zoom_bar"]["position"]?$GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["zoom_bar"]["position"]:''));
      $direction = ($this->properties["zoombar"]["direction"]?$this->properties["zoombar"]["direction"]:($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["zoom_bar"]["direction"]?$GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["zoom_bar"]["direction"]:''));
      if($position=="relative") {
        $zoomobj .= "<table class='obj_zoombar' cellpadding='0' cellspacing='0'><tr>\n";

        if($GLOBALS["MAP_PROJECT"]["status_bar"]["alt"]) $status = "onmouseover=\"window.status='".$GLOBALS["RESOURCE_STRING"]["zoom_pin_out"]."';return true;\" onmouseout=\"window.status='';return true;\"";
        else $status = "";

        $zoomobj .= "<td class='obj_zoombar_inout'><a href=\"javascript:if (zoom.index>1) {ZoomBarOnMouseDown(window); ChangeZoom(zoom.index-1);}\" $status><img src='".FileUpUrl("images/zoombar/zoom_pin_out.gif")."' alt='".$GLOBALS["RESOURCE_STRING"]["zoom_pin_out"]."' border='0'></a></td>\n";
        if (($position=="relative") && ($direction=="vertical")) $zoomobj .= "</tr>\n";

      }

      reset($obj_zoombar);
      while (list($i, $zoom) = each($obj_zoombar)) {

        $i += 1;
        $left = $zoom["left"]?$zoom["left"]:0;
        $top = $zoom["top"]?$zoom["top"]:0;

        if($position=="relative") {
          if($direction=="vertical") $zoomobj .= "<tr>\n";
          $zoomobj .= "<td class='obj_zoombar'>";
        } else $zoomobj .= "<div style=\"position:absolute;left:$left;top:$top;\">\n";

        if($GLOBALS["MAP_PROJECT"]["status_bar"]["alt"]) $status = "onmouseover=\"window.status='".$zoom["alt"]."';return true;\" onmouseout=\"window.status='';return true;\"";
        else $status = "";

        $zoomobj .= "<a href='javascript:";
        $alt = $zoom["alt"]?$zoom["alt"]:"1:".$zoom["scale"];
        if($zoom["full_extent"]) {
          $zoomobj .= "FullExtent();' $status>";
        } else {
          if ($zoom["centered"]) {
            $zoomobj .= "c=map.cur; c.minx=map.minx; c.miny=map.miny; c.maxx=map.maxx; c.maxy=map.maxy;";
          }
          $zoomobj .= "ChangeZoom($i)' $status>";
        }
        $zoomobj .= "<img src='".FileUpURL("images/".$zoom["img"])."' alt='$alt' title='$alt' name='zoom_$i' border='0'";
        if ($this->properties["onmousedown"] || $panel_zoombar["onmousedown"]) {
          $zoomobj .= " onmousedown='".($this->properties["onmousedown"]?$this->properties["onmousedown"]:$panel_zoombar["onmousedown"])."'";
        }
        $zoomobj .= "></a>";
        if($position=="relative") {
          $zoomobj .= "</td>\n";
          if($direction=="vertical") $zoomobj .= "</tr>\n";
        } else $zoomobj .= "</div>\n";
  	  }
      if($position=="relative") {

        if($GLOBALS["MAP_PROJECT"]["status_bar"]["alt"]) $status = "onmouseover=\"window.status='".$GLOBALS["RESOURCE_STRING"]["zoom_pin_in"]."';return true;\" onmouseout=\"window.status='';return true;\"";
        else $status = "";

        if (($position=="relative") && ($direction=="vertical")) $zoomobj .= "<tr>\n";
        $zoomobj .= "<td class='obj_zoombar_inout'><a href=\"javascript:if (zoom.index<(zoom.length-1)) {ZoomBarOnMouseDown(window); ChangeZoom(zoom.index+1);}\" $status><img src='".FileUpURL("images/zoombar/zoom_pin_in.gif")."' alt='".$GLOBALS["RESOURCE_STRING"]["zoom_pin_in"]."' border='0'></a></td>\n";

        $zoomobj .= "</tr></table>\n";
      }
    } else $zoombar .= "zoom=false;\n";
    $zoombar .= "</script>\n";
    $zoombar .= $zoomobj;
    $zoombar .= "\n<script type=\"text/javascript\">\n";
    $zoombar .= "InitZoomIndex();\n";
    $zoombar .= "</script>\n";
    $this->properties["text"] = $zoombar;
  }

}

class CL_ZoomBarLevel extends CL_TextPosition {

  function CL_ZoomBarLevel($prop,$params,&$main_client) {
    $this->CL_TextPosition($prop,$params,&$main_client);
    $imsize = getimagesize(FileUpURL($this->properties["background"]));
    $zb  = '<div style="width:'.$imsize[0].';height:'.$imsize[1].'">'."\n";
    $zb  = '<div style="position:absolute">'."\n";
    $zb .= '<img src="'.FileUpURL($this->properties["background"]).'" style="position:absolute;width:'.$imsize[0].';height:'.$imsize[1].'">'."\n";
    if ($this->properties["levels"]) {

    }
    $zb .= '</div>'."\n";
    $zb .= '</div>'."\n";
    $this->properties["text"] = $zb;
  }

}

class CL_MapNavigation extends CL_Base {

  function CL_MapNavigation($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    $left = $this->properties["left"];
    $top = $this->properties["top"];
    $width = $this->properties["width"];
    $height = $this->properties["height"];
    $class = $this->properties["class"]?$this->properties["class"]:"abs";
    $size = $this->properties["size"]?$this->properties["size"]:10;
    $corner = $this->properties["corner_size"]?$this->properties["corner_size"]:$size*5;
    $corner_space = $corner+($this->properties["corner_space"]?$this->properties["corner_space"]:0);

    $res =

      $this->GetMapNavDiv($left-$size,$top-$size,$corner,$corner,"PanLeftUp","arrows_ul").
      $this->GetMapNavDiv($left+$width-$corner+$size,$top-$size,$corner,$corner,"PanRightUp","arrows_ur").
      $this->GetMapNavDiv($left+$width-$corner+$size,$top+$height-$corner+$size,$corner,$corner,"PanRightDown","arrows_dr").
      $this->GetMapNavDiv($left-$size,$top+$height-$corner+$size,$corner,$corner,"PanLeftDown","arrows_dl").

      $this->GetMapNavDiv($left-$size,$top+$corner_space-$size,$size,$height-2*($corner_space-$size),"PanLeft","arrows_l").
      $this->GetMapNavDiv($left+$corner_space-$size,$top-$size,$width-2*($corner_space-$size),$size,"PanUp","arrows_u").
      $this->GetMapNavDiv($left+$width,$top+$corner_space-$size,$size,$height-2*($corner_space-$size),"PanRight","arrows_r").
      $this->GetMapNavDiv($left+$corner_space-$size,$top+$height,$width-2*($corner_space-$size),$size,"PanDown","arrows_d")."\n".

      '<div class="'.$class.'" style="background-color:white;left:'.$left.';top:'.$top.';height:'.$height.';width:'.$width.'"></div>'."\n";

     return $res;
  }

  function GetMapNavDiv($x, $y, $width, $height, $action, $class) {
    $style = "left:".$x."px;top:".$y."px;width:".$width."px;height:".$height."px";
    $res = "\n".'<a href="javascript:'.$action.'();" class="'.$class.'" style="'.$style.'"></a>';
    return $res;
  }

}

class CL_MapLegend extends CL_Base {

  function CL_MapLegend($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
      $this->properties["mode"] = "lg";
      $params = $this->parameters;
      $params["map_properties"]["ulayers"] = $this->properties["ulayers"]?$this->properties["ulayers"]:$this->parameters["map_properties"]["ulayers"];
      $prop = $this->properties;
      $prop["width"] = $prop["map_width"];
      $prop["height"] = $prop["map_height"];
      $mapimage = new CL_MapImage($prop, $params, &$this->main_client);
      $map_legend .= $this->properties["caption"]?$this->properties["caption"]:"";
      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["legend"]) {
        if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["legend"] && $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["function_bar"]["function_array"]["legend"]["source"]=="file") {
          $map_legend .= "<img src='".$GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["function_bar"]["function_array"]["legend"]["source_file"]."' alt=''>\n";
        } else {
          $map_legend .= $mapimage->SetHTMLOutput();
        }
        $map_legend .= "\n";
      }

      return $map_legend;
  }
}

class CL_Select extends CL_TextPosition {

  function CL_Select($prop,$params,&$main_client) {
    $this->CL_TextPosition($prop,$params,&$main_client);

    $selvalue = $this->properties["select_value"]?$this->properties["select_value"]:$GLOBALS[$this->properties["select_name"]];

    $text = "\n";
    $text .= $this->properties["text_header"]."\n";
    $text .= "<select name=\"".$this->properties["select_name"]."\" ";
    if ($this->properties["select_class"]) {
      $text .= ' class="'.$this->properties["select_class"].'"';
    }
    if ($this->properties["select_width"]) {
      $text .= ' style="width:'.$this->properties["select_width"].'"';
    }
    $text .= $this->properties["select_append"].">\n";
    if (!$this->properties["select_options"]) $this->properties["select_options"] = array();
    reset($this->properties["select_options"]);
    while (list($i, $opt) = each($this->properties["select_options"])) {
      $i += 1;
      if (Is_array($opt)) {
        $value = $opt["value"]?$opt["value"]:$i;
        $caption = $opt["caption"]?$opt["caption"]:$i;
      } else {
        $value = $i;
        $caption = $opt;
      }
      $text .= "<option ";
      $text .= $selvalue==$value?"selected ":"";
      $text .= "value=\"$value\">$caption</option>\n";
	  }
    $text .= "</select>\n";
    $text .= $this->properties["text_footer"]."\n";
    $this->properties["text"] = $text;
  }
}

class CL_DivScaleBar extends CL_Base {

  function CL_DivScaleBar($prop,$params,&$main_client) {
    $this->CL_Base($prop,$params,&$main_client);
  }

  function SetHTMLOutput() {
    $w = $this->parameters["map_properties"]["width"];
    $bbox = $this->parameters["map_properties"]["bbox"];
    $dx = $bbox["maxx"]-$bbox["minx"];
    $len = Round($this->properties["width"]/$w*$dx);
    if ($len < 10) {
      $len = $len;
    } elseif ($len < 100) {
      $len = Floor($len/10)*10;
    } elseif ($len < 1000) {
      $len = Floor($len/100)*100;
    } else {
      $len = Floor($len/1000)*1000;
    }
    $width = $len/$dx*$w;
    $res  = '<table><tr><td valign="middle">';
    $res .= '<table cellspacing="0" cellpadding="0" style="width:'.$width.'px;height:'.$this->properties["height"].';';
    $res .= 'border-style:solid;border-top-style:none;';
    $res .= 'border-color:'.($this->properties["color"]?$this->properties["color"].";":"black;");
    $res .= 'border-width:1px;border-bottom-width:2px;';
    $res .= '"><tr><td colspan="2"><span style="font-size:1px">&nbsp;</span></td></tr><tr><td width="50%" style="';
    $res .= 'border-right-style:solid;';
    $res .= 'border-color:'.($this->properties["color"]?$this->properties["color"].";":"black;");
    $res .= 'border-width:1px;';
    $res .= 'margin-top:10px;';
    $res .= '"><span style="font-size:1px">&nbsp;</span></td>';
    $res .= '<td width="50%" style="';
    $res .= 'border-left-style:solid;';
    $res .= 'border-color:'.($this->properties["color"]?$this->properties["color"].";":"black;");
    $res .= 'border-width:1px;';
    $res .= 'margin-top:10px;';
    $res .= '"><span style="font-size:1px">&nbsp;</span></td>';
    $res .= '</tr></table>';
    $res .= '</td><td style="padding-left:5px;color:'.($this->properties["color"]?$this->properties["color"]:"black").'">';
    if ($len >= 1000)
      $res .= ($len/1000)."&nbsp;km";
    else
      $res .= $len."&nbsp;m";
    $res .= '</td></tr></table>';
    $res .= "</div>\n";
    return $res;
  }
}

class CL_LayerBar extends CL_Text {

  function CL_LayerBar($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);
    if ($this->properties["layerbar"] || $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["layer_bar"]["layer_array"]) {

    	$pixel = ($this->parameters["map_properties"]["bbox"]["maxx"]-$this->parameters["map_properties"]["bbox"]["minx"])/$this->parameters["map_properties"]["width"];

      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["layer_bar"]) $panel_layerbar = $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["layer_bar"]["layer_array"];

      if($this->properties["layerbar"]["layer_array"]) $obj_layerbar = $this->properties["layerbar"]["layer_array"];
      else $obj_layerbar = $panel_layerbar;

      reset($obj_layerbar);

      //object caption
      switch ($prop["caption"]["type"]) {
        case 'none':
        break;
        case 'function':
          if (function_exists($prop["caption"]["function"])) {
            $layerobj = $prop["caption"]["function"]();
          }
        break;
        case 'auto':
        case 'text':
        default:
          $caption = $prop["caption"]['text']?$prop["caption"]['text']:$GLOBALS["RESOURCE_STRING"]["caption_layer_bar"];
          $class = $prop["caption"]['class']?$prop["caption"]['class']:'boxd_nadpis';
          $layerobj = '<table cellpadding="0" cellspacing="0" width="100%"><tr>'."\n";
          $layerobj .= "<td class='".$class."'>".$caption."</td>\n";
          $layerobj .= "</tr></table>\n";
        break;
      }

      //object
      $l_h = $GLOBALS["HEIGHT"];
      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["layer_bar"]["deduct_height"]) $l_h -= $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["layer_bar"]["deduct_height"];
      else {
        if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["overview"]) if($GLOBALS["CLIENT_OBJECT"]["MapOverview"]["height"]) $l_h -= ($GLOBALS["CLIENT_OBJECT"]["MapOverview"]["height"]+20);
        if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]) $l_h -= 55;
      }

      $layerobj .= "<div style='overflow-y:auto;height:".abs($l_h)."px'><table class=\"layer_bar\" width=\"100%\">\n"; //overflow: -moz-scrollbars-vertical;

      $ulayers='';
      reset($obj_layerbar);
      while (list($i, $layer) = each($obj_layerbar)) {
        if(!$layer["hidden"]) {
          if($layer["minpixel"] && $layer["maxpixel"]) {
            if(($pixel>=$layer["minpixel"]) && ($pixel<=$layer["maxpixel"])) $visible_layer = true;
            else $visible_layer = false;
          }
          elseif ($layer["minpixel"] && !$layer["maxpixel"]) {
            if($pixel>=$layer["minpixel"]) $visible_layer = true;
            else $visible_layer = false;
          }
          elseif (!$layer["minpixel"] && $layer["maxpixel"]) {
            if($pixel<=$layer["maxpixel"]) $visible_layer = true;
            else $visible_layer = false;
          }
          else $visible_layer = true;
          if ((!$visible_layer && $layer["inactive_class"]) || $layer["visible"]=='false') $unvisible = true;
          else $unvisible = false;

          if($visible_layer || $unvisible) {

						//ArcGIS numeric layer name - HACK !!!
						if(is_numeric($layer["name"])) $lnlb = "__".$layer["name"];
						else $lnlb = $layer["name"];
						//die(print_r($GLOBALS["MapVars"]));

            $layerobj .= "<tr>";

            $layerobj_tx = "<td ".($layer["image"]?"":"colspan='2'").($unvisible?" class=\"".$layer["inactive_class"]."\"":($layer["class"]?" class=\"".$layer["class"]."\"":"")).">".$layer["title"]."</td>";
            if($layer["image"]) $layerobj_tx .= "<td><img src=\"".FileUp2($layer["image"])."\" alt=\"\"></td>";

            $layerobj_ch = "<td".($layer["class"]?" class=\"".$layer["class"]."\"":"")."><input type='checkbox' name='".$layer["name"]."' id='".$layer["name"]."'";
//die(print_r($GLOBALS["MapVars"]));
						$layerobj_ch .= ($GLOBALS["MapVars"][$lnlb]=='true'?' checked':'');

            if ($layer["function"]) $layerobj_ch .= " onclick='".$layer["function"]."'";
            else $layerobj_ch .= " onclick='SetHTMLLayerVisible(\"".$layer["name"]."\", this.checked)'";

            $layerobj_ch .= ($unvisible?" disabled":"")."></td>\n";

            if($layer["label"]) {
              $layerobj .= "<td ".($layer["image"]?"colspan='2'":"colspan='3'")." style='padding:3px;' ".($unvisible?"class=".$layer["inactive_class"]:($layer["class"]?"class=".$layer["class"]:"")).">".$layer["title"]."</td>";
              if($layer["image"]) $layerobj .= "<td><img src=\"".FileUp2($layer["image"])."\" alt=\"\"></td>";
            }
            else {
              if($prop["checkbox_first"]) $layerobj .= $layerobj_ch.$layerobj_tx;
              else $layerobj .= $layerobj_tx.$layerobj_ch;
            }

            $layerobj .= "</tr>\n";
          }
        }
  	  }
      $layerobj .= "</table></div>\n";
    }
    $this->properties["text"] = $layerobj;
  }
}

class CL_JSettings extends CL_TextPosition {

  function CL_JSettings($prop,$params,&$main_client) {
    $this->CL_TextPosition($prop,$params,&$main_client);

    $js_settings .= '<script language="JavaScript" type="text/javascript">'."\n";
    $js_settings .= "<!--\n";
    $js_settings .= "var mobj = new Object();\n";

    foreach ($GLOBALS["MapVars"] as $key=>$value) {
      if($key) {

				//ArcGis HACK - numeric layer names -> string
        if(is_numeric($key)) $key = "__".$key;

        if ($value) {
          if (Is_Array($value)&&($key=='layers')) {
            $val_aux = '';
            foreach ($value as $key2=>$value2) {
              if ($val_aux) $val_aux .= ",";
              $val_aux .= $key2;
            }
            $value = "'$val_aux'";
          }
          else $value = Is_String($value)?"'".$value."'":$value;
          $js_settings .= "mobj.".$key."=".$value.";\n";
          $mobjprop .= ($mobjprop?",":"")."'$key'";
        }
        else $js_settings .= "mobj.".$key."='';\n";
      }
    }
    $js_settings .= "var mobjprop = new Array(".$mobjprop.");\n";

    $js_settings .= "InitHeader();\n";

    if($GLOBALS["CLIENT"]["default_state"] || $GLOBALS["CLIENT"]["map_properties"]["def_panel_state"]) $js_settings .= "window.panel.state=\"".($GLOBALS["CLIENT"]["default_state"]?$GLOBALS["CLIENT"]["default_state"]:$GLOBALS["CLIENT"]["map_properties"]["def_panel_state"])."\";\n";
    if($GLOBALS["CLIENT"]["default_ctrl"] || $GLOBALS["CLIENT"]["map_properties"]["def_panel_ctrl"]) $js_settings .= "window.panel.default_ctrl=\"".($GLOBALS["CLIENT"]["default_ctrl"]?$GLOBALS["CLIENT"]["default_ctrl"]:$GLOBALS["CLIENT"]["map_properties"]["def_panel_ctrl"])."\";\n";
    else $js_settings .= "window.panel.default_ctrl=false;\n";
    $js_settings .= "window.panel.support_rightButton=".($GLOBALS["CLIENT"]["map_properties"]["def_support_rightButton"]?"true":"false").";\n";
    $js_settings .= "window.panel.support_middleButton=".($GLOBALS["CLIENT"]["map_properties"]["def_support_middleButton"]?"true":"false").";\n";
    $js_settings .= "window.panel.support_wheelButton=".($GLOBALS["CLIENT"]["map_properties"]["def_support_wheelButton"]?"true":"false").";\n";

    $js_settings .= "//-->\n";
    $js_settings .= "</script>\n";

    $this->properties["text"] = $js_settings;
  }
}

class CL_Info extends CL_TextPosition {
  //konverze z IL2 do WIN-1250
  function TransformIsoLatin2($str) {
    return StrTr($str,"","");
  }
  //konverze z WIN-1250 do IL2
  function TransformWin1250($str) {
    return StrTr($str,"","");
  }

  function CL_Info($prop,$params,&$main_client) {
    $this->CL_TextPosition($prop,$params,&$main_client);


    function GetInfoDataByXY ($X, $Y) {
      static $manager;
      include_once(FileUp2(".admin/main_hotlink.inc"));

      if (!$manager) {
        include_once(Fileup2(".admin/manager.inc"));
        $manager = new Manager();
      }

      $params["properties"] = $GLOBALS["MAP_INFO"];
      $params['x']=Round($X);
      $params['y']=Round($Y);
      $params['bbox']=$GLOBALS["BBOX"]["minx"].",".$GLOBALS["BBOX"]["miny"].",".$GLOBALS["BBOX"]["maxx"].",".$GLOBALS["BBOX"]["maxy"];
      $params['width']=$GLOBALS['WIDTH'];
      $params['height']=$GLOBALS['HEIGHT'];

      $res = array();

      if($params['properties']) {

        foreach ($params['properties'] as $key=>$val) $layers.=($layers?",".$key:$key);
        $params['layers']=$layers;

        $params['manager']=&$manager;

        $hotlink = new Hotlink($params);
        $result = $hotlink->GetResultLayers();

        $res = array();
        $i=0;
        $j=0;
        foreach ($params['properties'] as $key=>$val) {
          $res[$key] = $result[$i++]->output['data'];
          $res[$key."_extra"] = $result[$j++]->output['extra_data'];
        }
      }
      return $res;
    }
    if ($GLOBALS["MapVars"]["X"] && $GLOBALS["MapVars"]["Y"] && $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["info"] && (($GLOBALS["MapVars"]["panel_state"]=='info') || $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["info_forever"])) {

      $no_data = true;

      $data = GetInfoDataByXY ($GLOBALS["MapVars"]["X"], $GLOBALS["MapVars"]["Y"]);

      //Info OBJECT PLUGIN - define
      $PluginFile = FileUp2(".admin/client_objects/plugins/Info_plugin.inc");
      if ($PluginFile) {
        require_once($PluginFile);
        $GLOBALS["INFO_PLUGIN_BEFORE"] = MapAccessArray($INFO_PLUGIN_BEFORE);
        $GLOBALS["INFO_PLUGIN_AFTER"] = MapAccessArray($INFO_PLUGIN_AFTER);
      }

      $res = '';

      //object caption
      switch ($prop["caption"]["type"]) {
        case 'none':
        break;
        case 'function':
          if (function_exists($prop["caption"]["function"])) {
            $res .= $prop["caption"]["function"]();
          }
        break;
        case 'auto':
        case 'text':
        default:
          $caption = $prop["caption"]['text']?$prop["caption"]['text']:$GLOBALS["RESOURCE_STRING"]["caption_informations"];
          $class = $prop["caption"]['class']?$prop["caption"]['class']:'boxd_nadpis';
          $res .= '<table cellpadding="0" cellspacing="0" width="100%"><tr>'."\n";
          $res .= "<td class='".$class."'>".$caption."</td>\n";
          $res .= "</tr></table>\n";
        break;
      }
      //print_r($data);

      if ($GLOBALS["MAP_INFO_PROPERTIES"]["height"]) $i_h = $GLOBALS["MAP_INFO_PROPERTIES"]["height"];
      else {
        $i_h = $GLOBALS["HEIGHT"];
        if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["search_box"]) $i_h -= 60;
      }
      if ($GLOBALS["MAP_INFO_PROPERTIES"]["deduct_height"]) $i_h -= $GLOBALS["MAP_INFO_PROPERTIES"]["deduct_height"];
//      $res .= "<div style='overflow-y:scroll;overflow: -moz-scrollbars-vertical;height:".abs($i_h)."px'>\n";
      $res .= "<div style='overflow-y:auto;height:".abs($i_h)."px'>\n";

      //Info OBJECT PLUGIN BEFORE
      if($GLOBALS["INFO_PLUGIN_BEFORE"]) $res .= $GLOBALS["INFO_PLUGIN_BEFORE"];

      if($GLOBALS["MAP_INFO"]) {
        foreach($GLOBALS["MAP_INFO"] as $key=>$val) {

          if($data[$key]) {
            $no_data = false;
            $res .= '<div class="info_text"><table width="90%" class="info_html" cellspacing="0">';
            $res .= '<tr class="brow_html"><th class="info_html" colspan="2">'.$GLOBALS["MAP_INFO"][$key]["caption"].'</th></tr>';
            if($GLOBALS["MAP_INFO"][$key]["description"]) $res .= '<tr class="brow_html"><td class="info_html_description" colspan="2">'.$GLOBALS["MAP_INFO"][$key]["description"].'</td></tr></table>';
            else $res .= '</table>';
            for($i=0;$i<count($data[$key]);$i++) {
              $nadpis = array_keys($GLOBALS["MAP_INFO"][$key]["table"]["schema"]);
              if((count($data[$key])>1 || count($GLOBALS["MAP_INFO"][$key]["table"]["schema"])>1) && $GLOBALS["MAP_INFO"][$key]["tree"]) {
                $res .= "<div id=\"nadpis_".$GLOBALS["MAP_INFO"][$key]["table"]["name"]."_".$i."\">";
                $res .= "<img class=\"img_odkaz\" id=\"img_".$GLOBALS["MAP_INFO"][$key]["table"]["name"]."_".$i."\" width=\"16\" height=\"16\" src=\"".FileUpURL("images/toc_tree/tree_expand.gif")."\" onClick=\"FolderCollapse('".$GLOBALS["MAP_INFO"][$key]["table"]["name"]."_".$i."')\">";
                //AKTIVNI NADPIS ROZBALOVACIHO VYSLEDKU VYHLEDAVANI NASTROJEM INFO
                if(is_array($GLOBALS["MAP_INFO"][$key]["table"]["link"])) {
                  $url="";
                  $class=$GLOBALS["MAP_INFO"][$key]["table"]["link"][$nadpis[0]]["class"];
                  $link = $GLOBALS["MAP_INFO"][$key]["table"]["link"][$nadpis[0]]["href"];
                  $caption = $GLOBALS["MAP_INFO"][$key]["table"]["link"][$nadpis[0]]["caption"];
                  $target = $GLOBALS["MAP_INFO"][$key]["table"]["link"][$nadpis[0]]["target"];
                  while (EReg("^(.*)<fl>([^<]*)</fl>(.*)$",$link,$res_link)) {
                    $link = $res_link[1];
                    $value = $data[$key][$i][StrToUpper($res_link[2])];
                    $url = $res_link[1].urlencode($value).$res_link[3];
                  }
                  $res .= "<a ".($class?'class="'.$class.'"':'')." href=\"".($url?$url:$link)."\" ".($target?'target="'.$target.'"':'').">".($caption?$caption:$data[$key][$i][$nadpis[0]]).'</a></div>';
                }

                else $res .= $data[$key][$i][$nadpis[0]].'</div>';
                $res .= '<div id="'.$GLOBALS["MAP_INFO"][$key]["table"]["name"].'_'.$i.'" style="position: relative; display: none;">';
              }
              else $res .= '<div></div><div id="'.$GLOBALS["MAP_INFO"][$key]["table"]["name"].'_$i" style="display: block;">';
              $res .= '<table width="90%" class="info_html" cellspacing="0">';

              if(count($data[$key])>1 && count($GLOBALS["MAP_INFO"][$key]["table"]["schema"])>1 && !$GLOBALS["MAP_INFO"][$key]["tree"] && $i!=0) $res .= '<tr><td>&nbsp;</td></tr>';
              $count_schema=0;
              $union_field = array();
              foreach($GLOBALS["MAP_INFO"][$key]["table"]["schema"] as $ch_key => $val_key) {
                if (($GLOBALS["MAP_INFO"][$key]["table"]["show_only_values"] && $data[$key][$i][$ch_key]) || !$GLOBALS["MAP_INFO"][$key]["table"]["show_only_values"]) {
                  switch($GLOBALS["MAP_INFO"][$key]["table"]["lang_translate"]) {
                    case "il2_win":
                      $data[$key][$i][$ch_key] = $this->TransformIsoLatin2($data[$key][$i][$ch_key]);
                      break;
                    case "win_il2":
                      $data[$key][$i][$ch_key] = $this->TransformWin1250($data[$key][$i][$ch_key]);
                      break;
                  }
                  $is_union = false;
                  if($GLOBALS["MAP_INFO"][$key]["table"]["union_field"]) {
                    if(is_array($GLOBALS["MAP_INFO"][$key]["table"]["union_field"])) {
                      if(is_array($GLOBALS["MAP_INFO"][$key]["table"]["union_field"]["unions"])) {
                        foreach($GLOBALS["MAP_INFO"][$key]["table"]["union_field"]["unions"] as $u_key=>$u_val) {
                          $union_fields = array_flip($u_val);
                          if(isset($union_fields[$ch_key])) {
                            $is_union = true;
                            if($val_key!=" " && $val_key!="&nbsp;") $union_field[$u_key]["caption"] .= $val_key;
                            $union_field[$u_key]["value"] .= $data[$key][$i][$ch_key];
                          }
                        }
                      } else {
                        $union_fields = array_flip($GLOBALS["MAP_INFO"][$key]["table"]["union_field"]);
                        if(isset($union_fields[$ch_key])) {
                          $is_union = true;
                          if($val_key!=" " && $val_key!="&nbsp;") $union_field["caption"] .= $val_key;
                          $union_field["value"] .= $data[$key][$i][$ch_key];
                        }
                      }
                    }
                  }
                  if(!$is_union) {
                    if($GLOBALS["MAP_INFO"][$key]["table"]["hotlink"][$ch_key]) {
                      $l_name = $GLOBALS["MAP_INFO"][$key]["table"]["hotlink"][$ch_key];
                      //$link = explode("<fl>",$GLOBALS["MAP_LINK"][$l_name]["hotlink"]);
                      $link = $GLOBALS["MAP_LINK"][$l_name]["hotlink"];
                      while (EReg("^(.*)<fl>([^<]*)</fl>(.*)$",$link,$res_link)) {
                        $link = $res_link[1];
                        $value = $data[$key][$i][StrToUpper($res_link[2])];
                        $url = $res_link[1].$value.$res_link[3];
                      }
                      $active_text = $GLOBALS["MAP_LINK"][$l_name]["info"]["text"];
                      $target = ($GLOBALS["MAP_LINK"][$l_name]["output"]["name"]?$GLOBALS["MAP_LINK"][$l_name]["output"]["name"]:"_blank");
                      $res .= '  <tr class="brow_html"><td class="infoleft_html" width="50%">'.$val_key.'</td><td class="info_html" width="50%">';
                      if($data[$key][$i][$ch_key]) {
                        if($active_text) $res .= '<a class="info_a" target="'.$target.'" href="'.$url.'">'.$active_text.'</a>';
                        else {
                          if($data[$key][$i][$ch_key]=="-") $res .= '<i>'.$GLOBALS["RESOURCE_STRING"]["no_value"].'</i>';
                          elseif(strstr($data[$key][$i][$ch_key],"http://") || strstr($data[$key][$i][$ch_key],"https://")) {
                            switch($GLOBALS["MAP_INFO"][$key]["table"]["www"]) {
                              case "text": $res .= '<a class="info_a" target="'.$target.'" href="'.$url.'">'.$GLOBALS["RESOURCE_STRING"]["www_value"].'</a>';break;
                              case "value": $res .= '<a class="info_a" target="'.$target.'" href="'.$url.'">'.$link[0].$data[$key][$i][$ch_key].'</a>';break;
                              default: $res .= '<a class="info_a" target="'.$target.'" href="'.$url.'">'.$GLOBALS["MAP_INFO"][$key]["table"]["www"].'</a>';
                            }
                          }
                          else $res .= '<a class="info_a" target="'.$target.'" href="'.$url.'">'.$data[$key][$i][$ch_key].'</a>';
                        }
                      } else $res .= '<i>'.$GLOBALS["RESOURCE_STRING"]["no_value"].'</i>';
                      $res .= '</td></tr>';
                    }
                    else {
                      if(!(count($GLOBALS["MAP_INFO"][$key]["table"]["schema"])>1 && $GLOBALS["MAP_INFO"][$key]["tree"] && $count_schema==0)) {
                        $res .= '  <tr><td class="infoleft_html" width="50%">'.$val_key.'</td><td class="info_html" width="50%">';
                        if((strstr($data[$key][$i][$ch_key],"http://") || strstr($data[$key][$i][$ch_key],"https://"))) {
                          switch($GLOBALS["MAP_INFO"][$key]["table"]["www"]) {
                            case "text": $res .= '<a class="info_a" target="_blank" href="'.$data[$key][$i][$ch_key].'">'.$GLOBALS["RESOURCE_STRING"]["www_value"].'</a>';break;
                            case "value": $res .= '<a class="info_a" target="_blank" href="'.$data[$key][$i][$ch_key].'">'.$data[$key][$i][$ch_key].'</a>';break;
                            default: $res .= '<a class="info_a" target="_blank" href="'.$data[$key][$i][$ch_key].'">'.$GLOBALS["MAP_INFO"][$key]["table"]["www"].'</a>';
                          }
                        }
                        else {
                          //AKTIVNI NADPIS ROZBALOVACIHO VYSLEDKU VYHLEDAVANI NASTROJEM INFO
                          $link_res = false;
                          if(is_array($GLOBALS["MAP_INFO"][$key]["table"]["link"][$ch_key])) {
                            $url="";
                            $class=$GLOBALS["MAP_INFO"][$key]["table"]["link"][$ch_key]["class"];
                            $link = $GLOBALS["MAP_INFO"][$key]["table"]["link"][$ch_key]["href"];
                            $caption = $GLOBALS["MAP_INFO"][$key]["table"]["link"][$ch_key]["caption"];
                            $target = $GLOBALS["MAP_INFO"][$key]["table"]["link"][$ch_key]["target"];
                            while (EReg("^(.*)<fl>([^<]*)</fl>(.*)$",$link,$res_link)) {
                              $link = $res_link[1];
                              $value = $data[$key][$i][StrToUpper($res_link[2])];
                              $url = $res_link[1].$value.$res_link[3];
                            }
                            $link_res = "<a ".($class?'class="'.$class.'"':'')." href=\"".($url?$url:$link)."\" ".($target?'target="'.$target.'"':'').">".($caption?$caption:$data[$key][$i][$ch_key]).'</a>';
                          }
                          if($link_res) $res .= $link_res;
                          else $res .= ($data[$key][$i][$ch_key]?($data[$key][$i][$ch_key]=="-"?'<i>'.$GLOBALS["RESOURCE_STRING"]["no_value"].'</i>':$data[$key][$i][$ch_key]):'<i>'.$GLOBALS["RESOURCE_STRING"]["no_value"].'</i>');
                        }
                        $res .= '</td></tr>';
                      }
                    }
                  }
                  $count_schema++;
                }
              }

              if(is_array($union_field)) {
                if($union_field["value"]) {
                  $res .= '  <tr><td class="infoleft_html" width="50%">'.$union_field["caption"].'</td><td class="info_html" width="50%">'.($union_field["value"]?$union_field["value"]:"&nbsp;")."</td></tr>\n";
                } else {
                  foreach($union_field as $u_key=>$u_val) {
                    if($u_val["value"]) $res .= '  <tr><td class="infoleft_html" width="50%">'.$u_val["caption"].'</td><td class="info_html" width="50%">'.($u_val["value"]?$u_val["value"]:"&nbsp;")."</td></tr>\n";
                  }
                }
              }

              //EXTRA INFO
              if(count($data[$key."_extra"])>0 && is_array($data[$key."_extra"])) {
                foreach($data[$key."_extra"] as $exkey=>$exval) {
                  foreach($GLOBALS["MAP_INFO"][$key]["extra_table"]["schema"] as $extable_key=>$extable_val) {
                    $res .= "  <tr><td class=\"infoleft_html\" width=\"50%\">".$extable_val."</td><td class=\"info_html\" width=\"50%\">";

                    switch($GLOBALS["MAP_INFO"][$key]["extra_table"]["lang_translate"]) {
                      case "il2_win":
//                        $data[$key."_extra"][$i][$extable_key] = $this->TransformIsoLatin2($data[$key."_extra"][$i][$extable_key]);
                        $exval[$extable_key] = $this->TransformIsoLatin2($exval[$extable_key]);
                        break;
                      case "win_il2":
//                        $data[$key."_extra"][$i][$extable_key] = $this->TransformWin1250($data[$key."_extra"][$i][$extable_key]);
                        $exval[$extable_key] = $this->TransformWin1250($exval[$extable_key]);
                        break;
                    }

                    //AKTIVNI POLOZKA
                    $link_res = false;
                    $ext_t = $GLOBALS["MAP_INFO"][$key]["extra_table"]["link"][$extable_key];
                    if(is_array($ext_t)) {
                      $url="";
                      $class=$ext_t["class"];
                      $link = $ext_t["href"];
                      $caption = $ext_t["caption"];
                      $target = $ext_t["target"];
                      while (EReg("^(.*)<fl>([^<]*)</fl>(.*)$",$link,$res_link)) {
                        $link = $res_link[1];
                        $value = $data[$key."_extra"][$i][StrToUpper($res_link[2])];
                        $url = $res_link[1].$value.$res_link[3];
                      }
                      $link_res = "<a ".($class?'class="'.$class.'"':'')." href=\"".($url?$url:$link)."\" ".($target?'target="'.$target.'"':'').">".($caption?$caption:$data[$key."_extra"][$i][$extable_key]).'</a>';
                    }
                    if($link_res) $res .= $link_res;
                    elseif((strstr($exval[$extable_key],"http://") || strstr($exval[$extable_key],"https://"))) {
                      switch($GLOBALS["MAP_INFO"][$key]["extra_table"]["www"]) {
                        case "text": $res .= '<a class="info_a" target="_blank" href="'.$exval[$extable_key].'">'.$GLOBALS["RESOURCE_STRING"]["www_value"].'</a>';break;
                        case "value": $res .= '<a class="info_a" target="_blank" href="'.$exval[$extable_key].'">'.($exval[$extable_key]?$exval[$extable_key]:"&nbsp;").'</a>';break;
                        default: $res .= '<a class="info_a" target="_blank" href="'.$exval[$extable_key].'">'.$GLOBALS["MAP_INFO"][$key]["extra_table"]["www"].'</a>';
                      }
                    }
                    else {
                      $res .= ($exval[$extable_key]?$exval[$extable_key]:"&nbsp;");
                    }
                    $res .= "</td></tr>\n";
                  }
                }
              }
              $res .= "</table></div>\n";
            }
            $res .= "</div>\n";
          }
        }
      }
      if($no_data) $res .= $GLOBALS["RESOURCE_STRING"]["informace_no_data"];

      //Info OBJECT PLUGIN AFTER
      if($GLOBALS["INFO_PLUGIN_AFTER"]) $res .= $GLOBALS["INFO_PLUGIN_AFTER"];

      $res .= "</div>\n";

      $res .= "<script type=\"text/javascript\">\n";
      $res .= "  var img_info_collapse = '".FileUpURL("images/toc_tree/tree_collapse.gif")."';\n";
      $res .= "  var img_info_expand = '".FileUpURL("images/toc_tree/tree_expand.gif")."';\n";
      $res .= "</script>\n";

    } else {
      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["info"] && !$GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["pan"]) $res .= $GLOBALS["RESOURCE_STRING"]["informace_info_text"];
      if(is_array($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["search_box"])) $res .= $GLOBALS["RESOURCE_STRING"]["informace_search_text"];
      $res .= $GLOBALS["RESOURCE_STRING"]["informace_map_text"];
    }

    //INICIALIZACE CHOVANI NASTROJE INFO
    $res .= "<script type=\"text/javascript\">\n";
    $res .= "  in_extent_info=".($prop["in_extent_info"]?"true":"false").";\n";
    $res .= "</script>\n";

    $this->properties["text"] = $res;
  }
}

class CL_FunctionBar extends CL_Text {

  function CL_FunctionBar($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);

    if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["function_bar"]) {
      $funcobj = "<table><tr>\n";
      foreach($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["function_bar"]["function_array"] as $key=>$val) {
        $obj = $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["function_bar"]["function_array"][$key];
        if($obj && $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]][$key]) {
          $funcobj .= "<td>";

          if($GLOBALS["MAP_PROJECT"]["status_bar"]["alt"]) $status = "onmouseover=\"window.status='".$obj["alt"]."';return true;\" onmouseout=\"window.status='';return true;\"";
          else $status = "";

          switch($key) {
            case "legend":
              switch($obj["type"]) {
                case "button": $funcobj .= "<input name=\"".$obj["name"]."\" type=\"button\" value=\"".$obj["alt"]."\" class=\"in_button\" onclick=\"MapLegend('".$obj["target"]."','".$obj["source"]."','".$obj["source_file"]."')\" $status>";break;
                case "text": $funcobj .= "<a name=\"".$obj["name"]."\" class=\"function\" href=\"#\" onclick=\"MapLegend('".$obj["target"]."','".$obj["source"]."','".$obj["source_file"]."')\" alt=\"".$obj["alt"]."\" title=\"".$obj["alt"]."\" $status>".$obj["alt"]."</a>";break;
                case "img":
                default:
                  $funcobj .= "<a href=\"#\" onclick=\"MapLegend('".$obj["target"]."','".$obj["source"]."','".$obj["source_file"]."')\" $status><img name=\"".$obj["name"]."\" src=\"".FileUpURL('images/'.$obj["img"])."\" border=\"0\" alt=\"".$obj["alt"]."\" title=\"".$obj["alt"]."\"></a>";break;
              }
            break;
            default:
              switch($obj["type"]) {
                case "button": $funcobj .= "<input name=\"".$obj["name"]."\" type=\"button\" value=\"".$obj["alt"]."\" class=\"in_button\" onclick=\"".$obj["function"]."\" $status>";break;
                case "text": $funcobj .= "<a name=\"".$obj["name"]."\" class=\"function\" href=\"#\" onclick=\"".$obj["function"]."\" alt=\"".$obj["alt"]."\" title=\"".$obj["alt"]."\" $status>".$obj["alt"]."</a>";break;
                case "img":
                default:
                  $funcobj .= "<a href=\"#\" onclick=\"".$obj["function"]."\" $status><img name=\"".$obj["name"]."\" src=\"".FileUpURL('images/'.$obj["img"])."\" border=\"0\" alt=\"".$obj["alt"]."\" title=\"".$obj["alt"]."\"></a>";break;
              }
          }
          $funcobj .= "</td>\n";
        }
      }
      $funcobj .= "</tr></table>\n";
    } else $funcobj = "";
    $this->properties["text"] = $funcobj;
  }

}

class CL_SizeBar extends CL_Text {

  function CL_SizeBar($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);
    if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]) {

      $i=0;

      //object caption
      switch ($prop["caption"]["type"]) {
        case 'none':
        break;
        case 'function':
          if (function_exists($prop["caption"]["function"])) {
            $sizeobj = $prop["caption"]["function"]();
          }
        break;
        case 'auto':
        case 'text':
        default:
          $caption = $prop["caption"]['text']?$prop["caption"]['text']:$GLOBALS["RESOURCE_STRING"]["caption_map_size"];
          $class = $prop["caption"]['class']?$prop["caption"]['class']:'boxd_nadpis';
          $sizeobj = '<table cellpadding="0" cellspacing="0" width="100%"><tr>'."\n";
          $sizeobj .= "<td class='".$class."'>".$caption."</td>\n";
          $sizeobj .= "</tr></table>\n";
        break;
      }

      //object
      $sizeobj .= "<table>\n";

      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]["direction"] != "vertical")  $sizeobj .= "<tr>\n";

      foreach($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]["size_array"] as $key=>$val) {
        $obj = $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]["size_array"][$key];
        if($obj) { // && $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]][$key]) {
          if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]["direction"] == "vertical")  $sizeobj .= "<tr>\n";
          $sizeobj .= "<td class='obj_sizebar'>";
          if($GLOBALS["MAP_PROJECT"]["status_bar"]["alt"]) $status = "onmouseover=\"window.status='".$obj["alt"]."';return true;\" onmouseout=\"window.status='';return true;\"";
          else $status = "";
          switch($obj["type"]) {
            case "button": $sizeobj .= "<input name=\"".$obj["name"]."\" type=\"button\" value=\"".(($key == $GLOBALS["MapVars"]["map_size"])?">>".$obj["alt"]."<<":$obj["alt"])."\" class=\"in_button\" onclick=\"ChangeMapClientSize(".$obj["width"].",".$obj["height"].")\" $status>";break;
            case "text": $sizeobj .= "<a name=\"".$obj["name"]."\" class=\"function\" href=\"#\" onclick=\"ChangeMapClientSize(".$obj["width"].",".$obj["height"].")\" alt=\"".$obj["alt"]."\" $status>".(($key == $GLOBALS["MapVars"]["map_size"])?">>".$obj["alt"]."<<":$obj["alt"])."</a>";break;
            case "img":
            default:
              $sizeobj .= "<a href=\"#\" onclick=\"ChangeMapClientSize(".$obj["width"].",".$obj["height"].",'".$key."')\" $status><img name=\"".$obj["name"]."\" src=\"".FileUpURL('images/'.(($key == $GLOBALS["MapVars"]["map_size"])?$obj["img2"]:$obj["img"]))."\" border=\"0\" alt=\"".$obj["alt"]."\" title=\"".$obj["alt"]."\"></a>";break;
          }
          $sizeobj .= "</td>";
          if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]["direction"] == "vertical")  $sizeobj .= "</tr>\n";
        }
      }
      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["size_bar"]["direction"] != "vertical")  $sizeobj .= "</tr>\n";
      $sizeobj .= "</table>\n";
    } else $sizeobj = "";
    $this->properties["text"] = $sizeobj;
  }

}
class CL_Hotlink extends CL_Text {

  function CL_Hotlink($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);
    if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["hotlink"]) {
      $this_link = $GLOBALS["MAP_LINK"];
      $this_link_ex = $GLOBALS["MAP_LINK_EX"];
      $hotlinkobj = "<script type=\"text/javascript\">\n";
      $hotlinkobj .= "var sel_el=new Object();\n";
      $hotlinkobj .= "sel_el.active = false;\n";
      $hotlinkobj .= "link=new Object();\n";
      $hotlinkobj .= "link.layers=new Object();\n";
      $hotlinkobj .= "link.groups=new Object();\n";
      switch ($this_link_ex["search_type"]) {
        case "first_from_all":
          $hotlinkobj .= "link.type = 'ffa';\n";
          $hotlink = $this_link_ex["output"];
          $hotlinkobj .= "link.all=new Object();\n";
          $hotlinkobj .= "l=link.all;\n";
          $hotlinkobj .= "l.output='".($hotlink["target"]?StrToLower($hotlink["target"]):"")."';\n";
          $hotlinkobj .= "l.name='".($hotlink["name"]?$hotlink["name"]:"Hotlink")."';\n";
          $hotlinkobj .= "l.features='".($hotlink["features"]?$hotlink["features"]:"")."';\n";
        break;
        case "all_from_group":
          $hotlinkobj .= "link.type = 'afg';\n";
          $hotlinkobj .= "link.group = '".$this_link_ex["group"]."';\n";
          $hotlink = $this_link_ex["output"];
          $hotlinkobj .= "link.groups['".$this_link_ex["group"]."']=new Object();\n";
          $hotlinkobj .= "l=link.groups['".$this_link_ex["group"]."'];\n";
          $hotlinkobj .= "l.output='".($hotlink["target"]?StrToLower($hotlink["target"]):"")."';\n";
          $hotlinkobj .= "l.name='".($hotlink["name"]?$hotlink["name"]:"Hotlink")."';\n";
          $hotlinkobj .= "l.features='".($hotlink["features"]?$hotlink["features"]:"")."';\n";
        break;
        default: //"first_from_one"
          $hotlinkobj .= "link.type = 'ffo';\n";
        break;
      }

      reset($this_link);
      while (list($key,$val) = each($this_link)) {
        if ($val["output"]) {
          $hotlink = $val["output"];
          $hotlinkobj .= "link.layers['$key']=new Object();\n";
          $hotlinkobj .= "l=link.layers['$key'];\n";
          $hotlinkobj .= "l.output='".($hotlink["target"]?StrToLower($hotlink["target"]):"")."';\n";
          $hotlinkobj .= "l.name='".($hotlink["name"]?$hotlink["name"]:"Hotlink")."';\n";
          $hotlinkobj .= "l.features='".($hotlink["features"]?$hotlink["features"]:"")."';\n";
          if ($hotlink["parameters"]) $hotlinkobj .= "l.parameters='".$hotlink["parameters"]."';\n";
          if ($val["query_layers"]) $hotlinkobj .= "l.query_layers='".$val["query_layers"]."';\n";
        }
      }

      $hotlinkobj .= "link.select_type=".($this_link_ex["select_type"]?$this_link_ex["select_type"]:"1").";\n";
      //echo "link.select_num=".($this->link_ex["select_num"]?$this->link_ex["select_num"]:"0").";\n";
      if($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["hotlink1"] || $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["hotlink2"] || $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["hotlink3"] || $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["hotlink4"] || $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["hotlink5"]) {
        $hotlinkobj .= "link.hotlink_layers=new Object();\n";
        $hotlinkobj .= "l_hl=link.hotlink_layers;\n";
        for($i=0;$i<5;$i++) {
          $h_set = $GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["hotlink".($i+1)];
          if($h_set["hotlink_layer"]) $hotlinkobj .= "l_hl.hotlink".($i+1)."='".$h_set["hotlink_layer"]."';\n";
        }
      }
      $hotlinkobj .= "</script>\n";
    } else $hotlinkobj = "";
    $this->properties["text"] = $hotlinkobj;
  }
}

class CL_SearchBox extends CL_Text {

  function CL_SearchBox($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);
    if (is_array($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["search_box"])) {

      //object caption
      switch ($prop["caption"]["type"]) {
        case 'none':
        break;
        case 'function':
          if (function_exists($prop["caption"]["function"])) {
            $searchbox = $prop["caption"]["function"]();
          }
        break;
        case 'auto':
        case 'text':
        default:
          $caption = $prop["caption"]['text']?$prop["caption"]['text']:$GLOBALS["RESOURCE_STRING"]["caption_search_box"];
          $class = $prop["caption"]['class']?$prop["caption"]['class']:'boxd_nadpis';
          $searchbox = '<table cellpadding="0" cellspacing="0" width="100%"><tr>'."\n";
          $searchbox .= "<td class='".$class."'>".$caption."</td>\n";
          $searchbox .= "</tr></table>\n";
        break;
      }

      //object
      $searchbox .= "<table cellpadding='0' cellspacing='0' width='100%'>\n";

      //zalozky
      $search_tabs = "<td class='boxw' style='width:1%;padding:4px;padding-top:5px;padding-bottom:0px;padding-right:0px'>\n<nobr>\n";
      foreach($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["search_box"]["search_box_array"] as $key=>$val) {
        if($val) {
          $search_tabs .= "<input type='button' value='".$val["caption"]."' id='btn_".$val["name"]."' class='".$GLOBALS["search_class"][$val["name"]]["class"]."' onclick='SearchSwitch(\"".$val["name"]."\")'>";
        }
      }
      $search_tabs .= "</nobr>\n</td>\n<td class='boxw' style='padding:4px;padding-top:5px;padding-bottom:0px;padding-left:0px'>\n<input type='button' class='in_button_empty'>\n</td>\n";

      //formular
      $search_form = "";
      foreach($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["search_box"]["search_box_array"] as $key=>$val) {
        if($val) {
          $search_form .= "<table cellpadding='0' cellspacing='0' width='100%' id='search_".$val["name"]."' style='border:1px solid #666666;border-top-style:none;".$GLOBALS["search_class"][$val["name"]]["style"]."height:60px'>\n";
          $search_form .= "  <tr>\n<td class='box' style='padding:5px;padding-top:3px;padding-bottom:0px;'>\n";
          $search_form .= $val["field_caption"].":&nbsp;<input name='".$val["name"]."_".$val["field"]."' class='in_text' type='' id='".$val["name"]."_".$val["field"]."' style='width:135px' value='".$GLOBALS["search_class"][$val["name"]]["last"]."' onkeydown='if(window.event.keyCode == 13) SearchBox(\"".$val["name"]."\");'>\n";
          $search_form .= "  </td>\n</tr>\n<tr>\n<td class='box' align='right' style='padding:5px;padding-top:3px;padding-bottom:5px;'>\n";
          $search_form .= "<input type='button' value='Vyhledat' class='in_button' id='sub_".$val["name"]."' onclick='SearchBox(\"".$val["name"]."\")'>\n</td>\n</tr>\n</table>\n";
        }
      }

      $searchbox .= "<tr>\n".$search_tabs."</tr>\n</table>\n";
      $searchbox .= "<div id='search_box' style='padding-left:4px;padding-right:4px;width:100%;padding-bottom:1px;'>\n".$search_form."</div>\n";

      $script_search_box = "<script type=\"text/javascript\">\n";
      $script_search_box .= "function SearchSwitch(type) {\n";
      $null_all = "";
      $array_search = "var array_search_box = new Object();\n";
      foreach($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["search_box"]["search_box_array"] as $key=>$val) {
        if($val) {
          $array_search .= "array_search_box['href_".$val["name"]."']='".$val["href"]."';\n";
          $array_search .= "array_search_box['field_".$val["name"]."']='".$val["name"]."_".$val["field"]."';\n";
          $array_search .= "array_search_box['field_".$val["name"]."_name']='".$val["field"]."';\n";

          $null_all .= "  window.document.getElementById('btn_".$val["name"]."').className = 'in_button_back';\n";
          $null_all .= "  window.document.getElementById('sub_".$val["name"]."').disabled = true;\n";
          $null_all .= "  window.document.getElementById('search_".$val["name"]."').style.visibility = 'hidden';\n";
          $null_all .= "  window.document.getElementById('search_".$val["name"]."').style.position = 'absolute';\n";
        }
      }
      $script_search_box .= $null_all;
      //$script_search_box .= "  ChangeMapVarsObj('stype', type);\n";
      $script_search_box .= "  window.document.getElementById('btn_'+type).className  = 'in_button_front';\n";
      $script_search_box .= "  window.document.getElementById('sub_'+type).disabled = false;\n";
      $script_search_box .= "  window.document.getElementById('search_'+type).style.visibility = 'visible';\n";
      $script_search_box .= "  window.document.getElementById('search_'+type).style.position = 'relative';\n";
      $script_search_box .= "  var input_box = window.array_search_box['field_'+type];\n";
      $script_search_box .= "  window.document.getElementById(input_box).focus();\n";
      $script_search_box .= "}\n";
      $script_search_box .= $array_search;
      $script_search_box .= "</script>\n";

      $searchbox .= $script_search_box;

    } elseif($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["search_box"] && $GLOBALS["MAP_BOOKMARK"]["bookmark"]) {
      $searchbox_options = "<select name='search_box_type' id='search_box_type'>\n";
      $index = 0;
      foreach($GLOBALS["MAP_BOOKMARK"]["bookmark"] as $key=>$val) {
        $searchbox_options .= "<option value='".$val["href"]."' ";

        if($GLOBALS["MapVars"]["search_box_type"]) {
          if($GLOBALS["MapVars"]["search_box_type"] == $index) $searchbox_options .= "selected";
        } else $searchbox_options .= ($val["selected"]?"selected":"");

        $searchbox_options .= ">".$val["name"]."\n";
        $index++;
      }
      $searchbox_options .= "</select>\n";

      $searchbox = "<form name='searchbox' id='searchbox' onsubmit='SearchBox();return false;'>\n";
      $searchbox .= "<table cellspacing='0' cellpadding='0' width='100%'>\n";
      //$searchBox .= "<tr><td><font class='blue_text'>Vyhledvn</font></td><td><font class='blue_text'>Typ objektu</font></td><td>&nbsp;</td></tr>\n";
      $searchbox .= "<tr>\n";

      if($prop["method"]=="line") $searchbox .= "<td class='search_left'>&nbsp;</td>\n";

      $searchbox .= "<td class='search_back'>&nbsp;<input name='search_box_value' class='in_text' type='text' id='search_box_value' style='width:135px' value='".$GLOBALS["MapVars"]["search_box_value"]."'>&nbsp;</td>\n";

      if($prop["method"]=="box") $searchbox .= "</tr><tr>\n";

      $searchbox .= "<td class='search_back'>&nbsp;".$searchbox_options."&nbsp;</td>\n";
      switch($prop["button"]) {
        case "button":
          $searchbox .= "<td class='search_back'><input type='button' onclick='SearchBox()' onmouseover=\"window.status='Vyhledvn';return true;\" onmouseout=\"window.status='';return true;\" value=\"hledej\"></td>\n";
        break;
        default:
          $searchbox .= "<td class='search_back'><table><tr><td>&nbsp;<a class='search_box' href='#' onclick='SearchBox()' onmouseover=\"window.status='Vyhledvn';return true;\" onmouseout=\"window.status='';return true;\">hledej</a></td><td><a class='search_box' href='#' onclick='SearchBox()' onmouseover=\"window.status='Vyhledvn';return true;\" onmouseout=\"window.status='';return true;\"><img src='".FileUpURL("images/search/vyhledat.gif")."' border='0' alt='Vyhledvn'></a></td></tr></table></td>\n";
      }

      if($prop["method"]=="line") $searchbox .= "<td class='search_right'>&nbsp;</td>\n";

      $searchbox .= "</tr>\n";
      $searchbox .= "</table></form>\n";
    } else $searchbox = "";
    $this->properties["text"] = $searchbox;
  }
}
class CL_TabsBox extends CL_Text {

  function CL_TabsBox($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);
    if ($GLOBALS["MAP_PANEL"][$GLOBALS["client_type"]]["tabs_box"]) {

      $tab_params = explode("&",$GLOBALS["QUERY_STRING"]);
      $p_tab="";
      for($i=0;$i<count($tab_params);$i++) {
        $tab_param = explode("=",$tab_params[$i]);
        //parametry, ktere se v URL nepredavaji
        $reserved = array("subproject", "Layers", "m_search_box_type", "BBOX");
        if (!in_array($tab_param[0], $reserved)) $p_tab .= "&".$tab_param[0]."=".urlencode($tab_param[1]);
      }
      $p_tab .= "&BBOX=".$GLOBALS["BBOX"]["minx"].",".$GLOBALS["BBOX"]["miny"].",".$GLOBALS["BBOX"]["maxx"].",".$GLOBALS["BBOX"]["maxy"];

      $tabsbox = '<script type="text/javascript">';
      $tabsbox .= 'var subproject="'.$GLOBALS["subproject"].'";';
      $tabsbox .= '</script>';
      $tabsbox .= '<table border="0" cellpadding="0" cellspacing="0">';
      $tabsbox .= '  <tr>';

      foreach($GLOBALS["TABS_PANEL"] as $tab_key=>$tab_val) {

        $tabsbox .= '    <td id="'.$tab_val["ident"].'_l" class="l_b">&nbsp;</td>';
        $tabsbox .= '    <td id="'.$tab_val["ident"].'_m" class="m_b" nowrap><a id="'.$tab_val["ident"].'_tab" class="tab" href="'.$tab_val["href"].$p_tab.'" title="'.$tab_val["title"].'" onclick="SetPageLayerVisible(window, \'MapWait\', true)">'.$tab_val["caption"].'</a></td>';
        $tabsbox .= '    <td id="'.$tab_val["ident"].'_r" class="r_b">&nbsp;</td>';

        if($tab_val["wrap"]) {
          $tabsbox .= '    <td id="'.$tab_val["ident"].'_end" class="end_b">&nbsp;</td>';
          $tabsbox .= '</tr></table>';
          $tabsbox .= '<table border="0" cellpadding="0" cellspacing="0">';
          $tabsbox .= '  <tr>';
        }
      }
      $tabsbox .= '  </tr>';
      $tabsbox .= '</table>';
    } else $tabsbox = "";
    $this->properties["text"] = $tabsbox;
  }
}

class CL_Title extends CL_Text {

  function CL_Title($prop,$params,&$main_client) {
    $this->CL_Text($prop,$params,&$main_client);

    $title = "";
    if($GLOBALS["PROPERTIES"]["AGENDA_NAME"]) $title = $GLOBALS["PROPERTIES"]["AGENDA_NAME"];
    else $title = "T-MapServer";
    $this->properties["text"] = $title;

  }

}
?>
