<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: TileMapService.inc,v 1.1 2007/12/05 12:06:15 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2('.admin/main_cache.inc'));

class Map_Cache_TileMapService extends Map_Cache{

  function Map_Cache_TileMapService($properties, $params) {
    $this->Map_Cache($properties, $params);
    if (!$this->properties['origin']) {
      $this->properties['origin']=array('x'=>0,'y'=>0);
      $this->properties['tile']=array('width'=>0,'height'=>0);
    }
  }
  
  function GetParams () {
    $params = array();
    $params['map']=$this->request['map'];
    $params['bbox']=$this->request['bbox'];
    $params['width']=$this->request['width'];
    $params['height']=$this->request['height'];
    $params['layers']=$this->request['ulayers_visible'];
    $params['layerpath']=$this->request['layerpath'];
    $params['style']=$this->request['style'];
    $params['format']=$this->request['format'];
    $params['mode']=$this->request['mode'];
    return $params;
  }
  
  function Find() {
    $fn = $this->GetFileName();
    echo($fn);
    if (File_Exists($fn)) return file_get_contents($fn);
    return false;
  }

  function Write($data) {
    if ($this->disabled) return false;
    $fn = $this->GetFileName($params,true);
    if (!$f = fopen($fn, 'w')) {
      echo 'Cache: cannot write '.$fn;
    }
    fwrite($f, $data);
    fclose($f);
  }

  function WriteImage($type, $data) {
    if ($this->disabled) return false;
    $fn = $this->GetFileName(true);
    switch ($type) {
      case 'GIF': ImageGIF($data, $fn); break;
      case 'PNG': ImagePNG($data, $fn); break;
      case 'JPEG': ImageJPEG($data, $fn); break;
      default: die('Cache: Unknown format.'); break;
    }
  }
  
  function GetFileName($mkdir=false) {
    if (!$this->request['bbox']) return false;
    $x = Round(($this->request['bbox']['minx']-$this->properties['origin']['x'])/(double)$this->request['pixel']/(double)$this->properties['width']);
    $y = Round(($this->request['bbox']['miny']-$this->properties['origin']['y'])/(double)$this->request['pixel']/(double)$this->properties['height']);
    
    switch ($this->properties['repository']['filename']['dirname']['type']) {
      case 'layers': 
        $layers = $this->request['layers']; 
      break;
      case 'nhlayers': 
      default:
        $layers = $this->request['nhlayers']; 
      break;
    }
    
    //Remove layerpath layers
    $arlayerpath = Explode('/',$this->request['layerpath']);
    foreach($arlayerpath as $val) array_shift($layers);
    sort($layers, SORT_STRING);
    
    if (!Count($layers)) $layers = array('default');

    $levellayers = $this->properties['repository']['path'].(SubStr($this->properties['repository']['path'],-1)=='/'?'':'/').
          $this->project['name'].'/'.$this->request['layerpath'].'/'.$this->request['style'].'/';
    
    switch ($this->properties['repository']['filename']['dirname']['encoding']) {
      case 'crc32':
        $levellayers .= crc32(Implode(',',$layers));
      break;
      case 'plain':
      default:
        $levellayers .= Implode(',',$layers);
      break;
    }
          
    if (isset($this->properties['repository']['filename']['pixelround'])) {
      $leveldir = $levellayers.'/'.
            Round($this->request['pixel'],$this->properties['repository']['filename']['pixelround']);
    } else {
      $leveldir = $levellayers.'/'.$this->request['pixel'];
    }

    $fn = $leveldir.'/'.
          $x.'/'.$y.'.'.
          strtolower($this->request['format']);
    $dir = DirName($fn);
    if (!Is_dir($dir) && $mkdir) {
      $dirs = Explode('/', $dir);
      $dirtemp = '';
      foreach ($dirs as $d) {
        $dirtemp .= '/'.$d;
        if (!Is_Dir($dirtemp)) mkdir($dirtemp,0775);
      }
      $metadata = $levellayers.'/layers.txt';
      if (!File_Exists($metadata)) {
        $fp = fopen($metadata, 'w');
        fWrite($fp, Implode(',',$layers));
        fClose($fp);
      }
      $metadata = $leveldir.'/metadata.txt';
      if (!File_Exists($metadata)) {
        $originx = $this->request['bbox']['minx']-$x*$this->request['pixel']*$this->properties['width'];
        $originy = $this->request['bbox']['miny']-$y*$this->request['pixel']*$this->properties['height'];
        $fp = fopen($metadata, 'w');
        fWrite($fp, "Origin x=\"$originx\" y=\"$originy\"\n".
                    "TileFormat width=\"".$this->properties['width']."\" height=\"".$this->properties['height']."\"\n".
                    "TileSet href=\".../".Basename($leveldir)."\" units_per_pixel=\"".$this->request['pixel']."\"\n"
                    );
        fClose($fp);
      }
    }
    
    return $fn; 
  }
}

?>
