<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: File.inc,v 1.1 2007/12/05 12:06:15 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once(FileUp2('.admin/main_cache.inc'));

class Map_Cache_File extends Map_Cache{

  function Map_Cache_File($properties, $params) {
    $this->Map_Cache($properties, $params);
  }
  
  function GetParams () {
    $params = array();
    $params['map']=$this->request['map'];
    $params['bbox']=$this->request['bbox'];
    $params['width']=$this->request['width'];
    $params['height']=$this->request['height'];
    $params['layers']=$this->request['layers'];
    $params['ulayers_visible']=$this->request['ulayers_visible'];
    $params['format']=$this->request['format'];
    $params['mode']=$this->request['mode'];
    return $params;
  }
  
  function Find() {
    $fn = $this->GetFileName();
    if (File_Exists($fn)) return file_get_contents($fn);
    return false;
  }
  
  function Write($data) {
    $fn = $this->GetFileName();
    if (!$f = fopen($fn, 'w')) {
      echo 'Cache: cannot write '.$fn;
    }
    fwrite($f, $data);
    fclose($f);
  }

  function WriteImage($type, $data) {
    $fn = $this->GetFileName();
    switch ($type) {
      case 'GIF': ImageGIF($data, $fn); break;
      case 'PNG': ImagePNG($data, $fn); break;
      case 'JPEG': ImageJPEG($data, $fn); break;
      default: die('Cache: Unknown format.'); break;
    }
  }
  
  //Private
  function GetFileName() {
    return $this->properties['repository'].'/'.md5(serialize($this->GetParams())).'.'.strtolower($this->request['format']);
  }
  
}

?>
