<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: table.inc,v 1.20 2008/04/08 11:56:45 tohu Exp $'.'$Name:  $';exit;}; /* HEADER */ 

require_once ('main.inc');

class Upload_Obj_Table extends Upload_Obj_Main
{
  var $modul_name = 'table';
  var $upl_table = '';
  var $upl_tab_met = array();
  var $q = array();
  var $q_ag = array();
  var $UPL_RECORD = array();
  var $AGENDA_RECORD = array();
  var $FILE = '';

  function Upload_Obj_Table ($config) {
    //$this->config = $config;
    parent::Upload_Obj_Main($config);

    $this->upl_table = $this->config['TABLE'];
    $GLOBALS['upl_table'] = $this->upl_table;

    //db konektor na tabulku UPLOADU
    $db = $this->config["DB_NAME"]?$this->config["DB_NAME"]:"DB_DEFAULT";
    $this->q = new $db;

    //db konektor na tabulku AGENDY
    $db = $this->config['AGENDA_PROPERTIES']["DB_NAME"]?$this->config['AGENDA_PROPERTIES']["DB_NAME"]:"DB_DEFAULT";
    $this->q_ag = new $db;

    $this->upl_tab_met = $this->q->metadata($this->upl_table);

    $this->main_dir = $GLOBALS["TMAPY_DIR"].'/';
    $this->main_dir.= $this->config['UPLOAD_DIR']?$this->config['UPLOAD_DIR']:'data/upload';
    $GLOBALS['MAIN_DIR']=$this->main_dir;


    if($GLOBALS['DELETE_ID'] || $GLOBALS['EDIT_ID'] || $GLOBALS['FILE_ID'] || $GLOBALS['FILE_ID_H'] || $GLOBALS['HISTORY_ID'] || $GLOBALS['DELETE_ID_H']){

      $id = $GLOBALS['FILE_ID']?$GLOBALS['FILE_ID']:($GLOBALS['DELETE_ID']?$GLOBALS['DELETE_ID']:($GLOBALS['EDIT_ID']?$GLOBALS['EDIT_ID']:$GLOBALS['HISTORY_ID']));
      $idh = $GLOBALS['FILE_ID_H']?$GLOBALS['FILE_ID_H']:$GLOBALS['DELETE_ID_H'];

      if( ($id && !is_numeric($id)) || ($idh && !is_numeric($idh)) ){
        $this->FlushMesg('Error ID');
        die();
      }

      if($idh)
        $this->UPL_RECORD = $this->GetRecordTable($idh, true);
      else
        $this->UPL_RECORD = $this->GetRecordTable($id, false);

      if($this->UPL_RECORD['RECORD_ID'])
        $this->AGENDA_RECORD = $this->GetRecordAgenda($this->UPL_RECORD['RECORD_ID']);

      $this->FILE = $this->main_dir.$this->UPL_RECORD["DIRECTORY"].$this->UPL_RECORD["NAME"];
      $this->FILE_preview = $this->main_dir.$this->UPL_RECORD["DIRECTORY"].'preview/'.$this->UPL_RECORD["NAME"];
    }
    // prevedeni casu pro MSSQL - lumo
    $this->UPL_RECORD["LAST_DATE"] = $this->q->dbdate2str($this->UPL_RECORD["LAST_DATE"]);
    $this->UPL_RECORD["LAST_DATE"] = $this->q->str2dbdate($this->UPL_RECORD["LAST_DATE"]);

    //print_r($this->config);
  }


    ///kontrola na
    ///1. pokud se jedna o anonyma, tak musi byt nastaveno ze je soubor pristupny pro nej
    ///2. pokud je soubor nastaven jako privatni, tak porovnat id uzivatele
    ///3. pravo k zaznamu
  function HasAccessToUploadRecord($right = false){
    if(($this->config['use_anonym_access'] && $this->config['USER_INFO']['is_anonymous'] && $this->UPL_RECORD["ANONYM"]=='n')  || ($this->config['use_private_access'] && $this->UPL_RECORD["PRIVATE"]=='y' && $this->config['USER_INFO']['ID']!=$this->UPL_RECORD["OWNER_ID"]))
      $acc = false;
    else
      $acc = true;

    if($acc && $right && $this->UPL_RECORD)
      $acc = HasAccessToRecord($right, $this->AGENDA_RECORD);

    return $acc;
  }


  //ziska zaznam z UPLOADU pro konkretni prilohu
  function GetRecordTable($id, $history=false){

    $tname = $history?$this->upl_table.'_h':$this->upl_table;
    $tid = $history?'id_h':'id';

    $this->q->query("SELECT * FROM $tname WHERE $tid = $id");

    $this->q->next_record();

    return $this->q->Record;
  }

  //ziska zaznam z agendy, pro ktery patri konkretni priloha
  function GetRecordAgenda($record_id=0){

    if(!$record_id) $record_id = $this->UPL_RECORD['RECORD_ID'];

    $this->q_ag->query('SELECT * FROM '.$this->config['AGENDA_PROPERTIES']['AGENDA_TABLE'].' WHERE '.$this->config['AGENDA_PROPERTIES']['AGENDA_ID'].' = '. $record_id);

    $this->q_ag->next_record();

    return $this->q_ag->Record;
  }

  //ziska pole zaznamu z UPLOADU dle agenda_ident a record_id
  function GetRecordsUploadForAgenda($record_id=0){

    $ret = array();

    if(!$record_id) $record_id = $this->UPL_RECORD['RECORD_ID'];

    $this->q->query('SELECT * FROM '.$this->upl_table.' WHERE record_id = '. $record_id.' AND agenda_ident = \''.$this->config['AGENDA_PROPERTIES']['AGENDA_IDENT'].'\' ORDER BY id');

    while($this->q->next_record()){
      $ret[] = $this->q->Record;
    }

    return $ret;
  }

  //zobrazi vlastni prilohu
  function ShowUploadFiles(){

    if(!$this->UPL_RECORD) return false;

    if(!file_exists(FileSystemConvertFNToFS($this->FILE))){
      $error_f = FileUp2('images/foto/error.gif');
      $this->SendHTTPHeaderForFile($error_f, 'image/gif');
      readfile($error_f);
    }

    $preview = $GLOBALS['preview']?$GLOBALS['preview']:0;
    $info = GetImageSize(FileSystemConvertFNToFS($this->FILE));

    //jestlize je pozadovany nahled
    if($preview && $info){

       $WIDTH  = $info[0];
       $HEIGHT = $info[1];

       $file_prw = $this->AddId2FileName($this->FILE_preview, $preview);

       if(!file_exists(FileSystemConvertFNToFS($file_prw))){
         $this->CreatePreview($this->FILE, $this->FILE_preview, $info, array($preview));
       }

       $this->SendHTTPHeaderForFile($file_prw, $this->UPL_RECORD['TYPEFILE']);
       readfile(FileSystemConvertFNToFS($file_prw));


    }else{

      if($this->IsApplTypeFile($this->UPL_RECORD['TYPEFILE']))
        $content_disposition = 'attachment';
      else
        $content_disposition = 'inline';

      if($this->UPL_RECORD['TYPEFILE'] == 'text/plain')
        $this->UPL_RECORD['TYPEFILE'] .= '; charset=windows-1250';

      $this->SendHTTPHeaderForFile($this->FILE, $this->UPL_RECORD['TYPEFILE'], $content_disposition);

      if(Is_File(FileSystemConvertFNToFS($this->FILE))){

        readfile(FileSystemConvertFNToFS($this->FILE));

        if($GLOBALS['FILE_ID']){
          $sql = 'UPDATE '.$this->upl_table.' SET counter = '.($this->UPL_RECORD['COUNTER']+1).', last_date_show=\''.$this->q->date2dbdate().'\' WHERE id = '.$GLOBALS['FILE_ID'];
          $this->q->query($sql);
        }
      }else{
        $this->FlushMesg('soubor nenalezen !');
      }
    }
  }



  /**
  Zobrazuje Table uploadu
  **/
  function ShowUploadTable(){

    $schema_file = FileUp_Main(".admin/upload/table_schema.inc", $this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']);

    $add_where='';
    if($this->config['USER_INFO']["is_anonymous"] && $this->config['use_anonym_access']) $add_where.=" AND anonym='y'";

    ///podminka pro "duverne" dokumenty
    if($this->config['use_private_access']) $add_where.=" AND (private<>'y' OR owner_id=".$this->config['USER_INFO']['ID'].')';

    $sql_arr = array();

    if($GLOBALS['DELETE_ID']){
      $nocapt = true;
      $nopaging = true;
      $sql_arr[1]="SELECT * FROM $this->upl_table WHERE id=$GLOBALS[DELETE_ID] $add_where";
    }else{
      $nocapt = false;
      $sql_arr['image']   = "SELECT * FROM $this->upl_table WHERE agenda_ident='".$this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']."' AND record_id=".($GLOBALS['RECORD_ID']?$GLOBALS['RECORD_ID']:'0')." $add_where AND isimage = 'y'";
      $sql_arr['noimage'] = "SELECT * FROM $this->upl_table WHERE agenda_ident='".$this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']."' AND record_id=".($GLOBALS['RECORD_ID']?$GLOBALS['RECORD_ID']:'0')." $add_where AND (isimage = 'n' OR isimage IS NULL)";
    }

    $properties = $this->config['AGENDA_PROPERTIES'];
    $properties["DB_NAME"] = $this->config["DB_NAME"]?$this->config["DB_NAME"]:"DB_DEFAULT";
    $properties["AGENDA_ID"] = "ID";
    $properties["AGENDA_TABLE"] = $this->upl_table;

    foreach($sql_arr as $typ => $sql){

      $GLOBALS['ORDER_BYupload_files'] = $GLOBALS['ORDER_BYupload_files']?$GLOBALS['ORDER_BYupload_files']:'id';
      $sql.= ' ORDER BY '.$GLOBALS['ORDER_BYupload_files'];

      if($typ == 'image'){
        $capt = 'Plohy - obrzky';
        $no_top_menu = false;
        $GLOBALS['IMAGE_PREVIEW'] = true;
      }elseif($typ == 'noimage'){
        $capt = 'Plohy - ostatn';
        $no_top_menu = true;
        $GLOBALS['IMAGE_PREVIEW'] = false;
      }

      Table(array(
          "properties"=>$properties, //tento parametr MUSI byt podporovan, pokud db tabulky pro UPLOAD, jsou jinde nez agenda
          "caption"=>$capt,
          "nocaption"=>$nocapt,
          "nopaging"=>$nopaging,
          "tablename"=>$this->upl_table,
          "sql"=>$sql,
          "schema_file"=>$schema_file,
          "showhistory"=>false,
          "setvars"=>true,
          "noprint"=>true,
          "noexport"=>true,
          "showaccess"=>true,
          "showinfo"=>false,
          "showedit"=>false,
          "showdelete"=>false,
          "noshowrelation"=>true,
          "noshowinsert2clip"=>true,
          "no_top_menu"=>$no_top_menu,
        ));

    }

    $text = 'Pro novou verzi dokumentu pouij ikonu editace na pslun ploze !!!';
    if(strcasecmp($this->config['AGENDA_PROPERTIES']["DEFAULT_LANG"],"cz_iso")==0) $text = iconv("windows-1250","ISO-8859-2",$text);

    $this->FlushMesg($text);

  }




  function ShowUploadForm(){

    $schema_file = FileUp_Main(".admin/upload/form_schema.inc", $this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']);

    if($GLOBALS['EDIT_ID']) $sql = "SELECT * FROM $this->upl_table WHERE id = $GLOBALS[EDIT_ID]";
    else $sql=false;

    /// toto je vyuziti tohoto globalniho parametru, ktery se pouziva ve fci HasAccessToRecord,
    /// ktera se vola ve Form_(), abych se vyhnul kontrole, protoze nemuze spravne zafungovat,
    /// protoze ma PROPERTIES z jine agendy a EDIT_ID z UPLOADU
    $GLOBALS["PROPERTIES"]["NO_TABLE"] = HasAccessToRecord("update", $this->UPL_RECORD['RECORD_ID']);

    $properties = $this->config['AGENDA_PROPERTIES'];
    $properties["DB_NAME"] = $this->config["DB_NAME"]?$this->config["DB_NAME"]:"DB_DEFAULT";
    $properties["AGENDA_ID"] = "ID";
    $properties["AGENDA_TABLE"] = $this->upl_table;

    Form_(array(
        "properties"=>$properties, //tento parametr MUSI byt podporovan, pokud db tabulky pro UPLOAD, jsou jinde nez agenda
        "caption"=>"Ploha",
        "action"=>'ug_file.php',
        "myform_schema"=>$schema_file,
        "myform_sql_all"=>$sql,
        "formvars"=>array("show_typ"=>2),
        "method"=>'post',
        "showaccess"=>true
    ));

  }



  /**
  Historie
  **/
  function ShowUploadHistory(){
    global $PROPERTIES, $USER_INFO;

    if(HasSubRole("update") && $this->HasAccessToUploadRecord('update')){

      $capt = "Plohy";

      if($this->config['use_private_access']) $private = " AND (private<>'y' OR owner_id=".$this->config['USER_INFO']['ID'].")";

      $sql = "SELECT * FROM $this->upl_table WHERE agenda_ident='".$this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']."' AND id=".($GLOBALS['HISTORY_ID']?$GLOBALS['HISTORY_ID']:'0').$private;

      $table_schema_file=FileUp_Main(".admin/upload/table_schema.inc", $this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']);
      $form_schema_file=FileUp_Main(".admin/upload/form_schema.inc", $this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']);

      ///zde se podstrci fci History() jine hodnoty
      $GLOBALS['PROPERTIES']['AGENDA_TABLE'] = $this->upl_table;
      $GLOBALS['PROPERTIES']['AGENDA_ID'] = 'ID';
      $GLOBALS['PROPERTIES']['DB_NAME'] = $this->config["DB_NAME"]?$this->config["DB_NAME"]:"DB_DEFAULT";

      include(FileUp2(".admin/history_.inc"));

      History(array(
          "table_name"=>$this->upl_table,
          "table_sql"=>$sql,
          "table_caption"=>$capt,
          "agenda_id"=>"ID",
          "caption"=>'Historie',
          "table_schema_file"=>$table_schema_file,
          "table_showinfo"=>false,
          "form_schema_file"=>$form_schema_file,
          "noundo"=>true,
          "noacceptfields"=>array('COUNTER','FILESIZE','DIRECTORY','TYPEFILE'),
      ));

    }else{
      include_once(FileUp2("html_error.inc"));
    }
  }


  /**
  Uklada do Uploadu
  **/
  function ActionRun() {

    include_once(FileUp2(".admin/upload_fce_.inc"));

    //global $PROPERTIES, $USER_INFO, $UPL_RECORD, $q, $FILE, $MAIN_DIR, $upl_tab_met;

    $button_back = "<input type=\"button\" value=\"".$GLOBALS["RESOURCE_STRING"]["button_back"]."\" onClick=\"javascript:window.history.go(-1)\" class=\"button\">\n";

    /// toto je vyuziti tohoto globalniho parametru, ktery se pouziva ve fci HasAccessToRecord,
    /// ktera se vola ve Form_(), abych se vyhnul kontrole, protoze nemuze spravne zafungovat,
    /// protoze ma PROPERTIES z jine agendy a EDIT_ID/DELETE_ID z UPLOADU
    if($GLOBALS['EDIT_ID']) $role = "update";
    elseif($GLOBALS['DELETE_ID'] || $GLOBALS['DELETE_ID_H']) $role = "delete";
    if($role) $GLOBALS["PROPERTIES"]["NO_TABLE"] = $this->HasAccessToUploadRecord($role);

    if(!$GLOBALS['DELETE_ID']){ ///nejedna se o mazani

      if($GLOBALS['UPLOAD_FILE']){
        $maxfilesize = $this->GetMaxFileSizeUpload();
        if($maxfilesize && $maxfilesize < $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['size']){
          $this->FlushMesg('Soubor je pli velik '.number_format(round($GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['size']/1024),'','',' ').'kB (max. '.number_format(round($maxfilesize/1024),'','',' ').'kB)<br>&nbsp;<br>&nbsp;');
          die($button_back);
        }
      }
      
      if (!$GLOBALS['EDIT_ID'] && (!$GLOBALS['UPLOAD_FILE'] || $GLOBALS['UPLOAD_FILE']=="none") && !($GLOBALS['UPL_FILE'] && $GLOBALS['UPL_DIR'])){ ///jedna se o nepovedeny UPLOAD
        $this->FlushMesg('Chyb soubor, nebo je pli velik  !!!<br>&nbsp;<br>&nbsp;');
        die($button_back);
      }

      // ziskani konfigurace
      if ($this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name]) {
        $upload_config = $this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name];
      }
      else {
        $upload_config = $this->config;
      }

      // zjisteni typu a omezeni na nej
      if (!$GLOBALS['EDIT_ID'] &&
          $upload_config['ONLY_FILE_TYPES'] &&
          $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['type']) {
        // ziskani typu
        $command = 'file ' . $GLOBALS['UPLOAD_FILE'];
        exec($command, &$out);
        $type = ereg_replace("^[^:]*:", "", $out[0]);
        // ziskani typu podle mime-type
        unset($out);
        $command = 'file -i ' . $GLOBALS['UPLOAD_FILE'];
        exec($command, &$out);
        $type_mime = ereg_replace("^[^:]*:", "", $out[0]);
        if (!$type && !$type_mime) {
          $type = $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['type'];
        }
        $allowed = false;
        // projdi pole - muze typ obsahovat, nemusi se rovnat
        if (is_array($upload_config['ONLY_FILE_TYPES'])) {
          foreach ($upload_config['ONLY_FILE_TYPES'] as $file_type) {
            $file_type_check = ereg_replace("^_", "", $file_type);
            if (eregi($file_type_check, (ereg("^[^_]", $file_type) && $type_mime) ? $type_mime : $type)) {
              $allowed = true;
            }
          }
        }
        // obsahuje jen jednu hodnotu
        else {
          $file_type_check = ereg_replace("^_", "", $upload_config['ONLY_FILE_TYPES']);
          if (eregi($file_type_check, (ereg("^[^_]", $upload_config['ONLY_FILE_TYPES']) && $type_mime) ? $type_mime : $type)) {
            $allowed = true;
          }
        }

        // je povoleno?
        if (!$allowed) {
          $this->FlushMesg('Soubor typu ['.$type.'] nen pro upload povolen!<br>&nbsp;<br>&nbsp;');
          die($button_back);
        }
      }

      $tmp_dir = '/tmp/upload/';

      $tmp_file = '';
      $archiv_file = '';

      if($GLOBALS['UPL_FILE'] && $GLOBALS['UPL_DIR']){
         $tmp_file =  $tmp_dir.$GLOBALS['UPL_DIR'].'/'.$GLOBALS['UPL_FILE'];
         if(file_exists(FileSystemConvertFNToFS($tmp_file))){
           $GLOBALS['RENAME_NEW'] = strtr(trim($GLOBALS['RENAME_NEW']),'\/:*?"<>|&','__________');
           $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['tmp_name'] = $tmp_file;
           $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["name"] = $GLOBALS['RENAME_NEW']?$GLOBALS['RENAME_NEW']:$GLOBALS['UPL_FILE'];
           $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["type"] = $GLOBALS['UPL_TYPE'];
           $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["size"] = $GLOBALS['UPL_SIZE'];
         }else{
           $this->FlushMesg('Chyb soubor v zloze !!!<br>&nbsp;<br>&nbsp;');
           die($button_back);
         }
      }

      ///pokud je zaroven v editu upload a rename
      $GLOBALS['RENAME'] = strtr(trim($GLOBALS['RENAME']),'\/:*?"<>|&','__________');
      if($GLOBALS['RENAME'] && $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["name"]){
        $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["name"] = $GLOBALS['RENAME'];
        unset($GLOBALS['RENAME']);
      }

      if($GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["name"]){

        $dir_arr = $this->GetUploadDir(); ///pokud se jedna o vkladani, tak $UPL_RECORD["RECORD_ID"] je prazdne => pouzije RECORD_ID

        $file_name = $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["name"];

        $dir_upl = $dir_arr[0];
        $file_upl = $dir_upl.$file_name;

        ///jedna se o ZIP
        $file_is_zip = $this->IsZipTypeFile($GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['type']);

        ///kontrola na existenci stejne prilohy pro dany zaznam a agendu
        $file_is_exists = file_exists(FileSystemConvertFNToFS($file_upl));

        ///jedna se o EDIT a jmeno souboru je jine, nez puvodni
        $upl_file_have_new_name = ($GLOBALS['EDIT_ID'] && strcasecmp($this->UPL_RECORD['NAME'],$file_name));

        ///pekne zkurvena podminka, ale vypada to, ze maka jak ma
        ///podminka se snazi vystihnou stav kdy nazev nebo novy nazev je shodny s jinym existujicim souborem, nebo se pta pouze na archivaci
        if(
            (($file_is_exists &&
              (substr($GLOBALS['COSTIM'],0,6)!='archiv' ||
                (substr($GLOBALS['COSTIM'],0,6)=='archiv' && $GLOBALS['RENAME_NEW'] && strcasecmp($this->UPL_RECORD['NAME'],$file_name))
               )) ||
             ($GLOBALS['EDIT_ID'] && substr($GLOBALS['COSTIM'],0,6)!='archiv') ||
             ($file_is_zip && !$GLOBALS['EDIT_ID'] && !$GLOBALS['COSTIM'] && !$GLOBALS['RENAME_NEW'])
            )
          ){

          $frm_rename = false;
          $frm_archiv = false;
          $frm_zip    = false;

          if($GLOBALS['UPL_DIR']){
            $uniqid_dir = $GLOBALS['UPL_DIR'];
            $tmp_dir .= $uniqid_dir.'/';
          }else{ ///tady se musi soubor zazalohovat, aby se mohl v dalsim kroku pouzit
            $uniqid_dir = uniqid('');
            $tmp_dir .= $uniqid_dir.'/';
            $this->CreateDir($tmp_dir,true);

            if(!@move_uploaded_file(FileSystemConvertFNToFS($GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['tmp_name']), FileSystemConvertFNToFS($tmp_dir.$file_name))){
              $this->FlushMesg('Soubor <i>'.$file_name.'</i> <b>NELZE</b> nahrt do zlohy !!!<br>&nbsp;<br>&nbsp;');
              die($button_back);
            }
          }

          include_once($GLOBALS["TMAPY_LIB"]."/oohformsex.inc");

          $f = new formex;
          $GLOBALS["show_typ"]=2;
          if($GLOBALS['EDIT_ID']) $f->ae(array( type=>"hidden", name=>"EDIT_ID"));
          $f->ae(array( type=>"hidden", name=>"show_typ"));
          $f->ae(array( type=>"hidden", name=>"UPL_FILE", "value"=>$file_name));///POZOR: param "value" zafunguje pouze v pripade ze neexistuje globalni promenna
          $f->ae(array( type=>"hidden", name=>"UPL_DIR", "value"=>$uniqid_dir));
          $f->ae(array( type=>"hidden", name=>"UPL_TYPE", "value"=>$GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["type"]));
          $f->ae(array( type=>"hidden", name=>"UPL_SIZE", "value"=>$GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["size"]));
          $f->ae(array( type=>"submit", name=>"__", value=>"Pokraovat"));
          $f->ae(array( type=>"button_close", name=>"___", value=>"Konec"));

          if(!$GLOBALS['EDIT_ID'] && $file_is_exists){  ///INSERT se stejnym nazvem
            $frm_caption = "<div class=\"caption\">POZOR: $file_name existuje !</div>\n";
            $f->ae(array( type=>"text", name=>"RENAME_NEW", size=>20, required=>true, label=>"Nov pejmenovat na", 'add'=>'class="required"'));
            $frm_rename = true;
          }
          elseif($GLOBALS['EDIT_ID'] && !$file_is_exists){  ///EDIT pod jinym nazvem
            $frm_caption = "<div class=\"caption\">Archivovat pvodn soubor ?</div>\n";
            $frm_archiv = true;
          }
          elseif($GLOBALS['EDIT_ID'] && $file_is_exists){  ///EDIT pod stejnym nazvem (jeste se musi rozlisit, zda je shoda se stejnym zaznamem, nebo s jinym)
            if($upl_file_have_new_name){ ///nazev souboru je neni shodny s nazvem prave editovaneho zaznamu
              $frm_caption = "<div class=\"caption\">POZOR: $file_name m shodn nzev s jinou plohou!</div>\n";
              $f->ae(array( type=>"text", name=>"RENAME_NEW", size=>20, required=>true, label=>"Nov pejmenovat na", 'add'=>'class="required"'));
              $frm_rename = true;
            }else{
              $frm_caption = "<div class=\"caption\">Archivovat pvodn soubor ?</div>\n";
            }
            $frm_archiv = true;
          }
          elseif(!$GLOBALS['EDIT_ID'] && $file_is_zip){ //INSERT ZIP souboru
            $frm_caption = "<div class=\"caption\">Vkldte ZIP soubor</div>\n";
            $frm_zip = true;
          }

          ///vytvori vlastni form
          $f->start("frm","GET","ug_file.php","","frm");
          echo $frm_caption;
          ?>
          <table width="100%">
          <tr><td align="left">
          <br>
          <?php
          if($frm_rename){
            echo '<span class="text">Nov pejmenovat na</span>&nbsp;';
            echo $f->se("RENAME_NEW");
            echo "<br>\n";
          }
          if($frm_archiv){
            echo '<input type="radio" name="COSTIM" value="archiv_a" class="radio" checked="checked"><span class="text">pvodn archivovat ANO</span><br>';
            echo '<input type="radio" name="COSTIM" value="archiv_n" class="radio"><span class="text">pvodn archivovat NE</span>';
          }
          if($frm_zip){
            echo '<input type="radio" name="COSTIM" value="unzip_n" class="radio" checked="checked"><span class="text">NEROZBALOVAT a ponechat jako ZIP</span><br>';
            echo '<input type="radio" name="COSTIM" value="unzip_a" class="radio"><span class="text">rozbalit a uloit jednotliv soubory z archivu zvlṻ</span>';
          }
          ?>
          <tr><td><hr></td></tr>
          <tr><td align="right"><?php echo $f->se("__")?>&nbsp;&nbsp;&nbsp;<?php echo $f->se("___")?>
          </table>
          <?php

          $fields = array();
          foreach($this->upl_tab_met as $arr) $fields[]=$arr[name];

          CreateHiddenForVars(true,'',$fields);

          $f->finish();
          ///konec mezikroku pri shode jmen, nebo dotazu na archivaci pri editu
          return true;
        }

        ///zde vytvori vlastni adresar, kam se ma kopirovat
        $this->CreateDir($dir_upl, true);

        ///archivace puvodniho souboru
        if($GLOBALS['COSTIM']=='archiv_a' && $GLOBALS['EDIT_ID']){
          if(file_exists(FileSystemConvertFNToFS($this->FILE))){
            $archiv_dir = $this->main_dir.$this->UPL_RECORD["DIRECTORY"].'archiv/';
            $this->CreateDir($archiv_dir, false);
            $arch_count = '001';
            $archiv_file = $GLOBALS['EDIT_ID'].'_'.$arch_count.'_'.$this->UPL_RECORD["NAME"];
            while(file_exists(FileSystemConvertFNToFS($archiv_dir.$archiv_file))){
              $arch_count=str_pad($arch_count+1,3,'0',STR_PAD_LEFT);
              $archiv_file = $GLOBALS['EDIT_ID'].'_'.$arch_count.'_'.$this->UPL_RECORD["NAME"];
            }
            copy(FileSystemConvertFNToFS($this->FILE),FileSystemConvertFNToFS($archiv_dir.$archiv_file));
          }else{
            //$this->FlushMesg('Soubor <i>'.$file_name.'</i> pro archivaci zmizel ???<br>&nbsp;<br>&nbsp;');
            //die($button_back);
          }
        }

        $zip_files_arr = array();

        //pri INSERTU se vlozil ZIP soubor a chce jej rozbalit a ulozit jednotlive soubory
        if($GLOBALS['COSTIM']=='unzip_a' && !$GLOBALS['EDIT_ID']){

          $this->FlushMesg("Rozbaluji ZIP soubor ...");

          //rozbaleni archivu a smazani ZIP souboru
          $zip_dir = dirname($tmp_file);
          exec("unzip -j -o $tmp_file -d $zip_dir");
          unlink($tmp_file);
          //exec("/tmp/convmv-1.07/convmv --notest -f iso-8859-1 -t utf-8 $zip_dir/*");
          $this->FlushMesg("<hr>");

          $no_exist_some_zipfile = true;

          //vypis souboru z archivu
          $d = dir($zip_dir);

          while($entry=$d->read()) {

            if($entry[0]!='.'){
              /*
              if(!file_exists(FileSystemConvertFNToFS($zip_dir.'/'.FileSystemConvertFNFromFS($entry)))){
                if(file_exists($zip_dir.'/'.$entry)){
                  $entry_new = iconv('WINDOWS-1250',$GLOBALS["TMAPY_CONFIG"]['ENCODING']['FILESYSTEM'],$entry);
                  if($entry_new){
                    echo "$entry -- $entry_new -- ".FileSystemConvertFNToFS($entry_new)."<br>";
                    rename($zip_dir.'/'.$entry, $zip_dir.'/'.$entry_new);
                    $entry = $entry_new;
                  }
                }
              }else{
                $entry = FileSystemConvertFNFromFS($entry);
              }
              */

              $entry = FileSystemConvertFNFromFS($entry);

              $zip_file_path_new = $dir_upl.'/'.$entry;

              if(file_exists(FileSystemConvertFNToFS($zip_file_path_new))){
                $no_exist_some_zipfile = false;
                $this->FlushMesg($entry.'&nbsp;<i><b>tento soubor ji EXISTUJE !</b></i>');
              }elseif(!file_exists(FileSystemConvertFNToFS($zip_dir.'/'.$entry))){
                $this->FlushMesg($entry.'&nbsp;<i><b>tento soubor NENALEZEN !</b></i>');
              }else{
                $this->FlushMesg($entry);
                $zip_files_arr[] = $entry;
              }

            }
          }
          $d->close();

          $tmp_file = '';

        }

        ///prekopiruje uploadnuty soubor z /tmp do pozadovaneho adresare pod orig. nazvem
        if($tmp_file){

          $ret = copy(FileSystemConvertFNToFS($GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['tmp_name']), FileSystemConvertFNToFS($file_upl));
          @unlink(FileSystemConvertFNToFS($GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['tmp_name']));
          @rmdir(FileSystemConvertFNToFS($tmp_dir.$GLOBALS['UPL_DIR']));

        }elseif($zip_files_arr && $no_exist_some_zipfile){ //jedna se o rozbaleny ZIP archiv a nema zadne existujici soubory jiz uploadovane
          foreach($zip_files_arr as $zip_file){
            $zip_file_path_tmp = $zip_dir.'/'.$zip_file;
            $zip_file_path_new = $dir_upl.$zip_file;
            $ret = copy(FileSystemConvertFNToFS($zip_file_path_tmp), FileSystemConvertFNToFS($zip_file_path_new));
            if(!$ret) break;
            @unlink(FileSystemConvertFNToFS($zip_file_path_tmp));
            @rmdir(FileSystemConvertFNToFS($zip_dir));
          }

        }elseif(!$no_exist_some_zipfile && $zip_files_arr){
          $ret = false;
        }else{//klasicky uploadovany soubor
          $ret = move_uploaded_file(FileSystemConvertFNToFS($GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']['tmp_name']), FileSystemConvertFNToFS($file_upl));
        }

        ///pokud jsou v poradku soubor(y) prekopirovany
        if($ret){

          if($zip_files_arr) $files_arr = $zip_files_arr;
          else $files_arr = array($file_name);
          $for_RUN_GLOBALS = array();

          foreach($files_arr as $file_name){

            $file_upl2 = $dir_upl.$file_name;

            //$for_RUN_GLOBALS[$file_name]['TYPEFILE'] = $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["type"];
            $for_RUN_GLOBALS[$file_name]['TYPEFILE'] = $this->GetMimeContentType($file_upl2, $GLOBALS['HTTP_POST_FILES']['UPLOAD_FILE']["type"]);
            $for_RUN_GLOBALS[$file_name]['FILESIZE'] = filesize($file_upl2);
            $for_RUN_GLOBALS[$file_name]['NAME'] = $file_name;
            $for_RUN_GLOBALS[$file_name]['DIRECTORY']  = '/'.$dir_arr[2].'/'.$dir_arr[3];

            //navic, pokud se jedna o obrazek
            if($info = GetImageSize(FileSystemConvertFNToFS($file_upl2))){ ///jedna se o obrazek
              $for_RUN_GLOBALS[$file_name]['ISIMAGE'] = 'y';
              $for_RUN_GLOBALS[$file_name]["WIDTH"] = $info[0];
              $for_RUN_GLOBALS[$file_name]["HEIGHT"] = $info[1];
              $for_RUN_GLOBALS[$file_name]['TYPEFILE'] = $info['mime'];
              $image_preview_dir = $dir_upl.'preview';
              $image_preview_filename = $image_preview_dir.'/'.$file_name;
              $this->CreateDir($image_preview_dir, false);
              $this->CreatePreview($file_upl2, $image_preview_filename, $info);
            }else{
              $for_RUN_GLOBALS[$file_name]['ISIMAGE'] = 'n';
              $for_RUN_GLOBALS[$file_name]["WIDTH"] = false;
              $for_RUN_GLOBALS[$file_name]["HEIGHT"] = false;
            }
          }

        }else{

          $this->FlushMesg('<br>Soubor <i>'.$file_name.'</i> <b>NELZE</b> nahrt !!!<br>&nbsp;<br>&nbsp;');
          die($button_back);

        }

        if($upl_file_have_new_name && $GLOBALS['EDIT_ID']){ ///smaze puvodni soubor, pokud se jinak jmenoval
          if (file_exists(FileSystemConvertFNToFS($this->FILE)) && !@unlink(FileSystemConvertFNToFS($this->FILE))){
            $this->FlushMesg('<div class="text">Soubor nelze smazat !</div><br><br>');
            die($button_back);
          }
        }

      }

      if ($GLOBALS['EDIT_ID'] && trim($GLOBALS['RENAME'])){

        $frename = strtr(trim($GLOBALS['RENAME']),'\/:*?"<>|&','__________');

        $file_new = $this->main_dir.$this->UPL_RECORD["DIRECTORY"].$frename;

        if (file_exists(FileSystemConvertFNToFS($file_new))){
          $this->FlushMesg('<div class="text">Soubor s tmto nzvem existuje.</div><br><br>');
          die($button_back);
        }

        if (file_exists(FileSystemConvertFNToFS($this->FILE)) && !rename(FileSystemConvertFNToFS($this->FILE),FileSystemConvertFNToFS($file_new))){
          $this->FlushMesg('<div class="text">Soubor nelze pejmenovat !</div><br><br>');
          die($button_back);
        }
        $GLOBALS['NAME'] = $frename;
      }


    }

    ///zde se podstrci fci Run() jine hodnoty
    $GLOBALS['PROPERTIES']['AGENDA_TABLE'] = $this->upl_table;
    $GLOBALS['PROPERTIES']['AGENDA_ID'] = 'ID';
    $GLOBALS['PROPERTIES']['DB_NAME'] = $this->config["DB_NAME"]?$this->config["DB_NAME"]:"DB_DEFAULT";
    $GLOBALS["PROPERTIES"]["FIELD_OWNER_ID"] = "OWNER_ID";
    $GLOBALS["PROPERTIES"]["FIELD_UPDATE_DATE"] = "LAST_DATE";
    $GLOBALS["PROPERTIES"]["FIELD_UPDATE_TIME"] = "LAST_TIME";
    $GLOBALS["PROPERTIES"]["FIELD_UPDATE_ID"] = "LAST_USER_ID";


    ///no a zde dochazi k vlastnimu uprave zaznamu !!!
    if($for_RUN_GLOBALS){
      foreach($for_RUN_GLOBALS as $file_name_arr){
        foreach($file_name_arr as $name => $value) $GLOBALS[$name] = $value;
        unset($GLOBALS['ID']);
        $GLOBALS['NEW_ID_UPLOAD'] = Run_(array("outputtype"=>1,"no_unsetvars"=>true));
      }
    }else{
      $GLOBALS['NEW_ID_UPLOAD'] = Run_(array("outputtype"=>1,"no_unsetvars"=>true));
    }


    //FullText - begin - TOKR
    if ($GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']) {
      if ($GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_FILE'])
        include_once(FileUp2('.admin/db/'.$GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_FILE']));
      if ($GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_NAME'])
        $qft = new $GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_NAME'];
    }
    //end

    //FullText - begin - TOKR
    if ($qft && $GLOBALS['NEW_ID_UPLOAD']) {
      InsertIntoFullText(&$qft, $GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['TABLE'], $GLOBALS['NEW_ID_UPLOAD'], $this->main_dir.$GLOBALS['DIRECTORY'].$GLOBALS['NAME']);
    }

    $table_h = $GLOBALS['upl_table'].'_h';

    if($GLOBALS['EDIT_ID']){ ///puvodni zapise do historie

      $meth = $this->q->metadata($table_h);
      foreach($this->UPL_RECORD as $key => $val) $GLOBALS[$key]=$val;

      if($archiv_file){ ///byl archivovan i soubor
        $GLOBALS['NAME']=$archiv_file;
        $GLOBALS['DIRECTORY'].='archiv/';
        ///aby se pripadne nazvy v historii prejmenovali podle nazvu archivniho souboru
        $sql = "UPDATE $table_h SET name='$GLOBALS[NAME]', directory='$GLOBALS[DIRECTORY]' WHERE id=$GLOBALS[EDIT_ID] AND name='$this->UPL_RECORD[NAME]'";
        $this->q->query($sql);
      }

      $seth = "INSERT INTO $table_h ";
      $seth .= CreateValuesSQLFromVar($meth);
      $this->q->query($seth);

      //FullText - begin - TOKR
      if ($qft) {
        InsertIntoFullText(&$qft, $GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['TABLE'].'_h', $GLOBALS['NEW_ID_UPLOAD'], $this->main_dir.$GLOBALS['DIRECTORY'].$GLOBALS['NAME'], $q->getlastid($table_h, ID_H));
      }

    }
    elseif($GLOBALS['DELETE_ID']){ ///jedna se o mazani

      ///smaze vlastni soubor z disku
      if (file_exists(FileSystemConvertFNToFS($this->FILE))){

        $info = GetImageSize(FileSystemConvertFNToFS($this->FILE));

        if(!@unlink(FileSystemConvertFNToFS($this->FILE))){

          $this->FlushMesg('Soubor nelze smazat !<br>&nbsp;<br>&nbsp;');
          die($button_back);

        }elseif($info){ //smazat i pripadne preview

          $files_prw_del = $this->AddId2FileName($this->FILE_preview,'*');

          exec('rm -f '.FileSystemConvertFNToFS($files_prw_del));
        }

      }
      ///smaze soubory z archivu
      $archiv_dir = $this->main_dir.$this->UPL_RECORD["DIRECTORY"].'archiv/';
      $this->DeleteHistFiles($GLOBALS['DELETE_ID'],$archiv_dir);

      ///smaze db zaznamy z histori
      $sql = 'DELETE FROM '.$table_h.' WHERE id='.$GLOBALS['DELETE_ID'];
      $this->q->query($sql);

      //FullText - begin - TOKR
      if ($qft) {
        $qft->query('DELETE FROM '.$GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['TABLE'].' WHERE id='.$GLOBALS['DELETE_ID']);
        $qft->query('DELETE FROM '.$GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['TABLE'].'_h WHERE id='.$GLOBALS['DELETE_ID']);
      }

    }

    if(!$this->no_close_after_delete){
      echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
      echo "  if (window.opener.parent.frames[1]!=null) {\n";
      echo "    window.opener.parent.frames[1].location.reload(1);\n";
      echo "  }else if(window.opener!=null) {\n";
      echo "    window.opener.location.reload(1);\n";
      echo "    if(window.opener.opener.parent.frames[1]!=null) \n";
      echo "       window.opener.opener.parent.frames[1].location.reload(1);\n";
      echo "  }\n";
      echo "  window.close();\n";
      echo "</script>\n";
    }

  }


  /**
   Delete
  **/
  function ShowUploadDelete() {

    include_once($GLOBALS["TMAPY_LIB"]."/oohformsex.inc");
    include_once(Fileup2(".admin/access_.inc"));

    if ((!Access())||(!HasSubRole("delete"))||(!$this->HasAccessToUploadRecord('delete'))):

      include_once(FileUp2("html_error.inc"));

      $f = new formex;
      $f->ae(array( type=>"button_close", name=>"__"));
      $f->start("","","","","");
      $f->se("__");
      $f->finish();

    elseif($GLOBALS['actiondelh']):  //maze z historie

      if (file_exists(FileSystemConvertFNToFS($this->FILE)) && !@unlink(FileSystemConvertFNToFS($this->FILE))){
        $this->FlushMesg('Soubor nelze smazat !<br>&nbsp;<br>&nbsp;');
        die($button_back);
      }

      echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
      echo "  if (window.opener.parent.frames[1]!=null) {\n";
      echo "    window.opener.parent.frames[1].location.reload(1);\n";
      echo "  }else if(window.opener!=null) {\n";
      echo "    window.opener.location.reload(1);\n";
      echo "    if(window.opener.opener.parent.frames[1]!=null) \n";
      echo "       window.opener.opener.parent.frames[1].location.reload(1);\n";
      echo "  }\n";
      echo "  window.close();\n";
      echo "</script>\n";

    else:

      $f = new formex;

      if($GLOBALS['DELETE_ID_H']): ///mazani souboru z historie

        echo "<span class=\"caption\">Ploha z historie - ".$GLOBALS["RESOURCE_STRING"]["delete"]."</span>\n";
        echo "<h4 class=filterblock>Chcete skuten smazat z historie nsledujc soubor ?</h4><br>\n";
        echo "<div class=text>".$this->UPL_RECORD['DIRECTORY']."<b>".$this->UPL_RECORD['NAME']."</b></div>\n";

        $GLOBALS["show_typ"]=3;
        $f->ae(array( type=>"hidden", name=>"DELETE_ID_H"));
        $f->ae(array( type=>"hidden", name=>"actiondelh", value=>"1"));

      else:

        echo "<span class=\"caption\">Plohy - ".$GLOBALS["RESOURCE_STRING"]["delete"]."</span>\n";
        echo "<h3 class=filterblock>".$GLOBALS["RESOURCE_STRING"]["record_delete_confirm"]."</h3>\n";

        $this->ShowUploadTable();

        $GLOBALS["show_typ"]=2;
        $f->ae(array( type=>"hidden", name=>"DELETE_ID"));

      endif;

      $frm_str="\n";
      $f->ae(array( type=>"hidden", name=>"show_typ"));
      $f->ae(array( type=>"hidden", name=>"upload_modul"));
      $f->ae(array( type=>"submit", name=>"__", value=>$GLOBALS["RESOURCE_STRING"]["button_yes"]));
      $f->ae(array( type=>"button_close", name=>"___", value=>$GLOBALS["RESOURCE_STRING"]["button_no"]));

      $f->start("frm_delete","GET","ug_file.php","","");
      echo $frm_str;
      echo "<table width='100%'>";
      echo "<tr><td align='right'>\n";
      $f->se("__");
      echo "&nbsp;&nbsp;&nbsp;";
      $f->se("___");
      echo "</table>\n";
      $f->finish();

    endif;
  }



  /**
  FullText - tokr
  **/
  function ShowUploadText() {

    include_once(FileUp2('.admin/upload_fce_.inc'));

    if ($GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_FILE'])
      include_once(FileUp2('.admin/db/'.$GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_FILE']));

    if ($GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_NAME']) {
      $qft = new $GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['DB_NAME'];
      $qft->query('SELECT text FROM '.$GLOBALS['SERVER_CONFIG']['UPLOAD_CONFIG']['FULL_TEXT']['TABLE'].' WHERE id = '.Round($GLOBALS['ID']));
      if ($qft->next_record()) $text = $qft->Record['TEXT'];
      $text = preg_replace('/(.{100})/', '\\1'."\n", $text);
      $text = preg_replace('/\.{3,}/', '...', $text);
      if ($GLOBALS['FULLTEXT_UPLOAD']) {
        $ft = Upload_GetFulltextRegularExp($GLOBALS['FULLTEXT_UPLOAD'],true);
        $colors = array('red','green','blue','magenta','darkgray','black','darkblue');
        $i=0;
        foreach($ft as $val) {
          if ($val)
            $text = preg_replace('/'.$val.'/', ' <span style="color:white;background-color:'.$colors[$i++].'">\\1</span> ', $text);
          if ($i > Count($colors)-1) $i=0;
        }
      }

      echo '<pre>'.$text.'</pre><script>var els=document.getElementsByTagName("SPAN");'."\n".'if (els && els[0]) window.scrollBy(0,els[0].offsetTop-50);</script>';
    }

  }


  /**
  Vrati celou cestu k adresari, kam se ukladaji soubory pro konkretni agendu a zaznam dle definice v PROPERTIES.
  Nazev hlavniho adresare je bud dle nastaveni, nebo je to AGENDA_IDENT.
  Nastaveni zpusobu skladani podadresare - je to seznam db polozek, nebo primo nazvy adresaru. U db polozek,
  lze navic nastavit i format:
    - bez niceho se vytvori jako hodnota te polozky
    - u datumove polozky lze urict, zda se adresar slozi pouze dle datumu, dtumu s mesicem nebo celeho datumu (date_format[year|month|day])
    - u ciselne polozky minimalni pocet cifer (min_dir_cif)
  Pokud neni nastaven zadny format, tak tvori adresar dle hodnoty PK do adresary dle aktualniho roku
  **/
  function GetUploadDir(){

    $arr = array();

    $RECORD_ID = $this->UPL_RECORD["RECORD_ID"]?$this->UPL_RECORD["RECORD_ID"]:$GLOBALS['RECORD_ID'];

    $AGENDA_RECORD = $this->GetRecordAgenda($RECORD_ID);

    $agend_dir= strtolower($this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name]['DIR']?$this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name]['DIR']:$this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']);
    $subdirs  = date('Y').'/'.$RECORD_ID.'/';

    if($this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name]['SUBDIRS']){

      $dir_ext = '';

      foreach($this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name]['SUBDIRS'] as $key => $val){

        $up_dir = $AGENDA_RECORD[strtoupper($key)];

        if (!$up_dir) $up_dir = $key; ///polozka v DB pod timto jmenem neni a

        if ($val["date_format"]){ ///jedna se o datumovou polozku
            $date = explode(".",$this->q_ag->dbdate2str($up_dir));
            switch ($val["date_format"]){
              case "year" : $up_dir = $date[2]; break;
              case "month" : $up_dir = $date[2].$date[1]; break;
              case "day" : $up_dir = $date[2].$date[1].$date[0]; break;
            }
        }
        elseif($val["min_dir_cif"]){ ///jedna se o ciselnou polozku
           $up_dir = str_pad($up_dir,$val["min_dir_cif"],"0",STR_PAD_LEFT);
        }
        $dir_ext .= strtr($up_dir,'\/:*?"<>|&','__________')."/";
      }
    }

    if($dir_ext) $subdirs = $dir_ext;

    $arr[] = $this->main_dir.'/'.$agend_dir.'/'.$subdirs;
    $arr[] = $this->main_dir;
    $arr[] = $agend_dir;
    $arr[] = $subdirs;

    return $arr;
  }


  function CreatePreview($file, $file_prw, $info, $size_arr=array(), $no_exec=false){

    $ret = array();

    if(!$size_arr) $size_arr = $this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name]['PREVIEW_SIZE_RATIO']?$this->config['AGENDA_PROPERTIES']['UPLOAD_CONFIG']["MODULES"][$this->modul_name]['PREVIEW_SIZE_RATIO']:$this->config['PREVIEW_SIZE_RATIO'];
    if(!$size_arr) $size_arr = array(80);

    $WIDTH  = $info[0];
    $HEIGHT = $info[1];

    if(!$WIDTH || !$HEIGHT) return false;

    $this->CreateDir(dirname($file_prw), false);

    foreach($size_arr as $size){

      // nastaveni procentualni zmeny velikost obrazku podle vetsi strany
      if($WIDTH>$HEIGHT)
        $ratio = $WIDTH / $size;
      else
        $ratio = $HEIGHT / $size;

      //a ted priprav velikostne odpovidajici vysledek
      $new_w = round($WIDTH / $ratio);
      $new_h = round($HEIGHT / $ratio);

      $file_prw = $this->AddId2FileName($file_prw, $size);

      if(!$no_exec){
        $command = 'convert -geometry '.$new_w.'x'.$new_h.' "'.FileSystemConvertFNToFS($file).'" "'.FileSystemConvertFNToFS($file_prw).'"';
        @system($command, $result);
        if ($result != 0) {
          $this->ResizeImageUpload(
              FileSystemConvertFNToFS($file),
              FileSystemConvertFNToFS($file_prw),
              $new_w,
              $new_h
          );
        }
      }

      $ret[$size] = $file_prw;
    }

    return $ret;
  }


  function AddId2FileName($path_file,$id){
    $dir = dirname($path_file);
    $file = basename($path_file);

    if($poz = strrpos($file,'.')){
      $fname = substr($file,0,$poz);
      $fprip = substr($file,$poz);
    }else{
      $fname = $file;
      $fprip = '';
    }

    return $dir.'/'.$fname.'_'.$id.$fprip;
  }


  function IsApplTypeFile($mime_type){

    $ret = false;

    switch($mime_type):
      case 'application/msword' :
      case 'application/vnd.ms-excel' :
      case 'application/pdf' :
      case 'message/rfc822' :
      case 'text/rtf' :
      case 'application/octet-stream':
      case 'application/vnd.ms-project' :
      case 'application/vnd.ms-powerpoint' : $ret = true; break;
    endswitch;

    if(!$ret && strstr($mime_type,'application')) $ret = true;

    return $ret;
  }



  function IsZipTypeFile($mime_type){

    $ret = false;

    switch($mime_type):
      case 'application/x-zip-compressed' : $ret = true; break;
    endswitch;

    return $ret;
  }

  function UnzipArchivFoto($zip_file){
    $dir_zip = $GLOBALS["SERVER_CONFIG"]["UPLOAD_FOTO"]["TMP_UNZIP_DIR"]?$GLOBALS["SERVER_CONFIG"]["UPLOAD_FOTO"]["TMP_UNZIP_DIR"]:'/tmp/upload_zip';
    CreateDir($dir_zip);
    FlushMesg("Rozbaluji soubor ...");
    exec("unzip -j -o $zip_file -d $dir_zip");
    //die("unzip -o $zip_file -d $dir_zip");
    $d = dir($dir_zip);
    $i = 0;
    while($entry = $d->read()){ //zjistim zda je v adresari nejaky podporovany soubor
      if ($entry != "." && $entry != ".." && !is_dir($dir_zip."/".$entry)){
         $ext = end(explode(".",$entry));
         $file = $dir_zip."/".$entry;
         if (in_array(strtolower($ext),$GLOBALS["SERVER_CONFIG"]["UPLOAD_FOTO"]["UPLOAD_FILE"]) && getimagesize($file)){ //kontrola zda se jedna o obrazek
           $i++;
           //FlushMesg($entry);
         }else
           unlink($file);
      }
    }
    $d->close();
    return $i;
  }

  //pro kompatibilitu se starsi verzi
  function DeleteAllUploadForAgenda($record_id){
    $this->DeleteAllUploadForAgendaRecord($record_id);
  }

  ///smaze vsechny uploady, ktere patri konkretni agende a zaznamu
  function DeleteAllUploadForAgendaRecord($record_id){

    if(!$record_id) return false;

    $AGENDA_DELETE_ID = $GLOBALS["DELETE_ID"];

    if(!$this->HasAccessToUploadRecord('delete')){
      include_once(FileUp2("html_error.inc"));
      die($button_back);
    }

    $q = $this->q;

    $q->query('SELECT * FROM '.$this->upl_table.' WHERE record_id = '.$record_id.' AND agenda_ident=\''.$this->config['AGENDA_PROPERTIES']['AGENDA_IDENT']."'");

    while($q->next_record()){

       $this->UPL_RECORD = $q->Record;

       $this->FILE = $this->main_dir.$this->UPL_RECORD["DIRECTORY"].$this->UPL_RECORD["NAME"];
       $this->FILE_preview = $this->main_dir.$this->UPL_RECORD["DIRECTORY"].'preview/'.$this->UPL_RECORD["NAME"];

       $GLOBALS["DELETE_ID"] = $this->UPL_RECORD['ID'];

       $this->no_close_after_delete = true;
       $this->ActionRun();
    }

    $this->no_close_after_delete = false;
    $GLOBALS["DELETE_ID"] = $AGENDA_DELETE_ID;

  }


  function IsAnyUploadForRecord($record_id){

    $this->AGENDA_RECORD = $this->GetRecordAgenda($record_id);

    $q = $this->q;

    $add_where='';
    if($this->config['USER_INFO']["is_anonymous"] && $this->config['use_anonym_access']) $add_where.=" AND anonym='y'";

    $q->query('SELECT count(*) as pocet FROM '.$this->upl_table.' WHERE agenda_ident=\''.$this->config['AGENDA_PROPERTIES']['AGENDA_IDENT'].'\' AND record_id = '.$this->AGENDA_RECORD[$this->config['AGENDA_PROPERTIES']['AGENDA_ID']].$add_where);

    $q->next_record();

    return $q->Record['POCET'];
  }


  function DeleteHistFiles($id,$archiv_dir){
    if(!is_dir(FileSystemConvertFNToFS($archiv_dir))) return false;
    $d = dir(FileSystemConvertFNToFS($archiv_dir));
    while(false !== ($file = $d->read())) {
      if(is_file(FileSystemConvertFNToFS($archiv_dir).$file) && ereg('^'.$id.'.*$',FileSystemConvertFNFromFS($file)))
        @unlink(FileSystemConvertFNToFS($archiv_dir).$file);
    }
    $d->close();
    return true;
  }


  function SaveFileToAgendaRecord($file, $record_id){
    
    $ret = array();

    if(file_exists(FileSystemConvertFNToFS($file))){
    
      $GLOBALS['RECORD_ID'] = $record_id;
      $GLOBALS['AGENDA_IDENT'] = $this->config['AGENDA_PROPERTIES']['AGENDA_IDENT'];
      $dir_arr = $this->GetUploadDir();
      $dir_upl = $dir_arr[0];
      $file_upl = $dir_upl.basename($file);
      
      //unlink(FileSystemConvertFNToFS($file_upl));
      
      if(!file_exists(FileSystemConvertFNToFS($file_upl))){

        if(copy(FileSystemConvertFNToFS($file), FileSystemConvertFNToFS($file_upl))){

          $GLOBALS['TYPEFILE'] = $this->GetMimeContentType($file_upl);
          $GLOBALS['FILESIZE'] = filesize($file_upl);
          $GLOBALS['NAME'] = basename($file_upl);
          $GLOBALS['DIRECTORY'] = '/'.$dir_arr[2].'/'.$dir_arr[3];
          $GLOBALS['OWNER_ID'] = $this->config['USER_INFO']['ID'];
          $GLOBALS['LAST_USER_ID'] = $this->config['USER_INFO']['ID'];
          $GLOBALS['LAST_DATE'] = $this->q->date2dbdate();
          $GLOBALS['LAST_TIME'] = $this->q->time2dbtime();
          
          if($info = GetImageSize(FileSystemConvertFNToFS($file_upl))){ ///jedna se o obrazek
            $GLOBALS['ISIMAGE'] = 'y';
            $GLOBALS["WIDTH"] = $info[0];
            $GLOBALS["HEIGHT"] = $info[1];
            $GLOBALS['TYPEFILE'] = $info['mime'];
          }else{
            $GLOBALS['ISIMAGE'] = 'n';
            $GLOBALS["WIDTH"] = false;
            $GLOBALS["HEIGHT"] = false;
          }
          
          $sql = 'INSERT INTO '.$this->upl_table;
          $sql .= CreateValuesSQLFromVar($this->upl_tab_met);
          //echo $sql;
          
          $this->q->query($sql);
          $ret['ID'] = $this->q->getlastid($this->upl_table, 'ID');  
      
        }else{
          $ret['err_msg'] = basename($file).' - copy error to '.$file_upl;
          $ret['err_no'] = 3;
        }

      }else{
        $ret['err_msg'] = basename($file).' has been uploaded already';
        $ret['err_no'] = 2;
      }
      
    }else{
      $ret['err_msg'] = $file.' not exist';
      $ret['err_no'] = 1;
    }
    
    return $ret;
  }

}
?>
