<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: winnt.inc,v 1.2 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class  CNTServer {

  var $NTServer = "localhost";
  var $NetAPICOM;
  var $PhpVersion = 3;
  var $noCOM = false;
  var $groups = false;
  var $users = false;
  
  function RemoteUser() {
    $arr = explode("\\", getenv("REMOTE_USER"));
    if (Count($arr)==2):
      return $arr[1];
    else:
      return $arr[0];
    endif;
  }
  
  function CNTServer($NTServer="") {
    if ($this->noCOM) return false;
    $this->PhpVersion = PhpVersion(); 
    SetType($this->PhpVersion, "integer");
    if ($NTServer) $this->NTServer = $NTServer;
    if ($this->PhpVersion == 3):
      $this->NetAPICOM = COM_Load("NetAPIObj.AutoNetAPI");
      COM_Invoke($this->NetAPICOM, "SetServerName", $this->NTServer);
    else:
      $this->NetAPICOM = new COM("NetAPIObj.AutoNetAPI");
      $this->NetAPICOM->SetServerName($this->NTServer);
    endif;
  }
  
  function GetLocalGroupsForUser($user="") {
    $ret = array();
    if ($this->noCOM) return $ret;
    if (!$user) $user = $this->RemoteUser();
    if ($user): 
      if ($this->PhpVersion == 3):
        COM_Invoke($this->NetAPICOM, "SetUserName", $user);
        $str = COM_Get($this->NetAPICOM, "PropNetUserGetLocalGroups");
      else:
        $this->NetAPICOM->SetUserName($user);
        $str = $this->NetAPICOM->PropNetUserGetLocalGroups;
      endif;
      if ($str[0] != "0"):
        $spl = split("\|", $str);
        reset($spl);
        while (list($key, $val) = each($spl)):
          if ($val) $ret[$val] = $val;
        endwhile;
      endif;
    endif;
    return $ret;
  }

  function GetGroupsForUser($user="") {
    $ret = array();
    if ($this->noCOM) return $ret;
    if (!$user) $user = $this->RemoteUser();
    if ($user): 
      if ($this->PhpVersion == 3):
        COM_Invoke($this->NetAPICOM, "SetUserName", $user);
        $str = COM_Get($this->NetAPICOM, "PropNetUserGetGroups");
      else:
        $this->NetAPICOM->SetUserName($user);
//        $str = $this->NetAPICOM->PropNetUserGetGroups;
        $str = $this->NetAPICOM->PropNetUserGetGroups;
      endif;
      if ($str[0] != "0"):
        $spl = split("\|", $str);
        while (list($key, $val) = each($spl)):
          if ($val) $ret[$val] = $val;
        endwhile;
      endif;
    endif;
    return $ret;
  }

  function GetAllGroupsForUser($user="") {
    if ($this->groups):
      $ret = $this->groups;
    else:
      if (!$user) $user = $this->RemoteUser();
      $ret = $this->GetLocalGroupsForUser($user);
//    ShowArray($ret);
      $ret2 = $this->GetGroupsForUser($user);
      reset($ret2);
      while (list($key, $val) = each($ret2))
        $ret[$key] = $val;
      $this->groups = $ret;
    endif;
    return $ret;
  }
   
  function GetUsersForLocalGroup($group="") {
    $ret = array();
    if ($this->noCOM) return $ret;
    if ($group): 
      if ($this->PhpVersion == 3):
        COM_Invoke($this->NetAPICOM, "SetGroupName", $group);
        $str = COM_Get($this->NetAPICOM, "PropNetLocalGroupGetUsers");
      else:
        $this->NetAPICOM->SetGroupName($group);
        $str = $this->NetAPICOM->PropNetLocalGroupGetUsers;
      endif;
      if ($str[0] != "0"):
        $spl = split("\|", $str);
        while (list($key, $val) = each($spl)):
          if ($val) $ret[$val] = $val;
        endwhile;
      endif;
    endif;
    return $ret;
  }

  function GetUsersForGroup($group="") {
    $ret = array();
    if ($this->noCOM) return $ret;
    if ($group): 
      if ($this->PhpVersion == 3):
        COM_Invoke($this->NetAPICOM, "SetGroupName", $group);
        $str = COM_Get($this->NetAPICOM, "PropNetGroupGetUsers");
      else:
        $this->NetAPICOM->SetGroupName($group);
        $str = $this->NetAPICOM->PropNetGroupGetUsers;
      endif;
      if ($str[0] != "0"):
        $spl = split("\|", $str);
        while (list($key, $val) = each($spl)):
          if ($val) $ret[$val] = $val;
        endwhile;
      endif;
    endif;
    return $ret; 
  }
  
  function GetUsersForAllGroups($group="") {
    if ($this->users):
      $ret = $this->users;
    else:
      $ret = $this->GetUsersForLocalGroup($group);
      $ret2 = $this->GetUsersForGroup($group);
      reset($ret2);
      while (list($key, $val) = each($ret2))
        $ret[$key] = $val;
      $this->users = $ret;
    endif;
    return $ret;
  }

  function IsUserInGroups($groups="", $user="", $casesensitive=false) {
    if (!$groups && !users) return false;
    //Group
    if (!Is_Array($groups)) $groups = array($groups);
    $arr = $this->GetAllGroupsForUser($user);
    if ($casesensitive):
      reset($groups);
      while (list($key, $val) = each($groups)):
        if ($arr[$val]) return true;
      endwhile;
    else:
      $arr2 =  $arr;
      reset($ret2);
      while (list($key, $val) = each($arr2))
        $arr[StrToUpper($key)] = $key;
      reset($groups);
      while (list($key, $val) = each($groups))
        if ($arr[StrToUpper($val)]) return true;
    endif;
      
    return false;
  }

}

?>
