<?php
class Security_Obj_Main {

  var $groups = false;
  var $users = false;

  function Security_Obj_Main () {
  }
  
  function ConvertEncoding($ar) {
    global $SERVER_CONFIG;
    if ($SERVER_CONFIG['SECURITY']['AUTH_LANG'] && $GLOBALS['PROPERTIES']['DEFAULT_LANG'] && $SERVER_CONFIG['SECURITY']['AUTH_LANG']!=$GLOBALS['PROPERTIES']['DEFAULT_LANG']) {
      foreach($ar as $key=>$val) {
        if (Is_string($val)) {
          switch ($SERVER_CONFIG['SECURITY']['AUTH_LANG']) {
            case 'cz_win': $from='WINDOWS-1250'; break;
            case 'cz_iso': $from='ISO-8859-2'; break;
          }
          switch ($GLOBALS['PROPERTIES']['DEFAULT_LANG']) {
            case 'cz_win': $to='WINDOWS-1250'; break;
            case 'cz_iso': $to='ISO-8859-2'; break;
          }
          $ar[$key]=iconv($from, $to, $val); 
        }
      }
    }
    return $ar;
  }

  function RemoteUser($anonymous=false, $nodebug=false) {
    global $SERVER_CONFIG, $HTTP_SERVER_VARS;
    $arr = explode("\\", $HTTP_SERVER_VARS["REMOTE_USER"]);
//    $arr = explode("\\", getenv("REMOTE_USER"));
    if (Count($arr)==2):
      $ret = $arr[1];
    else:
      $ret = $arr[0];
    endif;

    if (!$ret) $ret = $GLOBALS["HTTP_SERVER_VARS"]["PHP_AUTH_USER"]; 
    if (!$ret && ($anonymous || $SERVER_CONFIG["SECURITY"]["ANONYMOUS_ACCESS"])) {
      $ret = $SERVER_CONFIG["SECURITY"]["ANONYMOUS_LOGIN"]?$SERVER_CONFIG["SECURITY"]["ANONYMOUS_LOGIN"]:$GLOBALS["RESOURCE_STRING"]["user_anon_login"]; 
    }
    if (!$nodebug) {
      include_once(FileUp2(".admin/agenda_func.inc"));
      $debug_ag = getAgendaPath("DEBUG", false);
      if (File_Exists($debug_ag."/.admin/get_user.inc")) {
        include($debug_ag."/.admin/get_user.inc");
        if ($GLOBALS["PROPERTIES_DEBUG"]["USER_NAME"]) {
          $ret = $GLOBALS["PROPERTIES_DEBUG"]["USER_NAME"];
        }
      }
    }
    return $ret;  
  }

  function GetAllGroupsForUser($user="") {
    if (!$this->groups[$user]):
      if (!$user) $user = $this->RemoteUser();
      $ret = $this->GetLocalGroupsForUser($user);
      $ret2 = $this->GetGroupsForUser($user);
      reset($ret2);
      while (list($key, $val) = each($ret2))
        $ret[$key] = $val;
      $this->groups[$user] = $this->ConvertEncoding($ret);
    endif;
    return $this->groups[$user];
  }
  
  function GetUsersForAllGroups($group="", $all_data=false ) {
    if (is_array($group)) $grp=Implode(',', $group); else $grp=$group;
    if (!$this->users[$grp]):
      $ret = $this->GetUsersForLocalGroup($group, $all_data);
      $ret2 = $this->GetUsersForGroup($group, $all_data);
      reset($ret2);
      while (list($key, $val) = each($ret2))
        $ret[$key] = $val;
        
      $this->users[$grp] = $this->ConvertEncoding($ret);
    endif;
    return $this->users[$grp];
  }

  function IsUserInGroups($groups="", $user="", $casesensitive=false) {
    if (!$groups && !users) return false;
    //Group
    if (!Is_Array($groups)) $groups = array($groups);
    $arr = $this->GetAllGroupsForUser($user);
    if ($casesensitive):
      reset($groups);
      while (list($key, $val) = each($groups)):
        if ($arr[$val]) return true;
      endwhile;
    else:
      $arr2 =  $arr;
      reset($arr2);
      while (list($key, $val) = each($arr2))
        $arr[StrToUpper($key)] = $key;
      reset($groups);
      while (list($key, $val) = each($groups))
        if ($arr[StrToUpper($val)]) return true;
    endif;
      
    return false;
  }
  
  function GetUserInfo($user=false, $force=false, $anonymous=false, $user_type=0) {
    global $SERVER_CONFIG;
    static $USER_INFO;
    if (!$user && !$user_type) $user = $this->RemoteUser($anonymous);
    if (!$this->user_info[$user] || $force) {
      if ($user) {
        $USER_INFO2 = $this->GetUserInfo_Func($user,$user_type);
      }
      if (!$USER_INFO2 && ($anonymous || $SERVER_CONFIG["SECURITY"]["ANONYMOUS_ACCESS"])) {
        $USER_INFO2 = array(
          "ID"=>0,
          "CODE"=>0,
          "LOGIN"=>$user, 
          "SHORT"=>$GLOBALS["RESOURCE_STRING"]["user_anon_short"], 
          "LNAME"=>$GLOBALS["RESOURCE_STRING"]["user_anon_name"], 
          "GROUP"=>$SERVER_CONFIG["SECURITY"]["ANONYMOUS_GROUP"]?$SERVER_CONFIG["SECURITY"]["ANONYMOUS_GROUP"]:"ANONYMOUS", 
          "GROUP_ID"=>$SERVER_CONFIG["SECURITY"]["ANONYMOUS_GROUP_ID"]?$SERVER_CONFIG["SECURITY"]["ANONYMOUS_GROUP_ID"]:0, 
        );
      } 
      
      if ($user == ($SERVER_CONFIG["SECURITY"]["ANONYMOUS_LOGIN"]?$SERVER_CONFIG["SECURITY"]["ANONYMOUS_LOGIN"]:$GLOBALS["RESOURCE_STRING"]["user_anon_login"])){
        $USER_INFO2["is_anonymous"] = true; 
      }
      $this->user_info[$user] = $this->ConvertEncoding($USER_INFO2);
      return $this->user_info[$user];
    } else { 
      return $this->user_info[$user];
    }
  }  
}

?>
