<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ldap_main.inc,v 1.2 2004/01/14 09:29:42 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class Security_Obj_LDAP extends Security_Obj_Main {

  var $Comma="'";
  var $connect=false;
  var $bind=false;
  var $base_dn=false;
  var $filter=false;
  
  function Security_Obj_LDAP() {
    global $SERVER_CONFIG;
    $this->Security_Obj_Main();
    if (!($this->connect=@ldap_connect($SERVER_CONFIG["SECURITY"]["AUTH_LDAP_SERVER"]))) Debug(array("msg"=>"ldap_main: Cannot connect to LDAP server.")); 
    if (!($this->bind=@ldap_bind($this->connect, $SERVER_CONFIG["SECURITY"]["AUTH_LDAP_USER"], $SERVER_CONFIG["SECURITY"]["AUTH_LDAP_PASSWORD"]))) Debug(array("msg"=>"ldap_main: Unable to bind to server."));  
  }
  
  function GetLocalGroupsForUser($user="") {
    return array();
  }

  function GetGroupsForUser($user="") {
    global $SERVER_CONFIG;

    $this->base_dn = $SERVER_CONFIG["SECURITY"]["AUTH_LDAP_BASE_DN_USER"];
    $this->filter = '('.$this->attr_username.'='.($user?$user:$SERVER_CONFIG["SECURITY"]["AUTH_LDAP_USER"]).")";

    $this->Security_Obj_LDAP();

    function search_memberOf($base_dn,$filter,$connect) {
      static $done;
      if (!isset($done)) $done = array();
      $result = array();
      if (!$done[$base_dn]) {
        $done[$base_dn] = true;
        if (!($search=@ldap_search($connect, $base_dn, $filter))) Debug(array("msg"=>"ldap_main: Cannot search user.")); 
        $member = ldap_get_entries($connect, $search);
        for ($i=0; $i<$member["count"]; $i++) {
          for ($j=0; $j<$member[$i]["memberof"]["count"]; $j++) {
            $name = Eregi_Replace("^[^=]+=([^,]*).*$", "\\1", $member[$i]["memberof"][$j]);
            $result[$name] = $name; 
            $result = array_merge($result, search_memberOf($member[$i]["memberof"][$j],"name=*",$connect));
          }  
        }
      }
      return $result;
    }
    $return_values = search_memberOf($this->base_dn,$this->filter,$this->connect);
    if ($this->connect) ldap_close($this->connect); 
   
    return $return_values;
  }

  function GetUsersForLocalGroup($group="") {
    return array();
  }

  function GetUsersForGroup($group="") {
    global $SERVER_CONFIG;

    $this->base_dn = $SERVER_CONFIG["SECURITY"]["AUTH_LDAP_BASE_DN_GROUP"];
    $this->filter = '('.$this->attr_username.'='.($group?$group:"").")";

    $this->Security_Obj_LDAP();

    function search_members($base_dn,$filter,$connect) {
      static $done;
      if (!isset($done)) $done = array();
      $result = array();
      if (!$done[$base_dn]) {
        $done[$base_dn] = true;
        if (!($search=@ldap_search($connect, $base_dn, $filter))) die("error #3"); 
        $member = ldap_get_entries($connect, $search);
        for ($i=0; $i<$member["count"]; $i++) {
          for ($j=0; $j<$member[$i]["member"]["count"]; $j++) {
            if (!($search_m=@ldap_search($connect, $member[$i]["member"][$j], "name=*"))) die("error #3_1"); 
            $member1 = ldap_get_entries($connect, $search_m);
            $user_type=true;
            for ($k=0; $k<$member1[0]["objectclass"]["count"]; $k++) if ($member1[0]["objectclass"][$k] == "group") $user_type=false;
            if ($user_type) {
              $name = Eregi_Replace("^[^=]+=([^,]*).*$", "\\1", $member[$i]["member"][$j]);
              $result[$name] = $name;
            } else {
              $result = array_merge($result, search_members($member[$i]["member"][$j],"name=*",$connect));
            } 
          }  
        }
      }
      return $result;
    }
    $return_values = search_members($this->base_dn,$this->filter,$this->connect);
    if ($this->connect) ldap_close($this->connect); 
   
    return $return_values;
    
  }
  
  function GetUserInfo_Func($user) {
    global $SERVER_CONFIG;
    $ret = false;

    $this->base_dn = $SERVER_CONFIG["SECURITY"]["AUTH_LDAP_BASE_DN_USER"];
    $this->filter = '('.$this->attr_username.'='.($user?$user:$SERVER_CONFIG["SECURITY"]["AUTH_LDAP_USER"]).")";

    $this->Security_Obj_LDAP();

    function search_userInfo($base_dn,$filter,$connect) {
      if (!($search=@ldap_search($connect, $base_dn, $filter))) Debug(array("msg"=>"ldap_main: Cannot search user.")); 
      $member = ldap_get_entries($connect, $search);

      $ret["LOGIN"] = $member[0]["samaccountname"][0];  //login
      $ret["SHORT"] = $member[0]["samaccountname"][0];  //login
      $ret["LNAME"] = $member[0]["sn"][0];  //prijmeni
      $ret["FNAME"] = $member[0]["givenname"][0];  //jmeno
      list($ret["TITLE1"], $ret["TITLE2"]) = Explode(',', $member[0]["title"][0]); //email
      $ret["EMAIL"] = $member[0]["mail"][0]; //email
      $ret["GROUP"] = $member[0]["company"][0]?$member[0]["company"][0]:$member[0]["department"][0]; //group
      
      $ret["WWW"] = $member[0]["wwwhomepage"][0];  //homepage
      $ret["STREET"] = $member[0]["streetaddress"][0]; //ulice
      $ret["CITY"] = $member[0]["l"][0]; //mesto
      $ret["P_CODE"] = $member[0]["postalcode"][0]; //psc
      $ret["H_PHONE"] = $member[0]["homephone"][0]; //telefon domu
      $ret["PHONE"] = $member[0]["telephonenumber"][0]; //telefon
      $ret["MOBILE"] = $member[0]["mobile"][0]; //mobil
      //$user["P_GROUP_ID"] = $member[0]["primarygroupid"][0];  //primary group_id
      return $ret;
    }

    $return_values = search_userInfo($this->base_dn,$this->filter,$this->connect);
    if ($this->connect) ldap_close($this->connect); 
   
    return $return_values;
    
  }
}
?>
