<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: db_main.inc,v 1.11 2006/07/31 15:45:25 tohu Exp $'.'$Name:  $';exit;}; /* HEADER */

class Security_Obj_DB extends Security_Obj_Main {

  var $Database="DB_DEFAULT";
  var $q;

  var $User_Table="security_user";
  var $User_Field_Login="login_name";
  var $User_Field_Id="id";
  var $User_Field_FName="fname";
  var $User_Field_LName="lname";
  var $User_Field_Title1="title_1";
  var $User_Field_Title2="title_2";
  var $User_Field_EMail="email";
  var $User_Field_Phone="phone";
  var $User_Field_Group="group_id";
  var $User_Field_Short="login_name";

  var $Group_Table="security_group";
  var $Group_Field_Name="name";
  var $Group_Field_Id="id";
  var $Group_Field_Type="type";
  var $Group_Field_Desc="description";

  var $User_Group_Table="security_u_g";
  var $User_Group_Field_User_Id="u_id";
  var $User_Group_Field_Group_Id="g_id";

  var $Login_Search_CaseInsensitive = false;
  
  var $Comma="'";

  function Security_Obj_DB($database=false) {
    $this->Security_Obj_Main();
    if ($GLOBALS["SERVER_CONFIG"]["SECURITY"]["AUTH_DATABASE_FILE"]) include_once(FileUp2($GLOBALS["SERVER_CONFIG"]["SECURITY"]["AUTH_DATABASE_FILE"]));
    if ($GLOBALS["SERVER_CONFIG"]["SECURITY"]["AUTH_DATABASE"]) $this->Database = $GLOBALS["SERVER_CONFIG"]["SECURITY"]["AUTH_DATABASE"]; 
    else if ($database) $this->Database = $database;
    $this->q = new $this->Database;
    if (Is_array($GLOBALS["SERVER_CONFIG"]["SECURITY"]["AUTH_OBJECT_PARAMS"])) {
      foreach ($GLOBALS["SERVER_CONFIG"]["SECURITY"]["AUTH_OBJECT_PARAMS"] as $key=>$val) {
        $this->$key=$val;
      }
    }
    if ($GLOBALS["SERVER_CONFIG"]["SECURITY"]["LOGIN_SEARCH_CASEINSENSITIVE"]) $this->Login_Search_CaseInsensitive = true;
  }
  
  function GetLocalGroupsForUser($user="") {
    return array();
  }

  function GetGroupsForUser($user="") {
    $ret = array();
    if (!$user) $user = $this->RemoteUser();
    if ($user):
      if($this->Login_Search_CaseInsensitive){
        $user = strtoupper($user);
        $sql = "SELECT ".$this->User_Field_Id." FROM ".$this->User_Table." WHERE UPPER(".$this->User_Field_Login.") = ".$this->Comma.$user.$this->Comma;
      }else{
        $sql = "SELECT ".$this->User_Field_Id." FROM ".$this->User_Table." WHERE ".$this->User_Field_Login." = ".$this->Comma.$user.$this->Comma;
      }  
      $this->q->Query($sql);
      if ($this->q->next_record()) {
        $sql = "SELECT g.".$this->Group_Field_Id.", g.".$this->Group_Field_Name." FROM ".$this->Group_Table." g, ".$this->User_Group_Table." ug WHERE g.".$this->Group_Field_Id." = ug.".$this->User_Group_Field_Group_Id." AND ".$this->User_Group_Field_User_Id." = ".$this->q->Record[0];
        $this->q->Query($sql);
        while ($this->q->next_record()) {
          $ret[$this->q->Record[1]] = $this->q->Record[0];
        }
      }
    endif;
    return $ret;
  }

  function GetUsersForLocalGroup($group="") {
    return array();
  }

  function GetUsersForGroup($group="", $all_data=false) {
    $ret = array();
    if ($group):
      $sql = "SELECT DISTINCT ".
      $sql .= " u.".$this->User_Field_Id." as ID";
      $sql .= ", u.".$this->User_Field_Id." as CODE";
      $sql .= ", u.".$this->User_Field_Login." as LOGIN";
      $sql .= ", u.".$this->User_Field_Short." as SHORT";
      $sql .= ", u.".$this->User_Field_FName." as FNAME";
      $sql .= ", u.".$this->User_Field_LName." as LNAME";
      $sql .= ", u.".$this->User_Field_Title1." as TITLE1";
      $sql .= ", u.".$this->User_Field_Title2." as TITLE2";
      $sql .= ", u.".$this->User_Field_EMail." as EMAIL";
      $sql .= ", u.".$this->User_Field_Phone." as PHONE";
      $sql .= ", g2.".$this->Group_Field_Name." as GRP";
      $sql .= " FROM ".$this->User_Table." u";
      $sql .= " LEFT JOIN ".$this->User_Group_Table." ug ON u.".$this->User_Field_Id." = ug.".$this->User_Group_Field_User_Id;
      $sql .= " LEFT JOIN ".$this->Group_Table." g ON ug.".$this->User_Group_Field_Group_Id." = g.".$this->Group_Field_Id;
      $sql .= " LEFT JOIN ".$this->Group_Table." g2 ON u.".$this->User_Field_Group." = g2.".$this->Group_Field_Id;
      $sql .= " WHERE";
      $sql .= " g.".$this->Group_Field_Name." IN (";

      if (!Is_array($group)) 
         $group=array($group);
      
      $sql .= $this->Comma.Implode($this->Comma.",".$this->Comma, $group).$this->Comma.")";
      
      foreach($group as $val)
         if(stristr($val,'%')) $sql .= ' OR g.'.$this->Group_Field_Name.' LIKE '.$this->Comma.$val.$this->Comma;      

      $sql .= " ORDER BY lname, fname";
         
      $this->q->Query($sql);
      while ($this->q->next_record()) {
        if ($all_data) 
          $ret[$this->q->Record["LOGIN"]] = $this->q->Record;
        else  
          $ret[$this->q->Record["LOGIN"]] = $this->q->Record["LOGIN"];
      }
    endif;
    return $ret; 
  }
  
  function GetUserInfo_Func($user,$type=0) {
    $ret = false;
    $sql  = "SELECT";
    $sql .= " u.".$this->User_Field_Id." as ID";
    $sql .= ", u.".$this->User_Field_Id." as CODE";
    $sql .= ", u.".$this->User_Field_Login." as LOGIN";
    $sql .= ", u.".$this->User_Field_Short." as SHORT";
    $sql .= ", u.".$this->User_Field_FName." as FNAME";
    $sql .= ", u.".$this->User_Field_LName." as LNAME";
    $sql .= ", u.".$this->User_Field_Title1." as TITLE1";
    $sql .= ", u.".$this->User_Field_Title2." as TITLE2";
    $sql .= ", u.".$this->User_Field_EMail." as EMAIL";
    $sql .= ", u.".$this->User_Field_Phone." as PHONE";
    $sql .= ", g.".$this->Group_Field_Name." as GRP";
    $sql .= ", u.".$this->User_Field_Group." as GROUP_ID";
//    $sql .= ", g.".$this->Group_Field_Name." as GROUP";
    $sql .= " FROM ".$this->User_Table." u, ".$this->Group_Table." g";
    $sql .= " WHERE";
    $sql .= " u.".$this->User_Field_Group." = g.".$this->Group_Field_Id;
    
    //login
    if( StrCmp($type, 0) == 0) {
      if($this->Login_Search_CaseInsensitive){
        $user = strtoupper($user);
        $sql .= " AND UPPER(u.".$this->User_Field_Login.") = ".$this->Comma.$user.$this->Comma;
      }else{  
        $sql .= " AND u.".$this->User_Field_Login." = ".$this->Comma.$user.$this->Comma;
      }  
    } else {
      $sql .= " AND u.".$this->User_Field_Id." = ".$this->Comma.$user.$this->Comma;
    }
//    if ($user == "jala") print_r($sql); 
    $this->q->Query($sql);
    if ($this->q->next_record()) $ret = $this->q->Record;
    if ($ret) $ret["GROUP"] = $ret["GRP"];
    return $ret;
  }

  function GetGroups($name_mask=false){
    $ret = array();
    $sql = 'SELECT '.$this->Group_Field_Id.','.$this->Group_Field_Name.','.$this->Group_Field_Desc.' FROM '.$this->Group_Table.' WHERE '.$this->Group_Field_Type.'=3';
    if($name_mask) $sql.= ' AND '.$this->Group_Field_Name." LIKE '$name_mask'";
    $this->q->Query($sql);
    while ($this->q->next_record())
      $ret[$this->q->Record[0]]= array($this->q->Record[1],$this->q->Record[2]);
    return $ret;
  }

  function GetUsers($name_mask=false,$all_data=false,$order_by=false){
    $ret = array();
    if (is_string($order_by)) $order_by = " order by ".$order_by;
    if($all_data)
      $sql = 'SELECT * FROM '.$this->User_Table.$order_by;
    else  
      $sql = 'SELECT '.$this->User_Field_Id.','.$this->User_Field_Login.','.$this->User_Field_FName.','.$this->User_Field_LName.' FROM '.$this->User_Table.$order_by;

    if($name_mask) $sql.= ' WHERE '.$this->User_Field_Login." LIKE '$name_mask'";

    $this->q->Query($sql);

    while ($this->q->next_record()){
      if($all_data){
        $ret[$this->q->Record[strtoupper($this->User_Field_Id)]] = $this->q->Record;
      }else{
        $ret[$this->q->Record[0]]=array($this->q->Record[1],$this->q->Record[2].' '.$this->q->Record[3]);
      }  
    }
    return $ret;
    
  }
}
?>
