<?php
require_once ('ApplicationModul.inc');


/**
 * @version 1.0
 * @created 10-IX-2004 15:58:05
 */
class TangoOqldsApplication extends ApplicationModul
{

	/**
	 * @param application
	 * 
	 */
	function GetDefineRightsForApplication($application)
	{
    $rights = array();

    if(!$this->applications) $this->GetApplicationsInfo();
    

    if($this->applications[$application]['access']){

      $rights = $this->applications[$application]['access'];

    }elseif($this->applications[$application]){
      
      //tady nemusi nic byt, protoze se to deje rovnou v GetApplicationsInfo();
      
      $this->applications[$application]['access'] = $rights;

    }

    return $rights;
	}

	/**
	 * @param right
	 * 
	 */
	function GetApplicationsForRight($right)
	{
	}
  

	function GetApplicationsInfo($only_reg=false)
	{
    $appl = array();
    $error = array();

    if($this->applications){
      
      $appl = $this->applications;

    }else{

      $url = $this->configuration['url'];

      $str_xml = $this->CurlConnection($url);
      
      $str_xml = iconv('WINDOWS-1250', $this->securityManager->configuration['CEU_GLOBAL_PARAMS']['ceu_charset'], $str_xml);
      
      $str_arr = explode("\n",$str_xml);
      
      foreach($str_arr as $index => $line){

        if($index==0) continue; //vynecham 1.radek

        $line = trim($line);

        if($line){

          $line_arr = explode('|',$line);

          if(count($line_arr)<2) die("<b>wrong data from Tango OQLDS:</b><br>\n".$str_xml);
            
            $ident = $line_arr[0];
            $desc = $line_arr[1];

            $appl[$ident] = array(
                             "ident"=>$ident,
                             "name"=>$ident,
                             "desc"=>$desc,
                             "rightCategories"=>array($ident=>array('category'=>$ident, 'desc'=>$ident)),
                             'access'=>array()
                            );
            
            for($i=2;$i<count($line_arr);$i++){
            
              $right_name = $line_arr[$i];
              $i++;
              $right_desc = $line_arr[$i];
              $ident_r = $ident.'|'.$ident.'|'.$right_name;
              
              $appl[$ident]['access'][$ident_r] = array(
                   'ident' => $ident,
                   'right_id' => $ident.'|'.$ident,
                   'name' => $right_name,
                   'category' => $ident,
                   'type' => 'p',
                   'desc' => $right_desc,
                   'config_name' => '',
              );
            }                 

        }
      }
      
      //die();

      /*
      $dom = domxml_open_mem($str_xml,DOMXML_LOAD_PARSING,$error);
      //$dom = new DOMDocument($str_xml);

      if($error){
        print_r($error);
        echo $str_xml;
      }

      $domdoc = $dom->document_element();
 
      $arr_xml = array();

      $this->dom_to_simple_array($domdoc, $arr_xml);

      if(!is_array($arr_xml)) die('Error: wrong data <br>'.$str_xml);
      
      //zpracuje XML prevedene na PHP array do tvaru pro CEU a prekoduje do spravneho kodovani z UTF-8
      foreach($arr_xml['applications'][0]['app'] as $val1){
        
        $ident = $val1['id'][0]['cdata'];
        $desc = iconv('UTF-8', $this->securityManager->configuration['CEU_GLOBAL_PARAMS']['ceu_charset'], $val1['desc'][0]['cdata']);
        
        $appl[$ident] = array(
                         "ident"=>$ident,
                         "name"=>$ident,
                         "desc"=>$desc,
                         "rightCategories"=>array($ident=>array('category'=>$ident, 'desc'=>$ident)),
                         'access'=>array()
                        );
        
        foreach($val1['rights'][0]['right'] as $val2){
          $right_name = $val2['id'][0]['cdata'];
          $right_desc = iconv('UTF-8', $this->securityManager->configuration['CEU_GLOBAL_PARAMS']['ceu_charset'], $val2['desc'][0]['cdata']);
          
          $ident_r = $ident.'|'.$ident.'|'.$right_name;
          
          $appl[$ident]['access'][$ident_r] = array(
               'ident' => $ident,
               'right_id' => $ident.'|'.$ident,
               'name' => $right_name,
               'category' => $ident,
               'type' => 'p',
               'desc' => $right_desc,
               'config_name' => '',
          );
          //echo "$right_name - $right_desc <br>";
        }
        
      }
      */
      $this->applications = $appl;
    }
    
    $appl_ret = array();
    $appl_ret['config']['name_modul'] = $this->configuration['name'];
    $appl_ret['applications'] = $appl;
    
    //print_r($appl_ret);
    
    return $appl_ret;
	}
  

  function dom_to_simple_array($domnode, &$array) {
    $array_ptr = &$array;
    $domnode = $domnode->first_child();
    
    while (!is_null($domnode)) {
  
     //if (! (trim($domnode->node_value()) == "") ) {
  
       switch ($domnode->node_type()) {
  
         case XML_TEXT_NODE: {
           $array['cdata'] = $domnode->node_value();
           break;
         }
         case XML_ELEMENT_NODE: {
           $array_ptr = &$array[$domnode->node_name()][];
           if ($domnode->has_attributes() ) {
             $attributes = $domnode->attributes();
             if (!is_array ($attributes)) {
               break;
             }
             foreach ($attributes as $index => $domobj) {
               $array_ptr[$index] = $array_ptr[$domobj->name()] = $domobj->value();
             }
           }
           break;
         }
       }
       if ( $domnode->has_child_nodes() ) {
         $this->dom_to_simple_array($domnode, $array_ptr);
       }
     //}
     $domnode = $domnode->next_sibling();
    }
  }
  
  
  function CurlConnection($url){

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.5 [en] (WinNT; I)');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->configuration['CurlParameters']['verifypeer']?true:false);
    curl_setopt($ch, CURLOPT_USERPWD, $this->configuration['CurlParameters']['username'].':'.$this->configuration['CurlParameters']['password']);
    
    $ret = curl_exec ($ch);

    $ch_code = curl_getinfo ($ch, CURLINFO_HTTP_CODE);

    if (!$ret) {
       die("error CURL Exec: ".curl_error($ch));
    } 
    if ($ch_code != 200) {
       die("error CURL Exec: return code ".$ch_code);
    }
  
    curl_close ($ch);

    return $ret;
  }

}
?>
