<?php
require_once ('ApplicationModul.inc');


/**
 * @version 1.0
 * @created 10-IX-2004 15:58:05
 */
class TWISTApplication_ExtCEU extends ApplicationModul
{

	/**
	 * @param application
	 * 
	 */
	function GetDefineRightsForApplication($application)
	{
    $rights = array();

    if(!$this->applications) $this->GetApplicationsInfo();
    

    if($this->applications[$application]['access']){

      $rights = $this->applications[$application]['access'];

    }elseif($this->applications[$application]){

      $output = 'serialize';

      $system = $this->configuration['source_system'];

      $url = $this->configuration['url'].'?type=DefineRightsForApplication&output='.$output.'&system='.$system.'&appl_ident='.$application;

      $str_arr = $this->CurlConnection($url);

      $arr = unserialize($str_arr);
      
      $rights = $arr[$system];
     
      $this->applications[$application]['access'] = $rights;

    }

    return $rights;
	}

	/**
	 * @param right
	 * 
	 */
	function GetApplicationsForRight($right)
	{
	}
  

	function GetApplicationsInfo($only_reg=false)
	{
    $appl = array();
    
    if($this->applications){
      
      $appl = $this->applications;

    }else{

      $output = 'serialize';

      $system = $this->configuration['source_system'];

      $url = $this->configuration['url'].'?type=applications&output='.$output.'&system='.$system;

      $str_arr = $this->CurlConnection($url);

      $arr = unserialize($str_arr);

      if(!is_array($arr)) die('Error: wrong data <br>'.$str_arr);
      
      $appl = $arr[$system]['applications'];

      $this->applications = $appl;
    }
    
    $appl_ret = array();
    $appl_ret['config']['name_modul'] = $this->configuration['name'];
    $appl_ret['applications'] = $appl;

    return $appl_ret;
	}
  
  
  
  function CurlConnection($url){

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.5 [en] (WinNT; I)');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->configuration['CurlParameters']['verifypeer']?true:false);
    curl_setopt($ch, CURLOPT_USERPWD, $this->configuration['CurlParameters']['username'].':'.$this->configuration['CurlParameters']['password']);
    
    $ret = curl_exec ($ch);

    $ch_code = curl_getinfo ($ch, CURLINFO_HTTP_CODE);

    if (!$ret) {
       die("error CURL Exec: ".curl_error($ch));
    } 
    if ($ch_code != 200) {
       die("error CURL Exec: return code ".$ch_code);
    }
  
    curl_close ($ch);

    return $ret;
  }

}
?>