<?php
require_once ('ApplicationModul.inc');


/**
 * @version 1.0
 * @created 10-IX-2004 15:58:05
 */
class TWISTApplication extends ApplicationModul
{

	/**
	 * @param application
	 * 
	 */
	function GetDefineRightsForApplication($application)
	{
    $rights = array();

    if(!$this->applications) $this->GetApplicationsInfo();
    

    if($this->applications[$application]['access']){

      $rights = $this->applications[$application]['access'];

    }elseif($this->applications[$application]){

      $dir = getcwd();
      chdir($GLOBALS["TMAPY_DIR"].'/'.$this->applications[$application]['path']);
      $acc_file = FileUp2('.admin/access.inc');
      $prop_file = FileUp2('.admin/properties.inc');
      
      $GLOBALS['_FROM_CEU_'] = true;
      
      if(file_exists($acc_file)){
        include($prop_file);
        include($acc_file);
        
        foreach($PROPERTIES_ACCESS as $acc_ident => $acc_s){

          ///dodatecne doplni rightCategories
          //$this->applications[$application]['rightCategories'][$acc_ident] = array('category'=>$acc_ident, 'desc'=>$acc_s['desc']);
          
          if($acc_s['rights']){
            foreach($acc_s['rights'] as $r => $acc){
              if(!$acc===false){ ///pokud je pravo rovno FALSE, tak ho ignoruj
                $ident = $application.'|'.$acc_ident;
                $ident_r = $ident.'|'.$r; 
                $rights[$ident_r] = array(
                              "ident"=>$application,
                              "right_id"=>$ident,
                              "name"=>$r,
                              "category"=>$acc_ident,
                              "type"=>'p',
                              "config_name"=>$this->configuration['name'],
                              );
                ///tady prida cele pole z definice prava
                if(is_array($acc)) $rights[$ident_r] = array_merge($rights[$ident_r],$acc);            
              }
            }                
          
          }else{
//            print_r($PROPERTIES_ACCESS);
            echo ('<div class="text">Chyba: sekce <b>'.$acc_ident.'</b> v <i>'.getcwd().$acc_file.'</i> neobsahuje definici prv !</div>');
          }
          
          if($acc_s['rightgroups']){
            foreach($acc_s['rightgroups'] as $r => $acc){
              if(!$acc===false){ ///pokud je pravo rovno FALSE, tak ho ignoruj
                $ident = $application.'|'.$acc_ident;
                $ident_r = $ident.'|'.$r; 
                $rights[$ident_r] = array(
                              "ident"=>$application,
                              "right_id"=>$ident,
                              "name"=>$r,
                              "category"=>$acc_ident,
                              "type"=>'g',
                              "config_name"=>$this->configuration['name'],
                              );
                ///tady prida cele pole z definice prava
                if(is_array($acc)) $rights[$ident_r] = array_merge($rights[$ident_r],$acc);            
              }
            }                
          }
        }
        
        $this->applications[$application]['access'] = $rights; 

        chdir($dir);
        unset($GLOBALS['_FROM_CEU_']);
      }
    }
    //print_r($this->applications[$application]);
    //print_r($rights);
    return $rights;
	}

	/**
	 * @param right
	 * 
	 */
	function GetApplicationsForRight($right)
	{
	}
  

	function GetApplicationsInfo($only_reg=false)
	{
    $appl = array();
    
    if($this->applications){
      
      $appl = $this->applications;

    }else{

      if(!$GLOBALS[SERVER_CONFIG]["AGENDA_PATH"]){
        include($GLOBALS["TMAPY_DIR"].'/.config/settings/agenda_path.inc');
        $ap = &$SERVER_CONFIG["AGENDA_PATH"];
      }else{
        $ap = &$GLOBALS[SERVER_CONFIG]["AGENDA_PATH"];
      }
      
      $dir = getcwd();
      $GLOBALS['_FROM_CEU_'] = true;
      
      foreach($ap as $ag_ident => $ag_path){
        $prop = $GLOBALS["TMAPY_DIR"].'/'.$ag_path.'/.admin/properties.inc';
        //$conf = $GLOBALS["TMAPY_DIR"].'/'.$ag_path.'/.admin/config.inc';

        if(file_exists($prop)){
//print_r($GLOBALS['PROPERTIES_ACCESS']);
//echo $ag_ident.'<br>';flush();          
          chdir($GLOBALS["TMAPY_DIR"].'/'.$ag_path);
          unset($PROPERTIES);
          //echo $prop."<br>";
          //@include($conf); ///pro jistotu se pokousi nacist i pripadny config.inc, protoze v nem muze byt AGENDA_IDENT, ale nechci pouzit chdir, protoze by se mohli includovat ostatni soubory, ktere by mohli vyvolat error z duvode redeklarace nejake fce nebo tridy
          include($prop);

          if(!$only_reg || $PROPERTIES['SECURITY_REGISTRATION']){ 
            
            if($PROPERTIES['SECURITY_REGISTRATION']){
              //$dir = getcwd();
             // chdir($GLOBALS["TMAPY_DIR"].'/'.$ag_path);
              //echo $prop."($PROPERTIES[AGENDA_IDENT])<br>";
              unset($PROPERTIES_ACCESS);
              @include('.admin/access.inc');
             // chdir($dir);
              if(!$PROPERTIES_ACCESS){
                echo('<div><b>CEU warning:</b> missing access.inc for '.$PROPERTIES['AGENDA_IDENT'].' (<small>TWISTApplication.inc</small>)</div>');
                continue;
              }  
              $rightCategories = array();
              foreach($PROPERTIES_ACCESS as $acc_ident => $acc_s)
                $rightCategories[$acc_ident] = array('category'=>$acc_ident, 'desc'=>$acc_s['desc']);
            }

            $appl[$ag_ident] = array(
                            "ident"=>$ag_ident,
                            "name"=>$PROPERTIES['AGENDA_NAME'],
                            "path"=>$ag_path,
                            "desc"=>$PROPERTIES['AGENDA_DESCRIPTION'],
                            //toto zde nenaplnim, protoze bych musel nacist i access.inc a to se mi nechce, kdyz ho nactu az v GetDefineRightsForApplication, kde toto pole teprve vyplnim 
                            "rightCategories"=>$rightCategories,
                            "rightTypes"=>array(
                                            array('type'=>'p', 'desc'=>'primrn prva'),
                                            array('type'=>'g', 'desc'=>'skupina prv'),
                                          ),
                            //"appl_name"=>$this->configuration['name'],
                            );
          }
          
        }
        
      }
      $this->applications = $appl;
      chdir($dir);
      unset($GLOBALS['_FROM_CEU_']);
    }
    
    $appl_ret = array();
    $appl_ret['config']['desc_modul'] = $this->configuration['desc_modul'];
    $appl_ret['applications'] = $appl;

    return $appl_ret;
	}

}
?>
