<?php

/**
 * @version 1.0
 * @created 01-IX-2004 9:07:41
 */
class SecurityManager
{

	var $userLogins = array(); //LoginObj[] 
	var $userModul = false; //UserModul 
	var $securityModul = false; //SecurityModul 
  var $authenModul = false; //AuthenModul
  var $configuration = array();
  var $resolvers = array();
  var $applications = array();

	/**
	 * @param configuration
	 * @param login
	 * 
	 */
	function SecurityManager($configuration)
	{
    $this->configuration = $configuration;

    //vytvoreni instanci Resolveru
    if($configuration['Resolvers']){
      foreach($configuration['Resolvers'] as $resolver => $resolver_conf){
        include_once($resolver.'.inc');
        $this->resolvers[] = new $resolver($resolver_conf);
      } 
    }
            
    //vytvoreni instance SecurityModulu 
    if($configuration['SecurityModul']['type']){
      include_once($configuration['SecurityModul']['type'].'.inc');
      $this->securityModul = new $configuration['SecurityModul']['type'](&$this);
    }
    elseif($configuration['SecurityModul']['external']){
      $this->securityModul = $configuration['SecurityModul']['external'];
    }

    //vytvoreni instance UserModulu 
    if($configuration['UserModul']['type']){
      include_once($configuration['UserModul']['type'].'.inc');
      $this->userModul = new $configuration['UserModul']['type'](&$this);
    }

    //vytvoreni instanci Applications
    if($configuration['Applications']){
      foreach($configuration['Applications'] as $application => $application_conf){
        include_once($application.'.inc');
        $this->applications[] = new $application($application_conf,&$this);
      } 
    }

    //vytvoreni instance AuthenticateModul 
    if($configuration['AuthenticateModul']['type']){
      include_once($configuration['AuthenticateModul']['type'].'.inc');
      $this->authenModul = new $configuration['AuthenticateModul']['type']($configuration['AuthenticateModul']);
    }
    
	}
  
  
  function GetLoginsFromResolver($login)
  {
    $userLogins = array();
    if($this->userLogins[$login]){
      $userLogins = $this->userLogins[$login];
    }else{
      foreach($this->resolvers as $res){
        $userLogins = array_merge($userLogins, $res->GetLogins($login));
      }
      $this->userLogins[$login] = $userLogins;
    }
    return $userLogins;
  }
  
  
  function GetLoginsWithInfoXXX($login=''){
    $logins = $this->securityModul->GetLogins($login);
    foreach($logins as $login => $login_info){
      $logins[$login]['user_info'] = $this->userModul->GetUser($login);
    }
    return $logins;
  }
  
  
  
	function GetSecurityModul()
	{
    return $this->securityModul;
	}

	function GetUserModul()
	{
    return $this->userModul;
	}

	function GetApplicationModul()
	{
    return $this->applications;
	}
}
?>