<?php
require_once ('SecurityManager.inc');

/**
 * @version 1.0
 * @created 01-IX-2004 9:07:40
 */
class Security
{

	var $configFilePath = '';  //string
	var $securityManagers = array(); //SecurityManager[] 
	/**
	 * Seznam podporovanch systm s informac zda u nj vytvet User a/nebo
	 * Security Modul. A ke kadmu systmu seznam Resolver, kter m pout.
	 */
	var $configuration = array(); //HasArray 
  var $systemsCount = 0; //Integer
	var $idProvider = false; //IDProvider 
	/**
	 * @param login
	 * 
	 */
	function Security($charset=false)
	{
    $this->ReadConfiguration();
    
    if($charset) $this->configuration['charset'] = $charset;
    
    $add_ceu_global_params = array('CEU_GLOBAL_PARAMS' => array('ceu_charset'=>$this->configuration['charset']));

    if($this->configuration['IDProvider']["type"]){
       include_once($this->configuration['IDProvider']["type"].'.inc');
       $this->idProvider = new $this->configuration['IDProvider']["type"]($this->configuration['IDProvider']);
    }
    
    foreach($this->configuration["SYSTEMS"] as $conf_system){
      if($conf_system['SecurityModul']['type'] || $conf_system['UserModul']['type'] || $conf_system['Applications']){
        $this->securityManagers[] = new SecurityManager(array_merge($conf_system, $add_ceu_global_params));
      }
    }
  }
  
  
  function GetIndexSystemByName($name){
    $idx = false;
    for($i=0; $i<count($this->securityManagers); $i++){
      if($this->securityManagers[$i]->configuration['name']==$name){
        $idx = $i;
        break;
      }
    }
    return $idx;
  }
  
	/**
	 * @param login
	 * POZOR: tato metoda je nejdulezitejsi pro T-WIST, ktery ji casto pouziva !!!
	 */
	function GetAllRights($login, $login_system, $default_appl_system=false, $only_for_ceu_system=false)
	{
    $rights = array();
    
    if($login && !$login_system) $login_system = $this->configuration['default_appl_system'];
    
    if($login && $login_system) $log_ceu_id = $this->idProvider->GetCEUID($login,$login_system);
    else $log_ceu_id = false;

    if($default_appl_system=='all') $default_appl_system = false;
    elseif(!$default_appl_system) $default_appl_system = $this->configuration['default_appl_system'];
    
    for($i=0; $i<count($this->securityManagers); $i++){
 
      $SMan = &$this->securityManagers[$i];   
      
      if(!$only_for_ceu_system || $only_for_ceu_system==$SMan->configuration['name']){
      
        if(is_array($SMan->securityModul) && $only_for_ceu_system){//pokud je securityModul 'external' (viz.:SecurityManager) a je to pouze pro tento system (jinak by volal 2x to same)
          $id = $this->GetIndexSystemByName($SMan->securityModul[0]);
          $SMan = &$this->securityManagers[$id]; 
        } 
  
        if(is_object($SMan->securityModul)){ 
         
         $r1 = $SMan->securityModul->GetRightsFromLogin($log_ceu_id, $default_appl_system);

         //print_r($r1);echo"<br>---<br>\n\n";
         foreach($r1 as $k => $arr){
           if(!$rights[$k]){
             $rights = array_merge($rights, $r1);
           }else{
           
             foreach($arr as $k2 => $arr2){
               if(!$rights[$k][$k2]){
                 $rights[$k][$k2] = $arr2;
               }else{
                 $rights[$k][$k2] = array_merge($rights[$k][$k2], $arr2);
               }
             }
           
           }
         }
         
        }  
        
      }
    }

    //print_r($rights);
    return $rights; 
	}


	/**
	 * @param login
	 * 
	 */
	function GetAllRoles($login='', $login_system='', $role_system='', $only_for_ceu_system=false, $filter=array())
	{
    $roles = array();
    
    if($login && $login_system) $log_ceu_id = $this->idProvider->GetCEUID($login,$login_system);
    else $log_ceu_id = false;
    
    for($i=0; $i<count($this->securityManagers); $i++){

      $SMan = &$this->securityManagers[$i];    
      $orig_sys = $SMan->configuration['name'];
      
      if(!$only_for_ceu_system || $only_for_ceu_system==$SMan->configuration['name']){
        
        if(is_array($SMan->securityModul)){//pokud je securityModul 'external'
          $id = $this->GetIndexSystemByName($SMan->securityModul[0]);
          $SMan = &$this->securityManagers[$id]; 
        } 

        if(is_object($SMan->securityModul)) $roles = array_merge($roles, $SMan->securityModul->GetRolesFromLogin($log_ceu_id, $role_system, $filter) );
      }  
      
    }

    //print_r($roles);
    return $roles; 
	}
  
	/**
	 * @param login
	 * 
	 */
	function GetAllLoginsWithRight($right_id, $default_appl_system='', $only_for_ceu_system=false, $format=0)
	{
    $logins = array();

    $default_appl_system = $default_appl_system?$default_appl_system:$this->configuration['default_appl_system'];
    
    for($i=0; $i<count($this->securityManagers); $i++){
      
      $SMan = &$this->securityManagers[$i]; 
      
      if(!$only_for_ceu_system || $only_for_ceu_system==$SMan->configuration['name']){
        
        if(is_array($SMan->securityModul) && $only_for_ceu_system){//pokud je securityModul 'external'
          $id = $this->GetIndexSystemByName($SMan->securityModul[0]);
          $SMan = &$this->securityManagers[$id]; 
        } 
      
        if(is_object($SMan->securityModul)){
          
          $l1 = $SMan->securityModul->GetLoginsWithRight($right_id, $default_appl_system);

          foreach($l1 as $log1){
            $l2 = $this->idProvider->GetCEULoginSysById($log1['log_ceu_id']);            
            $logins[$l2['system']][] = array_merge($log1, array('log_system'=>$l2['system'],'login'=>$l2['login']) );
          }
          
        }  

      }  

    }

    if($format) $logins = $this->FormatReturnData($logins,$format,'GALWR');
    
    //print_r($logins);
    return $logins; 
	}
  
  
 function GetAllRolesWithRight($right_id, $appl_system=false, $only_for_ceu_system=false)
 {
   $roles = array();
   
   for($i=0; $i<count($this->securityManagers); $i++){
     
      $SMan = &$this->securityManagers[$i];

      if(!$only_for_ceu_system || $only_for_ceu_system==$SMan->configuration['name']){
        
        if(is_array($SMan->securityModul) && $only_for_ceu_system){//pokud je securityModul 'external'
          $id = $this->GetIndexSystemByName($SMan->securityModul[0]);
          $SMan = &$this->securityManagers[$id]; 
        } 
      
        if(is_object($SMan->securityModul)) $roles = array_merge($roles, $SMan->securityModul->GetRolesWithRight($right_id, $appl_system) );
      }  
   }
   
   //print_r($roles);
   return $roles;
 }
  
  
  function GetAllRightsFromRole($role_id, $role_system=false, $only_for_ceu_system=false){
   
   $rights = array();
   
   for($i=0; $i<count($this->securityManagers); $i++){
     
      $SMan = &$this->securityManagers[$i];

      if(!$only_for_ceu_system || $only_for_ceu_system==$SMan->configuration['name']){
        
        if(is_array($SMan->securityModul) && $only_for_ceu_system){//pokud je securityModul 'external'
          $id = $this->GetIndexSystemByName($SMan->securityModul[0]);
          $SMan = &$this->securityManagers[$id]; 
        } 
        
        if(is_object($SMan->securityModul)){
          $r1 = $SMan->securityModul->GetRightsFromRole($role_id, $role_system);
          //print_r($r1);
          $rights = array_merge($rights, $r1 );
        }  
      }  
   }
   
   //print_r($rights);
   return $rights;
  }
  
  
  
  function GetAllLoginsFromRole($role_id, $role_system=false, $only_for_ceu_system=false)
  {
   $logins = array();
   
   for($i=0; $i<count($this->securityManagers); $i++){
     
      $SMan = &$this->securityManagers[$i];

      if(!$only_for_ceu_system || $only_for_ceu_system==$SMan->configuration['name']){
        
        if(is_array($SMan->securityModul) && $only_for_ceu_system){//pokud je securityModul 'external'
          $id = $this->GetIndexSystemByName($SMan->securityModul[0]);
          $SMan = &$this->securityManagers[$id]; 
        } 
        
        if(is_object($SMan->securityModul)){

          $l1 = $SMan->securityModul->GetLoginsFromRole($role_id, $role_system);

          foreach($l1 as $log1){
            $l2 = $this->idProvider->GetCEULoginSysById($log1['log_ceu_id']);            
            $logins[$l2['system']][] = array_merge($log1, array('log_system'=>$l2['system'],'login'=>$l2['login']) );
          }

        }  
      }  
   }
   
  // print_r($logins);
   return $logins;
  }
  
	/**
	 * @param login
	 * 
	 */
	function GetAllLoginsXXX($login='', $with_info=false)
	{
    $logins = array();
    
    for($i=0; $i<count($this->securityManagers); $i++){
      $SMan = &$this->securityManagers[$i];    
      if(is_object($SMan->securityModul)) 
        if($with_info) $logins[$SMan->configuration['name']] = $SMan->GetLoginsWithInfo($login);
        else $logins[$SMan->configuration['name']] = $SMan->securityModul->GetLogins($login);
    }

    return $logins; 
	}
  

	/**
	 * @param login
	 * 
	 */
	function GetAllUserInfo($login='', $system='', $filter=array(), $type=0, $format=0)
	{
    $users = array();

    if($type==1 && is_numeric($login)){
      $ceu_login = $this->idProvider->GetCEULoginSysById($login);
      $login = $ceu_login['login'];
      $system = $ceu_login['system'];
      $type=0;
    }  

    for($i=0; $i<count($this->securityManagers); $i++){
      $SMan = &$this->securityManagers[$i];
      if(!$system || $system==$SMan->configuration['name']){ 
        if($SMan->userModul) $users[$SMan->configuration['name']] = $SMan->userModul->GetUser($login,$filter,$type);
        //print_r($users[$SMan->configuration['name']]);
      }  
    }

    if($this->idProvider){
      foreach($users as $sys => $usr){
        if($usr){///pokud uzivatel vubec existuje
          foreach($usr['logins'] as $u){
           $users[$sys]['logins'][$u['LOGIN']]['ID'] = $this->idProvider->GetCEUID($u['LOGIN'], $sys, $u['ID']); 
          }
        }  
      }
    }
    
    if($format) $users = $this->FormatReturnData($users,$format,'GAUI');
    
    return $users;
	}


	/**
	 * @param right
	 * 
	 */
	function GetAllLoginsFromResolver($login)
	{
    $logins = array();
    
    foreach($this->securityManagers as $key_SMan => $SMan){
      $logins[$SMan->configuration['name']] = $SMan->GetLoginsFromResolver($login);
    }
    
    return $logins;
	}


	function GetAllApplications($application='', $system='', $only_reg=false)
	{
    $applications = array();

    for($i=0; $i<count($this->securityManagers); $i++){
      $SMan = &$this->securityManagers[$i];    
      foreach($SMan->applications as $k => $appl){
        if(!$system || $system==$SMan->configuration['name']){
          $applications[$SMan->configuration['name']] = $SMan->applications[$k]->GetApplicationsInfo($only_reg, $application);
        }  
      }  
    }
    
    return $applications;
	}


	function GetAllDefineRightsForApplication($application, $system='')
	{
    $rights = array();

    for($i=0; $i<count($this->securityManagers); $i++){
      $SMan = &$this->securityManagers[$i];    
      foreach($SMan->applications as $k => $appl){
        if(!$system || $system==$SMan->configuration['name']){
          $rights[$SMan->configuration['name']] = $SMan->applications[$k]->GetDefineRightsForApplication($application);
        }  
      }  
    }
    
    return $rights;
	}


	function ReadConfiguration()
	{
	  $this->configFilePath = $GLOBALS["TMAPY_DIR"].'/.config/settings/ceu_config.inc';
    include($this->configFilePath);
    $this->configuration = $CEU_CONFIG;
    ksort($this->configuration["SYSTEMS"]);
    $this->systemsCount = count($this->configuration["SYSTEMS"]);
	}

	function UniqueValues($array)
	{
    return array_unique($array);
	}
  

	/**
	 * Provd autentifikaci na zklad loginu a hesla pro kad poadovan systm
	 * @param system
	 * @param pasword
	 * @param login
	 * 
	 */
	function GetAuthenticate($login, $password, $system)
	{
    $ret = false;

    $id = $this->GetIndexSystemByName($system);

    if($id!==false){
      
      $ret = $this->securityManagers[$id]->authenModul->Authenticate($login, $password);
          
    }
    return $ret;
	}


  
  function FormatReturnData($arr_data, $format, $typ){

     global $FormatReturnData_OrderBy;

     if(!function_exists('this__Compare_Czech')){

        function this__Compare_Czech ($a, $b, $codepage="iso-8859-2") {
          if (StrCmp($a, $b) == 0) return 0;
          if (!$tr_from):
            static $tr_from;
            static $tr_to;
          if ($codepage == "iso-8859-2"):
            $tr_from = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"."abcdefghijklmnopqrstuvwxyz";
          else:
            $tr_from = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"."abcdefghijklmnopqrstuvwxyz";
          endif;
            $tr_to =   "1123456778ABCCDEFGHIJKKLMNOPQRSTTTUVWXXYZ"."1123456778ABCCDEFGHIJKKLMNOPQRSTTTUVWXXYZ";
          endif;
          $a1 = ERegi_Replace("CH", "H|", $a);
          $b1 = ERegi_Replace("CH", "H|", $b);
          $a1 = StrTr($a1, $tr_from, $tr_to);	
          $b1 = StrTr($b1, $tr_from, $tr_to);
          //echo "$a1($a) == $b1($b) =>".StrCmp($a1, $b1)."<br>\n";
          return StrCmp($a1, $b1);	
        } 
        
        function this__Compare_Czech_1250 ($a, $b) {
          global $FormatReturnData_OrderBy;
          return this__Compare_Czech ($a[$FormatReturnData_OrderBy], $b[$FormatReturnData_OrderBy], "windows-1250");
        } 
        
        function this__Compare_Czech_1250_Desc ($b, $a) {
          global $FormatReturnData_OrderBy;
          return this__Compare_Czech ($a[$FormatReturnData_OrderBy], $b[$FormatReturnData_OrderBy], "windows-1250");
        }  
        
        function this__Compare_Czech_ISO_8859_2 ($a, $b) {
          global $FormatReturnData_OrderBy;
          return this__Compare_Czech ($a[$FormatReturnData_OrderBy], $b[$FormatReturnData_OrderBy], "iso-8859-2");
        } 
        
        function this__Compare_Czech_ISO_8859_2_Desc ($b, $a) {
          global $FormatReturnData_OrderBy;
          return this__Compare_Czech ($a[$FormatReturnData_OrderBy], $b[$FormatReturnData_OrderBy], "iso-8859-2");
        }  
     }
    
    
     $ret_data = array();
     
     if(strcasecmp($this->configuration['charset'],'windows-1250')===0){
       $compare_fce = 'this__Compare_Czech_1250';
     }else{
       $compare_fce = 'this__Compare_Czech_ISO_8859_2';
     }
     
     
     if($typ=='GALWR')://GetAllLoginsWithRight

        switch($format):
          case 1: //vsechno dohromady a setridit dle prijmeni

                foreach($arr_data as $u1){
                  foreach($u1 as $users2){
                    foreach($users2 as $u2){
                      $ret_data[] = $u2;
                    }  
                  }   
                }
                $FormatReturnData_OrderBy = 'LNAME';
                uasort($ret_data, $compare_fce);
              break;
        endswitch;

        
     elseif($typ=='GAUI')://GetAllUserInfo
        
        switch($format):
          case 1: //vsechno dohromady a setridit dle prijmeni
               
                foreach($arr_data as $sys => $u){
                  $ret_data = array_merge($u['logins'], $ret_data);
                }
                $FormatReturnData_OrderBy = 'LNAME';
                uasort($ret_data, $compare_fce);
              break;
        endswitch;

     endif;
     
     return $ret_data;  
  }
  
  

  function multimerge ($array1, $array2) {
   if (is_array($array2) && count($array2)) {
     foreach ($array2 as $k => $v) {
       if (is_array($v) && count($v)) {
         $array1[$k] = $this->multimerge($array1[$k], $v);
       } else {
         $array1[$k] = $v;
       }
     }
   } else {
     $array1 = $array2;
   }

   return $array1;
  }

  function array_merge_ceu($arr1, $arr2){
    
    return $arr1;
  }
}
?>
