<?php
require_once ('UserModul.inc');


/**
 * @version 1.0
 * @created 01-IX-2004 9:07:39
 */
class LDAPUserModul extends UserModul
{

  var $Comma="'";
  var $connect=false;
  var $bind=false;
  var $base_dn=false;
  var $ldap_filter=array();
  var $attr_username = 'sAMAccountName';

  function LDAPUserModul($securityManager) {

    $this->UserModul($securityManager);

    if($this->securityManager->configuration['UserModul']["AUTH_LDAP_USERATTR"])
      $this->attr_username = $this->securityManager->configuration['UserModul']["AUTH_LDAP_USERATTR"];
    
  }
  
  
  function LDAP_UM_Connect() {

    if (!($this->connect=ldap_connect($this->securityManager->configuration['UserModul']["AUTH_LDAP_SERVER"],$this->securityManager->configuration['UserModul']["AUTH_LDAP_SERVER_PORT"]))) die("ldap_main: Cannot connect to LDAP server."); 

    if (!($this->bind=ldap_bind($this->connect, $this->securityManager->configuration['UserModul']["AUTH_LDAP_BIND_USER"], $this->securityManager->configuration['UserModul']["AUTH_LDAP_BIND_PASSWORD"]))) die("ldap_main: Unable to bind to server.");

  }
  

	function GetUser($login, $filter=array(), $type=0)
	{ 
    //if($filter) $has_filter = count(array_unique(Array_values($filter)))>1;
		if(is_array($filter)){
  		foreach($filter as $v){
  		  if($v){
  			  $has_filter = true;
  				break;
  			}
  		}
		}
    
    $UserModulName = $this->securityManager->configuration['UserModul']["name"];
    
    if ($this->securityManager->configuration['UserModul']["cache"]=='session' && $GLOBALS['HTTP_SESSION_VARS']['CEU_USERS'][$UserModulName] && !$has_filter && !$login) {

      $users_ret = $GLOBALS['HTTP_SESSION_VARS']['CEU_USERS'][$UserModulName];

    } else {
     
      $ret = false;
      $users = array();
  
      $AUTH_LDAP_FIELDS = $this->securityManager->configuration['UserModul']["AUTH_LDAP_FIELDS"];
      
      if($login && $this->users[$login]){
      
        $users = $this->users[$login];
      
      }else{
  
        $this->ldap_filter = array();
    
        $this->base_dn = $this->securityManager->configuration['UserModul']["AUTH_LDAP_BASE_DN_USER"];
        
        if($type==3){
          $this->ldap_filter[] = '(objectClass=*)';
          $this->base_dn = $login;
        }else{
          $this->ldap_filter[] = '('.$this->attr_username.'='.($login?$login:'*').")";
        }
        
        if($this->securityManager->configuration['UserModul']["AUTH_LDAP_FILTER"])
          $this->ldap_filter[] = $this->securityManager->configuration['UserModul']["AUTH_LDAP_FILTER"];

        if(is_array($filter)){
          foreach($filter as $key => $val){
            if($val){
              switch ($key) {
                case 'login' : $this->ldap_filter[] = '('.$this->attr_username.'='.$val.")"; break;
                case 'fname' : $this->ldap_filter[] = '(givenname='.$val.")"; break;
                case 'lname' : $this->ldap_filter[] = '(sn='.$val.")"; break;
                case 'email' : $this->ldap_filter[] = '(mail='.$val.")"; break;
                default      : $this->ldap_filter[] = "($key=$val)";
              }
            }
          }
        }

        $this->LDAP_UM_Connect();
  
        $ldap_filter_str = '(&'.implode('',$this->ldap_filter).')';

        $ldap_filter_str = $this->TextEncoding($ldap_filter_str, false, $this->securityManager->configuration['CEU_GLOBAL_PARAMS']['ceu_charset'], $this->securityManager->configuration['UserModul']["charset"]);
  
        if (!($search=@ldap_search($this->connect, $this->base_dn, $ldap_filter_str))) die(array("msg"=>"ldap_main: Cannot search user.")); 
  
        $members = ldap_get_entries($this->connect, $search);
        //print_r($members);
        
        unset($members['count']);
        
        foreach($members as $member){
          
          foreach($AUTH_LDAP_FIELDS as $fname => $field){
            $ret[$fname] = $this->TextEncoding($member[$field['name']][0]);
          }
          
          $ret['dn'] = $this->TextEncoding($member['dn']);
          $ret['system'] = $this->securityManager->configuration['name'];
          $ret['sys_id'] = $ret['ID'];
          
          $users[$ret["LOGIN"]] = $ret;
        }
  
        if ($this->connect) ldap_close($this->connect); 
        
        if($login) $this->users[$login] = $users;
      }
  
      $users_ret = array();
      
      if($users){
      
        $users_ret['logins'] = $users;
        $users_ret['config']['name_modul'] = $this->securityManager->configuration['UserModul']['name']; 
        
        $users_ret['config']['desc_fields']['dn'] = 'DN';
        $users_ret['config']['desc_fields']['system'] = 'System';
        $users_ret['config']['desc_fields']['sys_id'] = 'Sys. identifiktor';
         
        foreach($AUTH_LDAP_FIELDS as $fname => $field){
          $users_ret['config']['desc_fields'][$fname] =  $field['desc'];
        }
      
      }
      
     
      //die(print_r($users_ret));
  
      if ($this->securityManager->configuration['UserModul']["cache"]=='session' && !$GLOBALS['HTTP_SESSION_VARS']['CEU_USERS'][$UserModulName] && !$has_filter && !$login) {
        session_register('CEU_USERS');
        $GLOBALS['CEU_USERS'][$UserModulName] = $users_ret;
      }
    }
    
    return $users_ret;
    
	}

}
/*
Konfigurace pro Win AD:

        "AUTH_LDAP_FIELDS"=>array(
          "ID"=>array("name"=>"samaccountname", "desc"=>"Identifiktor"),
          "LOGIN"=>array("name"=>"samaccountname", "desc"=>"Login"),
          "SHORT"=>array("name"=>"samaccountname", "desc"=>"Zkratka"),
          "LNAME"=>array("name"=>"sn", "desc"=>"Pijmeni"),
          "FNAME"=>array("name"=>"givenname", "desc"=>"Jmno"),
          "EMAIL"=>array("name"=>"mail", "desc"=>"E-mail"),
          "WWW"=>array("name"=>"wwwhomepage", "desc"=>"WWW"),
          "STREET"=>array("name"=>"streetaddress", "desc"=>"Ulice"),
          "CITY"=>array("name"=>"l", "desc"=>"Msto"),
          "P_CODE"=>array("name"=>"postalcode", "desc"=>"Pota"),
          "H_PHONE"=>array("name"=>"homephone", "desc"=>"Telefon dom"),
          "PHONE"=>array("name"=>"telephonenumber", "desc"=>"Telefon"),
          "MOBILE"=>array("name"=>"mobile", "desc"=>"Mobil"),
        ),

*/
?>
