<?php
require_once ('AuthenModul.inc');


/**
 * @author Tom Hlek
 * @version 1.0
 * @created 24-I-2005 11:48:36
 */
class LDAPAuthenModul extends AuthenModul
{
  
  var $attr_username = 'sAMAccountName';
  
	/**
	 * @param password
	 * @param login
	 * 
	 */
	function Authenticate($login, $password)
	{
    $ret = false;
    
    if($this->configuration["AUTH_LDAP_USERATTR"])
      $this->attr_username = $this->configuration["AUTH_LDAP_USERATTR"];
    
    $filter = $this->attr_username."=".$login;

    $con = ldap_connect($this->configuration["AUTH_LDAP_SERVER"],$this->configuration["AUTH_LDAP_SERVER_PORT"]);
    
    if(!$con) die("ldap_auth: Cannot connect to LDAP server.");
    
    $bind = ldap_bind($con, $this->configuration["AUTH_LDAP_BIND_USER"], $this->configuration["AUTH_LDAP_BIND_PASSWORD"]);

    if(!$bind) die("ldap_auth: Unable to bind to server.");

    $base_dn = $this->configuration["AUTH_LDAP_BASE_DN_USER"];
    
    $sr = ldap_search($con, $base_dn, $filter, array('dn')); 

    $info = ldap_get_entries($con, $sr);

    $login = $info[0]['dn'];                   
  
    if($login)
      $ret = @ldap_bind($con, $login, $password);

    ldap_close($con);

    return $ret;
	}

}
?>