<?php
require_once ('SecurityModul.inc');


/**
 * @version 1.0
 * @created 01-IX-2004 9:07:40
 */
class GroupSecurityModul extends SecurityModul
{
  
  var $db;
   
	/**
	 * @param login
	 * 
	 */
	function GetRolesFromLogin($log_ceu_id, $role_system='', $filter=array())
	{
    $roles = array();
    
    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
    
    if($log_ceu_id){

      $roles_id = array(0);

      $sql = "SELECT g.*,t.name as typ_name FROM ceu_rel_log_role r LEFT JOIN security_group g ON (r.role_id=g.id) LEFT JOIN security_group_typ t ON (g.type_group=t.code)".
                 " WHERE r.role_system = '".$this->securityManager->configuration['name']."'".
                 " AND r.log_ceu_id = $log_ceu_id";
    

    }else{
      
      $sql = 'SELECT g.*,t.name as typ_name FROM security_group g LEFT JOIN security_group_typ t ON (g.type_group=t.code) WHERE 1=1';
      
    }

    if($filter['id']) $sql.=' AND g.id IN ('.$filter['id'].')';
    if($filter['name']) $sql.=" AND upper(g.name) LIKE '".$this->Stars2Percent(strtoupper($filter['name']))."'";
    if($filter['typ_code'])  $sql.=" AND upper(g.type_group) = ".$filter['typ_code'];

    $sql.= ' ORDER BY g.name';
    
    //echo "<br><b>$sql</b><br>\n";flush();
    $this->db->Query($sql);
    
    $system = $this->securityManager->configuration['name'];
    
    while($this->db->next_record()) {
        $roles[$system][] = 
          array('role_id'=>$this->db->Record['ID'],
                'role_name'=>$this->db->Record['NAME'],
                'role_system'=>$system,
                'role_description'=>$this->db->Record['DESCRIPTION'],
                'role_typ'=>$this->db->Record['TYP_NAME'],
               );
    }
    
    //print_r($roles);
    return $roles; 
	}

	/**
	 * @param login
	 * 
	 */
	function GetRightsFromLogin($log_ceu_id, $appl_system='')
	{
    $rights = array();
    
    if($login && $appl_system && $this->rights[$log_ceu_id][$appl_system]){

      $rights = $this->rights[$log_ceu_id][$appl_system];
    
    }elseif($login && !$appl_system && $this->rights[$log_ceu_id]['_all_']){
    
      $rights = $this->rights[$log_ceu_id]['_all_'];
    
    }else{

      if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
      
      $add_where = '';
      if($appl_system) $add_where.=" AND r.appl_system = '$appl_system'";
      
      //prava primo na skupiny
      $sql = "(SELECT r.appl_system, r.appl_ident, r.right_id, r.right_name, r.role_id, s.name as role_name, r.role_system".
             " FROM ceu_rel_log_role l, ceu_rel_role_right r, security_group s".
             " WHERE (r.role_id=l.role_id AND r.role_system=l.role_system AND s.id=r.role_id)".
             " AND r.role_system = '".$this->securityManager->configuration['name']."'".
             " AND l.log_ceu_id = $log_ceu_id ".$add_where;

      $sql.= ") UNION ALL (";
      
      $sql.= "SELECT r.appl_system, r.appl_ident, r.right_id, r.right_name, r.role_id, rr.name as role_name, r.role_system".
             " FROM ceu_rel_log_role l, security_group_ceu_role s, ceu_rel_role_right r, ceu_role rr".
             " WHERE l.role_id = s.sec_g_code AND s.ceu_role_id=r.role_id AND r.role_id=rr.role_id".
             " AND l.role_system = '".$this->securityManager->configuration['name']."'".
             " AND l.log_ceu_id = $log_ceu_id ".$add_where;

      $sql.= ") ORDER BY appl_system, appl_ident, right_name";
      
      $this->db->Query($sql);
      //echo "<br><b>$sql</b><br>\n";flush();

      while($this->db->next_record()) {
        //$rights['roles'][$this->db->Record[3]][] = $this->db->Record[0].'|'.$this->db->Record[1].'|'.$this->db->Record[2];
        $arr = explode('|',$this->db->Record['RIGHT_ID']);
        $rights[$this->db->Record['APPL_SYSTEM']][$this->db->Record['APPL_IDENT']][] = 
            array('right_id'    => $this->db->Record['RIGHT_ID'], 
                  'name'        => $this->db->Record['RIGHT_NAME'], 
                  'ident'       => $arr[0], 
                  'category'    => $arr[1], 
                  'role_id'     => $this->db->Record['ROLE_ID'], 
                  'role_name'   => $this->db->Record['ROLE_NAME'], 
                  'role_system' => $this->db->Record['ROLE_SYSTEM']
                  );  
      }

      if($log_ceu_id  && $appl_system) $this->rights[$log_ceu_id][$appl_system] = $rights;
      elseif($log_ceu_id  && !$appl_system) $this->rights[$log_ceu_id]['_all_'] = $rights;

    }
//print_r($rights);
    return $rights;
	}


	function GetLoginsWithRight($right_id, $appl_system=false)
	{

    $logins = array();

    if($right_id && !is_array($right_id) && $this->logins[$right_id]){
    
      $logins = $this->logins[$right_id];
    
    }else{

      if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
      
      if(!$appl_system) $appl_system = $this->securityManager->configuration['name'];
      
      if(is_array($right_id)){
        $right_cond = "IN ('".implode("','",$right_id)."')";
      }else{
        $right_cond = "LIKE '$right_id'";
      }
      
      //loginy primo pres skupine jako roli
      $sql = "(SELECT r.right_id, r.right_name, l.log_ceu_id, l.role_id, g.name as role_name, l.role_system".
             " FROM ceu_rel_log_role l, ceu_rel_role_right r, security_group g".
             " WHERE (r.role_id=l.role_id AND r.role_system=l.role_system AND g.id=r.role_id)".
             " AND r.role_system = '".$this->securityManager->configuration['name']."'".
             " AND r.right_id $right_cond AND r.appl_system = '".$appl_system."'";

      $sql.= ") UNION ALL(";       

      $sql.= "SELECT r.right_id, r.right_name, l.log_ceu_id, l.role_id, g.name as role_name, l.role_system".
             " FROM ceu_rel_role_right r, security_group_ceu_role s, ceu_rel_log_role l, security_group g".
             " WHERE  s.ceu_role_id=r.role_id AND l.role_id = s.sec_g_code AND l.role_id=g.id".
             " AND l.role_system = '".$this->securityManager->configuration['name']."'".
             " AND r.right_id $right_cond AND r.appl_system = '".$appl_system."'";

      $sql.= ")";
      
      //echo "<br><b>$sql</b><br>\n";flush();
      $this->db->Query($sql);

      while($this->db->next_record()){
        $arr = explode('|',$this->db->Record['RIGHT_ID']);
        $logins[] = 
                 array('log_ceu_id'    =>$this->db->Record['LOG_CEU_ID'], 
                       'role_id'       =>$this->db->Record['ROLE_ID'], 
                       'role_name'     =>$this->db->Record['ROLE_NAME'], 
                       'role_system'   =>$this->db->Record['ROLE_SYSTEM'],
                       'right_id'      =>$this->db->Record['RIGHT_ID'],
                       'right_name'    =>$this->db->Record['RIGHT_NAME'],
                       'right_ident'   =>$arr[0],
                       'right_category'=>$arr[1],
                       );  
      }
      
      if($right && $appl_ident) $this->logins[$appl_ident.'-'.$right] = $logins;  
    
    }
    
//print_r($logins);
    return $logins;
  }

	function GetLoginsWithRight_XXX($right_id, $appl_system=false)
	{ 
    $logins = array();
    return $logins;

    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
    
    if($right_id && !is_array($right_id) && $this->logins[$right_id]){
    
      $logins = $this->logins[$right_id];
    
    }else{

      if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
      
      if(!$appl_system) $appl_system = $this->securityManager->configuration['name'];
      
      if(!is_array($right_id)) $right_id = array($right_id); 
      
      foreach($right_id as $right){
      
        //ROLE ktere jsou spojeny s pravem
        $sql1= "SELECT DISTINCT role.role_id, r.right_id, r.right_name  ".
               " FROM ceu_rel_role_right r, security_group s".
               " WHERE role.role_id=r.role_id AND role.system = r.role_system".
               " AND r.right_id LIKE '$right' AND r.appl_system = '".$appl_system."'";
        
        $this->db->Query($sql1);
        //echo "<br><b>$sql1</b><br>\n";flush();
        $role_ids = array();
        $rights_info = array();
        while($this->db->next_record()){
          $role_ids[] = $this->db->Record[0];
          $rights_info[] = array('right_id'=>$this->db->Record['RIGHT_ID'], 'right_name'=>$this->db->Record['RIGHT_NAME']);
        }   
        
        if(!$role_ids) continue;
        
        //SKUPINY navazany na ROLE, ktere obsahuji predchozi pravo
        $sql2= "SELECT DISTINCT g.*,t.name as typ_name".
               " FROM security_group g, security_group_ceu_role c, security_group_typ t ".
               " WHERE g.id = c.sec_g_code AND g.type_group=t.code".
               " AND c.ceu_role_id IN (".implode(",",$role_ids).")".
               "";
      
        $this->db->Query($sql2);
        //echo "<br><b>$sql2</b><br>\n";flush();
        $id_groups = array();
        while($this->db->next_record()) $id_groups[] = $this->db->Record['NAME']; 
      
        if(!$id_groups) continue;

        //USERs ve SKUPINACH 
        $sql = "SELECT r.*, g.name as role_name FROM ceu_rel_log_role r, security_group g".
               " WHERE g.name IN ('".implode("','",$id_groups)."') AND role_system = 'Groups'".
               " ";
        $this->db->Query($sql);
        //echo "<br><b>$sql</b><br>\n";flush();       

        
        while($this->db->next_record()){
          
          $rights_info = array_unique($rights_info);
          
          foreach($rights_info as $ri){
            
            $arr = explode('|',$ri['right_id']);
            
            $logins[$this->db->Record['LOG_SYSTEM']][] = 
                     array('login'         =>$this->db->Record['LOG_USER'],
                           'login_system'  =>$this->db->Record['LOG_SYSTEM'], 
                           'role_id'       =>$this->db->Record['ROLE_ID'], 
                           'role_name'     =>$this->db->Record['ROLE_NAME'], 
                           'role_system'   =>$this->db->Record['ROLE_SYSTEM'],
                           'right_id'      =>$ri['right_id'],
                           'right_name'    =>$ri['right_name'],
                           'right_ident'   =>$arr[0],
                           'right_category'=>$arr[1],
                           );
          }                    
        }
        
      }
      
      
      if($right && $appl_ident) $this->logins[$appl_ident.'-'.$right] = $logins;  
    
    }

//print_r($logins);
    return $logins;
	}
  
  
  function GetRolesWithRight($right_id, $appl_system=false)
  {
    $roles = array();
    $groups = array();

    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
    
    if(!$appl_system) $appl_system = $this->securityManager->configuration['name'];
    
    if(is_array($right_id)){
      $right_cond = "IN ('".implode("','",$right_id)."')";
    }else{
      $right_cond = "= '$right_id'";
    }
    
    // SKUPINY prirazene k pravu
    $sql = "SELECT DISTINCT g.*,t.name as typ_name FROM ceu_rel_role_right r, security_group g, security_group_typ t ".
           " WHERE r.role_id=g.id AND g.type_group=t.code".
           " AND right_id $right_cond AND appl_system = '".$appl_system."'".
           " AND role_system = '".$this->securityManager->configuration['name']."'";
    
    $this->db->Query($sql);
    //echo "<br><b>$sql</b><br>\n";flush();

    while($this->db->next_record()) {
      
      $roles[] = array('role_id'=>$this->db->Record['ID'],
                       'role_name'=>$this->db->Record['NAME'],
                       'role_system'=>$this->securityManager->configuration['name'],
                       'role_description'=>$this->db->Record['DESCRIPTION'],
                       'role_typ'=>$this->db->Record['TYP_NAME'],
                       );
    }

//print_r($roles);
    return $roles;
  }
  
  
  function GetRightsFromRole($group_id, $role_system=false)
  {
    $rights = array();
        
    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];

    //SKUPINY, ktere obsahuji primo pridelena prava
    $sql = "(SELECT r.appl_system, r.appl_ident, r.right_id, r.right_name, r.role_id, rr.name as role_name, r.role_system".
           " FROM security_group_ceu_role c, ceu_rel_role_right r, ceu_role rr".
           " WHERE c.ceu_role_id = r.role_id AND r.role_id=rr.role_id AND rr.system = r.role_system".
           " AND c.ceu_role_id = $group_id";
    
    $sql.= ") UNION ("; 
           
    //primo prava na skupinu jako roli
    $sql.= "SELECT r.appl_system, r.appl_ident, r.right_id, r.right_name, r.role_id, g.name as role_name, r.role_system".
           " FROM ceu_rel_role_right r, security_group g".
           " WHERE r.role_id=g.id AND r.role_id = '$group_id' AND r.role_system = '".$this->securityManager->configuration['name']."'".
           ") ORDER BY appl_system, appl_ident, right_name";
           
    $this->db->Query($sql);
    //echo "<br><b>$sql</b><br>\n";flush();
    
    while($this->db->next_record()) {
      $arr = explode('|',$this->db->Record['RIGHT_ID']);
      $rights[$this->db->Record['APPL_SYSTEM']][$this->db->Record['APPL_IDENT']][] = 
              array('right_id'    => $this->db->Record['RIGHT_ID'],
                    'name'        => $this->db->Record['RIGHT_NAME'],  
                    'ident'       => $arr[0], 
                    'category'    => $arr[1], 
                    'role_id'     => $this->db->Record['ROLE_ID'],
                    'role_name'   => $this->db->Record['ROLE_NAME'],
                    'role_system' => $this->db->Record['ROLE_SYSTEM'],
                   );  
    }
   
    //print_r($rights);
    return $rights;

  }
  
  
  function GetLoginsFromRole($group_id, $role_system=false)
  {
    $logins = array(); 
    
    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
    
    if(is_array($group_id)) $gr_where = implode("','",$group_id);
    else $gr_where = $group_id;
    
    
    $sql = "SELECT r.log_ceu_id, r.role_id, r.role_system, g.name as role_name FROM ceu_rel_log_role r, security_group g".
           " WHERE r.role_id=g.id AND r.role_id IN ('$gr_where') AND r.role_system = '".$this->securityManager->configuration['name']."'".
           "";
    $this->db->Query($sql);
    //echo "<br><b>$sql</b><br>\n";flush();
    while($this->db->next_record()) {
        $logins[] = 
               array('log_ceu_id' =>$this->db->Record['LOG_CEU_ID'], 
                     'role_id'    =>$this->db->Record['ROLE_ID'], 
                     'role_name'  =>$this->db->Record['ROLE_NAME'], 
                     'role_system'=>$this->db->Record['ROLE_SYSTEM']
                    );  
    }
    //print_r($logins);
    return $logins;
  }

  
  
  function GetCEURoles4Group($id)
  {
    $ret = array();
    $ceu_role_ids = array(0);

    $db = new $this->securityManager->configuration['SecurityModul']['db'];
      
    $db->query('SELECT ceu_role_id FROM security_group_ceu_role WHERE sec_g_code='.$id);
    
    while($db->next_record()) $ceu_role_ids[] = $db->Record[0];
    
    
    $sql = "SELECT * FROM ceu_role WHERE role_id IN (".implode(',',$ceu_role_ids).")";
    //echo "<br><b>$sql</b><br>\n";flush();
          
    $db->Query($sql);       

    while($db->next_record()) {
        $ret[] = array('role_id'         => $db->Record['ROLE_ID'],
                       'role_name'       => $db->Record['NAME'],
                       'role_system'     => $db->Record['SYSTEM'],
                       'role_description'=> $db->Record['DESCRIPTION']
                      );  
    }
    
    return $ret;
  }
  
  
  function Stars2Percent($value){
    $value = trim($value);
    if($value[0]=='*') $value[0] = '%';
    $end_id = strlen($value)-1;
    if($value[$end_id]=='*') $value[$end_id] = '%';
    return $value; 
  }

}
?>