<?php
require_once ('SecurityModul.inc');

require_once($GLOBALS["TMAPY_LIB"]."/lib/nusoap/lib/nusoap.php");


/**
 * @version 1.0
 * @created 01-IX-2004 9:07:40
 */
class CeuSOAPBasicSecurityModul extends SecurityModul
{
  
	/**
	 * @param login
	 * 
	 */
	function GetRolesFromLogin($login='', $login_system='', $role_system='', $filter=array())
	{

    $roles = array();
    
    $ext_system = $this->securityManager->configuration['SecurityModul']['ext_system'];

    $login_system = $login_system? $login_system: $ext_system;
    
    if($login && !$role_system && $this->roles[$login_system][$login]){
    
      $result = $this->roles[$login_system][$login];
    
    }else{

      $client = new soapclient($this->securityManager->configuration['SecurityModul']['soap_service']);
      
      $result1 = $client->call('CEUGetRolesFromLogin', 
                              array('system'       => $ext_system, 
                                    'login'        => $login, 
                                    'login_system' => $login_system, 
                                    'role_system'  => $role_system,
                                    'filter'       => $filter
                                    )
                             );
    
      
      foreach($result1[$ext_system] as $k => $role){
        $result[$this->securityManager->configuration['name']][$k] = $role;
        $result[$this->securityManager->configuration['name']][$k]['role_system'] = $this->securityManager->configuration['name'];
      }

      
      if($login) $this->roles[$login_system][$login] = $roles;
    
    }
//print_r($result);
    return $result;
	}


	/**
	 * @param login
	 * 
	 */
	function GetRightsFromLogin($login, $login_system='', $appl_system='')
	{
    $rights = array();
    
    $login_system = $login_system? $login_system: $this->securityManager->configuration['name'];
       
    if($login && $appl_system && $this->rights[$login_system][$login][$appl_system]){

      $rights = $this->rights[$login_system][$login][$appl_system];
    
    }elseif($login && !$appl_system && $this->rights[$login_system][$login]['_all_']){
    
      $rights = $this->rights[$login_system][$login]['_all_'];
    
    }else{

      $client = new soapclient($this->securityManager->configuration['SecurityModul']['soap_service']);

      $rights = $client->call('CEUGetRightsFromLogin', 
                              array('system'=>$this->securityManager->configuration['SecurityModul']['ext_system'], 
                                    'login'=>$login, 
                                    'login_system'=>$login_system, 
                                    'appl_system'=>$appl_system
                                    )
                             );

      if($login  && $appl_system) $this->rights[$login_system][$login][$appl_system] = $rights;
      elseif($login  && !$appl_system) $this->rights[$login_system][$login]['_all_'] = $rights;

    }
//print_r($rights);
    return $rights;
	}

  
	/**
	 * @param login
	 * 
	 */
   ///zjisti loginy k nejakemu pravu 
	function GetLoginsWithRight($right_id, $appl_system=false)
	{

    $logins = array();

    if($right_id && !is_array($right_id) && $this->logins[$right_id]){
    
      $logins = $this->logins[$right_id];
    
    }else{

      $client = new soapclient($this->securityManager->configuration['SecurityModul']['soap_service']);

      $logins = $client->call('CEUGetLoginsWithRight', 
                              array('system'=>$this->securityManager->configuration['SecurityModul']['ext_system'], 
                                    'right_id'=>$right_id, 
                                    'appl_system'=>$appl_system
                                    )
                             );
    
      
      if($right && $appl_ident) $this->logins[$appl_ident.'-'.$right] = $logins;  
    
    }
    
//print_r($logins);
    return $logins;
  }
  
  
	function GetRolesWithRight($right_id, $appl_system=false)
	{
    $roles = array();

    if(!$appl_system) $appl_system = $this->securityManager->configuration['SecurityModul']['ext_system'];
    
    $client = new soapclient($this->securityManager->configuration['SecurityModul']['soap_service']);

    $roles = $client->call('CEUGetRolesWithRight', 
                            array('system'=>$this->securityManager->configuration['SecurityModul']['ext_system'], 
                                  'right_id'=>$right_id, 
                                  'appl_system'=>$appl_system
                                  )
                           );

    //print_r($roles);
    return $roles;
  }
    
	/**
	 * @param role
	 * 
	 */
	function GetRightsFromRole($role_id, $role_system=false)
	{
    $rights = array();
        
    $client = new soapclient($this->securityManager->configuration['SecurityModul']['soap_service']);

    $rights = $client->call('CEUGetRightsFromRole', 
                            array('system'=>$this->securityManager->configuration['SecurityModul']['ext_system'], 
                                  'role_id'=>$role_id, 
                                  'role_system'=>$role_system
                                  )
                           );

    //print_r($rights);
    return $rights;

	}

	/**
	 * @param role
	 * 
	 */
	function GetLoginsFromRole($role_id)
	{ 
    $logins = array(); 

    $client = new soapclient($this->securityManager->configuration['SecurityModul']['soap_service']);

    $logins = $client->call('CEUGetLoginsFromRole', 
                            array('system'=>$this->securityManager->configuration['SecurityModul']['ext_system'], 
                                  'role_id'=>$role_id 
                                  )
                           );

    return $logins;
  }  


}
?>