<?php
require_once ('ApplicationModul.inc');

require_once($GLOBALS["TMAPY_LIB"]."/lib/nusoap/lib/nusoap.php");

/**
 * @version 1.0
 * @created 10-IX-2004 15:58:05
 */
class CeuSOAPApplication extends ApplicationModul
{

	/**
	 * @param application
	 * 
	 */
	function GetDefineRightsForApplication($application)
	{
    $rights = array();

    $client = new soapclient($this->configuration['soap_service']);

    $rights = $client->call('CEUGetDefineRightsForApplication', 
                              array('system'=>$this->configuration['ext_system'], 
                                    'application'=>$application 
                                   )
                             );
    $rights = array_key_replace_recursive('--','|',$rights);
    
    $rights = $rights[0];
                              
/*
      // Display the request and response
      echo '<h2>Request</h2>';
      echo '<pre>' . htmlspecialchars($client->request, ENT_QUOTES) . '</pre>';
      echo '<h2>Response</h2>';
*/
//      echo '<pre>' . htmlspecialchars($client->response, ENT_QUOTES) . '</pre>';
/*
      // Display the debug messages
      echo '<h2>Debug</h2>';
      echo '<pre>' . htmlspecialchars($client->debug_str, ENT_QUOTES) . '</pre>';
*/
    
    //print_r($this->applications[$application]);
    //print_r($rights);
    return $rights;
	}

  

	function GetApplicationsInfo($only_reg=false)
	{
    $appl_ret = array();
    $appl = array();

    if($this->applications){
      
      $appl = $this->applications;
      $appl_ret['config']['name_modul'] = $this->configuration['name'];
      $appl_ret['applications'] = $appl;

    }else{

      $client = new soapclient($this->configuration['soap_service']);
  
      $appl_ret = $client->call('CEUGetApplicationsInfo', 
                                array('system'=>$this->configuration['ext_system'], 
                                      'only_reg'=>$only_reg 
                                     )
                               );
                           
      $appl_ret = $appl_ret[0];                         
      
      $this->applications = $appl_ret['applications'];
    }
    
    return $appl_ret;
	}

}
?>
