<?php
require_once ('SecurityModul.inc');


/**
 * @version 1.0
 * @created 01-IX-2004 9:07:40
 */
class BasicSecurityModul extends SecurityModul
{
  
  var $db;
	/**
	 * @param login
	 * 
	 */
	function GetRolesFromLogin($log_ceu_id, $role_system='', $filter=array())
	{

    $roles = array();

    if($log_ceu_id && !$role_system && $this->roles[$log_ceu_id]){
    
      $roles = $this->roles[$log_ceu_id];
    
    }else{

      if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
      /*
      Poznamka: tak jak je nyni tento SQL udelan, tak dokaze vracet pouze role, ktere jsou v tabulce ceu_role a pokud je v tabulce ceu_rel_log_role
                vazba na role z jinych systemu, tak je nevybere, ale zatim to nevadi a asi vadit ani nebude ! Tim padem je prametr "role_system" zbytecny.
      */
      
      if($log_ceu_id)
        $sql = "SELECT r.role_id, r.name, r.system, r.description, r.state, r.owner_id".
               " FROM ceu_role r, ceu_rel_log_role l".
               " WHERE (r.role_id=l.role_id AND r.system=l.role_system)".
               " AND l.log_ceu_id = $log_ceu_id";
      else  
        $sql = 'SELECT r.role_id, r.name, r.system, r.description, r.state, r.owner_id FROM ceu_role r WHERE r.system = \''.$this->securityManager->configuration['name'].'\'';
      
      if($filter['id']) $sql.=' AND r.role_id IN ('.$filter['id'].')';
      if($filter['name']) $sql.=" AND upper(name) LIKE '".$this->Stars2Percent(strtoupper($filter['name']))."'";
      
      $sql.= ' ORDER BY r.name';

      $this->db->Query($sql);
      //echo "<br><b>$sql</b><br>\n";flush();
      
      while($this->db->next_record()) {
          $roles[$this->db->Record['SYSTEM']][] = 
            array('role_id'=>$this->db->Record['ROLE_ID'],
                  'role_name'=>$this->db->Record['NAME'],
                  'role_system'=>$this->db->Record['SYSTEM'],
                  'role_description'=>$this->db->Record['DESCRIPTION'],
                  'role_state'=>$this->db->Record['STATE'],
                  'role_owner_id'=>$this->db->Record['OWNER_ID'],
                 );
      }
      
      if(!$roles) $roles[$this->securityManager->configuration['name']] = array();
      
      if($log_ceu_id) $this->roles[$log_ceu_id] = $roles;
    
    }

    return $roles;
	}

	/**
	 * @param login
	 * 
	 */
	function GetLoginsXXX($login='')
	{
    $logins = array();
    
    if($login && $this->logins[$login]){
    
      $logins = $this->logins[$login];
    
    }else{

      if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];

      $sql = 'SELECT * FROM ceu_login';
      if($login) $sql.= " WHERE login IN ('".implode("','",$this->securityManager->GetLoginsFromResolver($login))."')";
      $this->db->Query($sql);
      while($this->db->next_record()) {
          $logins[$this->db->Record['LOGIN']] =  $this->db->Record;
      }
      if($login) $this->logins[$login] = $logins;
    }

    return $logins;
    
	}

	/**
	 * @param login
	 * 
	 */
	function GetRightsFromLogin($log_ceu_id, $appl_system='')
	{
    $rights = array();
    
    if($log_ceu_id && $appl_system && $this->rights[$log_ceu_id][$appl_system]){

      $rights = $this->rights[$log_ceu_id][$appl_system];
    
    }elseif($log_ceu_id && !$appl_system && $this->rights[$log_ceu_id]['_all_']){
    
      $rights = $this->rights[$log_ceu_id]['_all_'];
    
    }else{

      if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
      
      $add_where = '';
      if($appl_system) $add_where.=" AND r.appl_system = '$appl_system'";
      
      //prava pres CEU role
      $sql = "(SELECT r.appl_system, r.appl_ident, r.right_id, r.right_name, r.role_id, rr.name as role_name, r.role_system".
             " FROM ceu_rel_log_role l, ceu_rel_role_right r, ceu_role rr".
             " WHERE (r.role_id=l.role_id AND r.role_system=l.role_system AND rr.role_id=r.role_id)".
             " AND r.role_system = '".$this->securityManager->configuration['name']."'".
             " AND l.log_ceu_id = $log_ceu_id ".$add_where;

      $sql.= ") UNION ALL (";
      
      //primo prava na login
      $sql.= "SELECT r.appl_system, r.appl_ident, r.right_id, r.right_name, null, null, null".
             " FROM ceu_rel_log_right r".
             " WHERE r.log_ceu_id = $log_ceu_id ".$add_where;
             
      $sql.= ") ORDER BY appl_system, appl_ident, right_name";

      $this->db->Query($sql);
      //echo "<br><b>$sql</b><br>\n";flush();

      while($this->db->next_record()) {
        //$rights['roles'][$this->db->Record[3]][] = $this->db->Record[0].'|'.$this->db->Record[1].'|'.$this->db->Record[2];
        $arr = explode('|',$this->db->Record['RIGHT_ID']);
        $rights[$this->db->Record['APPL_SYSTEM']][$this->db->Record['APPL_IDENT']][] = 
            array('right_id'    => $this->db->Record['RIGHT_ID'], 
                  'name'        => $this->db->Record['RIGHT_NAME'], 
                  'ident'       => $arr[0], 
                  'category'    => $arr[1], 
                  'role_id'     => $this->db->Record['ROLE_ID'], 
                  'role_name'   => $this->db->Record['ROLE_NAME'], 
                  'role_system' => $this->db->Record['ROLE_SYSTEM']
                  );  
      }

      if($log_ceu_id  && $appl_system) $this->rights[$log_ceu_id][$appl_system] = $rights;
      elseif($log_ceu_id  && !$appl_system) $this->rights[$log_ceu_id]['_all_'] = $rights;

    }
//print_r($rights);
    return $rights;
	}

  
	/**
	 * @param login
	 * 
	 */
   ///zjisti loginy k nejakemu pravu 
	function GetLoginsWithRight($right_id, $appl_system=false)
	{

    $logins = array();

    if($right_id && !is_array($right_id) && $this->logins[$right_id]){
    
      $logins = $this->logins[$right_id];
    
    }else{

      if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
      
      if(!$appl_system) $appl_system = $this->securityManager->configuration['name'];
      
      if(is_array($right_id)){
        $right_cond = "IN ('".implode("','",$right_id)."')";
      }else{
        $right_cond = "LIKE '$right_id'";
      }
      
      //loginy pres role
      $sql = "(SELECT r.right_id, r.right_name, l.log_ceu_id, l.role_id, rr.name as role_name, l.role_system, null as appl_system, null as appl_ident".
             " FROM ceu_rel_log_role l, ceu_rel_role_right r, ceu_role rr".
             " WHERE (r.role_id=l.role_id AND r.role_system=l.role_system AND l.role_id=rr.role_id)".
             " AND r.right_id $right_cond AND r.appl_system = '".$appl_system."'";

      $sql.= ") UNION ALL(";

      //loginy primo na pravo
      $sql.= "SELECT right_id, right_name, log_ceu_id, null, null, null, appl_system, appl_ident".
             " FROM ceu_rel_log_right".
             " WHERE right_id $right_cond AND appl_system = '".$appl_system."'";

      $sql.= ")";

      $this->db->Query($sql);
      //echo "<br><b>$sql</b><br>\n";flush();
      
      while($this->db->next_record()){
        $arr = explode('|',$this->db->Record['RIGHT_ID']);
        $logins[] = 
                 array('log_ceu_id'    =>$this->db->Record['LOG_CEU_ID'], 
                       'role_id'       =>$this->db->Record['ROLE_ID'], 
                       'role_name'     =>$this->db->Record['ROLE_NAME'], 
                       'role_system'   =>$this->db->Record['ROLE_SYSTEM'],
                       'right_id'      =>$this->db->Record['RIGHT_ID'],
                       'right_name'    =>$this->db->Record['RIGHT_NAME'],
                       'right_ident'   =>$arr[0],
                       'right_category'=>$arr[1],
                       );  
      }
      
      if($right && $appl_ident) $this->logins[$appl_ident.'-'.$right] = $logins;  
    
    }
    
//print_r($logins);
    return $logins;
  }
  
  
	function GetRolesWithRight($right_id, $appl_system=false)
	{
    $roles = array();

    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
    
    if(!$appl_system) $appl_system = $this->securityManager->configuration['name'];
    
    if(is_array($right_id)){
      $right_cond = "IN ('".implode("','",$right_id)."')";
    }else{
      $right_cond = "= '$right_id'";
    }

    $sql = "SELECT DISTINCT rr.role_id, rr.name, rr.system, rr.description, rr.state".
           " FROM ceu_rel_role_right r, ceu_role rr".
           " WHERE (rr.role_id=r.role_id AND rr.system=r.role_system) AND r.right_id $right_cond AND r.appl_system = '".$appl_system."'";
    $this->db->Query($sql);
    //echo "<br><b>$sql</b><br>\n";flush();
    while($this->db->next_record()) {
      $roles[] = array('role_id'         => $this->db->Record['ROLE_ID'],
                       'role_name'       => $this->db->Record['NAME'],
                       'role_system'     => $this->db->Record['SYSTEM'],
                       'role_description'=> $this->db->Record['DESCRIPTION'],
                       'role_state'      => $this->db->Record['STATE'],
                       );
    }
    //print_r($roles);
    return $roles;
  }
    
	/**
	 * @param role
	 * 
	 */
	function GetRightsFromRole($role_id, $role_system=false)
	{
    $rights = array();
        
    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
    
    $sql = "SELECT r.appl_system, r.appl_ident, r.right_id, r.right_name, r.role_id, r.role_system, rr.name as role_name".
           " FROM ceu_rel_role_right r, ceu_role rr".
           " WHERE r.role_id = rr.role_id AND r.role_id = '$role_id' AND r.role_system = '".$this->securityManager->configuration['name']."'".
           " ORDER BY r.appl_system, r.appl_ident, r.right_name";
    $this->db->Query($sql);
    //echo "<br><b>$sql</b><br>\n";flush();
    while($this->db->next_record()) {
      $arr = explode('|',$this->db->Record['RIGHT_ID']);
      $rights[$this->db->Record['APPL_SYSTEM']][$this->db->Record['APPL_IDENT']][] = 
              array('right_id' => $this->db->Record['RIGHT_ID'],
                    'name'    => $this->db->Record['RIGHT_NAME'],  
                    'ident'    => $arr[0], 
                    'category' => $arr[1], 
                    'role_id'  => $this->db->Record['ROLE_ID'],
                    'role_name'=> $this->db->Record['ROLE_NAME'],
                    'role_system'=> $this->db->Record['ROLE_SYSTEM'],
                   );  
    }
    //print_r($rights);
    return $rights;

	}

	/**
	 * @param role
	 * 
	 */
	function GetLoginsFromRole($role_id, $role_system=false)
	{ 
    $logins = array(); 

    if(!$this->db) $this->db = new $this->securityManager->configuration['SecurityModul']['db'];
    
    $sql = "SELECT r.log_ceu_id, r.role_id, r.role_system, rr.name as role_name".
           " FROM ceu_rel_log_role r, ceu_role rr".
           " WHERE r.role_id = rr.role_id AND r.role_id = '$role_id' AND r.role_system = '".$this->securityManager->configuration['name']."'".
           "";
    $this->db->Query($sql);
    //echo "<br><b>$sql</b><br>\n";flush();
    while($this->db->next_record()) {
        $logins[] = 
               array('log_ceu_id'  =>$this->db->Record['LOG_CEU_ID'],
                     'role_id'     =>$this->db->Record['ROLE_ID'], 
                     'role_name'   =>$this->db->Record['ROLE_NAME'], 
                     'role_system' =>$this->db->Record['ROLE_SYSTEM']
                    );  
    }

    return $logins;
  }  

  function Stars2Percent($value){
    $value = trim($value);
    if($value[0]=='*') $value[0] = '%';
    $end_id = strlen($value)-1;
    if($value[$end_id]=='*') $value[$end_id] = '%';
    return $value; 
  }
}
?>