<?php
require_once ('ceu/Security.inc');

/**
 * @version 1.0
 * @created 01-IX-2004 9:07:38
 */
class Security_Obj extends Security_Obj_Main
{

	var $Security;

	function Security_Obj()
	{
    switch($GLOBALS['PROPERTIES']['DEFAULT_LANG']):
      case 'cz_iso' : $charset = 'iso-8859-2'; break;
      case 'cz_win' : $charset = 'windows-1250'; break;
      default       : $charset = false;
    endswitch;
    
    $this->Security = new Security($charset);
	}

	/**
	 * metoda vraci pouze prazdne pole
	 * @param user
	 * 
	 */
	function GetLocalGroupsForUser($user)
	{
    return array();
	}

	/**
	 * @param user
	 * 
	 */
	function GetGroupsForUser($user='',$appl_system='')
	{
    if (!$user) $user = $this->RemoteUser();
    $groups1 = $this->Security->GetAllRights($user,$GLOBALS["SYSTEM_LOGIN"],$appl_system);
    //die(print_r($groups1));
    //$groups1 = $groups1['T-WIST'];

    $groups = array(); 

    //foreach($groups1 as $g1){
      foreach($groups1 as $grps){
        foreach($grps as $grpname => $rights){
          foreach($rights as $r){
            $groups[$r['right_id']] = $r['right_id'];
          }
        }
      }
    //}
//print_r($groups);
    return $groups;
	}

	/**
	 * @param user
	 * 
	 */
	function GetRolesForUser($user='',$role_system='')
	{
    if (!$user) $user = $this->RemoteUser();
    $roles = $this->Security->GetAllRoles($user,$GLOBALS["SYSTEM_LOGIN"],$role_system);
    return $roles;
	}
  
	/**
	 * metoda vraci pouze prazdne pole
	 * @param group
	 * 
	 */
	function GetUsersForLocalGroup($group)
	{
    return array();
	}

	/**
	 * @param group
	 * @param all_data
	 * 
	 */
	function GetUsersForGroup($group, $application=false, $format=1)
	{ 
    if(!$application) $application = $GLOBALS['PROPERTIES']['AGENDA_IDENT'];
    $users = $this->Security->GetAllLoginsWithRight($group,0,0,$format);
    //print_r($users);
    return $users;
	}

	/**
	 * @param user
	 * @param type    rozlisuje, zda parametr user je LOGIN nebo ID
	 * 
	 */
	function GetUserInfo_Func($user, $type=0, $format=1)
	{
    $users = $this->Security->GetAllUserInfo($user, $GLOBALS["SYSTEM_LOGIN"], false, $type, $format);

    if ($type == 1) $ret = Current($users);
    elseif($users[$user]) $ret = $users[$user];
    elseif($users) $ret = $users;
    else $ret = array();

    return $ret;
	}

	/**
	 * @param name_mask
	 * 
	 */
	function GetUsers($name_mask='')
	{
    $all_users = $this->Security->GetAllUserInfo();
    $all_users = $all_users['T-WIST'];
    
    return $all_users;
	}

	/**
	 * @param name_mask
	 * 
	 */
	function GetGroups($name_mask='')
	{
    $all_groups = $this->Security->GetAllRights();
    $all_groups = $all_groups['T-WIST'];

    return $all_groups;
	}

	/**
	 * @param name_mask
	 * 
	 */
	function GetRoles($name_mask='')
	{
    $all_roles = $this->Security->GetAllRoles(false,'T-WIST');

    return $all_roles;
	}
}
?>