<?php
require_once ('main.inc');

class Security_Authen_Obj extends Security_Authen_Obj_Main
{
  var $ldap_conf = array();
  var $attr_username = '';
  
  function Authenticate($login, $password, $params=array()) {
    
    $ret = false;

    if(!$login || !$password) return false;

    $this->ldap_conf = $this->config['AUTH_SYSTEMS'][$params['system']]['ldap_conf'];

    if(!$this->ldap_conf) die("ldap_auth: missing LDAP configuration for the system (".$params['system'].")");
    
    if($this->ldap_conf["AUTH_LDAP_USERATTR"])
      $this->attr_username = $this->ldap_conf["AUTH_LDAP_USERATTR"];
    
    $filter = $this->attr_username."=".$login;

    $con = ldap_connect($this->ldap_conf["AUTH_LDAP_SERVER"],$this->ldap_conf["AUTH_LDAP_SERVER_PORT"]);
    
    if(!$con) die("ldap_auth: Cannot connect to LDAP server (".$this->ldap_conf["AUTH_LDAP_SERVER"].").");
    
    $bind = ldap_bind($con, $this->ldap_conf["AUTH_LDAP_BIND_USER"], $this->ldap_conf["AUTH_LDAP_BIND_PASSWORD"]);

    if(!$bind) die("ldap_auth: Unable to bind to server.");

    $base_dn = $this->ldap_conf["AUTH_LDAP_BASE_DN_USER"];
    
    $sr = ldap_search($con, $base_dn, $filter, array('dn')); 

    $info = ldap_get_entries($con, $sr);

    $login = $info[0]['dn'];                   
  
    if($login)
      $ret = @ldap_bind($con, $login, $password);

    ldap_close($con);
     
    return $ret; 
  } 
  
}

?>