<?php
/*
AUTHEN modul pro automaticke prihlaseni anonymniho uzivatele k aplikaci, ke ktere ma pravo pristupu.
Jsou 4 moznosti, jak se muze logovat:
1. k aplikaci ma pravo pristupu pouze uzivatel "anonymous" => tak ho to proste pod nim prihlasi
2. k alpikaci ma pristup jak "anonymous", tak jini uziv. => nabidne prihlasovaci okno navic s tlacitkem anonymniho prihlaseni
3. k alpikaci ma pristup jak "anonymous", tak jini uziv. a v URL je &autolog_anonymous=1 => tak ho to rovnou prihlasi
4. nema "anonymous" pristup => logovaci okno
*/
require_once ('main.inc');

class Security_Authen_Obj extends Security_Authen_Obj_Main
{

  var $anonymous_login = 'anonymous';
  var $anonymous_login_system = 'T-WIST';
  var $anonym_mutltiuser_appl = false;
  
  function Authenticate(&$login, $password, &$params) {
    
    $ret = false;
    
    require_once('tmapy_config.inc');
    require_once($GLOBALS["TMAPY_DIR"].'/tmapy/security/ceu/Security.inc');
    $Security_obj = new Security();
   
    if($login && $password && $params['system']){
      $ret = $Security_obj->GetAuthenticate($login, $password, $params['system']);
    }  

    //dle IP adresy se naloguje na urciteho uzivatele - to jsem tam dodelal, abych se nemusel stale prihlasovat (TOHU)
    if(!$ret && $this->config['IP_ADDRESS_LINK_TO_USER']){
       if($this->config['IP_ADDRESS_LINK_TO_USER'][$GLOBALS["REMOTE_ADDR"]]){
         $ret = true;
         $login = $this->config['IP_ADDRESS_LINK_TO_USER'][$GLOBALS["REMOTE_ADDR"]]['login'];
         $params['system'] = $this->config['IP_ADDRESS_LINK_TO_USER'][$GLOBALS["REMOTE_ADDR"]]['system'];
       }
    }

    //neprihlasil se - nema pristup
    if(!$ret){

      $prop_file1 = $GLOBALS["TMAPY_DIR"].$GLOBALS['REQUEST_URI'].'.admin/properties.inc';
      $prop_file2 = $GLOBALS["TMAPY_DIR"].dirname($GLOBALS['REQUEST_URI']).'/.admin/properties.inc';

      if(file_exists($prop_file1))
        $prop_file = $prop_file1;
      elseif(file_exists($prop_file2))  
        $prop_file = $prop_file2;
      else  
        $prop_file = '';

      //existuje properties.inc => leze primo na aplikaci 
      if($prop_file){

        include('tmapy_config.inc');
        include_once(FileUp2(".admin/agenda_func.inc"));//kvuli volani fce GetAgendaPath v Access() 
        include_once(FileUp2(".admin/access_.inc"));

        $GLOBALS['_FROM_SECURITY_'] = true;
        include($prop_file);
        unset($GLOBALS['_FROM_SECURITY_']);
        
        //zjisteni, zda ma "anonymous" pristup k aplikaci
        $GLOBALS['SERVER_CONFIG']['SECURITY']['AUTH_TYPE'] = 'ceu';
        $GLOBALS['SERVER_CONFIG']["SECURITY"]["ANONYMOUS_ACCESS"] = true;
        $GLOBALS['SERVER_CONFIG']["SECURITY"]["ANONYMOUS_LOGIN"] = $this->anonymous_login;
        $anonymous_access = Access(array('agenda'=>$PROPERTIES['AGENDA_IDENT']));
        
        //pokud ma pristup, a neni nastaveno ze ma automaticky na "anonymous" uzivatele, tak jeste zjistit zda maji i dalsi
        if($anonymous_access && !$GLOBALS['autolog_anonymous']){
  
          $this->anonym_mutltiuser_appl = false;
 
          //prava k aplikaci
          $rights = $Security_obj->GetAllDefineRightsForApplication($PROPERTIES['AGENDA_IDENT'],'T-WIST');
  
          //preformatovany seznam nazvu prav k aplikaci 
          $arr_r = array();
          foreach($rights['T-WIST'] as $r => $arr) $arr_r[] = $r;
  
          //uzivatele, kteri maji nektere z prav k aplikaci
          $logins = $Security_obj->GetAllLoginsWithRight($arr_r);
          
          //zjisteni, zda ma k aplikaci pravo i jini uzivatele nez "anonymous"
          foreach($logins as $sys => $log_arr){
            foreach ($log_arr as $larr){
              if(strcmp(strtolower($larr['login']),$this->anonymous_login)!=0){
                $this->anonym_mutltiuser_appl = true;
                break(2);
              }
            }    
          }

          //pokud ma i jiny, tak ma smulu, ale mel by se zobrazit logovaci okno s tlacitkem "autologin"
          if($this->anonym_mutltiuser_appl) $ret = false; 
          
        }
        
        //pokud ma "anonymous" pristup k aplikaci a je bud "autolog_anonymous", nebo je jediny, kdo ma pravo pristupu k aplikaci, tak at se rovnou prihlasi 
        if($anonymous_access && ($GLOBALS['autolog_anonymous'] || !$this->anonym_mutltiuser_appl)){
          $ret = true;
          $login = $this->anonymous_login;
          $params['system'] = $this->anonymous_login_system;
        }        

      }

    }

    return $ret;
       
  } 
  
}

?>