<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: oohforms.inc,v 1.16 2008/04/24 13:43:19 tohu Exp $'.'$Name:  $';exit;}; /* HEADER */

class of_element {

  var $label;
  var $name;
  var $value;
  var $multiple;
  var $extrahtml;
  var $required;
  
  function marshal_dispatch($m,$func) {   
    $vname = $this->name;
    global $$vname;
    return $this->$func($$vname);
  }
  
  function self_get($val, $which, &$count) {
  }
  
  function self_show($val, $which) {
    $count = 0;
    print $this->self_get($val, $which, $count);
    return $count;
  }

  function self_get_frozen($val, $which, &$count) {
    return $this->self_get($val, $which, $count);
  }

  function self_show_frozen($val, $which) {
    $count = 0;
    print $this->self_get_frozen($val, $which, $count);
    return $count;
  }

  function self_validate($val) {
    return false;
  }

  function self_get_js($ndx_array) {
  }

  function autostart_js(){
  }
  
  function before_validate_js(){
  }
  
  function after_validate_js(){
  }
	
  
  function self_print_js($ndx_array) {
    print $this->self_get_js($ndx_array);
  }

  // Note that this function is generally quite simple since
  // most of the work of dealing with different types of values
  // is now done in show_self.  It still needs to be overidable,
  // however, for elements like checkbox that deal with state
  // differently
  function self_load_defaults($val) {
    $this->value = $val;
  }

  // Helper function for compatibility
  function setup_element($a) {
    $cv_tab = array("type"=>"ignore",
        "min_l"=>"minlength",
        "max_l"=>"maxlength",
        "extra_html"=>"extrahtml",
        "required"=>"required");
    reset($a);
    while (list($k,$v) = each($a)) {
      if (isset($cv_tab[$k]) && $cv_tab[$k]=="ignore") continue;
      else $k = (isset($cv_tab[$k])&&($cv_tab[$k]) ? $cv_tab[$k] : $k);
      $this->$k = $v;
    }
//    $n = $this->name;
//    echo isset($this->value); 
//    if (!isset($this->value)):
//      $this->value = isset($GLOBALS[$this->name])&&isset($this->value)?$GLOBALS[$this->name]:$this->value;
//      echo $this->value." = ".$this->name; 
      $this->value = isset($GLOBALS[$this->name])?$GLOBALS[$this->name]:$this->value;
//      echo "$n=".$this->value."<br>"; 
//    endif;
  }

} // end ELEMENT

class of_hidden extends of_element {

  var $hidden=1;
  var $add;
  
  function of_hidden($a) {
    $this->setup_element($a);
  }

  function self_get($val,$which, &$count) {
    $str = "";

    $v = (is_array($this->value) ? $this->value : array($this->value));
    $n = $this->name . ($this->multiple ? "[]" : "");
    reset($v);
    while (list($k,$tv) = each($v)) {
      $str .= "<input type=\"hidden\" name=\"$n\" value=\"$tv\" $this->add";
      if ($this->extrahtml)
        $str .=" $this->extrahtml";
      $str .= " />\n";
    }
    
    return $str;
  }
} // end HIDDEN

class of_valid_fce extends of_element {

  var $name_fce;

  function of_valid_fce($a) {
    $this->name_fce = $a["name_fce"];
  }
  
  function after_validate_js(){
    return $str = "\n".$this->name_fce."\n";
  }  
}

class of_reset extends of_element {

  var $src;

  function of_reset($a) {
    $this->setup_element($a);
  }

  function self_get($val, $which, &$count) {
    $str = "<input name=\"$this->name\" type=\"reset\" value=\"$val\"";
    if ($this->extrahtml) 
      $str .= " $this->extrahtml";
    $str .= " />";
    
    return $str;
  }
} // end RESET

class of_submit extends of_element {

  var $src;

  function of_submit($a) {   
    $this->setup_element($a);
  }

  function self_get($val, $which, &$count) {
    $str = "";
    
    $sv = empty($val) ? $this->value : $val;
    $str .= "<input name=\"$this->name\" value=\"$sv\" class=\"button\"";
    if ($this->src) 
      $str .= " type=\"image\" src=\"$this->src\"";
    else 
      $str .= " type=\"submit\"";
    if ($this->extrahtml) 
      $str .= " $this->extrahtml";
    $str .= " />";
    
    $count = 1;
    return $str;
  }
  
  function self_load_defaults($val) {
    // SUBMIT will not change its value
  }
} // end SUBMIT

class form {
  var $elements;
  var $hidden;
  var $jvs_name;
  var $form_name;
  var $isfile;
  var $n;

  function get_start($jvs_name="",$method="",$action="",$target="",$form_name="") {
    global $SCRIPT_NAME;
    
    $str = "";
    
    $this->form_name = $form_name;
    $this->jvs_name = "";
    $this->n = 0;
    if (!$method) $method = "post";
    if (!$action) $action = $SCRIPT_NAME;
    if (!$target) $target = "_self";

    $str .= "<form name=\"$form_name\"";
    if ($this->isfile) {
      $str .= " enctype=\"multipart/form-data\"";
      $method = "post";
    }
    $str .= " action=\"$action\"";
    $str .= " method=\"$method\"";
    $str .= " target=\"$target\"";
    if ($jvs_name) {
      $this->jvs_name = $jvs_name;
      $str .= " onsubmit=\"return ${jvs_name}_Validator(this)\"";
    }
    
    $str .= ">\n";
    
    return $str;
  }

  function start($jvs_name="",$method="",$action="",$target="",$form_name="") {
    print $this->get_start($jvs_name,$method,$action,$target,$form_name);
  }

  function get_finish($after="",$before="") {
    global $sess;
    $str = "";
    
    if ($this->hidden) {
      reset($this->hidden);
      while (list($k,$elname) = each($this->hidden)) 
        $str .= $this->get_element($elname);
    }
    if (is_object($sess) && ($sess->mode == "get")) {
      $str .= sprintf("<input type=\"hidden\" name=\"%s\" value=\"%s\" />\n", $sess->name, $sess->id);
    }
    $str .= "</form>\n";

    if ($this->jvs_name) {
      $jvs_name = $this->jvs_name;
      $str .= "<script language=\"javascript\" type=\"text/javascript\">\n<!--\n";
      reset($this->elements);
      $active = "";
      while (list($k,$elrec) = each($this->elements)) {
        //tato podminka kontroloje, aby nedostal "focus" prvek, ktery nevyhovuje (je frozen, hidden, radio, obsahuje znak '[' - pole, multiple, button submit, je disabled, button ... )  
        if ((!$active && !$elrec["ob"]->frozen && ($elrec["ob"]->type != "of_hidden") && ($elrec["ob"]->type != "of_radio") && (!strstr($elrec["ob"]->name,'['))&& (!$elrec["ob"]->multiple) && ($elrec["ob"]->type != "of_submit") && (!Eregi("disabled",$elrec["ob"]->extrahtml)) && (!Eregi("of_button", $elrec["ob"]->type)))||($elrec["ob"]->active && !$elrec["ob"]->frozen)) $active = $k;
        $el = $elrec["ob"];
        $str .= $el->autostart_js();
      }
      if ($active) {
        $str .= "try {document.${jvs_name}.$active.focus();} catch(e) {}";
      }
      $str .= "\n";
      $str .= "function ${jvs_name}_Validator(f) {\n";

      reset($this->elements);
      while (list($k,$elrec) = each($this->elements)) {
        $el = $elrec["ob"];
        $str .= $el->before_validate_js();
      }

      if (strlen($before))
        $str .= "$before\n";
      reset($this->elements);
      while (list($k,$elrec) = each($this->elements)) {
        $el = $elrec["ob"];
        $str .= $el->self_get_js($elrec["ndx_array"]);
      }
      if (strlen($after))
        $str .= "$after\n";

      reset($this->elements);
      while (list($k,$elrec) = each($this->elements)) {
        $el = $elrec["ob"];
        $str .= $el->after_validate_js();
      }
      if(!$this->dont_disabled_submit_button && !$GLOBALS['PROPERTIES']['NO_DISABLE_BUTTON']){
  			if ($GLOBALS["DELETE_ID"])
          $str .= "\nif (document.forms[1].__) document.forms[1].__.disabled = true;\n";
        elseif($this->form_name)
          $str .= "\nif (document.".$this->form_name.".__) document.".$this->form_name.".__.disabled = true;\n";
        else
          $str .= "\nif (document.forms[0].__) document.forms[0].__.disabled = true;\n";
      }  

      $str .= "}\n//-->\n</script>\n";
    }    
    return $str;
  }
  
  function finish($after="",$before="") {
    print $this->get_finish($after, $before);
  }
  
  function add_element($el) {

    if (!is_array($el)) 
      return false;
    
    $cv_tab = array("select multiple"=>"select", "image"=>"submit");
    if ((isset($cv_tab[$el["type"]]))&&($t = $cv_tab[$el["type"]])) 
      $t = ("of_" . $t);
    else
      $t = ("of_" . $el["type"]);
    
    // translate names like $foo[int] to $foo{int} so that they can cause no
    // harm in $this->elements
    # Original match
    # if (preg_match("/(\w+)\[(d+)\]/i", $el[name], $regs)) { 
//    if (ereg("([a-zA-Z_]+)\[([0-9]+)\]", $el["name"], $regs)) {
    if (ereg("([a-zA-Z_]+)[[]([0-9]+)[]]", $el["name"], $regs)) {
       $el["name"] = sprintf("%s{%s}", $regs[1], $regs[2]);
       $el["multiple"] = true;
    }
    $el = new $t($el);
    $el->type = $t; # as suggested by Michael Graham (magog@the-wire.com)
    if (isset($el->isfile)&&($el->isfile)) 
      $this->isfile = true;
    $this->elements[$el->name]["ob"] = $el;
    if (isset($el->hidden)&&($el->hidden))
      $this->hidden[] = $el->name;
  }

  function get_element($name,$value=false) {
    $str = "";
    $x   = 0;
    $flag_nametranslation = false;
    
    // see add_element: translate $foo[int] to $foo{int}
#   Original pattern
#   if (preg_match("/(w+)\[(\d+)\]/i", $name, $regs) {
//    if (ereg("([a-zA-Z_]+)\[([0-9]+)\]", $name, $regs)) {
    if (ereg("([a-zA-Z_]+)[[]([0-9]+)[]]", $name, $regs)) {
       $org_name = $name;
       $name = sprintf("%s{%s}", $regs[1], $regs[2]);
       $flag_nametranslation = true;
    }
    
    if (!isset($this->elements[$name])) 
      return false; 

    if (!isset($this->elements[$name]["which"]))
      $this->elements[$name]["which"] = 0;

    $el = $this->elements[$name]["ob"];
    if (isset($falg_nametranslation)&&(true == $falg_nametranslation))
      $el->name = $org_name; 

    if (($el->required)&&(!$el->minlength)):
      $el->minlength = 1; 
      $el->length_e = $GLOBALS["RESOURCE_STRING"]["oohform_1"]; // "Hodnota v poli '";
      $el->length_e .= $el->label?$el->label:$name;
      $el->length_e .= $GLOBALS["RESOURCE_STRING"]["oohform_2"]; // "' nesm bt przdn!";
      $this->elements[$name]["ob"] = $el;
    endif;
      
    if (!isset($value)) 
       $value = $el->value; 

    if (isset($el->frozen)&&$el->frozen):
      $str .= $el->self_get_frozen($value,$this->elements[$name]["which"]++, $x);
    else:
      $str .= $el->self_get($value,$this->elements[$name]["which"]++, $x);
    endif;
    $this->elements[$name]["ndx_array"][$el->name] = $this->n;
    $this->n += $x;
    
    return $str;
  }

  function show_element($name, $value="") {
    print $this->get_element($name, $value);
  }

  function ge($name, $value="") {
    return $this->get_element($name, $value);
  }

  function se($name, $value="") {
    $this->show_element($name, $value);
  }

  function ae($el) {
    $this->add_element($el);
  }

  function validate($default=false,$vallist="") {
    if ($vallist) {
      reset($vallist);
      $elrec = $this->elements[current($vallist)];
    } else {
      reset($this->elements);
      $elrec = current($this->elements);
    }
    while ($elrec) {
      $el = $elrec["ob"];
      if ($res = $el->marshal_dispatch($this->method,"self_validate"))
        return $res; 
      if ($vallist) {
        next($vallist);
        $elrec = $this->elements[current($vallist)];
      } else {
        next($this->elements);
        $elrec = current($this->elements);
      }
    }
    return $default;
  }

  function load_defaults($deflist="") {
    if ($deflist) {
      reset($deflist);
      $elrec = $this->elements[current($deflist)];
    } else {
      reset($this->elements);
      $elrec = current($this->elements);
    }
    while ($elrec) {
      $el = $elrec["ob"];
      $el->marshal_dispatch($this->method,"self_load_defaults");
      $this->elements[$el->name]["ob"] = $el;  // no refs -> must copy back
      if ($deflist) {
        next($deflist);
        $elrec = $this->elements[current($deflist)];
      } else {
        next($this->elements);
        $elrec = current($this->elements);
      }
    }
  }

  function freeze($flist="") {
    if ($flist) {
      reset($flist);
      $elrec = $this->elements[current($flist)];
    } else {
      reset($this->elements);
      $elrec = current($this->elements);
    }
    while ($elrec) {
      $el = $elrec["ob"];
      $this->elements[$el->name]["frozen"]=1;
      if ($flist) {
        next($flist);
        $elrec = $this->elements[current($flist)];
      } else {
        next($this->elements);
        $elrec = current($this->elements);
      }
    }
  }

} /* end FORM */

if (!isset($_PHPLIB["libdir"])) {
  $_PHPLIB["libdir"] = "";
}

include_once($GLOBALS["TMAPY_LIB"]."/of_text.inc");
include_once($GLOBALS["TMAPY_LIB"]."/of_select.inc");
include_once($GLOBALS["TMAPY_LIB"]."/of_radio.inc");
include_once($GLOBALS["TMAPY_LIB"]."/of_checkbox.inc");
include_once($GLOBALS["TMAPY_LIB"]."/of_textarea.inc");
include_once($GLOBALS["TMAPY_LIB"]."/of_file.inc");

?>
