<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: MapServer.inc,v 1.16 2008/02/07 13:43:34 tokr Exp $'.'$Name:  $';exit;}; /* HEADER */

class MS_MapServer {
  var $Server;
  var $Map;
  var $result = array();
  var $index = 0;
  var $Record;

  function MS_MapServer($properties) {
    $this->Server = $properties["server"];
    $this->Map = $properties["project"];
    $this->CharSet = $properties["charset"]?$properties["charset"]:"ISO-8859-2";
  }

  function GetURL() {
    return $this->Server."?map=".$this->Map;
  }

  function query($query) {
    $query = "map=".$this->Map.$query;
//     if ($GLOBALS["request_method"]!="Session") $this->query_get($query);
//     else $this->query_post($query);
    if (strlen($query)<=2000) $this->query_get($query);
    else $this->query_post($query);
  }

  function query_get($query) {
    $index = 0;
    $query = $this->Server."?".$query;
    $fp = FOpen($query, "r");
    if ($fp) {
      while (!feof($fp)):
        $buffer = fgets($fp, 4096);
        if (StrLen($buffer) == 0) break;
        if (StrCmp(SubStr($buffer,0,5), '$data') != 0) continue;
        eval($buffer);
        $this->result[] = $data;
      endwhile;
    }
  }

  function query_post($query) {
    list($protokol,$rest) = Explode("://",$this->Server);
    if ($rest=="") { 
      $rest = $protokol;
      $protokol = "http";
    }
    list($host,$rest) = Explode("/",$rest,2);
    $pathname = "/".$rest;
    list($hostname,$port) = split(":",$host);
    if($port=="") $port = "80";
    
    //tono: now using curl 
    $ch = curl_init();
    $url = $protokol.'://'.$hostname.':'.$port.$pathname;
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.5 [en] (WinNT; I)');
//      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    if(strcasecmp($protokol,'HTTP')==0) curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $query);

//      curl_setopt($ch, CURLOPT_VERBOSE, 1);
    
    if($this->CurlParameters['proxy_hostname'] && $this->CurlParameters['proxy_port']) 
      curl_setopt($ch, CURLOPT_PROXY, $this->CurlParameters['proxy_hostname'].':'.$this->CurlParameters['proxy_port']);
    if($this->CurlParameters['proxy_user'] && $this->CurlParameters['proxy_pwd'])
      curl_setopt($ch, CURLOPT_PROXYUSERPWD, $this->CurlParameters['proxy_user'].':'.$this->CurlParameters['proxy_pwd']);

    if($this->CurlParameters['username'] && $this->CurlParameters['password'])
      curl_setopt($ch, CURLOPT_USERPWD, $this->CurlParameters['username'].':'.$this->CurlParameters['password']);

    $html = curl_exec ($ch);
    $ch_code = curl_getinfo ($ch, CURLINFO_HTTP_CODE);
    if (!$html) {
       die("error CURL Exec: ".curl_error($ch));
    } 
    if ($ch_code != 200) {
       die("error CURL Exec: return code ".$ch_code);
    }
    curl_close ($ch);
    
    $buf_arr = Explode("\n",$html);
    for($i=0;$i<Count($buf_arr);$i++) {
      if (StrCmp(SubStr($buf_arr[$i],0,5), '$data') != 0) continue;
      eval($buf_arr[$i]);
      $this->result[] = $data;
    }
  }

  function query_wfs_get_feature($wfs_query,$met) {
    $response = $this->RequestXMLPost($wfs_query);
    $response = iconv($this->wfs_encoding,'UTF-8',str_replace($this->wfs_encoding,'UTF-8',Trim($response)));    
    $response_dom = domxml_open_mem($response,DOMXML_LOAD_PARSING,$error);
    $root_node = $response_dom->first_child();
    $features = $root_node->get_elements_by_tagname("featureMember");
    $res = Array();
    $i=0;
    foreach($features as $key=>$ft) {
      foreach($met as $field) {
        $field_elem = $ft->get_elements_by_tagname($field['origName']);
        $res[$i][$field['name']] = iconv('UTF-8',$this->CharSet,$field_elem[0]->get_content()); //'ISO-8859-2'
      }
      if($props=$ft->get_elements_by_tagname('polygonProperty')?$ft->get_elements_by_tagname('polygonProperty'):$ft->get_elements_by_tagname('Polygon'))
        $res[$i]['_SHAPE_TYPE_'] = 'polygon';
      elseif($props=$ft->get_elements_by_tagname('MultiPolygon'))
        $res[$i]['_SHAPE_TYPE_'] = 'multipolygon';
      elseif($props=$ft->get_elements_by_tagname('lineStringProperty')?$ft->get_elements_by_tagname('lineStringProperty'):$ft->get_elements_by_tagname('LineString'))
        $res[$i]['_SHAPE_TYPE_'] = 'polyline';
      elseif($props=$ft->get_elements_by_tagname('pointProperty')?$ft->get_elements_by_tagname('pointProperty'):$ft->get_elements_by_tagname('Point'))
        $res[$i]['_SHAPE_TYPE_'] = 'point';
      $coords = $props[0]->get_elements_by_tagname('coordinates');
      if ($coords) $wfs_coords = $coords[0]->get_content(); 
      else $wfs_coords=false;
      $res[$i]['_SHAPE_COORDS_'] = $wfs_coords;
      $bbox = $ft->get_elements_by_tagname('Box');
      $res[$i]['_SHAPE_BBOX_'] = Trim($bbox[0]->get_content());
      //$res[$i]['_FEATURE_SEGMENT_'] = iconv('UTF-8',$this->wfs_encoding,$response_dom->dump_node($ft));
      $res[$i]['_FEATURE_SEGMENT_'] = preg_replace('/(featureMember)[^>]*(>)/','\\1\\2',$this->_dump_node($ft,$this->wfs_encoding));
      
      $i++;
    }
    $response_dom->free();
    return $res;
  }

  function next_record() {
    if ($this->index < Count($this->result)) {
      $this->Record = $this->result[$this->index];
      $this->index++;
      return true;
    }
    else return false;
  }

  function service_info($layer) {
    $layers = $this->get_wms_layers($layer);
    if(!$layers) return false;
    $wfs_layers = $this->get_wfs_layers($layer);
    if(!$wfs_layers) return false;
    if(is_array($wfs_layers)) {
      foreach($wfs_layers as $j=>$wfs_layer) {
        foreach($layers as $k=>$l) {
          if($l['name']==$wfs_layer['name']) {
            $layers[$k] = $wfs_layers[$j];
          }
        }
      }
    }
    return $layers;
  }

  // Returns names of layers from WMS Capability response
  function get_wms_layers($layer) {
    $response_dom = $this->Request('SERVICE=WMS&REQUEST=GetCapabilities&VERSION=1.1.1');
    if(!$response_dom) return false;
    $xpath_src = $response_dom->xpath_new_context();

    $extent_node = $xpath_src->xpath_eval('/WMT_MS_Capabilities/Capability/Layer/BoundingBox',$xpath_src);
    $extent_elem = $extent_node->nodeset;
    $minx = $extent_elem[0]->get_attribute("minx");
    $miny = $extent_elem[0]->get_attribute("miny");
    $maxx = $extent_elem[0]->get_attribute("maxx");
    $maxy = $extent_elem[0]->get_attribute("maxy");
    $layers['extent'] = $minx.' '.$miny.' '.$maxx.' '.$maxy;
    //die(print_r($layers['extent']));

    $layers_nodes = $xpath_src->xpath_eval('/WMT_MS_Capabilities/Capability/Layer/Layer',$xpath_src);
    $layers_elems = $layers_nodes->nodeset;
    foreach($layers_elems as $key=>$layer_elem) {
      $name_tag = $layer_elem->get_elements_by_tagname("Name");
      $title_tag = $layer_elem->get_elements_by_tagname("Title");
      $name = $name_tag[0]->get_content();
      if(isSet($layer) && $layer!=$name) continue; 
      $layers[$key]['name'] = $name;
      $layers[$key]['title'] = $title_tag[0]->get_content();
    }
    //die(print_r($names));
    $response_dom->free();
    unset($response_dom);
    return $layers;
  }

  // Returns names of layers from WFS Capability response
  function get_wfs_layers($layer) {
    $response_dom = $this->Request('SERVICE=WFS&REQUEST=GetCapabilities&VERSION=1.0.0');
    if(!$response_dom) return false;
    $root = $response_dom->first_child();
    $feature_types = $root->get_elements_by_tagname("FeatureType");
    foreach($feature_types as $key=>$ft) {
      $name_tag = $ft->get_elements_by_tagname("Name");
      $title_tag = $ft->get_elements_by_tagname("Title");
      $name = $name_tag[0]->get_content();
      if(isSet($layer) && $layer!=$name) continue; 
      $layers[$key]['name'] = $name;
      $layers[$key]['title'] = $title_tag[0]->get_content();
      $layers[$key]['fields'] = $this->get_wfs_fields($layers[$key]['name']);
    }
    $response_dom->free();
    return $layers;
  }

  // Returns names of layers from WCS Capability response
  function get_wcs_layers() {
    $response_dom = $this->Request('SERVICE=WCS&REQUEST=GetCapabilities&VERSION=1.0.0');
    if(!$response_dom) return false;
    $root = $response_dom->first_child();
    $coverages = $root->get_elements_by_tagname("CoverageOfferingBrief");
    foreach($coverages as $cov) {
      $name_tag = $cov->get_elements_by_tagname("name");
      $title_tag = $cov->get_elements_by_tagname("label");
      $layers[$key]['name'] = $name_tag[0]->get_content();
      $layers[$key]['title'] = $title_tag[0]->get_content();
    }
    $response_dom->free();
    return $layers;
  }


  function get_wfs_fields($feature_type) {
    $active_fields = $this->get_active_fields($feature_type);
    if(!$active_fields) return false;
    $response_dom = $this->Request('SERVICE=WFS&REQUEST=DescribeFeatureType&VERSION=1.0.0&TypeName='.$feature_type.'');
    if(!$response_dom) return false;
    $xpath_src = $response_dom->xpath_new_context();
    $nodes_type = $xpath_src->xpath_eval('//*[local-name() = \'sequence\']/*[local-name() = \'element\'][@name]',$xpath_src);

    $elems_type = $nodes_type->nodeset;

    foreach($elems_type as $elem_type) {

      if($elem_type->has_attribute("type") && preg_match("/^gml:.+/",$elem_type->get_attribute("type"))) {
        continue;
      }

      $atr_name = $elem_type->get_attribute("name");
      if(!in_array(strtoupper($atr_name),$active_fields)) continue;
      $names[] = $atr_name;

      if($elem_type->has_attribute("type")) {
         $type = $elem_type->get_attribute("type");
         $lens[] = '';
      }
      else {
         $children = $elem_type->child_nodes();
         foreach($children as $child) {
           if($child->tagname == "simpleType") $children_2 = $child->child_nodes();
         }
         foreach($children_2 as $child) {
           if($child->tagname == "restriction") {
             $type = $child->get_attribute("base");
             $children_3 = $child->child_nodes();
             foreach($children_3 as $child) {
               if($child->tagname == "maxLength") $lens[] = $child->get_attribute("value");
               else $lens[] = '';
             }
           }
         }
      }

      $types[] = $type;

      $null[] = $elem_type->get_attribute("nillable");

//       if(in_array($atr_name,$active_fields))
//         $active[] = 1;
//       else
//         $active[] = 0;
    }

    if(is_array($names)) {
      foreach($names as $k=>$name) {
        $ret[$k]['name']=strToUpper($name);
        $ret[$k]['origName']=$name;
        $ret[$k]['type']=$types[$k];
        $ret[$k]['len']=$lens[$k];
        $ret[$k]['null']=$null[$k];
        $ret[$k]['active']=$active[$k];
      }
    }

    $response_dom->free();
    return $ret; // vraci pole s atributy (jmeno, typ, delka, ..)
  }

  // ziskava atributy pouzitelne pro Info a Hotlink
  function get_active_fields($layer) {
    $php_data = $this->Request('mode=INDEXQUERY&qlayer='.$layer.'&shapeindex=1&tileindex=1');
    $act_fields=array();
    eval($php_data);
    if(is_array($data)) {
      foreach($data as $key=>$val) {
        if($key!='ext' && $key!='layer') {
          $act_fields[] = $key;
        }
      }
    }
    return $act_fields;
  }
  //--

    function Request($request) {

      $ch = curl_init();
      //die(print_r($this->GetURL().'&'.$request));

      curl_setopt($ch, CURLOPT_URL, $this->GetURL().'&'.$request);

      //curl_setopt($ch, CURLOPT_HEADER, 0);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
      curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.5 [en] (WinNT; I)');

//      curl_setopt($ch, CURLOPT_POST, true);
//      curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
     if(preg_match("/^https:.+$/",$this->GetURL()))
       curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $con->CurlParameters['verifypeer']?true:false);



//      curl_setopt($ch, CURLOPT_USERPWD, $con->CurlParameters['username'].':'.$con->CurlParameters['password']);


      $response = curl_exec ($ch);

      if(preg_match("/mode=INDEXQUERY&qlayer=/",$request))
        return $response;

      if(preg_match("/DescribeFeatureType/",$request))
        //die($response);
        ;

      $ch_code = curl_getinfo ($ch, CURLINFO_HTTP_CODE);
      if (!$response) {
         die("error CURL Exec: ".curl_error($ch));
      }
      if ($ch_code != 200) {
         die("error CURL Exec: return code ".$ch_code);
      }
      curl_close ($ch);

      if($dom = @domxml_open_mem(Trim($response),DOMXML_LOAD_PARSING,$error)) {
        return $dom;
      }
      else { 
        return false;
      }
  }

    function RequestXMLPost($request) {

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $this->GetURL());

      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
      curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.5 [en] (WinNT; I)');

      curl_setopt($ch, CURLOPT_POST, true);

      $headers = Array("Content-type: text/xml");
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $request);

      if(preg_match("/^https:.+$/",$this->GetURL()))
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $con->CurlParameters['verifypeer']?true:false);

      $response = curl_exec ($ch);

      if(preg_match("/Filter/",$request))
            //print($request.'<br>----<br>'.$response.'<br>----<br>');
        ;

      $ch_code = curl_getinfo ($ch, CURLINFO_HTTP_CODE);
      if (!$response) {
         die("error CURL Exec: ".curl_error($ch));
      }
      if ($ch_code != 200) {
         die("error CURL Exec: return code ".$ch_code);
      }
      curl_close ($ch);

      preg_match("/encoding=\"(.+)\"/",$response,$match);
      $this->wfs_encoding = $match[1]?$match[1]:$this->CharSet;

      if(Count($this->exclude_feature)>0) {
        $patt = array("/<([a-zA-Z]*[:]?[a-zA-Z0-9_]+)\/>/","/\n/","/>\s+</");
        $repl = array("<\\1></\\1>","","><");
      
        $response = preg_replace($patt,$repl,$response);
        foreach($this->exclude_feature as $exclude) {
          $exclude = preg_replace($patt,$repl,$exclude);
          $response = str_replace($exclude,'',$response);
        }
      }

      return $response;
  }
  
  function ParseGetFeatureInfoParams($params) {
    $params['INFO_FORMAT'] = 'application/vnd.ogc.gml';
    return $params;
  }
  
  function GetFeatureInfoResult($response) {
    die(print_r($response));
    $result = array();
    $response_dom = domxml_open_mem($response,DOMXML_LOAD_PARSING,$error);
    $root_node = $response_dom->first_child();
    $features = $root_node->get_elements_by_tagname("FIELDS");
    foreach($features as $ft) {
      $attrs = $ft->attributes();
      $res = array();
      foreach($attrs as $at) {
        $name_arr = Explode('.',$at->name);
        $res[$name_arr[Count($name_arr)-1]] = $at->value;
      }
      $result[] = $res;
    }    
    return $result;
  }

  function _dump_node($node,$encoding){
    $domNode = domxml_new_doc("1.0");
    $clonedNode = $node->clone_node(true);
    $domNode->append_child($clonedNode);
    $result = $domNode->dump_mem(true,$encoding);
    $pos = strpos($result,"?>");
    return substr($result,$pos+2);
  }

}

?>
