<?php

require_once($GLOBALS["TMAPY_LIB"]."/lib/nusoap/lib/nusoap.php");

//Datapacket xml parser: <table><row><field name="fldname">fld vlaue</field><field ...><envelope xmin="65656" ymin="6565" xmax="6546" ymax="989"/></row></table>
//return is array 
class DataPacketParser {
  var $records = array();
  var $rowidx = 0;
  var $activefield = "";
 
  function startElement($parser, $name, $attrs) {
    
    if ($name=="row") {
      $this->records[$this->rowidx] = array();    
    }
    if ($name=="field") {
      $this->activefield = $attrs["name"];
      $this->records[$this->rowidx][$this->activefield] = "";
    } 
    if ($name=="envelope"){
      $this->records[$this->rowidx]["ext"]= array("minx"=>$attrs["xmin"],
                                        "miny"=>$attrs["ymin"],
                                        "maxx"=>$attrs["xmax"],
                                        "maxy"=>$attrs["ymax"]); 
    }
  }

  function endElement($parser, $name) {
    if ($name=="row") {
      $this->rowidx++;
    }
  }

  function characterData($parser, $data) {
    $this->records[$this->rowidx][$this->activefield] = $data; 
  }
  
  function parse($sxml) { 
    $xml_parser = xml_parser_create();
    xml_set_object($xml_parser, &$this);
    xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, false);
    xml_set_element_handler($xml_parser, "startElement", "endElement");
    xml_set_character_data_handler($xml_parser, "characterData");

    if (!xml_parse($xml_parser,$sxml)) {
      die(sprintf("XML error: %s at line %d",
                   xml_error_string(xml_get_error_code($xml_parser)),
                   xml_get_current_line_number($xml_parser)));
    }
    return $this->records;
   }
}


class MS_ArcServerA {
  var $Server;
  var $Port;
  var $Path;
  var $MapName;
  
  var $Record;
  
  var $row_idx=0;
  var $Data=array(); 

  function MS_ArcServerA($properties) {
    $this->Server = $properties["server"];
    $this->Port = $properties["port"]?$properties["port"]:8080;
    $this->Servlet = $properties["servlet"]?$properties["servlet"]:"/AServAdapter/services/ASAdapter";
    $this->ServerObject = $properties["serverobject"]?$properties["serverobject"]:0;
    $this->MapId = $properties["mapid"]?$properties["mapid"]:0;
  }  

  function GetWebServiceUrl(){
    return "http://".$this->Server.":".$this->Port.$this->Servlet;
  }
   
  function GetURL() {
    return $this->Server;
  }

  function query($query) {
    $this->Data = array();
    
    $soapclient = new soapclient($this->GetWebServiceUrl()); 
    if ($query["query_type"]=="spatial") {
        $par = array(
                     "serverObjectName"=>(string)$this->ServerObject, 
                     "mapId"=>(int) $this->MapId,
                     "layerName"=>(string)$query["lyname"],
                     new soapval("xMin","double",(double)$query["xmin"]),
                     new soapval("yMin","double",(double)$query["ymin"]),
                     new soapval("xMax","double",(double)$query["xmax"]),
                     new soapval("yMax","double",(double)$query["ymax"]),
                     "spatialField"=>(string)$query["spatial_field"],
                     "subFields"=>(string)$query["subfields"], 
                     "whereClause"=>(string)$query["where"]
                    );
                  
        $data_xml = $soapclient->call("spatialQuery",$par);
        
    }else{
        $par = array(
                     "serverObjectName"=>(string)$this->ServerObject, 
                     "mapId"=>(int) $this->MapId,
                     "layerName"=>(string)$query["lyname"],
                     "subFields"=>(string)$query["subfields"],
                     "whereClause"=>(string)$query["where"]
                    );
        
        $data_xml = $soapclient->call("query",$par);
    }

    if (!$soapclient->getError()){ 
      $dpp = new DataPacketParser();
      $this->Data = $dpp->parse($data_xml);
      return true;
    }else{ 
        $p = $soapclient->getError();
        echo 'Chyba ws: '. $soapclient->getError(); 
        return false;
    }
  }
      
  function next_record() {
	  if ($this->row_idx < Count($this->Data)) {
      $this->Record = $this->Data[$this->row_idx];
      $this->row_idx++;
			return true; 
		}
		else return false;
  }

}
?>
