<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ArcIMS.inc,v 1.24 2008/01/09 07:44:29 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

class Node { 
    var $name; 
    var $attributes; 
    var $ancestors = "/";
    var $data; 
    var $type; 

    function Node($tree) { 
        $this->name = array_pop($tree); 
        $this->ancestors .= implode("/", $tree); 
    } 
}

class XML { 
    var $tree = array(); 
    var $nodes = array(); 

    function XML($html) { 
        $html = Str_Replace('&#', '-#-#-#-', $html);
        $xml_parser = xml_parser_create(); 
        xml_set_object($xml_parser,&$this); 
        xml_set_element_handler($xml_parser, "startElement", "endElement"); 
        xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, false); 
        xml_parse($xml_parser,$html);        
        xml_error_string(xml_get_error_code($xml_parser)); 
        xml_get_current_line_number($xml_parser); 
    } 

    function startElement($parser, $name, $attribs) { 
        $this->tree[] = $name; 
        $node = new Node($this->tree); 
        while (list($k, $v) = each($attribs)) { 
            $node->attributes[$k] = Str_Replace('-#-#-#-', '&#', $v); 
      } 
        $this->nodes[] = $node; 
    } 

    function endElement($parser, $name) { 
        if (count($this->nodes) >= 1) { 
            $prev_node = $this->nodes[count($this->nodes)-1]; 
            if (strlen($prev_node->data) > 0 || $prev_node->name != $name) { 
                $this->tree[count($this->tree)-1] = "/".$this->tree[count($this->tree)-1]; 
                $this->nodes[] = new Node($this->tree, NULL); 
            } else { 
                $prev_node->name = $prev_node->name."/"; 
                $this->nodes[count($this->nodes)-1]->name = $this->nodes[count($this->nodes)-1]->name."/"; 
            } 
        } 
        array_pop($this->tree);
    } 
}

class MS_ArcIMS {
  var $Server;
  var $Port;
  var $Path;
  var $ServiceName;
  var $result = array();
  var $index = 0;
  var $Record;

  function MS_ArcIMS($properties) {
    $this->Server = $properties["server"];
    $this->Port = $properties["port"]?$properties["port"]:"80";
    $this->Path = $properties["servlet"]?$properties["servlet"]:"/servlet/com.esri.esrimap.Esrimap";
    $this->ServiceName = $properties["service_name"];
    $this->CustomService = "Query";
    $this->CharSet = $properties["charset"]?$properties["charset"]:"windows-1250";
    $this->CharSetUnicodeEntities = $properties["charsetunicodeentities"]?$properties["charsetunicodeentities"]:false;
//    $this->CharSetQuery = $this->CharSet;
    $this->CharSetQuery = $properties["charsetquery"]?$properties["charsetquery"]:$this->CharSet;
    $this->CurlParameters = $properties["curl_parameters"]?$properties["curl_parameters"]:false;
    $this->ImageURL = $properties["image_url"]?$properties["image_url"]:false;
  }

  function GetURL() {
    return $this->Server;
  }
  
  function request($query) {

    $request_uri = $this->Path."?ServiceName=".$this->ServiceName."&ClientVersion=4.0";
    if ($this->CustomService) $request_uri .= "&CustomService=".$this->CustomService;
    $request_uri .= "&Form=True&Encode=False";
    
    $axlrequest = '<?xml version="1.0" encoding="UTF-8" ?>'."\n".$query;

    if ($this->CurlParameters['enabled']) {
    
      $ch = curl_init();
      $url = 'http'.($this->CurlParameters['https']?'s':'').'://'.$this->Server.($this->Port?':'.$this->Port:'').$request_uri;
      //echo $url;
      curl_setopt($ch, CURLOPT_URL, $url);

      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
      curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.5 [en] (WinNT; I)');
      
//      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->CurlParameters['verifypeer']?true:false);

      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, 'ArcXMLRequest='.UrlEncode($axlrequest).'&HeaderFile=&FooterFile=&FormCharset='.$this->CharSet);

//      curl_setopt($ch, CURLOPT_VERBOSE, 1);
      
      if($this->CurlParameters['proxy_hostname'] && $this->CurlParameters['proxy_port']) 
        curl_setopt($ch, CURLOPT_PROXY, $this->CurlParameters['proxy_hostname'].':'.$this->CurlParameters['proxy_port']);
      if($this->CurlParameters['proxy_user'] && $this->CurlParameters['proxy_pwd'])
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $this->CurlParameters['proxy_user'].':'.$this->CurlParameters['proxy_pwd']);

      if($this->CurlParameters['username'] && $this->CurlParameters['password'])
        curl_setopt($ch, CURLOPT_USERPWD, $this->CurlParameters['username'].':'.$this->CurlParameters['password']);

      $html = curl_exec ($ch);
      $ch_code = curl_getinfo ($ch, CURLINFO_HTTP_CODE);
      if (!$html) {
         die("error CURL Exec: ".curl_error($ch));
      } 
      if ($ch_code != 200) {
         die("error CURL Exec: return code ".$ch_code);
      }
      curl_close ($ch);
      
    } else {
  
      require_once(FileUp2(".admin/http.inc"));
  
      $http_connection = new http_class;
      $error=$http_connection->Open(array("HostName"=>$this->Server, "HostPort"=>$this->Port));
      $html = "";
      if($error==""):
        
        $error=$http_connection->SendRequest(array(
         "RequestMethod"=>"POST",
         //"RequestURI"=>$this->Path."?ServiceName=".$this->ServiceName."&ClientVersion=3.1&CustomService=Query&Form=True&Encode=False",
         "RequestURI"=>$request_uri,
         "Headers"=>array(
          "User-Agent"=>"Mozilla/4.5 [en] (WinNT; I)",
          "Pragma"=>"no-cache",
  				"Cache-Control"=>"no-cache"
         ),
         "PostValues"=>array(
           "ArcXMLRequest"=>$axlrequest,
           "HeaderFile"=>"",
           "FooterFile"=>"",
           "FormCharset"=>$this->CharSet
         )
        ));
        if($error==""):
          $headers=array();
          $error=$http_connection->ReadReplyHeaders(&$headers);
          if($error==""):
            while (true):
              $error=$http_connection->ReadReplyBody(&$body,1024);
              if($error!="" || strlen($body)==0) break;
              $html .= $body;
            endwhile;
          endif;
        endif;
      endif;
    }

//     $html = strstr($html,"<?xml");
//     $html = substr($html,0,strrpos($html,">")+1);
    $html = Str_Replace("#SHAPE#", "_SHAPE_", $html);
    $html = Str_Replace("#ID#", "_ID_", $html);

//     $html = Explode('"',$html);
//     for($i=0;$i<Count($html);$i++) {
//       if ($i%2 == 1) $html[$i] = HTMLSpecialChars($html[$i]);
//     }
    //$html = Implode('"',$html);


    preg_match("/\<\?xml.*\<\/ARCXML\>/i", $html, $match);
    unset($html);
    //$html = preg_replace('/="([^"]*)"/e', "'=\"'.HTMLSpecialChars('\\1').'\"'", $match[0]);
    set_time_limit(60);
    $request = '';
    while(preg_match("/^([^>]+)/",$match[0],$row)) {
      $match[0] = SubStr($match[0],StrLen($row[1])+1);
      $request .= preg_replace('/="([^"]*)"/e', "'=\"'.HTMLSpecialChars('\\1').'\"'", Str_Replace("#ID#", "_ID_", Str_Replace("#SHAPE#", "_SHAPE_", $row[1]))).'>';
    }
      //die('R:'.$request);

    return $request;
  }
  
  function query($query, $order_by_field='', $order_by_field_type='', $order_by_field_len=16) {
    $this->result = array();
    $this->index = 0;

    if (($this->CharSet && $this->CharSetQuery && ($this->CharSet != $this->CharSetQuery)) || $this->CharSetUnicodeEntities) {
      include_once(FileUp2(".admin/functions_compare.inc"));
      $query = Convert_Czech($query, $this->CharSet, $this->CharSetQuery, $this->CharSetUnicodeEntities);
    }
    
    $this->arcxml_request = $query;
    $html = $this->request($query);
    $this->arcxml_response = $html;

    $arcxml = preg_replace("/.*(<ARCXML.*<\/ARCXML>).*/ms","\\1",$html);
    unset($html);
    $arcxml = iconv("ISO-8859-2","UTF-8",$arcxml);
    
    if(!$dom = @domxml_open_mem($arcxml,DOMXML_LOAD_PARSING)) {
      die('Error parsing ArcIMS response.');
    }
    unset($arcxml);

    $root_node = $dom->first_child();
    $features = $root_node->get_elements_by_tagname("FEATURE");
    unset($root_node);
    $SHAPE = Array();
    $i=0;
    
    //foreach($features as $ft) {
    while($features && Count($features)>0) {
      $ft = array_pop($features);
      $rec = array();
          
      if($props=$ft->get_elements_by_tagname('POLYGON')) {
        $SHAPE[$i]['_SHAPE_TYPE_'] = 'polygon';
        $segments = $props[0]->get_elements_by_tagname('RING');
      }
      elseif($props=$ft->get_elements_by_tagname('POLYLINE')) {
        $SHAPE[$i]['_SHAPE_TYPE_'] = 'polyline';
        $segments = $props[0]->get_elements_by_tagname('PATH');
      }
      elseif($props=$ft->get_elements_by_tagname('MULTIPOINT')) {
        $SHAPE[$i]['_SHAPE_TYPE_'] = 'point';
        $segments[0] = $props;
      }
      if($SHAPE[$i]['_SHAPE_TYPE_']) {
        $coords = '';
        //foreach($segments as $segment) {
        while($segments && Count($segments)>0) {
          $segment = array_pop($segments);
                  
          $points = $segment->get_elements_by_tagname('POINT');        
          if($more) {
            $coords = Trim($coords);
            $coords .= '&';
          }
          foreach($points as $point) {
            $coords .= (str_replace(',','.',$point->get_attribute('x')).','.str_replace(',','.',$point->get_attribute('y'))).' ';
          }
          $more=true;
        }
        unset($points);
        $SHAPE[$i]['_SHAPE_COORDS_'] = Trim($coords,'&');
      }
      
      if($props=$ft->get_elements_by_tagname('ENVELOPE')) {
        $SHAPE[$i]['_SHAPE_BBOX_'] = str_replace(' ',',', 
        str_replace(',','.', 
          $props[0]->get_attribute('minx').' '.
          $props[0]->get_attribute('miny').' '.
          $props[0]->get_attribute('maxx').' '.
          $props[0]->get_attribute('maxy')
        ));
        unset($props);
      }
    
      $env = $ft->get_elements_by_tagname('ENVELOPE');
      if(is_array($env) && ($ext = $env[0])) {
        $ext_attr = $ext->attributes();
        $rec['ext'] = array();
        foreach($ext_attr as $attr) {
          $rec['ext'][$attr->name] = (double) Str_Replace(',', '.', $attr->value);
        }
        unset($ext_attr);
      }
      unset($env);

      $order_by_field = StrToUpper($order_by_field);
      $fld = $ft->get_elements_by_tagname('FIELDS');
      if(is_array($fld) && ($fields = $fld[0])) {
        $attrs = $fields->attributes();
        
        //foreach($attrs as $attr) {
        while($attrs && Count($attrs)>0) {
          $attr = array_pop($attrs);
                  
          $val = $attr->value;
          $name = $attr->name;
          switch (StrToUpper($name)) {
            case 'SHAPE.AREA':
              $rec['_SHAPE_AREA_'] = (double) Str_Replace(',', '.', $val);
            break;
            case 'SHAPE.LEN':
              $rec['_SHAPE_LEN_'] = (double) Str_Replace(',', '.', $val);
            break;
            default:
              if (StrPos($name, '.')) {
                $name_arr = Explode('.', $name);
                $name = $name_arr[Count($name_arr)-1];
              }
              $val = iconv("UTF-8","ISO-8859-2",$val);
              if ($name == 'OBJECTID') $rec['_ID_'] = $val;
              $rec[StrToUpper($name)] = $val;                
            break;     
          }     
        }
      }

      if ($order_by_field && isset($rec[$order_by_field])) {
        $key = $rec[$order_by_field];
        switch ($order_by_field_type) {
          case 'integer': 
          case 'double': 
            $key = Str_Replace(',', '.', $key);
            SetType($key, $order_by_field_type);
            $fill = "0"; 
            $key = sprintf ("%'{$fill}{$order_by_field_len}f", $key).'#'.$i;
          break;
          case 'string': 
            $key = $key.'#'.$i;
          break;
        }
      } 
      $rec['_SHAPE_TYPE_'] = $SHAPE[$j?$j:0]['_SHAPE_TYPE_'];
      $rec['_SHAPE_COORDS_'] = $SHAPE[$j?$j:0]['_SHAPE_COORDS_'];
      $rec['_SHAPE_BBOX_'] = $SHAPE[$j?$j:0]['_SHAPE_BBOX_'];
			$this->result[] = $rec;
      $i++;
    }

    $dom->free();
    unset($dom);

    //die(print_r($this->result));
    return true;
  }
  
  function halt($msg, $force=false, $error=false) {
    if ($GLOBALS["Debug"]["arcims"] || $force) {
      printf("<p><b>ArcIMS connector:</b> %s<br>\n", $msg);
      printf("<pre><b>ArcIMS REQUEST</b>:\n%s\n", HtmlEntities($this->arcxml_request));
      if ($error)
        printf("<b>ArcIMS RESPONSE</b>:\n%s\n", HtmlEntities($this->arcxml_response));
      echo "</pre></p>";
    }
  }
  
  
  function services() {
    $service_name = $this->ServiceName;
    $custom_service = $this->CustomService;
    $this->ServiceName = "catalog";
    $this->CustomService = "";
    $query = "<GETCLIENTSERVICES/>";
    $html = $this->request($query);

    //die(print_r($html));
    $xml = new XML($html);

    for($i=0; $i<count($xml->nodes); $i++) {
        if ($xml->nodes[$i]->name=="SERVICE") {
					$result[] = $xml->nodes[$i]->attributes;
        }
    }

    //die(print_r($result));
    $this->CustomService = $custom_service;
    $this->ServiceName = $service_name;
    
    return $result;
  }

  function service_info($service,$layer=false) {
    $service_name = $this->ServiceName;
    $custom_service = $this->CustomService;
    $this->ServiceName = $service;
    $this->CustomService = "";
    $query = "<ARCXML version=\"1.1\"><REQUEST><GET_SERVICE_INFO renderer=\"false\" extensions=\"false\" fields=\"true\" envelope=\"true\" /></REQUEST></ARCXML>"; // envelope=true - tono 2005-10-26
    $html = $this->request($query);

    $xml = new XML($html);
    //print_r($xml);
    //die(print_r($xml));

    $index = 0;
    $index_f = 0;
    for($i=0; $i<count($xml->nodes); $i++) {
      if ($xml->nodes[$i]->name=="ENVELOPE/") {
        $attr = $xml->nodes[$i]->attributes;
        $minx = str_replace("," , "." , $attr['minx']);
        $miny = str_replace("," , "." , $attr['miny']);
        $maxx = str_replace("," , "." , $attr['maxx']);
        $maxy = str_replace("," , "." , $attr['maxy']);
        $result['extent'] = $minx." ".$miny." ".$maxx." ".$maxy;
        //die(print_r($result['extent']));
      }
      if ($xml->nodes[$i]->name=="LAYERINFO") {
        $attr = $xml->nodes[$i]->attributes;
        $attr['i'] = $index++;
        if (isset($attr['minscale'])) $attr['minscale']=Str_Replace(',', '.', $attr['minscale']); 
        if (isset($attr['maxscale'])) $attr['maxscale']=Str_Replace(',', '.', $attr['maxscale']); 
        $id = StrToUpper($attr['id']);
        if ($layer && $layer != $id) continue;
  		$result[$id] = $attr;
        $index_f = 0;
      }
      if ($layer && $layer != $id) continue;
      if ($xml->nodes[$i]->name=="FCLASS") {
        $attr = $xml->nodes[$i]->attributes;
        $result[$id]["type"] = $attr["type"];
      }
      if ($xml->nodes[$i]->name=="FIELD/") {
        $attr = $xml->nodes[$i]->attributes;
        $attr['i'] = $index_f++;
        $name = StrToUpper($attr['name']);
        $result[$id]["fields"][$name] = $attr;
      }
    }

    //die(print_r($result));
    //print_r($result);
    $this->CustomService = $custom_service;
    $this->ServiceName = $service_name;
    
    return $result;
  }

  function ParseGetFeatureInfoParams($params) {
    $params['INFO_FORMAT'] = 'text/xml';
    return $params;
  }

  function GetFeatureInfoResult($response) {
    $result = array();
    $response_dom = domxml_open_mem($response,DOMXML_LOAD_PARSING,$error);
    $root_node = $response_dom->first_child();
    $features = $root_node->get_elements_by_tagname("FIELDS");
    foreach($features as $ft) {
      $attrs = $ft->attributes();
      $res = array();
      foreach($attrs as $at) {
        $name_arr = Explode('.',$at->name);
        $res[$name_arr[Count($name_arr)-1]] = $at->value;
      }
      $result[] = $res;
    }    
    return $result;
  }

  function next_record() {
    if ($this->index < Count($this->result)) {
      $this->Record = $this->result[$this->index];
      $this->index++;
      return true;
    }
    else return false;
  }
  

}
?>