<?php
/* HEADER */ if ($TWIST_FILE_INFO) {echo __FILE__.': $Id: ArcGISServer.inc,v 1.8 2008/03/07 10:47:16 tono Exp $'.'$Name:  $';exit;}; /* HEADER */

require_once($GLOBALS["TMAPY_LIB"]."/lib/nusoap/lib/nusoap.php");
$GLOBALS['_transient']['static']['nusoap_base']->globalDebugLevel=0;

class MS_SoapClient extends SoapClient {
  var $getMsgAndDoNotSend=false;

  function MS_soapclient($endpoint,$wsdl = false,$proxyhost = false,$proxyport = false,$proxyusername = false, $proxypassword = false, $timeout = 0, $response_timeout = 30){
		parent::soapclient($endpoint,$wsdl,$proxyhost,$proxyport,$proxyusername, $proxypassword, $timeout, $response_timeout);
  }
  
	function send($msg, $soapaction = '', $timeout=0, $response_timeout=30) {
	  if ($this->getMsgAndDoNotSend) {
	    $this->SoapMessage = $msg; 
	    $this->SoapAction = $soapaction; 
    } else {
		  return parent::send($msg, $soapaction, $timeout, $response_timeout);
		}
	}
	
}

class MS_ArcGISServer {
  var $Server;
  var $Version;
  var $MapName;
  var $result = array();
  var $Record;
  var $SoapClient;
  var $ShowError = true;
  var $HaltOnError = true;
  var $DebugError = false;
  var $InternalCharsetSet;

  function MS_ArcGISServer($properties) {
    $this->Server = $properties['server'];
    $this->EndPoint = $properties['endpoint'];
    $this->Version = $properties['version']?$properties['version']:'9.2';
    $this->MapName = $properties['mapname'];
    $this->NameSpace = $properties['namespace']?$properties['namespace']:'http://www.esri.com/schemas/ArcGIS/'.$this->Version; 
    $this->ShowError = isset($properties['error']['show'])?$properties['error']['show']:$this->ShowError;
    $this->HaltOnError = isset($properties['error']['halt'])?$properties['error']['halt']:$this->HaltOnError;
    $this->DebugError = isset($properties['error']['debug'])?$properties['error']['debug']:$this->DebugError;
    $this->Proxy = $properties['proxy'];
    $this->Credentials = $properties['credentials'];
    $this->RequestTimeout = $properties['request_timeout']?$properties['request_timeout']:30;
    if ($properties['internalcharset'])
      $this->InternalCharsetSet = $properties['internalcharset'];
    else {
      if ($GLOBALS['TMAPY_CONFIG']['ENCODING']['PHP']) 
        $this->InternalCharsetSet = $GLOBALS['TMAPY_CONFIG']['ENCODING']['PHP'];
      else {
        $this->Error = 'Error: Misssing $GLOBALS[\'TMAPY_CONFIG\'][\'ENCODING\'][\'PHP\'] or connector \'internalcharset\' setting.';
        $this->showerror('ArcGIS config error');
      }
    }

    if (Is_File($this->Server)) {
      $wsdl = new wsdl($this->Server);
      $wsdl->wsdl = $wsdl->bindings[$wsdl->currentBinding]['endpoint'];
      $this->SoapClient = new MS_SoapClient($wsdl, true, false, false, false, false, 0, $this->RequestTimeout);
    } else {
      $this->SoapClient = new MS_SoapClient($this->Server.'?WSDL', true, false, false, false, false, 0, $this->RequestTimeout);
    }
    if ($this->EndPoint) {
      $this->SoapClient->setEndpoint($this->EndPoint);
      $this->SoapClient->endpoint = $this->EndPoint;
    }
    $this->SoapClient->soap_defencoding='UTF-8';
    $this->SoapClient->decodeUTF8(false);
    if ($this->Proxy) 
      $this->SoapClient->setHTTPProxy(
        $this->Proxy['host'], 
        $this->Proxy['port'], 
        $this->Proxy['username'], 
        $this->Proxy['password']
      );
    if ($this->Credentials) 
      $this->SoapClient->setCredentials(
        $this->Credentials['username'], 
        $this->Credentials['password'], 
        $this->Credentials['authtype']?$this->Credentials['authtype']:'basic',
        $this->Credentials['certrequest']?$this->Credentials['certrequest']:array()
      );
    
    $this->Error = $this->SoapClient->getError();
    if ($this->Error) $this->showerror('ArcGIS constructor error');
  }

  //Core methods
  function query($query) {
    $this->Query = $query;
    //die($this->soapGetMessage($query));
    $this->SoapResult = $this->soapCall($this->Query);
    
    //echo '<pre>'.htmlspecialchars(str_replace('<',"\n<",$this->SoapClient->request), ENT_QUOTES).'</pre>';
    //die();
    
    //For QueryFeatureIDs and next_record support
    if (isset($this->SoapResult['Result']['FIDArray'])) {
      $this->LastRecordSetType = 'IDs';
      //Returned more items are in array
      if (Is_array($this->SoapResult['Result']['FIDArray']['Int'])) 
        $this->LastRecordSet=$this->SoapResult['Result']['FIDArray']['Int'];
      //Returned one is single variable
      else $this->LastRecordSet=array($this->SoapResult['Result']['FIDArray']['Int']);
      //Nothing found
      if (!Is_array($this->LastRecordSet)) $this->LastRecordSet=array();  
      $this->Row = 0;
    //For QueryFeatureData and next_record support
    } else if (isset($this->SoapResult['Result']['Records'])) {
      $this->LastRecordSetType = 'Data';
      $this->LastRecordSet = $this->SoapResult['Result'];
      $this->Row = 0;
    }

    return true;
  }
  
  function next_record() {
    static $cache=array();
    if (isset($this->LastRecordSet)) {
      switch ($this->LastRecordSetType) {
        case 'IDs':
          //Check next_record and get FID
          if ($this->Row++==0) $fid = current($this->LastRecordSet);
          else $fid = next($this->LastRecordSet);
          if ($fid === false || $fid == '') return false;

          //Create metadata for result (cached in this->metadata method)
          $metadata = $this->metadata(
            $this->Query['params']['LayerID'],
            array(
            'fieldarray'=>$result['Result']['Fields']['FieldArray'],
            'cacheid'=>md5(serialize(array(
              $this->Query['params']['MapName'],
              $this->Query['params']['LayerID'],
              $subfields
            ))))
          );
          if (preg_match('/^OBJECTID/', $metadata['_ID_']['agsname'])) {
            $request = array(
              'method'=>'QueryFeatureData',
              'params'=>array(
                'MapName'=>$this->Query['params']['MapName'],
                'LayerID'=>$this->Query['params']['LayerID'],
                'QueryFilter'=>$this->getSoapVal('QueryFilter',array(
                  'SubFields'=>$this->Query['params']['QueryFilter']->value['SubFields'],
                  'WhereClause'=>$metadata['_ID_']['agsname'].' IN ('.$fid.')'
                ))
              )
            );
          } else {
            //Query Data for FID
            $request = array(
              'method'=>'QueryFeatureData',
              'params'=>array(
                'MapName'=>$this->Query['params']['MapName'],
                'LayerID'=>$this->Query['params']['LayerID'],
                'QueryFilter'=>$this->getSoapVal('QueryFilter',array(
                  'SubFields'=>$this->Query['params']['QueryFilter']->value['SubFields'],
                  'FIDSet'=>$this->getSoapVal('FIDSet',array(
                    'FIDArray'=>$this->getSoapVal('FIDArray',array($fid))
                  ))
                ))
              )
            );
          }
          //die($this->soapGetMessage($request));
          $result = $this->soapCall($request);
          
          //Create Record array based on metadata
          $this->Record = array();
          $record = $result['Result']['Records']['Record']['Values']['Value'];
          foreach ($metadata as $key=>$val) {
            //Get ENVELOPE
            if ($val['agstype'] == 'esriFieldTypeGeometry') {
              // tono: support for point features added
              $coords = $record[$val['agskey']];
              if(is_array($coords['Extent'])) { 
                $extent = $coords['Extent'];
                $this->Record['_ENVELOPE_'] = array(
                  'minx'=>$extent['XMin'], 
                  'miny'=>$extent['YMin'], 
                  'maxx'=>$extent['XMax'], 
                  'maxy'=>$extent['YMax'], 
                );
              }
              else {
                $this->Record['_ENVELOPE_'] = array(
                  'minx'=>$coords['X']-0.000001, 
                  'miny'=>$coords['Y']-0.000001, 
                  'maxx'=>$coords['X']+0.000001, 
                  'maxy'=>$coords['Y']+0.000001, 
                );                
              }
            //Get others and skip ENVELOPE :-)
            } else if (!isset($this->Record[strtoupper($key)])) {
              $this->Record[strtoupper($key)] = $record[$val['agskey']];
              if ($val['agstype'] == 'esriFieldTypeOID') 
                $this->Record['_ID_'] = $record[$val['agskey']]+1;
            }
          }
          return true; 
        break;
        case 'Data':
          if (!$this->LastRecordSet['Records']) return false;
          if ($this->Row++==0) $record = current($this->LastRecordSet['Records']['Record']);
          else $record = next($this->LastRecordSet['Records']['Record']);
          if ($record === false) return false;
          if (is_array($record['Values']['Value'])) $record = $record['Values']['Value'];
          else $record = $record['Value'];
          $this->Record = $record['Values']['Value'];
          foreach ($record as $k=>$v) {
            $f_def = $this->LastRecordSet['Fields']['FieldArray']['Field'][$k];
            $this->Record[strtoupper($f_def['Name'])] = is_string($v) ? TranslateToUnicodeEntities($v,$this->InternalCharsetSet) : $v;
            if ($f_def['Type'] == 'esriFieldTypeOID') { 
              //$this->Record['_ID_'] = $v+1; //???
              $this->Record['_ID_'] = $v;
            }
            elseif ($f_def['Type'] == 'esriFieldTypeGeometry') { 
              $esri_type = $f_def['GeometryDef']['GeometryType'];
              switch($esri_type) {
                case 'esriGeometryPolygon':
                  $this->Record['_SHAPE_TYPE_'] = 'polygon';
                  $this->Record['_SHAPE_COORDS_'] = '';
                  $more = false;
                  if(is_array($v['RingArray']['Ring'])) {
                    foreach($v['RingArray']['Ring'] as $r) {
                      if($more) $this->Record['_SHAPE_COORDS_'].= '|';
                      $ring = array();
                      if(is_array($r['PointArray']['Point'])) {
                        foreach($r['PointArray']['Point'] as $p) {
                          $this->Record['_SHAPE_COORDS_'].= $p['X'].','.$p['Y'].' ';                      
                        }
                        $more = true;
                      }
                      elseif(is_array($r['Point'])) {
                        foreach($r['Point'] as $p) {
                          $this->Record['_SHAPE_COORDS_'].= $p['X'].','.$p['Y'].' ';                      
                        }
                        $more = true;
                      }
                    }
                  }
                  break;
                default: break; 
              }
            }
          }
          return true; 
        break;
      }
    } else {
      $this->Error = 'QueryFeatureIDs request supported only.';
      $this->showerror('ArcGIS next_record error');
    }
  }
  
  function seek($pos) {
    if ($this->Row != $pos) {
      $this->Row=0;
      if (isset($this->LastRecordSet)) {
        switch ($this->LastRecordSetType) {
          case 'IDs':
            reset($this->LastRecordSet);
            for(; $this->Row<($pos-2); $this->Row++) next($this->LastRecordSet);
          break;
          case 'Data':
            reset($this->LastRecordSet['Records']['Record']);
            for(; $this->Row<($pos-2); $this->Row++) next($this->LastRecordSet['Records']['Record']);
          break;
        }
      }
      if ($pos > -1) $this->next_record();
    }
  }
  
  function num_rows() {
    if (isset($this->LastRecordSet)) {
      switch ($this->LastRecordSetType) {
        case 'IDs':
          return Count($this->LastRecordSet);
        break;
        case 'Data':
          return Count($this->LastRecordSet['Records']['Record']);
        break;
      }
    }
    return -1;
  }
  
  function service_info($table, $params=false) {
    return $this->metadata($table, $params=false);
  }
  
  function metadata($table, $params=false) {
    static $cache;
    if (preg_match('/\D+/',$table)) {
      $table2 = $this->getLayerIndexByLayerName($table);
      if ($table2 === false) {
        $this->Error = 'Layer with name '.$table.' does not exist.';
        $this->showerror('ArcGIS metadata error');
      }
      $table = $table2;
      unset($table2);
    }
    $cacheid = $params['cacheid']?$params['cacheid']:$table;
    if ($cache[$cacheid]) return $cache[$cacheid];
    //FieldArray in param
    if ($params['fieldarray']['Field']) {
      $flds = $params['fieldarray']['Field'];
    //Query for FieldArray and FID=-1 
    } else {
    
      $request = array(
        'method'=>'QueryFeatureData',
        'params'=>array(
          'MapName'=>$this->encodeString($this->getMapName()),
          'LayerID'=>$table,
          'QueryFilter'=>$this->getSoapVal('QueryFilter',array(
            'WhereClause'=>'1=0',
            'FIDSet'=>$this->getSoapVal('FIDSet',array(
              'FIDArray'=>$this->getSoapVal('FIDArray',array(-1))
            ))
          ))
        )
      );
      $result = $this->soapCall($request);
      $flds = $result['Result']['Fields']['FieldArray']['Field'];

//       $request = array(
//         'method'=>'GetServerInfo',
//         'params'=>array(
//           'MapName'=>$this->encodeString($this->getMapName()),
//         )
//       );
//       $result = $this->soapCall($request);
//       $flds = $result['Result']['MapLayerInfos']['MapLayerInfo'][$table]['Fields']['FieldArray']['Field'];

    }
    //Create T-WIST metadata structure
    $met = array();
    foreach ($flds as $key=>$fld) {
      $name = $fld['Name'];
      $orig_name = false;
      switch ($fld['Type']) {
        case 'esriFieldTypeOID':        $type = '_id_';     $phptype='integer'; $orig_name=$name; $name='_ID_'; break; //row_id type fields
        case 'esriFieldTypeGeometry':   $type = '_shape_';  $phptype='string';  $name='_SHAPE_'; break; //shape fields
        case 'esriFieldTypeInteger':    $type = 'int';      $phptype='integer'; break; //integer type fields
        case 'esriFieldTypeSmallInteger': $type = 'smallint'; $phptype='integer'; break; //small integer type fields
        case 'esriFieldTypeSingle':     $type = 'float';    $phptype='double';  break; //double type fields
        case 'esriFieldTypeDouble':     $type = 'double';   $phptype='double';  break; //double type fields
        case 'esriFieldTypeString':     $type = 'string';   $phptype='string';  break; //string type fields
        case 'esriFieldTypeDate':       $type = 'date';     $phptype='string';  break; //date type fields
        case 'esriFieldTypeBlob':       $type = 'blob';     $phptype='string'; break; //blob type fields
        case 'esriFieldTypeRaster':     $type = '_raster_'; $phptype='string'; break; //raster type fields
        case 'esriFieldTypeXML':        $type = 'xml';      $phptype='string'; break; //blob type fields
      }
      $item = array();
      $item['table'] = $table;
      $item['name']  = StrToUpper($name);
      $item['type']  = $type;
      $item['phptype']  = $phptype;
      $item['len']   = $fld['Length'];
      $item['precision'] = $fld['Precision'];
      $item['scale'] = $fld['Scale'];
      $item['null']  = !$fld['Required'];
      $item['agsname']  = $fld['Name'];
      $item['agstype']  = $fld['Type'];
      $item['agskey']  = $key;
      $met[StrToUpper($name)] = $item;
      
      if($orig_name) {
        $met[StrToUpper($orig_name)] = $met[StrToUpper($name)];
        $met[StrToUpper($orig_name)]['name'] = $orig_name;
      }      
    }
    //Add _ENVELOPE_ for _SHAPE_ variable
    if ($met['_SHAPE_']) {
      $met['_ENVELOPE_']=$met['_SHAPE_'];
      $met['_ENVELOPE_']['name']='_envelope_';
      $met['_ENVELOPE_']['type']='_envelope_';
      unset($met['_ENVELOPE_']['agsname'], $met['_ENVELOPE_']['agstype'], $met['_ENVELOPE_']['agskey']);
    }
    $cache[$cacheid] = $met;

    return $met; 
  }

  //Services methods
    
  function soapCall($request, $encode=true) {
    $result = $this->SoapClient->call($request['method'], array($request['params']), $this->NameSpace);
    $this->Error = $this->SoapClient->getError();
    if ($this->Error) {
      $this->showerror('ArcGIS query error');
      return false;
    }
    if ($encode) $result = $this->encodeArray($result, $this->InternalCharsetSet);
    return $result;
  }

  function soapSend($message, $action='') {
    $this->SoapClient->endpoint = preg_replace('/\?WSDL$/','', $this->SoapClient->endpoint);
    $result = $this->SoapClient->send($message, $action);
    $this->Error = $this->SoapClient->getError();
    if ($this->Error) {
      $this->showerror('ArcGIS query error');
      return false;
    }
    if ($encode) $result = $this->encodeArray($result, $this->InternalCharsetSet);
    return $result;
  }
  
  function soapGetMessage($request, $encode=true) {
    $this->SoapClient->getMsgAndDoNotSend = true;
    $this->soapCall($request, false);
    $this->SoapClient->getMsgAndDoNotSend = false;
    return $this->SoapClient->SoapMessage;
  }
  
  function getMapName() {
    if (!$this->MapName) { 
      $request = array('method'=>'GetDefaultMapName','params'=>array());
      $r = $this->soapCall($request);
      $r = $this->encodeArray($r, $this->InternalCharsetSet);
      $this->MapName = $r['Result'];
    }
    return $this->MapName;
  }
  
  function getLayerIndexByLayerName($name) {
    if (preg_match('/\D+/',$name)) {
      $request = array(
        'method'=>'GetServerInfo',
        'params'=>array(
          'MapName'=>$this->encodeString($this->getMapName()),
        )
      );
      $response = $this->soapCall($request);
      $result = false;
      $name = StrToUpper($name);
      if (Is_array($response['Result']['MapLayerInfos']['MapLayerInfo'])) {
        foreach ($response['Result']['MapLayerInfos']['MapLayerInfo'] as $lr) {
          if ($name == StrToUpper($lr['Name'])) {
            $result = $lr['LayerID'];
            break;
          }
        }
      }
    } else {
      $result = $name;
    }
    return $result; 
    
  }

  function decodeString($data, $fromcharset='UTF-8') {
    return iconv($fromcharset, $this->InternalCharsetSet, $data);
  }

  function encodeString($data, $tocharset='UTF-8') {
    return iconv($this->InternalCharsetSet, $tocharset, $data);
  }

  function encodeArray($data, $tocharset='UTF-8', $fromcharset='UTF-8') {
    foreach ($data as $key=>$val) {
      if (Is_String($val)) $data[$key] = iconv($fromcharset, $tocharset, $val);
      elseif (Is_Array($val)) {
        $data[$key] = $this->encodeArray(&$val, $tocharset, $fromcharset);
      }
    }
    return $data;
  }

  function getSoapVal($type, $params, $name=false, $encode=true) {
    if ($encode)
      return new soapval($name?$name:$type,$type,$this->encodeArray($params,'UTF-8',$this->InternalCharsetSet), false, $this->NameSpace);
    else
      return new soapval($name?$name:$type,$type,$params, false, $this->NameSpace);
  }
  
  function showerror($msg) {
    if ($this->ShowError) {
      echo('<h2>'.$msg.'</h2><pre>'.$this->Error.'</pre>');
    }
    if ($this->DebugError) {
      print_R($this->SoapClient->request);
      echo '<h2>Request</h2>';
      echo '<pre>' . htmlspecialchars(str_replace('<',"\n<",$this->SoapClient->request), ENT_QUOTES) . '</pre>';
      echo '<h2>Response</h2>';
      echo '<pre>' . htmlspecialchars(str_replace('<',"\n<",$this->SoapClient->response), ENT_QUOTES) . '</pre>';
    }
    if ($this->HaltOnError) die();
  }
  
}


?>
